/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.text.DecimalFormat;
import java.text.Format;
import javafx.geometry.Pos;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX.CFFormattedTextField;

public class CFUInt16Editor
extends CFFormattedTextField {
    protected static Format defaultFormat = null;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65536;
    protected int minValue = 0;
    protected int maxValue = 65536;
    protected String fieldName = "?";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public static Format getDefaultFormat() {
        if (defaultFormat == null) {
            defaultFormat = new DecimalFormat("####0");
        }
        return defaultFormat;
    }

    public CFUInt16Editor() {
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setMinWidth(60.0);
        this.setMaxWidth(60.0);
        this.setPrefWidth(60.0);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int value) {
        if (value < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setMinValue", 1, "value", value, 0);
        }
        this.minValue = value;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int value) {
        if (value > 65536) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setMaxValue", 1, "value", value, 65536);
        }
        this.maxValue = value;
    }

    public boolean hasValue() {
        String text = this.getText();
        boolean retval = text != null && text.length() > 0;
        return retval;
    }

    public void setUInt16Value(Integer value) {
        if (value == null) {
            this.setText("");
        } else {
            String text = CFUInt16Editor.getDefaultFormat().format(value);
            this.setText(text);
        }
    }

    public Integer getUInt16Value() {
        Integer retval;
        String S_ProcName = "getUInt16Value";
        String text = this.getText();
        if (text == null || text.length() <= 0) {
            retval = null;
        } else {
            Integer v = Integer.valueOf(text);
            if (v == null) {
                throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(this.fieldName, "getUInt16Value", 0, "text", (Object)text);
            }
            if (v.compareTo(this.minValue) < 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "getUInt16Value", 1, this.fieldName, (int)v, this.minValue);
            }
            if (v.compareTo(this.maxValue) > 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "getUInt16Value", 1, this.fieldName, (int)v, this.maxValue);
            }
            retval = v;
        }
        return retval;
    }
}

