/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;

public class CFReferenceEditor
extends AnchorPane {
    public static final String PICK_ICON_RESOURCE = "/images/PickReference.gif";
    public static final String VIEW_ICON_RESOURCE = "/images/ViewReference.gif";
    protected ICFLibAnyObj referencedObject = null;
    protected TextField textFieldQualifiedName = null;
    protected Button buttonPickReference = null;
    protected Button buttonViewReference = null;
    protected boolean customDisable = false;
    protected String fieldName = "?";
    protected ICFReferenceCallback callback = null;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public CFReferenceEditor(ICFReferenceCallback argCallback) {
        String S_ProcName = "construct";
        if (argCallback == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.fieldName, "construct", 1, "argCallback");
        }
        this.callback = argCallback;
        this.referencedObject = null;
        this.setMinWidth(300.0);
        this.setPrefWidth(400.0);
        this.setMaxWidth(800.0);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
        this.textFieldQualifiedName = new TextField();
        this.textFieldQualifiedName.setMinHeight(25.0);
        this.textFieldQualifiedName.setMaxHeight(25.0);
        this.textFieldQualifiedName.setPrefHeight(25.0);
        this.textFieldQualifiedName.setEditable(false);
        this.buttonPickReference = new Button();
        this.buttonPickReference.setGraphic((Node)new ImageView(this.getPickIcon()));
        this.buttonPickReference.setMinHeight(25.0);
        this.buttonPickReference.setMaxHeight(25.0);
        this.buttonPickReference.setPrefHeight(25.0);
        this.buttonPickReference.setMinWidth(25.0);
        this.buttonPickReference.setMaxWidth(25.0);
        this.buttonPickReference.setPrefWidth(25.0);
        this.buttonPickReference.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (CFReferenceEditor.this.callback != null) {
                    CFReferenceEditor.this.callback.chose(CFReferenceEditor.this.referencedObject);
                }
            }
        });
        this.buttonViewReference = new Button();
        this.buttonPickReference.setGraphic((Node)new ImageView(this.getViewIcon()));
        this.buttonViewReference.setMinHeight(25.0);
        this.buttonViewReference.setMaxHeight(25.0);
        this.buttonViewReference.setPrefHeight(25.0);
        this.buttonViewReference.setMinWidth(25.0);
        this.buttonViewReference.setMaxWidth(25.0);
        this.buttonViewReference.setPrefWidth(25.0);
        this.buttonViewReference.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (CFReferenceEditor.this.callback != null) {
                    CFReferenceEditor.this.callback.view(CFReferenceEditor.this.referencedObject);
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.textFieldQualifiedName, this.buttonPickReference, this.buttonViewReference});
        CFReferenceEditor.setLeftAnchor((Node)this.textFieldQualifiedName, (Double)0.0);
        CFReferenceEditor.setRightAnchor((Node)this.textFieldQualifiedName, (Double)50.0);
        CFReferenceEditor.setRightAnchor((Node)this.buttonPickReference, (Double)25.0);
        CFReferenceEditor.setRightAnchor((Node)this.buttonViewReference, (Double)0.0);
    }

    public ICFLibAnyObj getReferencedObject() {
        return this.referencedObject;
    }

    public void setReferencedObject(ICFLibAnyObj value) {
        this.referencedObject = value;
        TextField textField = this.getTextFieldQualifiedName();
        if (this.referencedObject != null) {
            String qualifiedName = this.referencedObject.getObjQualifiedName();
            if (qualifiedName != null) {
                textField.setText(qualifiedName);
            } else {
                textField.setText("");
            }
        } else {
            textField.setText("");
        }
        textField.selectEnd();
        textField.deselect();
    }

    public Image getPickIcon() {
        Image icon = new Image(((Object)((Object)this)).getClass().getResourceAsStream(PICK_ICON_RESOURCE));
        return icon;
    }

    public Image getViewIcon() {
        Image icon = new Image(((Object)((Object)this)).getClass().getResourceAsStream(VIEW_ICON_RESOURCE));
        return icon;
    }

    public TextField getTextFieldQualifiedName() {
        return this.textFieldQualifiedName;
    }

    public Button getButtonPickReference() {
        return this.buttonPickReference;
    }

    public Button getButtonViewReference() {
        return this.buttonViewReference;
    }

    public void setCustomDisable(boolean value) {
        this.setDisable(false);
        this.customDisable = value;
        if (this.customDisable) {
            this.buttonPickReference.setDisable(true);
            this.buttonViewReference.setDisable(false);
            this.textFieldQualifiedName.setDisable(true);
        } else {
            this.buttonPickReference.setDisable(false);
            this.buttonViewReference.setDisable(false);
            this.textFieldQualifiedName.setDisable(false);
        }
    }

    public boolean getCustomDisable() {
        return this.customDisable;
    }

    public static interface ICFReferenceCallback {
        public void chose(ICFLibAnyObj var1);

        public void view(ICFLibAnyObj var1);
    }
}

