/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.math.BigDecimal;
import java.text.Format;
import javafx.scene.control.TableCell;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibBigDecimalUtil;

public class CFNumberTableCell<T>
extends TableCell<T, BigDecimal> {
    protected int digits;
    protected int precis;

    public CFNumberTableCell(int argDigits, int argPrecision) {
        this.setDigits(argDigits);
        this.setPrecision(argPrecision);
    }

    protected void updateItem(BigDecimal item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.setText(null);
            this.setStyle("");
        } else {
            Format fmt = CFLibBigDecimalUtil.getNumberFormat(((Object)((Object)this)).getClass().getName(), this.digits, this.precis);
            String cellText = fmt.format(item);
            this.setText(cellText);
            this.setStyle("-fx-alignment: CENTER-RIGHT");
        }
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int argDigits) {
        String S_ProcName = "setDigits";
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(((Object)((Object)this)).getClass(), "setDigits", 1, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(((Object)((Object)this)).getClass(), "setDigits", 1, "argDigits", argDigits, 31);
        }
        this.digits = argDigits;
    }

    public int getPrecision() {
        return this.precis;
    }

    public void setPrecision(int argPrecis) {
        String S_ProcName = "setPrecision";
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(((Object)((Object)this)).getClass(), "setPrecision", 1, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(((Object)((Object)this)).getClass(), "setPrecision", 1, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= this.digits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(((Object)((Object)this)).getClass(), "setPrecision", 1, "argPrecis", argPrecis, this.digits - 1);
        }
        this.precis = argPrecis;
    }

    public void setDigitsAndPrecision(int argDigits, int argPrecis) {
        String S_ProcName = "setDigitsAndPrecision";
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(((Object)((Object)this)).getClass(), "setDigitsAndPrecision", 1, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(((Object)((Object)this)).getClass(), "setDigitsAndPrecision", 1, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(((Object)((Object)this)).getClass(), "setDigitsAndPrecision", 1, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(((Object)((Object)this)).getClass(), "setDigitsAndPrecision", 1, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(((Object)((Object)this)).getClass(), "setDigitsAndPrecision", 1, "argPrecis", argPrecis, argDigits - 1);
        }
        this.digits = argDigits;
        this.precis = argPrecis;
    }
}

