/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.math.BigDecimal;
import javafx.geometry.Pos;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibBigDecimalUtil;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX.CFFormattedTextField;

public class CFNumberEditor
extends CFFormattedTextField {
    protected int digits;
    protected int precis;
    protected BigDecimal minValue = null;
    protected BigDecimal maxValue = null;
    protected String fieldName = "?";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public CFNumberEditor(int argDigits, int argPrecis) {
        String S_ProcName = "construct";
        this.setAlignment(Pos.CENTER_RIGHT);
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "construct", 1, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "construct", 1, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "construct", 1, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "construct", 1, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "construct", 1, "argPrecis", argPrecis, argDigits - 1);
        }
        this.minValue = null;
        this.maxValue = null;
        this.digits = argDigits;
        this.precis = argPrecis;
        int width = (argDigits + argPrecis + 2) * 10;
        if (width > 500) {
            width = 500;
        }
        this.setMinWidth(width);
        this.setMaxWidth(width);
        this.setPrefWidth(width);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int argDigits) {
        String S_ProcName = "setDigits";
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setDigits", 1, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setDigits", 1, "argDigits", argDigits, 31);
        }
        this.digits = argDigits;
        this.minValue = null;
        this.maxValue = null;
    }

    public int getPrecision() {
        return this.precis;
    }

    public void setPrecision(int argPrecis) {
        String S_ProcName = "setPrecision";
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setPrecision", 1, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setPrecision", 1, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= this.digits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setPrecision", 1, "argPrecis", argPrecis, this.digits - 1);
        }
        this.precis = argPrecis;
        this.minValue = null;
        this.maxValue = null;
    }

    public void setDigitsAndPrecision(int argDigits, int argPrecis) {
        BigDecimal newMaxValue;
        BigDecimal newMinValue;
        String S_ProcName = "setDigitsAndPrecision";
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setDigitsAndPrecision", 1, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setDigitsAndPrecision", 1, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setDigitsAndPrecision", 1, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setDigitsAndPrecision", 1, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setDigitsAndPrecision", 1, "argPrecis", argPrecis, argDigits - 1);
        }
        this.digits = argDigits;
        this.precis = argPrecis;
        if (this.minValue != null && this.minValue.compareTo(newMinValue = CFLibBigDecimalUtil.getAbsoluteMinValue(((Object)((Object)this)).getClass().getName(), argDigits, argPrecis)) < 0) {
            this.minValue = newMinValue;
        }
        if (this.maxValue != null && this.maxValue.compareTo(newMaxValue = CFLibBigDecimalUtil.getAbsoluteMaxValue(((Object)((Object)this)).getClass().getName(), argDigits, argPrecis)) > 0) {
            this.maxValue = newMaxValue;
        }
        BigDecimal numberValue = this.getNumberValue();
        this.setNumberValue(numberValue);
    }

    public BigDecimal getMinValue() {
        if (this.minValue == null) {
            this.minValue = CFLibBigDecimalUtil.getAbsoluteMinValue(this.fieldName, this.digits, this.precis);
        }
        return this.minValue;
    }

    public void setMinValue(BigDecimal value) {
        BigDecimal coerced;
        String S_ProcName = "setMinValue";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.fieldName, "setMinValue", 1, "value");
        }
        this.minValue = coerced = CFLibBigDecimalUtil.coerce(this.fieldName, this.digits, this.precis, value);
    }

    public BigDecimal getMaxValue() {
        if (this.maxValue == null) {
            this.minValue = CFLibBigDecimalUtil.getAbsoluteMaxValue(this.fieldName, this.digits, this.precis);
        }
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal value) {
        BigDecimal coerced;
        String S_ProcName = "setMaxValue";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.fieldName, "setMaxValue", 1, "value");
        }
        this.maxValue = coerced = CFLibBigDecimalUtil.coerce(this.fieldName, this.digits, this.precis, value);
    }

    public void setNumberValue(BigDecimal value) {
        if (value == null) {
            this.setText("");
        } else {
            String formatted = CFLibBigDecimalUtil.format(this.fieldName, this.digits, this.precis, value);
            this.setText(formatted);
        }
    }

    public BigDecimal getNumberValue() {
        String text = this.getText();
        BigDecimal retval = text == null || text.length() <= 0 ? null : CFLibBigDecimalUtil.parse(this.fieldName, this.digits, this.precis, text);
        return retval;
    }
}

