/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.text.DecimalFormat;
import java.text.Format;
import javafx.geometry.Pos;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX.CFFormattedTextField;

public class CFInt64Editor
extends CFFormattedTextField {
    protected static Format defaultFormat = null;
    protected long minValue = Long.MIN_VALUE;
    protected long maxValue = Long.MAX_VALUE;
    protected String fieldName = "?";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public static Format getDefaultFormat() {
        if (defaultFormat == null) {
            defaultFormat = new DecimalFormat("##################0;-##################0");
        }
        return defaultFormat;
    }

    public CFInt64Editor() {
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setMinWidth(210.0);
        this.setPrefWidth(210.0);
        this.setMaxWidth(210.0);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long value) {
        this.minValue = value;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long value) {
        this.maxValue = value;
    }

    public void setInt64Value(Long value) {
        if (value == null) {
            this.setText("");
        } else {
            String text = CFInt64Editor.getDefaultFormat().format(value);
            this.setText(text);
        }
    }

    public Long getInt64Value() {
        Long retval;
        String S_ProcName = "getInt64Value";
        String text = this.getText();
        if (text == null || text.length() <= 0) {
            retval = null;
        } else {
            Long v = Long.valueOf(text);
            if (v == null) {
                throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(this.fieldName, "getInt64Value", 0, "text", (Object)text);
            }
            if (v.compareTo(this.minValue) < 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "getInt64Value", 1, this.fieldName, (long)v, this.minValue);
            }
            if (v.compareTo(this.maxValue) > 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "getInt64Value", 1, this.fieldName, (long)v, this.maxValue);
            }
            retval = v;
        }
        return retval;
    }
}

