/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.text.DecimalFormat;
import java.text.Format;
import javafx.geometry.Pos;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX.CFFormattedTextField;

public class CFInt32Editor
extends CFFormattedTextField {
    protected static Format defaultFormat = null;
    protected int minValue = Integer.MIN_VALUE;
    protected int maxValue = Integer.MAX_VALUE;
    protected String fieldName = "?";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public static Format getDefaultFormat() {
        if (defaultFormat == null) {
            defaultFormat = new DecimalFormat("#########0;-#########0");
        }
        return defaultFormat;
    }

    public CFInt32Editor() {
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setMinWidth(120.0);
        this.setPrefWidth(120.0);
        this.setMaxWidth(120.0);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int value) {
        this.minValue = value;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public void setInt32Value(Integer value) {
        if (value == null) {
            this.setText("");
        } else {
            String text = CFInt32Editor.getDefaultFormat().format(value);
            this.setText(text);
        }
    }

    public Integer getInt32Value() {
        Integer retval;
        String S_ProcName = "getDoubleValue";
        String text = this.getText();
        if (text == null || text.length() <= 0) {
            retval = null;
        } else {
            Integer v = Integer.valueOf(text);
            if (v == null) {
                throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(this.fieldName, "getDoubleValue", 0, "text", (Object)text);
            }
            if (v.compareTo(this.minValue) < 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "getDoubleValue", 1, this.fieldName, (int)v, this.minValue);
            }
            if (v.compareTo(this.maxValue) > 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "getDoubleValue", 1, this.fieldName, (int)v, this.maxValue);
            }
            retval = v;
        }
        return retval;
    }
}

