/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.text.DecimalFormat;
import java.text.Format;
import javafx.geometry.Pos;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX.CFFormattedTextField;

public class CFFloatEditor
extends CFFormattedTextField {
    protected static Format defaultFormat = null;
    protected Float minValue = Float.valueOf(-3.4028235E38f);
    protected Float maxValue = Float.valueOf(Float.MAX_VALUE);
    protected String fieldName = "?";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public static Format getDefaultFormat() {
        if (defaultFormat == null) {
            defaultFormat = new DecimalFormat("######################################################################################################################################################################################################################################################################################################################0.0######################################################################################################################################################################################################################################################################################################################");
        }
        return defaultFormat;
    }

    public CFFloatEditor() {
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setMinWidth(160.0);
        this.setPrefWidth(160.0);
        this.setMaxWidth(300.0);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
    }

    public Float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Float value) {
        String S_ProcName = "setMinValue";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.fieldName, "setMinValue", 1, this.fieldName);
        }
        if (value.compareTo(Float.valueOf(-3.4028235E38f)) < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setMinValue", 1, this.fieldName, value.floatValue(), -3.4028235E38f);
        }
        this.minValue = value;
    }

    public Float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Float value) {
        String S_ProcName = "setMaxValue";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.fieldName, "setMaxValue", 1, this.fieldName);
        }
        if (value.compareTo(Float.valueOf(Float.MAX_VALUE)) > 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setMaxValue", 1, this.fieldName, value.floatValue(), Float.MAX_VALUE);
        }
        this.maxValue = value;
    }

    public void setFloatValue(Float value) {
        if (value == null) {
            this.setText("");
        } else {
            String text = CFFloatEditor.getDefaultFormat().format(value);
            this.setText(text);
        }
    }

    public Float getFloatValue() {
        Float retval;
        String S_ProcName = "getFloatValue";
        String text = this.getText();
        if (text == null || text.length() <= 0) {
            retval = null;
        } else {
            Float v = Float.valueOf(text);
            if (v == null) {
                throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(this.fieldName, "getFloatValue", 0, "text", (Object)text);
            }
            if (v.compareTo(this.minValue) < 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "getFloatValue", 1, this.fieldName, v.floatValue(), this.minValue.floatValue());
            }
            if (v.compareTo(this.maxValue) > 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "getFloatValue", 1, this.fieldName, v.floatValue(), this.maxValue.floatValue());
            }
            retval = v;
        }
        return retval;
    }
}

