/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.util.Calendar;
import javafx.scene.control.TextArea;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFConsole
extends TextArea {
    protected static boolean logExceptionsToSystem = true;
    protected static CFConsole sharedConsole = null;

    public CFConsole() {
        this.setPrefWidth(660.0);
        this.setMinHeight(50.0);
        this.setPrefHeight(50.0);
        this.setEditable(false);
        this.setWrapText(true);
        if (sharedConsole == null) {
            sharedConsole = this;
        }
    }

    public static boolean getLogExceptionsToSystem() {
        return logExceptionsToSystem;
    }

    public static void setLogExceptionsToSystem(boolean value) {
        logExceptionsToSystem = value;
    }

    protected void logMessage(String msg) {
        if (msg == null) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        String stamp = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL ", cal);
        buff.append(stamp);
        buff.append(msg);
        if (!msg.endsWith("\n")) {
            buff.append("\n");
        }
        this.appendText(buff.toString());
        this.positionCaret(this.getLength());
    }

    public static void message(String msg) {
        if (sharedConsole != null) {
            sharedConsole.logMessage(msg);
        }
    }

    protected void logFormException(String formName, String actionName, Throwable t) {
        String useActionName;
        String useFormName = formName != null ? formName : "?";
        String string = useActionName = actionName != null ? actionName : "?";
        if (t == null) {
            return;
        }
        String msg = t.getMessage();
        if (msg == null) {
            msg = "";
        }
        String className = t.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        String strippedClassName = className.substring(lastDot + 1);
        StringBuffer buff = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        String stamp = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL ", cal);
        buff.append(stamp);
        buff.append(useFormName + "." + useActionName + " caught " + strippedClassName + " - " + msg);
        buff.append("\n");
        String buffString = buff.toString();
        this.appendText(buffString);
        this.positionCaret(this.getLength());
        CFLib.beep();
        if (logExceptionsToSystem) {
            System.out.print(buffString);
            t.printStackTrace(System.out);
        }
    }

    public static void formException(String formName, String actionName, Throwable t) {
        if (sharedConsole != null) {
            sharedConsole.logFormException(formName, actionName, t);
        }
    }
}

