/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.UUID;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import org.apache.commons.codec.binary.Base64;

public class CFLibXmlUtil {
    public static final Calendar localCalendar = new GregorianCalendar();
    public static final int localTZOffsetMillis = localCalendar.get(15);
    protected static final String S_emptyString = "";

    public static Calendar parseDate(String value) {
        String S_ProcName = "parseDate";
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 10) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseDate", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DD, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseDate", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DD, \"" + value + "\" is invalid"));
        }
        int year = Integer.parseInt(value.substring(0, 4));
        int month = Integer.parseInt(value.substring(5, 7));
        int day = Integer.parseInt(value.substring(8, 10));
        GregorianCalendar retval = new GregorianCalendar(year, month - 1, day, 0, 0, 0);
        return retval;
    }

    public static Calendar parseDate(String fieldName, String value) {
        String S_ProcName = "parseDate";
        if (fieldName == null || fieldName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "parseDate", 1, "fieldName");
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 10) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseDate", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DD, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseDate", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DD, \"" + value + "\" is invalid"));
        }
        int year = Integer.parseInt(value.substring(0, 4));
        int month = Integer.parseInt(value.substring(5, 7));
        int day = Integer.parseInt(value.substring(8, 10));
        GregorianCalendar retval = new GregorianCalendar(year, month - 1, day, 0, 0, 0);
        return retval;
    }

    public static Calendar parseTime(String value) {
        String S_ProcName = "parseTime";
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 8) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTime", 1, "value", (Object)("Invalid value format, must be HH:MI:SS, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && value.charAt(2) == ':' && Character.isDigit(value.charAt(3)) && Character.isDigit(value.charAt(4)) && value.charAt(5) == ':' && Character.isDigit(value.charAt(6)) && Character.isDigit(value.charAt(7)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTime", 1, "value", (Object)("Invalid value format, must be HH:MI:SS, \"" + value + "\" is invalid"));
        }
        int hour = Integer.parseInt(value.substring(0, 2));
        int minute = Integer.parseInt(value.substring(3, 5));
        int second = Integer.parseInt(value.substring(6, 8));
        GregorianCalendar retval = new GregorianCalendar(1, 0, 1, hour, minute, second);
        return retval;
    }

    public static Calendar parseTime(String fieldName, String value) {
        String S_ProcName = "parseTime";
        if (fieldName == null || fieldName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "parseTime", 1, "fieldName");
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 8) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTime", 2, "value", (Object)("Invalid value format, must be HH:MI:SS, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && value.charAt(2) == ':' && Character.isDigit(value.charAt(3)) && Character.isDigit(value.charAt(4)) && value.charAt(5) == ':' && Character.isDigit(value.charAt(6)) && Character.isDigit(value.charAt(7)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTime", 2, "value", (Object)("Invalid value format, must be HH:MI:SS, \"" + value + "\" is invalid"));
        }
        int hour = Integer.parseInt(value.substring(0, 2));
        int minute = Integer.parseInt(value.substring(3, 5));
        int second = Integer.parseInt(value.substring(6, 8));
        GregorianCalendar retval = new GregorianCalendar(1, 0, 1, hour, minute, second);
        return retval;
    }

    public static Calendar parseTimestamp(String value) {
        String S_ProcName = "parseTimestamp";
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 19) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTimestamp", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SS, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)) && value.charAt(10) == 'T' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15)) && value.charAt(16) == ':' && Character.isDigit(value.charAt(17)) && Character.isDigit(value.charAt(18)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTimestamp", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SS, \"" + value + "\" is invalid"));
        }
        int year = Integer.parseInt(value.substring(0, 4));
        int month = Integer.parseInt(value.substring(5, 7));
        int day = Integer.parseInt(value.substring(8, 10));
        int hour = Integer.parseInt(value.substring(11, 13));
        int minute = Integer.parseInt(value.substring(14, 16));
        int second = Integer.parseInt(value.substring(17, 19));
        GregorianCalendar retval = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        return retval;
    }

    public static Calendar parseTimestamp(String fieldName, String value) {
        String S_ProcName = "parseTimestamp";
        if (fieldName == null || fieldName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "parseTimestamp", 1, "fieldName");
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 19) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTimestamp", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SS, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)) && value.charAt(10) == 'T' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15)) && value.charAt(16) == ':' && Character.isDigit(value.charAt(17)) && Character.isDigit(value.charAt(18)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTimestamp", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SS, \"" + value + "\" is invalid"));
        }
        int year = Integer.parseInt(value.substring(0, 4));
        int month = Integer.parseInt(value.substring(5, 7));
        int day = Integer.parseInt(value.substring(8, 10));
        int hour = Integer.parseInt(value.substring(11, 13));
        int minute = Integer.parseInt(value.substring(14, 16));
        int second = Integer.parseInt(value.substring(17, 19));
        GregorianCalendar retval = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        return retval;
    }

    public static Calendar parseTZDate(String value) {
        String S_ProcName = "parseTZDate";
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 11 && value.length() != 16) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZDate", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDZ or YYYY-MM-DD+HO:MO, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZDate", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDZ or YYYY-MM-DD+HO:MO, \"" + value + "\" is invalid"));
        }
        GregorianCalendar retval = null;
        if (value.charAt(10) == 'Z') {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            TimeZone tz = TimeZone.getTimeZone("GMT+0000");
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, 0);
            retval.set(12, 0);
            retval.set(13, 0);
            retval.getTimeInMillis();
        } else if (value.charAt(10) == '-' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            String tzCustomName = "GMT" + value.substring(10, 13) + value.substring(14, 16);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, 0);
            retval.set(12, 0);
            retval.set(13, 0);
            retval.getTimeInMillis();
        } else if (value.charAt(10) == '+' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            String tzCustomName = "GMT" + value.substring(10, 13) + value.substring(14, 16);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, 0);
            retval.set(12, 0);
            retval.set(13, 0);
            retval.getTimeInMillis();
        } else {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZDate", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDZ or YYYY-MM-DD+HO:MO, \"" + value + "\" is invalid"));
        }
        return retval;
    }

    public static Calendar parseTZDate(String fieldName, String value) {
        String S_ProcName = "parseTZDate";
        if (fieldName == null || fieldName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "parseTZDate", 1, "fieldName");
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 11 && value.length() != 16) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTZDate", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DDZ or YYYY-MM-DD+HO:MO, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTZDate", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DDZ or YYYY-MM-DD+HO:MO, \"" + value + "\" is invalid"));
        }
        GregorianCalendar retval = null;
        if (value.charAt(10) == 'Z') {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            TimeZone tz = TimeZone.getTimeZone("GMT+0000");
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, 0);
            retval.set(12, 0);
            retval.set(13, 0);
            retval.getTimeInMillis();
        } else if (value.charAt(10) == '-' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            String tzCustomName = "GMT" + value.substring(10, 13) + value.substring(14, 16);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, 0);
            retval.set(12, 0);
            retval.set(13, 0);
            retval.getTimeInMillis();
        } else if (value.charAt(10) == '+' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            String tzCustomName = "GMT" + value.substring(10, 13) + value.substring(14, 16);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, 0);
            retval.set(12, 0);
            retval.set(13, 0);
            retval.getTimeInMillis();
        } else {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTZDate", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DDZ or YYYY-MM-DD+HO:MO, \"" + value + "\" is invalid"));
        }
        return retval;
    }

    public static Calendar parseTZTime(String value) {
        String S_ProcName = "parseTZTime";
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 9 && value.length() != 14) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTime", 1, "value", (Object)("Invalid value format, must be HH:MI:SSZ or HH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && value.charAt(2) == ':' && Character.isDigit(value.charAt(3)) && Character.isDigit(value.charAt(4)) && value.charAt(5) == ':' && Character.isDigit(value.charAt(6)) && Character.isDigit(value.charAt(7)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTime", 1, "value", (Object)("Invalid value format, must be HH:MI:SSZ or HH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        GregorianCalendar retval = null;
        if (value.charAt(8) == 'Z') {
            int hour = Integer.parseInt(value.substring(0, 2));
            int minute = Integer.parseInt(value.substring(3, 5));
            int second = Integer.parseInt(value.substring(6, 8));
            TimeZone tz = TimeZone.getTimeZone("+0000");
            retval = new GregorianCalendar(tz);
            retval.set(1, 1970);
            retval.set(2, 0);
            retval.set(5, 1);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
            retval = new GregorianCalendar(1, 0, 1, hour, minute, second);
        } else if (value.charAt(8) == '-' && Character.isDigit(value.charAt(9)) && Character.isDigit(value.charAt(10)) && value.charAt(11) == ':' && Character.isDigit(value.charAt(12)) && Character.isDigit(value.charAt(13))) {
            int hour = Integer.parseInt(value.substring(0, 2));
            int minute = Integer.parseInt(value.substring(3, 5));
            int second = Integer.parseInt(value.substring(6, 8));
            String tzCustomName = "GMT" + value.substring(8, 11) + value.substring(12, 14);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, 1970);
            retval.set(2, 0);
            retval.set(5, 1);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else if (value.charAt(8) == '+' && Character.isDigit(value.charAt(9)) && Character.isDigit(value.charAt(10)) && value.charAt(11) == ':' && Character.isDigit(value.charAt(12)) && Character.isDigit(value.charAt(13))) {
            int hour = Integer.parseInt(value.substring(0, 2));
            int minute = Integer.parseInt(value.substring(3, 5));
            int second = Integer.parseInt(value.substring(6, 8));
            String tzCustomName = "GMT" + value.substring(8, 11) + value.substring(12, 14);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, 1970);
            retval.set(2, 0);
            retval.set(5, 1);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTime", 1, "value", (Object)("Invalid value format, must be HH:MI:SSZ or HH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        return retval;
    }

    public static Calendar parseTZTime(String fieldName, String value) {
        String S_ProcName = "parseTZTime";
        if (fieldName == null || fieldName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "parseTZTime", 1, "fieldName");
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 9 && value.length() != 14) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTZTime", 2, "value", (Object)("Invalid value format, must be HH:MI:SSZ or HH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && value.charAt(2) == ':' && Character.isDigit(value.charAt(3)) && Character.isDigit(value.charAt(4)) && value.charAt(5) == ':' && Character.isDigit(value.charAt(6)) && Character.isDigit(value.charAt(7)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTZTime", 2, "value", (Object)("Invalid value format, must be HH:MI:SSZ or HH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        GregorianCalendar retval = null;
        if (value.charAt(8) == 'Z') {
            int hour = Integer.parseInt(value.substring(0, 2));
            int minute = Integer.parseInt(value.substring(3, 5));
            int second = Integer.parseInt(value.substring(6, 8));
            TimeZone tz = TimeZone.getTimeZone("+0000");
            retval = new GregorianCalendar(tz);
            retval.set(1, 1970);
            retval.set(2, 0);
            retval.set(5, 1);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
            retval = new GregorianCalendar(1, 0, 1, hour, minute, second);
        } else if (value.charAt(8) == '-' && Character.isDigit(value.charAt(9)) && Character.isDigit(value.charAt(10)) && value.charAt(11) == ':' && Character.isDigit(value.charAt(12)) && Character.isDigit(value.charAt(13))) {
            int hour = Integer.parseInt(value.substring(0, 2));
            int minute = Integer.parseInt(value.substring(3, 5));
            int second = Integer.parseInt(value.substring(6, 8));
            String tzCustomName = "GMT" + value.substring(8, 11) + value.substring(12, 14);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, 1970);
            retval.set(2, 0);
            retval.set(5, 1);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else if (value.charAt(8) == '+' && Character.isDigit(value.charAt(9)) && Character.isDigit(value.charAt(10)) && value.charAt(11) == ':' && Character.isDigit(value.charAt(12)) && Character.isDigit(value.charAt(13))) {
            int hour = Integer.parseInt(value.substring(0, 2));
            int minute = Integer.parseInt(value.substring(3, 5));
            int second = Integer.parseInt(value.substring(6, 8));
            String tzCustomName = "GMT" + value.substring(8, 11) + value.substring(12, 14);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, 1970);
            retval.set(2, 0);
            retval.set(5, 1);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(fieldName, "parseTZTime", 2, "value", (Object)("Invalid value format, must be HH:MI:SSZ or HH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        return retval;
    }

    public static Calendar parseTZTimestamp(String value) {
        String S_ProcName = "parseTZTimestamp";
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 20 && value.length() != 25) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTimestamp", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SSZ or YYYY-MM-DDTHH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)) && value.charAt(10) == 'T' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15)) && value.charAt(16) == ':' && Character.isDigit(value.charAt(17)) && Character.isDigit(value.charAt(18)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTimestamp", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SSZ or YYYY-MM-DDTHH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        GregorianCalendar retval = null;
        if (value.charAt(19) == 'Z') {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            int hour = Integer.parseInt(value.substring(11, 13));
            int minute = Integer.parseInt(value.substring(14, 16));
            int second = Integer.parseInt(value.substring(17, 19));
            TimeZone tz = TimeZone.getTimeZone("+0000");
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
            retval = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        } else if (value.charAt(19) == '-' && Character.isDigit(value.charAt(20)) && Character.isDigit(value.charAt(21)) && value.charAt(22) == ':' && Character.isDigit(value.charAt(23)) && Character.isDigit(value.charAt(24))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            int hour = Integer.parseInt(value.substring(11, 13));
            int minute = Integer.parseInt(value.substring(14, 16));
            int second = Integer.parseInt(value.substring(17, 19));
            String tzCustomName = "GMT" + value.substring(19, 22) + value.substring(23, 25);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else if (value.charAt(19) == '+' && Character.isDigit(value.charAt(20)) && Character.isDigit(value.charAt(21)) && value.charAt(22) == ':' && Character.isDigit(value.charAt(23)) && Character.isDigit(value.charAt(24))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            int hour = Integer.parseInt(value.substring(11, 13));
            int minute = Integer.parseInt(value.substring(14, 16));
            int second = Integer.parseInt(value.substring(17, 19));
            String tzCustomName = "GMT" + value.substring(19, 22) + value.substring(23, 25);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTimestamp", 1, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SSZ or YYYY-MM-DDTHH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        return retval;
    }

    public static Calendar parseTZTimestamp(String fieldName, String value) {
        String S_ProcName = "parseTZTimestamp";
        if (fieldName == null || fieldName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "parseTZTimestamp", 1, "fieldName");
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() != 20 && value.length() != 25) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTimestamp", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SSZ or YYYY-MM-DDTHH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        if (!(Character.isDigit(value.charAt(0)) && Character.isDigit(value.charAt(1)) && Character.isDigit(value.charAt(2)) && Character.isDigit(value.charAt(3)) && value.charAt(4) == '-' && Character.isDigit(value.charAt(5)) && Character.isDigit(value.charAt(6)) && value.charAt(7) == '-' && Character.isDigit(value.charAt(8)) && Character.isDigit(value.charAt(9)) && value.charAt(10) == 'T' && Character.isDigit(value.charAt(11)) && Character.isDigit(value.charAt(12)) && value.charAt(13) == ':' && Character.isDigit(value.charAt(14)) && Character.isDigit(value.charAt(15)) && value.charAt(16) == ':' && Character.isDigit(value.charAt(17)) && Character.isDigit(value.charAt(18)))) {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTimestamp", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SSZ or YYYY-MM-DDTHH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        GregorianCalendar retval = null;
        if (value.charAt(19) == 'Z') {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            int hour = Integer.parseInt(value.substring(11, 13));
            int minute = Integer.parseInt(value.substring(14, 16));
            int second = Integer.parseInt(value.substring(17, 19));
            TimeZone tz = TimeZone.getTimeZone("+0000");
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
            retval = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        } else if (value.charAt(19) == '-' && Character.isDigit(value.charAt(20)) && Character.isDigit(value.charAt(21)) && value.charAt(22) == ':' && Character.isDigit(value.charAt(23)) && Character.isDigit(value.charAt(24))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            int hour = Integer.parseInt(value.substring(11, 13));
            int minute = Integer.parseInt(value.substring(14, 16));
            int second = Integer.parseInt(value.substring(17, 19));
            String tzCustomName = "GMT" + value.substring(19, 22) + value.substring(23, 25);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else if (value.charAt(19) == '+' && Character.isDigit(value.charAt(20)) && Character.isDigit(value.charAt(21)) && value.charAt(22) == ':' && Character.isDigit(value.charAt(23)) && Character.isDigit(value.charAt(24))) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            int hour = Integer.parseInt(value.substring(11, 13));
            int minute = Integer.parseInt(value.substring(14, 16));
            int second = Integer.parseInt(value.substring(17, 19));
            String tzCustomName = "GMT" + value.substring(19, 22) + value.substring(23, 25);
            TimeZone tz = TimeZone.getTimeZone(tzCustomName);
            retval = new GregorianCalendar(tz);
            retval.set(1, year);
            retval.set(2, month - 1);
            retval.set(5, day);
            retval.set(11, hour);
            retval.set(12, minute);
            retval.set(13, second);
            retval.getTimeInMillis();
        } else {
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "parseTZTimestamp", 2, "value", (Object)("Invalid value format, must be YYYY-MM-DDTHH:MI:SSZ or YYYY-MM-DDTHH:MI:SS+HO:MO, \"" + value + "\" is invalid"));
        }
        return retval;
    }

    public static String formatBoolean(boolean val) {
        String S_False = "false";
        String S_True = "true";
        String retval = val ? "true" : "false";
        return retval;
    }

    public static String formatBlob(byte[] val) {
        String S_ProcName = "formatBlob";
        if (val == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatBlob", 1, "val");
        }
        byte[] encoded = Base64.encodeBase64((byte[])val);
        String retval = new String(encoded);
        return retval;
    }

    public static String formatInt16(short val) {
        String retval = Short.toString(val);
        return retval;
    }

    public static String formatInt32(int val) {
        String retval = Integer.toString(val);
        return retval;
    }

    public static String formatInt64(long val) {
        String retval = Long.toString(val);
        return retval;
    }

    public static String formatUInt16(int val) {
        String S_ProcName = "formatUInt16";
        if (val < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(CFLibXmlUtil.class, "formatUInt16", 1, "val", val, 0);
        }
        String retval = Integer.toString(val);
        return retval;
    }

    public static String formatUInt32(long val) {
        String retval = Long.toString(val);
        return retval;
    }

    public static String formatUInt64(BigDecimal val) {
        String S_ProcName = "formatUInt64";
        if (val == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatUInt64", 1, "val");
        }
        String retval = val.toString();
        return retval;
    }

    public static String formatFloat(float val) {
        DecimalFormat fmt = new DecimalFormat("#################################################################################################################################0.##################################################################################################################################");
        String retval = fmt.format(val);
        return retval;
    }

    public static String formatDouble(double val) {
        DecimalFormat fmt = new DecimalFormat("#########################################################################################################################################################################################################################################################################################################################################0.##########################################################################################################################################################################################################################################################################################################################################");
        String retval = fmt.format(val);
        return retval;
    }

    public static String formatNumber(BigDecimal val) {
        String S_ProcName = "formatNumber";
        DecimalFormat fmt = new DecimalFormat("#########################################################################################################################################################################################################################################################################################################################################0.#########################################################################################################################################################################################################################################################################################################################################");
        if (val == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatNumber", 1, "val");
        }
        String retval = fmt.format(val);
        return retval;
    }

    public static String formatXmlString(String str) {
        String S_ProcName = "formatXmlString";
        if (str == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatXmlString", 1, "str");
        }
        StringBuffer buff = new StringBuffer();
        int len = str.length();
        block10: for (int idx = 0; idx < len; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\n': {
                    buff.append("&#10;");
                    continue block10;
                }
                case '\r': {
                    buff.append("&#13;");
                    continue block10;
                }
                case '\t': 
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buff.append(ch);
                    continue block10;
                }
                case '\'': {
                    buff.append("&apos;");
                    continue block10;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block10;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block10;
                }
                case '<': {
                    buff.append("&lt;");
                    continue block10;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block10;
                }
                default: {
                    if (!Character.isValidCodePoint(ch)) {
                        throw CFLib.getDefaultExceptionFactory().newArgumentRangeException(CFLibXmlUtil.class, "formatXmlString", "Only valid code points can be formatted, ch is out of range");
                    }
                    char charCode = ch;
                    String seq = "&#" + Integer.toString(charCode) + ";";
                    buff.append(seq);
                }
            }
        }
        String retval = buff.toString();
        return retval;
    }

    public static String formatXmlStringWhitespacePreserve(String str) {
        String S_ProcName = "formatXmlStringWhitespacePreserve";
        if (str == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatXmlStringWhitespacePreserve", 1, "str");
        }
        StringBuffer buff = new StringBuffer();
        int len = str.length();
        block8: for (int idx = 0; idx < len; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buff.append(ch);
                    continue block8;
                }
                case '\'': {
                    buff.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block8;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block8;
                }
                case '<': {
                    buff.append("&lt;");
                    continue block8;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block8;
                }
                default: {
                    if (!Character.isValidCodePoint(ch)) {
                        throw CFLib.getDefaultExceptionFactory().newArgumentRangeException(CFLibXmlUtil.class, "formatXmlStringWhitespacePreserve", "Only valid code points can be formatted, ch is out of range");
                    }
                    char charCode = ch;
                    String seq = "&#" + Integer.toString(charCode) + ";";
                    buff.append(seq);
                }
            }
        }
        String retval = buff.toString();
        return retval;
    }

    public static String formatDate(Calendar cal) {
        String S_ProcName = "formatDate";
        if (cal == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatDate", 1, "cal");
        }
        StringBuffer buff = new StringBuffer();
        Formatter fmt = new Formatter(buff);
        fmt.format("%1$04d", cal.get(1));
        buff.append('-');
        fmt.format("%1$02d", cal.get(2) + 1);
        buff.append('-');
        fmt.format("%1$02d", cal.get(5));
        String retval = buff.toString();
        fmt.close();
        return retval;
    }

    public static String formatTime(Calendar cal) {
        String S_ProcName = "formatTime";
        if (cal == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatTime", 1, "cal");
        }
        StringBuffer buff = new StringBuffer();
        Formatter fmt = new Formatter(buff);
        fmt.format("%1$02d", cal.get(11));
        buff.append(':');
        fmt.format("%1$02d", cal.get(12));
        buff.append(':');
        fmt.format("%1$02d", cal.get(13));
        String retval = buff.toString();
        fmt.close();
        return retval;
    }

    public static String formatTimestamp(Calendar cal) {
        String S_ProcName = "formatTimestamp";
        if (cal == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatTimestamp", 1, "cal");
        }
        StringBuffer buff = new StringBuffer();
        Formatter fmt = new Formatter(buff);
        fmt.format("%1$04d", cal.get(1));
        buff.append('-');
        fmt.format("%1$02d", cal.get(2) + 1);
        buff.append('-');
        fmt.format("%1$02d", cal.get(5));
        buff.append('T');
        fmt.format("%1$02d", cal.get(11));
        buff.append(':');
        fmt.format("%1$02d", cal.get(12));
        buff.append(':');
        fmt.format("%1$02d", cal.get(13));
        String retval = buff.toString();
        fmt.close();
        return retval;
    }

    public static String formatTZDate(Calendar cal) {
        String S_ProcName = "formatTZDate";
        if (cal == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatTZDate", 1, "cal");
        }
        StringBuffer buff = new StringBuffer();
        Formatter fmt = new Formatter(buff);
        fmt.format("%1$04d", cal.get(1));
        buff.append('-');
        fmt.format("%1$02d", cal.get(2) + 1);
        buff.append('-');
        fmt.format("%1$02d", cal.get(5));
        int tzoff = cal.getTimeZone().getRawOffset() / 60000;
        if (tzoff < 0) {
            tzoff = 0 - tzoff;
            buff.append('-');
        } else {
            buff.append('+');
        }
        int tzhour = tzoff / 60;
        int tzmin = tzoff % 60;
        if (tzhour > 12) {
            fmt.close();
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "formatTZDate", 0, "tzhour", (Object)tzhour);
        }
        fmt.format("%1$02d", tzhour);
        buff.append(':');
        fmt.format("%1$02d", tzmin);
        String retval = buff.toString();
        fmt.close();
        return retval;
    }

    public static String formatTZTime(Calendar cal) {
        String S_ProcName = "formatTZTime";
        if (cal == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatTZTime", 1, "cal");
        }
        StringBuffer buff = new StringBuffer();
        Formatter fmt = new Formatter(buff);
        fmt.format("%1$02d", cal.get(11));
        buff.append(':');
        fmt.format("%1$02d", cal.get(12));
        buff.append(':');
        fmt.format("%1$02d", cal.get(13));
        int tzoff = cal.getTimeZone().getRawOffset() / 60000;
        if (tzoff < 0) {
            tzoff = 0 - tzoff;
            buff.append('-');
        } else {
            buff.append('+');
        }
        int tzhour = tzoff / 60;
        int tzmin = tzoff % 60;
        if (tzhour > 12) {
            fmt.close();
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "formatTZTime", 0, "tzhour", (Object)tzhour);
        }
        fmt.format("%1$02d", tzhour);
        buff.append(':');
        fmt.format("%1$02d", tzmin);
        String retval = buff.toString();
        fmt.close();
        return retval;
    }

    public static String formatTZTimestamp(Calendar cal) {
        String S_ProcName = "formatTZTimestamp";
        if (cal == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatTZTimestamp", 1, "cal");
        }
        StringBuffer buff = new StringBuffer();
        Formatter fmt = new Formatter(buff);
        fmt.format("%1$04d", cal.get(1));
        buff.append('-');
        fmt.format("%1$02d", cal.get(2) + 1);
        buff.append('-');
        fmt.format("%1$02d", cal.get(5));
        buff.append('T');
        fmt.format("%1$02d", cal.get(11));
        buff.append(':');
        fmt.format("%1$02d", cal.get(12));
        buff.append(':');
        fmt.format("%1$02d", cal.get(13));
        int tzoff = cal.getTimeZone().getRawOffset() / 60000;
        if (tzoff < 0) {
            tzoff = 0 - tzoff;
            buff.append('-');
        } else {
            buff.append('+');
        }
        int tzhour = tzoff / 60;
        int tzmin = tzoff % 60;
        if (tzhour > 12) {
            fmt.close();
            throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(CFLibXmlUtil.class, "formatTZTimestamp", 0, "tzhour", (Object)tzhour);
        }
        fmt.format("%1$02d", tzhour);
        buff.append(':');
        fmt.format("%1$02d", tzmin);
        String retval = buff.toString();
        fmt.close();
        return retval;
    }

    public static String formatUuid(UUID val) {
        String S_ProcName = "formatUuid";
        if (val == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatUuid", 1, "val");
        }
        String retval = val.toString();
        return retval;
    }

    public static String formatRequiredBoolean(String separator, String attrName, boolean val) {
        String S_ProcName = "formatRequiredBoolean";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredBoolean", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatBoolean(val) + "\"";
        return retval;
    }

    public static String formatRequiredBlob(String separator, String attrName, byte[] val) {
        String S_ProcName = "formatRequiredBlob";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredBlob", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatBlob(val) + "\"";
        return retval;
    }

    public static String formatRequiredInt16(String separator, String attrName, short val) {
        String S_ProcName = "formatRequiredInt16";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredInt16", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatInt16(val) + "\"";
        return retval;
    }

    public static String formatRequiredInt32(String separator, String attrName, int val) {
        String S_ProcName = "formatRequiredInt32";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredInt32", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatInt32(val) + "\"";
        return retval;
    }

    public static String formatRequiredInt64(String separator, String attrName, long val) {
        String S_ProcName = "formatRequiredInt64";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredInt64", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatInt64(val) + "\"";
        return retval;
    }

    public static String formatRequiredUInt16(String separator, String attrName, int val) {
        String S_ProcName = "formatRequiredUInt16";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredUInt16", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatUInt16(val) + "\"";
        return retval;
    }

    public static String formatRequiredUInt32(String separator, String attrName, long val) {
        String S_ProcName = "formatRequiredUInt32";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredUInt32", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatUInt32(val) + "\"";
        return retval;
    }

    public static String formatRequiredUInt64(String separator, String attrName, BigDecimal val) {
        String S_ProcName = "formatRequiredUInt64";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredUInt64", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatUInt64(val) + "\"";
        return retval;
    }

    public static String formatRequiredFloat(String separator, String attrName, float val) {
        String S_ProcName = "formatRequiredFloat";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredFloat", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatFloat(val) + "\"";
        return retval;
    }

    public static String formatRequiredDouble(String separator, String attrName, double val) {
        String S_ProcName = "formatRequiredDouble";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredDouble", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatDouble(val) + "\"";
        return retval;
    }

    public static String formatRequiredNumber(String separator, String attrName, BigDecimal val) {
        String S_ProcName = "formatRequiredNumber";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredNumber", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatNumber(val) + "\"";
        return retval;
    }

    public static String formatRequiredXmlString(String separator, String attrName, String str) {
        String S_ProcName = "formatRequiredXmlString";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredXmlString", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatXmlString(str) + "\"";
        return retval;
    }

    public static String formatRequiredDate(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatRequiredDate";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredDate", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatDate(cal) + "\"";
        return retval;
    }

    public static String formatRequiredTime(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatRequiredTime";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredTime", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatTime(cal) + "\"";
        return retval;
    }

    public static String formatRequiredTimestamp(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatRequiredTimestamp";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredTimestamp", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatTimestamp(cal) + "\"";
        return retval;
    }

    public static String formatRequiredTZDate(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatRequiredTZDate";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredTZDate", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatTZDate(cal) + "\"";
        return retval;
    }

    public static String formatRequiredTZTime(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatRequiredTZTime";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredTZTime", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatTZTime(cal) + "\"";
        return retval;
    }

    public static String formatRequiredTZTimestamp(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatRequiredTZTimestamp";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredTZTimestamp", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatTZTimestamp(cal) + "\"";
        return retval;
    }

    public static String formatRequiredUuid(String separator, String attrName, UUID val) {
        String S_ProcName = "formatRequiredUuid";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatRequiredUuid", 1, "attrName");
        }
        String retval = (separator != null ? separator : S_emptyString) + attrName + "=\"" + CFLibXmlUtil.formatUuid(val) + "\"";
        return retval;
    }

    public static String formatOptionalBoolean(String separator, String attrName, Boolean val) {
        String S_ProcName = "formatOptionalBoolean";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalBoolean", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredBoolean(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalBlob(String separator, String attrName, byte[] val) {
        String S_ProcName = "formatOptionalBlob";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalBlob", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredBlob(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalInt16(String separator, String attrName, Short val) {
        String S_ProcName = "formatOptionalInt16";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalInt16", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredInt16(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalInt32(String separator, String attrName, Integer val) {
        String S_ProcName = "formatOptionalInt32";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalInt32", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredInt32(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalInt64(String separator, String attrName, Long val) {
        String S_ProcName = "formatOptionalInt64";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalInt64", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredInt64(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalUInt16(String separator, String attrName, Integer val) {
        String S_ProcName = "formatOptionalUInt16";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalUInt16", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredUInt16(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalUInt32(String separator, String attrName, Long val) {
        String S_ProcName = "formatOptionalUInt32";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalUInt32", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredUInt32(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalUInt64(String separator, String attrName, BigDecimal val) {
        String S_ProcName = "formatOptionalUInt64";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalUInt64", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredUInt64(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalFloat(String separator, String attrName, Float val) {
        String S_ProcName = "formatOptionalFloat";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalFloat", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredFloat(separator, attrName, val.floatValue()) : S_emptyString;
        return retval;
    }

    public static String formatOptionalDouble(String separator, String attrName, Double val) {
        String S_ProcName = "formatOptionalDouble";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalDouble", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredDouble(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalNumber(String separator, String attrName, BigDecimal val) {
        String S_ProcName = "formatOptionalNumber";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalNumber", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredNumber(separator, attrName, val) : S_emptyString;
        return retval;
    }

    public static String formatOptionalXmlString(String separator, String attrName, String str) {
        String S_ProcName = "formatOptionalXmlString";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalXmlString", 1, "attrName");
        }
        String retval = str != null ? CFLibXmlUtil.formatRequiredXmlString(separator, attrName, str) : S_emptyString;
        return retval;
    }

    public static String formatOptionalDate(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatOptionalDate";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalDate", 1, "attrName");
        }
        String retval = cal != null ? CFLibXmlUtil.formatRequiredDate(separator, attrName, cal) : S_emptyString;
        return retval;
    }

    public static String formatOptionalTime(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatOptionalTime";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalTime", 1, "attrName");
        }
        String retval = cal != null ? CFLibXmlUtil.formatRequiredTime(separator, attrName, cal) : S_emptyString;
        return retval;
    }

    public static String formatOptionalTimestamp(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatOptionalTimestamp";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalTimestamp", 1, "attrName");
        }
        String retval = cal != null ? CFLibXmlUtil.formatRequiredTimestamp(separator, attrName, cal) : S_emptyString;
        return retval;
    }

    public static String formatOptionalTZDate(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatOptionalTZDate";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalTZDate", 1, "attrName");
        }
        String retval = cal != null ? CFLibXmlUtil.formatRequiredTZDate(separator, attrName, cal) : S_emptyString;
        return retval;
    }

    public static String formatOptionalTZTime(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatOptionalTZTime";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalTZTime", 1, "attrName");
        }
        String retval = cal != null ? CFLibXmlUtil.formatRequiredTZTime(separator, attrName, cal) : S_emptyString;
        return retval;
    }

    public static String formatOptionalTZTimestamp(String separator, String attrName, Calendar cal) {
        String S_ProcName = "formatOptionalTZTimestamp";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalTZTimestamp", 1, "attrName");
        }
        String retval = cal != null ? CFLibXmlUtil.formatRequiredTZTimestamp(separator, attrName, cal) : S_emptyString;
        return retval;
    }

    public static String formatOptionalUuid(String separator, String attrName, UUID val) {
        String S_ProcName = "formatOptionalUuid";
        if (attrName == null || attrName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibXmlUtil.class, "formatOptionalUuid", 1, "attrName");
        }
        String retval = val != null ? CFLibXmlUtil.formatRequiredUuid(separator, attrName, val) : S_emptyString;
        return retval;
    }
}

