/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class CFLibXmlCoreSaxParser
extends CFLibXmlCoreParser {
    protected SAXParser saxParser = null;

    public CFLibXmlCoreSaxParser() {
    }

    public CFLibXmlCoreSaxParser(ICFLibMessageLog jLogger) {
        super(jLogger);
    }

    @Override
    public String getAPI() {
        return "sax";
    }

    @Override
    protected void initParser() {
        super.initParser();
        String S_ProcName = "initParser";
        try {
            assert (this.saxParser == null) : "saxParser already exists";
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setXIncludeAware(false);
            spf.setValidating(true);
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            spf.setFeature("http://xml.org/sax/features/validation", true);
            spf.setFeature("http://apache.org/xml/features/validation/schema", true);
            spf.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", true);
            SAXParser sp = spf.newSAXParser();
            sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            sp.setProperty("http://apache.org/xml/properties/internal/grammar-pool", CFLibXmlCoreSaxParser.getGrammarPool());
            XMLReader reader = sp.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", true);
            reader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", CFLibXmlCoreSaxParser.getGrammarPool());
            this.saxParser = sp;
        }
        catch (SAXParseException spf) {
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.initParser() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("CFLibXmlCoreSaxParser.initParser() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.initParser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            System.err.append("CFLibXmlCoreSaxParser.initParser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
        }
    }

    protected void parse(String uri) {
        assert (uri != null && uri.length() > 0) : "uri (parm 1) is null or empty";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(uri, (DefaultHandler)this);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
        }
        catch (FileNotFoundException e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            }
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
        }
    }

    public void parseStringContents(String str) {
        String S_ProcName = "parseStringContents";
        if (str == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "parseStringContents", 1, "str");
        }
        byte[] bytes = str.getBytes();
        ByteArrayInputStream instream = new ByteArrayInputStream(bytes);
        this.parse(instream);
    }

    protected void parse(InputStream inputStream) {
        assert (inputStream != null) : "inputStream (arg 1) is null";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
        }
    }
}

