/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreContext;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreContextFactory;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreElementHandler;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class CFLibXmlCoreParser
extends DefaultHandler
implements CFLibXmlCoreContextFactory {
    public static final String API_SAX = "sax";
    public static final String API_DOM = "dom";
    public static final boolean DEFAULT_XINCLUDE = false;
    public static final boolean DEFAULT_SECURE_PROCESSING = false;
    private boolean xIncludeAware = false;
    private boolean secureProcessingEnabled = false;
    private ICFLibMessageLog log = null;
    private Locator documentLocator = null;
    private CFLibXmlCoreElementHandler rootElementHandler = null;
    private volatile LinkedList<CFLibXmlCoreContext> contextStack = new LinkedList();
    private CFLibXmlCoreContextFactory xmlCoreContextFactory = null;
    private static XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();

    public static XMLGrammarPool getGrammarPool() {
        return grammarPool;
    }

    public static Grammar addToGrammarPool(String name, InputStream input) {
        Grammar grammar;
        assert (grammarPool != null);
        XMLGrammarPreparser preparser = new XMLGrammarPreparser();
        preparser.setGrammarPool((XMLGrammarPool)grammarPool);
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        XMLInputSource inputSource = new XMLInputSource("parseGrammar", name, name, input, "UTF-8");
        try {
            grammar = preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", inputSource);
        }
        catch (IOException e) {
            grammar = null;
        }
        try {
            input.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (grammar != null) {
            Grammar existingGrammar = grammarPool.retrieveGrammar(grammar.getGrammarDescription());
            if (existingGrammar != null) {
                grammar = existingGrammar;
            } else {
                grammarPool.putGrammar(grammar);
            }
        }
        return grammar;
    }

    public CFLibXmlCoreParser() {
        this.log = null;
    }

    public CFLibXmlCoreParser(ICFLibMessageLog jlog) {
        assert (jlog != null) : "jlog (arg 1) is null";
        this.log = jlog;
    }

    public abstract String getAPI();

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean flag) {
        this.xIncludeAware = flag;
    }

    public boolean isSecureProcessingEnabled() {
        return this.secureProcessingEnabled;
    }

    public void setSecureProcessingEnabled(boolean flag) {
        this.secureProcessingEnabled = flag;
    }

    @Override
    public ICFLibMessageLog getLog() {
        return this.log;
    }

    public void setLog(ICFLibMessageLog jlog) {
        assert (jlog != null) : "jlog (arg 1) is null";
        this.log = jlog;
    }

    public CFLibXmlCoreElementHandler getRootElementHandler() {
        return this.rootElementHandler;
    }

    protected void setRootElementHandler(CFLibXmlCoreElementHandler handler) {
        assert (handler != null) : "handler (arg 1) is null";
        this.rootElementHandler = handler;
    }

    public Locator getDocumentLocator() {
        return this.documentLocator;
    }

    public String getLocationInfo() {
        Locator locator = this.getDocumentLocator();
        StringBuffer buff = new StringBuffer();
        if (locator != null) {
            int line;
            int lastSlash;
            String shortName = null;
            String docName = locator.getSystemId();
            if (docName != null && (lastSlash = docName.lastIndexOf(47)) >= 0 && lastSlash != docName.length()) {
                shortName = new String(docName.substring(lastSlash + 1));
            }
            if (shortName == null && (docName = locator.getPublicId()) != null && (lastSlash = docName.lastIndexOf(47)) >= 0 && lastSlash != docName.length()) {
                shortName = new String(docName.substring(lastSlash + 1));
            }
            if (shortName != null) {
                buff.append(shortName);
            }
            if ((line = locator.getLineNumber()) >= 0) {
                buff.append("[" + line);
                int col = locator.getColumnNumber();
                if (col >= 0) {
                    buff.append("," + col);
                }
                buff.append("]");
            }
            buff.append(" ");
        }
        return buff.toString();
    }

    public CFLibXmlCoreContext getCurContext() {
        if (this.contextStack.isEmpty()) {
            return null;
        }
        CFLibXmlCoreContext curContext = this.contextStack.getLast();
        return curContext;
    }

    public CFLibXmlCoreContextFactory getXmlCoreContextFactory() {
        return this.xmlCoreContextFactory;
    }

    public void setXmlCoreContextFactory(CFLibXmlCoreContextFactory factory) {
        assert (factory != null) : "factory (arg 1) is null";
        this.xmlCoreContextFactory = factory;
    }

    @Override
    public CFLibXmlCoreContext newXmlCoreContext(CFLibXmlCoreContext src, String qName, CFLibXmlCoreElementHandler handler) {
        CFLibXmlCoreContext retval = this.xmlCoreContextFactory != null && this.xmlCoreContextFactory != this ? this.xmlCoreContextFactory.newXmlCoreContext(src, qName, handler) : new CFLibXmlCoreContext(src, qName, handler);
        return retval;
    }

    @Override
    public CFLibXmlCoreContext newXmlCoreContext(CFLibXmlCoreParser coreParser, ICFLibMessageLog jlog, CFLibXmlCoreElementHandler elementHandler) {
        CFLibXmlCoreContext retval = this.xmlCoreContextFactory != null && this.xmlCoreContextFactory != this ? this.xmlCoreContextFactory.newXmlCoreContext(coreParser, jlog, elementHandler) : new CFLibXmlCoreContext(coreParser, jlog, elementHandler);
        return retval;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        String fmt = this.formatMessage(ex);
        if (this.log != null) {
            this.log.message("WARN:  " + fmt);
        } else {
            System.err.append("WARN:  " + fmt + "\n");
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        String fmt = this.formatMessage(ex);
        if (this.log != null) {
            this.log.message("ERROR: " + fmt);
        } else {
            System.err.append("ERROR: " + fmt + "\n");
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        String fmt = this.formatMessage(ex);
        if (this.log != null) {
            this.log.message("FATAL: " + fmt);
        } else {
            System.err.append("FATAL: " + fmt + "\n");
        }
    }

    protected String formatMessage(SAXParseException ex) {
        StringBuffer buff = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            buff.append(systemId);
        }
        buff.append('[');
        buff.append(ex.getLineNumber());
        buff.append(',');
        buff.append(ex.getColumnNumber());
        buff.append("]: ");
        buff.append(ex.getMessage());
        buff.append('\n');
        return buff.toString();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        assert (locator != null) : "locator (arg 1) is null";
        this.documentLocator = locator;
    }

    public String getFormattedNearLocation() {
        Object retval;
        Locator loc = this.getDocumentLocator();
        if (loc != null) {
            String sysid = loc.getSystemId();
            if (sysid == null) {
                sysid = "";
            }
            int lineno = loc.getLineNumber();
            int colno = loc.getColumnNumber();
            retval = "near " + sysid + (String)(lineno > 0 ? "[" + Integer.toString(lineno) + (String)(colno > 0 ? "." + Integer.toString(colno) : "") + "]" : "") + " ";
        } else {
            retval = "";
        }
        return retval;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        CFLibXmlCoreContext prev;
        if (this.contextStack.isEmpty()) {
            CFLibXmlCoreElementHandler rootHandler = this.getRootElementHandler();
            assert (rootHandler != null);
            CFLibXmlCoreContext rootContext = new CFLibXmlCoreContext(this, this.getLog(), rootHandler);
            this.contextStack.addLast(rootContext);
        }
        if ((prev = this.contextStack.getLast()) == null) {
            throw new RuntimeException("ContextStack.top is a null value");
        }
        CFLibXmlCoreElementHandler prevHandler = prev.getElementHandler();
        if (prevHandler == null) {
            throw new RuntimeException("ContextStack.top.ElementHandler is null");
        }
        CFLibXmlCoreElementHandler curHandler = prevHandler.getElementHandler(qName);
        if (curHandler == null) {
            throw new RuntimeException("ContextStack.top.ElementHandler<" + prevHandler.getClass().getSimpleName() + ">.getElementHandler( \"" + qName + "\" ) has no such mapping");
        }
        CFLibXmlCoreContext curContext = new CFLibXmlCoreContext(prev, qName, curHandler);
        this.contextStack.addLast(curContext);
        curHandler.startElement(uri, localName, qName, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        assert (!this.contextStack.isEmpty()) : "ContextStack underflow";
        CFLibXmlCoreContext curContext = this.contextStack.getLast();
        CFLibXmlCoreElementHandler curHandler = curContext.getElementHandler();
        try {
            curHandler.endElement(uri, localName, qName);
        }
        finally {
            this.contextStack.removeLast();
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (ch == null || length <= 0) {
            return;
        }
        this.getCurContext().appendElementText(ch, start, length);
    }

    public StringBuffer appendLocatorInformation(StringBuffer buff) {
        assert (buff != null) : "buff (arg 1) is null";
        Locator locator = this.getDocumentLocator();
        if (locator != null) {
            int line;
            int lastSlash;
            String shortName = null;
            String docName = locator.getSystemId();
            if (docName != null && (lastSlash = docName.lastIndexOf(47)) >= 0 && lastSlash != docName.length()) {
                shortName = new String(docName.substring(lastSlash + 1));
            }
            if (shortName == null && (docName = locator.getPublicId()) != null && (lastSlash = docName.lastIndexOf(47)) >= 0 && lastSlash != docName.length()) {
                shortName = new String(docName.substring(lastSlash + 1));
            }
            if (shortName != null) {
                buff.append(shortName);
            }
            if ((line = locator.getLineNumber()) >= 0) {
                buff.append("[" + line);
                buff.append("]");
            }
        }
        return buff;
    }

    protected void initParser() {
        assert (this.log != null) : "log must be set before initializaton";
        assert (this.rootElementHandler != null) : "RootElementHandler must be set before initialization";
    }
}

