/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib;

import java.util.Calendar;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFLibDbUtil {
    public static final TimeZone tzUTC = TimeZone.getTimeZone("GMT+0000");
    public static final Calendar localCalendar = new GregorianCalendar();
    public static final int localTZOffsetMillis;
    public static int dbServerTZOffsetMillis;
    public static TimeZone dbServerTimeZone;

    public static int getDbServerTZOffsetMillis() {
        return dbServerTZOffsetMillis;
    }

    public static void setDbServerTZOffsetMillis(int value) {
        dbServerTZOffsetMillis = value;
        dbServerTimeZone = null;
    }

    public static TimeZone getDbServerTimeZone() {
        if (dbServerTimeZone == null) {
            int secondsOnly = dbServerTZOffsetMillis / 1000;
            int minutesOnly = secondsOnly / 60;
            int absMinutes = minutesOnly < 0 ? 0 - minutesOnly : minutesOnly;
            int minutes = absMinutes % 60;
            int hours = absMinutes / 60;
            StringBuffer buff = new StringBuffer();
            Formatter fmt = new Formatter(buff);
            if (minutesOnly < 0) {
                buff.append("GMT-");
            } else {
                buff.append("GMT+");
            }
            fmt.format("%1$02d", hours);
            fmt.format("%1$02d", minutes);
            dbServerTimeZone = TimeZone.getTimeZone(buff.toString());
            fmt.close();
        }
        return dbServerTimeZone;
    }

    public static void setDbServerTimeZone(TimeZone tz) {
        if (tz == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibDbUtil.class, "setDbServerTimeZone", 1, "tz");
        }
        dbServerTimeZone = tz;
        dbServerTZOffsetMillis = tz.getRawOffset();
    }

    public static Calendar getDbServerCalendar(Calendar value) {
        if (value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(CFLibDbUtil.getDbServerTimeZone());
        cal.setTimeInMillis(value.getTimeInMillis());
        return cal;
    }

    public static Calendar getUTCCalendar(Calendar value) {
        if (value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(tzUTC);
        cal.setTimeInMillis(value.getTimeInMillis());
        return cal;
    }

    static {
        dbServerTZOffsetMillis = localTZOffsetMillis = localCalendar.get(15);
        dbServerTimeZone = null;
    }
}

