/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFLibBigDecimalUtil {
    public static final int MAX_DIGITS = 31;
    public static final int MAX_PRECISION = 30;
    static final String S_Hashes = "###############################";
    static final String S_Zeroes = "0000000000000000000000000000000";
    static final String S_Nines = "9999999999999999999999999999999";

    public static Format getNumberFormat(String fieldOrClassName, int argDigits, int argPrecis) {
        String S_ProcName = "getNumberFormat";
        if (fieldOrClassName == null || fieldOrClassName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibBigDecimalUtil.class, "getNumberFormat", 1, "fieldOrClassName");
        }
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "getNumberFormat", 2, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 2, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, argDigits - 1);
        }
        int integerDigits = argDigits - argPrecis;
        String usePrefixHash = S_Hashes.substring(0, integerDigits - 1);
        Object useSuffix = argPrecis > 0 ? "." + S_Zeroes.substring(0, argPrecis) : "";
        DecimalFormat numberFormat = new DecimalFormat(usePrefixHash + "0" + (String)useSuffix + ";-" + usePrefixHash + "0" + (String)useSuffix);
        return numberFormat;
    }

    public static BigDecimal getAbsoluteMinValue(String fieldOrClassName, int argDigits, int argPrecis) {
        String S_ProcName = "getNumberFormat";
        if (fieldOrClassName == null || fieldOrClassName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibBigDecimalUtil.class, "getNumberFormat", 1, "fieldOrClassName");
        }
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "getNumberFormat", 2, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 2, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, argDigits - 1);
        }
        int integerDigits = argDigits - argPrecis;
        String strval = argPrecis == 0 ? "-" + S_Nines.substring(0, integerDigits) : "-" + S_Nines.substring(0, integerDigits) + "." + S_Nines.substring(0, argPrecis);
        BigDecimal absoluteMinValue = new BigDecimal(strval);
        return absoluteMinValue;
    }

    public static BigDecimal getAbsoluteMaxValue(String fieldOrClassName, int argDigits, int argPrecis) {
        String S_ProcName = "getNumberFormat";
        if (fieldOrClassName == null || fieldOrClassName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibBigDecimalUtil.class, "getNumberFormat", 1, "fieldOrClassName");
        }
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "getNumberFormat", 2, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 2, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "getNumberFormat", 3, "argPrecis", argPrecis, argDigits - 1);
        }
        int integerDigits = argDigits - argPrecis;
        Object strval = argPrecis == 0 ? S_Nines.substring(0, integerDigits) : S_Nines.substring(0, integerDigits) + "." + S_Nines.substring(0, argPrecis);
        BigDecimal absoluteMaxValue = new BigDecimal((String)strval);
        return absoluteMaxValue;
    }

    public static BigDecimal coerce(String fieldOrClassName, int argDigits, int argPrecis, BigDecimal value) {
        String S_ProcName = "coerce";
        if (fieldOrClassName == null || fieldOrClassName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibBigDecimalUtil.class, "coerce", 1, "fieldOrClassName");
        }
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(fieldOrClassName, "coerce", 4, "value");
        }
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "coerce", 2, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "coerce", 2, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "coerce", 3, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "coerce", 3, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "coerce", 3, "argPrecis", argPrecis, argDigits - 1);
        }
        BigDecimal minValue = CFLibBigDecimalUtil.getAbsoluteMinValue(fieldOrClassName, argDigits, argPrecis);
        if (value.compareTo(minValue) < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "coerce", 4, "value", value, minValue);
        }
        BigDecimal maxValue = CFLibBigDecimalUtil.getAbsoluteMaxValue(fieldOrClassName, argDigits, argPrecis);
        if (value.compareTo(maxValue) > 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "coerce", 4, "value", value, maxValue);
        }
        String coercedString = CFLibBigDecimalUtil.getNumberFormat(fieldOrClassName, argDigits, argPrecis).format(value);
        BigDecimal coercedValue = new BigDecimal(coercedString);
        return coercedValue;
    }

    public static BigDecimal parse(String fieldOrClassName, int argDigits, int argPrecis, String value) {
        String S_ProcName = "parse";
        if (fieldOrClassName == null || fieldOrClassName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibBigDecimalUtil.class, "parse", 1, "fieldOrClassName");
        }
        if (value == null || value.length() <= 0) {
            return null;
        }
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "parse", 2, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "parse", 2, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "parse", 3, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "parse", 3, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "parse", 3, "argPrecis", argPrecis, argDigits - 1);
        }
        BigDecimal rawValue = new BigDecimal(value);
        BigDecimal minValue = CFLibBigDecimalUtil.getAbsoluteMinValue(fieldOrClassName, argDigits, argPrecis);
        BigDecimal maxValue = CFLibBigDecimalUtil.getAbsoluteMaxValue(fieldOrClassName, argDigits, argPrecis);
        if (rawValue.compareTo(minValue) < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "parse", 4, "value", rawValue, minValue);
        }
        if (rawValue.compareTo(maxValue) > 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "parse", 4, "value", rawValue, maxValue);
        }
        String coercedString = CFLibBigDecimalUtil.getNumberFormat(fieldOrClassName, argDigits, argPrecis).format(rawValue);
        BigDecimal coercedValue = new BigDecimal(coercedString);
        return coercedValue;
    }

    public static String format(String fieldOrClassName, int argDigits, int argPrecis, BigDecimal value) {
        String S_ProcName = "format";
        if (fieldOrClassName == null || fieldOrClassName.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(CFLibBigDecimalUtil.class, "format", 1, "fieldOrClassName");
        }
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(fieldOrClassName, "format", 4, "value");
        }
        if (argDigits < 1) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "format", 2, "argDigits", argDigits, 1);
        }
        if (argDigits > 31) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "format", 2, "argDigits", argDigits, 31);
        }
        if (argPrecis < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "format", 3, "argPrecis", argPrecis, 0);
        }
        if (argPrecis > 30) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "format", 3, "argPrecis", argPrecis, 30);
        }
        if (argPrecis >= argDigits) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "format", 3, "argPrecis", argPrecis, argDigits - 1);
        }
        BigDecimal minValue = CFLibBigDecimalUtil.getAbsoluteMinValue(fieldOrClassName, argDigits, argPrecis);
        if (value.compareTo(minValue) < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(fieldOrClassName, "format", 4, "value", value, minValue);
        }
        BigDecimal maxValue = CFLibBigDecimalUtil.getAbsoluteMaxValue(fieldOrClassName, argDigits, argPrecis);
        if (value.compareTo(maxValue) > 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(fieldOrClassName, "format", 4, "value", value, maxValue);
        }
        String coercedString = CFLibBigDecimalUtil.getNumberFormat(fieldOrClassName, argDigits, argPrecis).format(value);
        return coercedString;
    }
}

