/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibEnCaExceptionFactory;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibExceptionFactory;

public class CFLib {
    public static final String LinkName = "CFLib";
    public static final String LinkVersion = "2.9.14143";
    protected static ICFLibExceptionFactory defaultExceptionFactory = new CFLibEnCaExceptionFactory();
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("+0000");

    public static void beep() {
        Clip clip = null;
        try {
            InputStream resource = CFLib.class.getResourceAsStream("/sounds/alert.wav");
            if (resource != null) {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(resource));
                DataLine.Info info = new DataLine.Info(Clip.class, audioInputStream.getFormat());
                clip = (Clip)AudioSystem.getLine(info);
                clip.open(audioInputStream);
                clip.start();
                clip.drain();
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static Calendar getUTCGregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar(UTC_TIMEZONE);
        cal.clear();
        cal.set(year, month, day, hour, minute, second);
        cal.getTimeInMillis();
        return cal;
    }

    public String getLinkName() {
        return LinkName;
    }

    public String getLinkVersion() {
        return LinkVersion;
    }

    public static ICFLibExceptionFactory getDefaultExceptionFactory() {
        return defaultExceptionFactory;
    }

    public static void setDefaultExceptionFactory(ICFLibExceptionFactory value) {
        if (value == null) {
            throw defaultExceptionFactory.newNullArgumentException(CFLib.class, "setExceptionFactory", 1, "value", null);
        }
        defaultExceptionFactory = value;
    }
}

