/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.ICFInternetSchema;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.CFInternetServiceEditObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.CFInternetServiceObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetServiceTableObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServiceBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServiceByClusterIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServiceByHostIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServiceByTypeIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServiceByUHostPortIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServiceByUTypeIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServicePKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySchemaObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityServiceEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityServiceObj;

public class CFInternetServiceTableObj
implements ICFInternetServiceTableObj {
    protected ICFSecuritySchemaObj schema;
    private Map<CFSecurityServicePKey, ICFSecurityServiceObj> members;
    private Map<CFSecurityServicePKey, ICFSecurityServiceObj> allService;
    private Map<CFSecurityServiceByClusterIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>> indexByClusterIdx;
    private Map<CFSecurityServiceByHostIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>> indexByHostIdx;
    private Map<CFSecurityServiceByTypeIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>> indexByTypeIdx;
    private Map<CFSecurityServiceByUTypeIdxKey, ICFSecurityServiceObj> indexByUTypeIdx;
    private Map<CFSecurityServiceByUHostPortIdxKey, ICFSecurityServiceObj> indexByUHostPortIdx;
    public static String TABLE_NAME = "Service";
    public static String TABLE_DBNAME = "hostsvc";

    public CFInternetServiceTableObj() {
        this.schema = null;
        this.members = new HashMap<CFSecurityServicePKey, ICFSecurityServiceObj>();
        this.allService = null;
        this.indexByClusterIdx = null;
        this.indexByHostIdx = null;
        this.indexByTypeIdx = null;
        this.indexByUTypeIdx = null;
        this.indexByUHostPortIdx = null;
    }

    public CFInternetServiceTableObj(ICFSecuritySchemaObj argSchema) {
        this.schema = argSchema;
        this.members = new HashMap<CFSecurityServicePKey, ICFSecurityServiceObj>();
        this.allService = null;
        this.indexByClusterIdx = null;
        this.indexByHostIdx = null;
        this.indexByTypeIdx = null;
        this.indexByUTypeIdx = null;
        this.indexByUHostPortIdx = null;
    }

    public ICFSecuritySchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFSecuritySchemaObj value) {
        this.schema = value;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getTableDbName() {
        return TABLE_DBNAME;
    }

    public Class getObjQualifyingClass() {
        return null;
    }

    public void minimizeMemory() {
        this.allService = null;
        this.indexByClusterIdx = null;
        this.indexByHostIdx = null;
        this.indexByTypeIdx = null;
        this.indexByUTypeIdx = null;
        this.indexByUHostPortIdx = null;
        LinkedList<ICFSecurityServiceObj> toForget = new LinkedList<ICFSecurityServiceObj>();
        ICFSecurityServiceObj cur2 = null;
        for (ICFSecurityServiceObj cur2 : this.members.values()) {
            toForget.add(cur2);
        }
        for (ICFSecurityServiceObj cur2 : toForget) {
            cur2.forget();
        }
    }

    public ICFSecurityServiceObj newInstance() {
        CFInternetServiceObj inst = new CFInternetServiceObj(this.schema);
        return inst;
    }

    public ICFSecurityServiceEditObj newEditInstance(ICFSecurityServiceObj orig) {
        CFInternetServiceEditObj edit = new CFInternetServiceEditObj(orig);
        return edit;
    }

    public ICFSecurityServiceObj realizeService(ICFSecurityServiceObj Obj) {
        ICFSecurityServiceObj obj = Obj;
        CFSecurityServicePKey pkey = obj.getPKey();
        ICFSecurityServiceObj keepObj = null;
        if (this.members.containsKey(pkey) && null != this.members.get(pkey)) {
            CFSecurityServiceByUHostPortIdxKey keyUHostPortIdx;
            CFSecurityServiceByUTypeIdxKey keyUTypeIdx;
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapTypeIdx;
            CFSecurityServiceByTypeIdxKey keyTypeIdx;
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapHostIdx;
            CFSecurityServiceByHostIdxKey keyHostIdx;
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapClusterIdx;
            CFSecurityServiceByClusterIdxKey keyClusterIdx;
            ICFSecurityServiceObj existingObj;
            keepObj = existingObj = this.members.get(pkey);
            if (this.indexByClusterIdx != null) {
                keyClusterIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByHostIdx != null) {
                keyHostIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newHostIdxKey();
                keyHostIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyHostIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                mapHostIdx = this.indexByHostIdx.get(keyHostIdx);
                if (mapHostIdx != null) {
                    mapHostIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByTypeIdx != null) {
                keyTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newTypeIdxKey();
                keyTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                mapTypeIdx = this.indexByTypeIdx.get(keyTypeIdx);
                if (mapTypeIdx != null) {
                    mapTypeIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByUTypeIdx != null) {
                keyUTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUTypeIdxKey();
                keyUTypeIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUTypeIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                this.indexByUTypeIdx.remove(keyUTypeIdx);
            }
            if (this.indexByUHostPortIdx != null) {
                keyUHostPortIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUHostPortIdxKey();
                keyUHostPortIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUHostPortIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUHostPortIdx.setRequiredHostPort(keepObj.getRequiredHostPort());
                this.indexByUHostPortIdx.remove(keyUHostPortIdx);
            }
            keepObj.setBuff(Obj.getBuff());
            if (this.indexByClusterIdx != null) {
                keyClusterIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByHostIdx != null) {
                keyHostIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newHostIdxKey();
                keyHostIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyHostIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                mapHostIdx = this.indexByHostIdx.get(keyHostIdx);
                if (mapHostIdx != null) {
                    mapHostIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByTypeIdx != null) {
                keyTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newTypeIdxKey();
                keyTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                mapTypeIdx = this.indexByTypeIdx.get(keyTypeIdx);
                if (mapTypeIdx != null) {
                    mapTypeIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByUTypeIdx != null) {
                keyUTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUTypeIdxKey();
                keyUTypeIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUTypeIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                this.indexByUTypeIdx.put(keyUTypeIdx, keepObj);
            }
            if (this.indexByUHostPortIdx != null) {
                keyUHostPortIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUHostPortIdxKey();
                keyUHostPortIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUHostPortIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUHostPortIdx.setRequiredHostPort(keepObj.getRequiredHostPort());
                this.indexByUHostPortIdx.put(keyUHostPortIdx, keepObj);
            }
            if (this.allService != null) {
                this.allService.put(keepObj.getPKey(), keepObj);
            }
        } else {
            keepObj = obj;
            keepObj.setIsNew(false);
            this.members.put(keepObj.getPKey(), keepObj);
            if (this.allService != null) {
                this.allService.put(keepObj.getPKey(), keepObj);
            }
            if (this.indexByClusterIdx != null) {
                CFSecurityServiceByClusterIdxKey keyClusterIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByHostIdx != null) {
                CFSecurityServiceByHostIdxKey keyHostIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newHostIdxKey();
                keyHostIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyHostIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapHostIdx = this.indexByHostIdx.get(keyHostIdx);
                if (mapHostIdx != null) {
                    mapHostIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByTypeIdx != null) {
                CFSecurityServiceByTypeIdxKey keyTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newTypeIdxKey();
                keyTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapTypeIdx = this.indexByTypeIdx.get(keyTypeIdx);
                if (mapTypeIdx != null) {
                    mapTypeIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByUTypeIdx != null) {
                CFSecurityServiceByUTypeIdxKey keyUTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUTypeIdxKey();
                keyUTypeIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUTypeIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                this.indexByUTypeIdx.put(keyUTypeIdx, keepObj);
            }
            if (this.indexByUHostPortIdx != null) {
                CFSecurityServiceByUHostPortIdxKey keyUHostPortIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUHostPortIdxKey();
                keyUHostPortIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUHostPortIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUHostPortIdx.setRequiredHostPort(keepObj.getRequiredHostPort());
                this.indexByUHostPortIdx.put(keyUHostPortIdx, keepObj);
            }
        }
        return keepObj;
    }

    public void forgetService(ICFSecurityServiceObj Obj) {
        this.forgetService(Obj, false);
    }

    public void forgetService(ICFSecurityServiceObj Obj, boolean forgetSubObjects) {
        ICFSecurityServiceObj obj = Obj;
        CFSecurityServicePKey pkey = obj.getPKey();
        if (this.members.containsKey(pkey)) {
            ICFSecurityServiceObj keepObj = this.members.get(pkey);
            if (this.indexByClusterIdx != null) {
                CFSecurityServiceByClusterIdxKey keyClusterIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByHostIdx != null) {
                CFSecurityServiceByHostIdxKey keyHostIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newHostIdxKey();
                keyHostIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyHostIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapHostIdx = this.indexByHostIdx.get(keyHostIdx);
                if (mapHostIdx != null) {
                    mapHostIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByTypeIdx != null) {
                CFSecurityServiceByTypeIdxKey keyTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newTypeIdxKey();
                keyTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapTypeIdx = this.indexByTypeIdx.get(keyTypeIdx);
                if (mapTypeIdx != null) {
                    mapTypeIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByUTypeIdx != null) {
                CFSecurityServiceByUTypeIdxKey keyUTypeIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUTypeIdxKey();
                keyUTypeIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUTypeIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUTypeIdx.setRequiredServiceTypeId(keepObj.getRequiredServiceTypeId());
                this.indexByUTypeIdx.remove(keyUTypeIdx);
            }
            if (this.indexByUHostPortIdx != null) {
                CFSecurityServiceByUHostPortIdxKey keyUHostPortIdx = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUHostPortIdxKey();
                keyUHostPortIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUHostPortIdx.setRequiredHostNodeId(keepObj.getRequiredHostNodeId());
                keyUHostPortIdx.setRequiredHostPort(keepObj.getRequiredHostPort());
                this.indexByUHostPortIdx.remove(keyUHostPortIdx);
            }
            if (this.allService != null) {
                this.allService.remove(keepObj.getPKey());
            }
            this.members.remove(pkey);
            if (forgetSubObjects) {
                // empty if block
            }
        }
    }

    public void forgetServiceByIdIdx(long ClusterId, long ServiceId) {
        ICFSecurityServiceObj probed;
        if (this.members == null) {
            return;
        }
        CFSecurityServicePKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredServiceId(ServiceId);
        if (this.members.containsKey(key) && (probed = this.members.get(key)) != null) {
            probed.forget(true);
        }
    }

    public void forgetServiceByClusterIdx(long ClusterId) {
        if (this.indexByClusterIdx == null) {
            return;
        }
        CFSecurityServiceByClusterIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx.containsKey(key)) {
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapClusterIdx = this.indexByClusterIdx.get(key);
            if (mapClusterIdx != null) {
                LinkedList<ICFSecurityServiceObj> toForget = new LinkedList<ICFSecurityServiceObj>();
                ICFSecurityServiceObj cur2 = null;
                for (ICFSecurityServiceObj cur2 : mapClusterIdx.values()) {
                    toForget.add(cur2);
                }
                for (ICFSecurityServiceObj cur2 : toForget) {
                    cur2.forget(true);
                }
            }
            this.indexByClusterIdx.remove(key);
        }
    }

    public void forgetServiceByHostIdx(long ClusterId, long HostNodeId) {
        if (this.indexByHostIdx == null) {
            return;
        }
        CFSecurityServiceByHostIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newHostIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        if (this.indexByHostIdx.containsKey(key)) {
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapHostIdx = this.indexByHostIdx.get(key);
            if (mapHostIdx != null) {
                LinkedList<ICFSecurityServiceObj> toForget = new LinkedList<ICFSecurityServiceObj>();
                ICFSecurityServiceObj cur2 = null;
                for (ICFSecurityServiceObj cur2 : mapHostIdx.values()) {
                    toForget.add(cur2);
                }
                for (ICFSecurityServiceObj cur2 : toForget) {
                    cur2.forget(true);
                }
            }
            this.indexByHostIdx.remove(key);
        }
    }

    public void forgetServiceByTypeIdx(int ServiceTypeId) {
        if (this.indexByTypeIdx == null) {
            return;
        }
        CFSecurityServiceByTypeIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newTypeIdxKey();
        key.setRequiredServiceTypeId(ServiceTypeId);
        if (this.indexByTypeIdx.containsKey(key)) {
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> mapTypeIdx = this.indexByTypeIdx.get(key);
            if (mapTypeIdx != null) {
                LinkedList<ICFSecurityServiceObj> toForget = new LinkedList<ICFSecurityServiceObj>();
                ICFSecurityServiceObj cur2 = null;
                for (ICFSecurityServiceObj cur2 : mapTypeIdx.values()) {
                    toForget.add(cur2);
                }
                for (ICFSecurityServiceObj cur2 : toForget) {
                    cur2.forget(true);
                }
            }
            this.indexByTypeIdx.remove(key);
        }
    }

    public void forgetServiceByUTypeIdx(long ClusterId, long HostNodeId, int ServiceTypeId) {
        if (this.indexByUTypeIdx == null) {
            return;
        }
        CFSecurityServiceByUTypeIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUTypeIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        key.setRequiredServiceTypeId(ServiceTypeId);
        if (this.indexByUTypeIdx.containsKey(key)) {
            ICFSecurityServiceObj probed = this.indexByUTypeIdx.get(key);
            if (probed != null) {
                probed.forget(true);
            }
            this.indexByUTypeIdx.remove(key);
        }
    }

    public void forgetServiceByUHostPortIdx(long ClusterId, long HostNodeId, short HostPort) {
        if (this.indexByUHostPortIdx == null) {
            return;
        }
        CFSecurityServiceByUHostPortIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUHostPortIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        key.setRequiredHostPort(HostPort);
        if (this.indexByUHostPortIdx.containsKey(key)) {
            ICFSecurityServiceObj probed = this.indexByUHostPortIdx.get(key);
            if (probed != null) {
                probed.forget(true);
            }
            this.indexByUHostPortIdx.remove(key);
        }
    }

    public ICFSecurityServiceObj createService(ICFSecurityServiceObj Obj) {
        ICFSecurityServiceObj obj = Obj;
        CFSecurityServiceBuff buff = obj.getServiceBuff();
        ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().createService(this.schema.getAuthorization(), buff);
        obj.copyBuffToPKey();
        obj = obj.realize();
        return obj;
    }

    public ICFSecurityServiceObj readService(CFSecurityServicePKey pkey) {
        return this.readService(pkey, false);
    }

    public ICFSecurityServiceObj readService(CFSecurityServicePKey pkey, boolean forceRead) {
        ICFSecurityServiceObj obj = null;
        if (!forceRead && this.members.containsKey(pkey)) {
            obj = this.members.get(pkey);
        } else {
            CFSecurityServiceBuff readBuff = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readDerivedByIdIdx(this.schema.getAuthorization(), pkey.getRequiredClusterId(), pkey.getRequiredServiceId());
            if (readBuff != null) {
                obj = this.schema.getServiceTableObj().newInstance();
                obj.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
                obj.setBuff(readBuff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.members.put(pkey, null);
            }
        }
        return obj;
    }

    public ICFSecurityServiceObj lockService(CFSecurityServicePKey pkey) {
        ICFSecurityServiceObj locked = null;
        CFSecurityServiceBuff lockBuff = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().lockDerived(this.schema.getAuthorization(), pkey);
        if (lockBuff == null) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "lockService", (Object)pkey);
        }
        locked = this.schema.getServiceTableObj().newInstance();
        locked.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
        locked.setBuff(lockBuff);
        locked = locked.realize();
        return locked;
    }

    public List<ICFSecurityServiceObj> readAllService() {
        return this.readAllService(false);
    }

    public List<ICFSecurityServiceObj> readAllService(boolean forceRead) {
        int idx;
        String S_ProcName = "readAllService";
        if (this.allService == null || forceRead) {
            HashMap<CFSecurityServicePKey, ICFSecurityServiceObj> map = new HashMap<CFSecurityServicePKey, ICFSecurityServiceObj>();
            this.allService = map;
            CFSecurityServiceBuff[] buffList = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readAllDerived(this.schema.getAuthorization());
            for (idx = 0; idx < buffList.length; ++idx) {
                CFSecurityServiceBuff buff = buffList[idx];
                ICFSecurityServiceObj obj = this.newInstance();
                obj.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
                obj.setBuff(buff);
                ICFSecurityServiceObj iCFSecurityServiceObj = obj.realize();
            }
        }
        Comparator<ICFSecurityServiceObj> cmp = new Comparator<ICFSecurityServiceObj>(){

            @Override
            public int compare(ICFSecurityServiceObj lhs, ICFSecurityServiceObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFSecurityServicePKey lhsPKey = lhs.getPKey();
                CFSecurityServicePKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo((Object)rhsPKey);
                return ret;
            }
        };
        int len = this.allService.size();
        ICFSecurityServiceObj[] arr = new ICFSecurityServiceObj[len];
        Iterator<ICFSecurityServiceObj> valIter = this.allService.values().iterator();
        idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readAllService", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readAllService", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFSecurityServiceObj> arrayList = new ArrayList<ICFSecurityServiceObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFSecurityServiceObj> sortedList = arrayList;
        return sortedList;
    }

    public ICFSecurityServiceObj readServiceByIdIdx(long ClusterId, long ServiceId) {
        return this.readServiceByIdIdx(ClusterId, ServiceId, false);
    }

    public ICFSecurityServiceObj readServiceByIdIdx(long ClusterId, long ServiceId, boolean forceRead) {
        CFSecurityServicePKey pkey = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey();
        pkey.setRequiredClusterId(ClusterId);
        pkey.setRequiredServiceId(ServiceId);
        ICFSecurityServiceObj obj = this.readService(pkey, forceRead);
        return obj;
    }

    public List<ICFSecurityServiceObj> readServiceByClusterIdx(long ClusterId) {
        return this.readServiceByClusterIdx(ClusterId, false);
    }

    public List<ICFSecurityServiceObj> readServiceByClusterIdx(long ClusterId, boolean forceRead) {
        Map<Object, Object> dict;
        String S_ProcName = "readServiceByClusterIdx";
        CFSecurityServiceByClusterIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx == null) {
            this.indexByClusterIdx = new HashMap<CFSecurityServiceByClusterIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>>();
        }
        if (!forceRead && this.indexByClusterIdx.containsKey(key)) {
            dict = this.indexByClusterIdx.get(key);
        } else {
            dict = new HashMap();
            this.indexByClusterIdx.put(key, dict);
            CFSecurityServiceBuff[] buffList = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readDerivedByClusterIdx(this.schema.getAuthorization(), ClusterId);
            for (int idx = 0; idx < buffList.length; ++idx) {
                CFSecurityServiceBuff buff = buffList[idx];
                ICFSecurityServiceObj obj = this.schema.getServiceTableObj().newInstance();
                obj.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
                obj.setBuff(buff);
                ICFSecurityServiceObj iCFSecurityServiceObj = obj.realize();
            }
        }
        Comparator<ICFSecurityServiceObj> cmp = new Comparator<ICFSecurityServiceObj>(){

            @Override
            public int compare(ICFSecurityServiceObj lhs, ICFSecurityServiceObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFSecurityServicePKey lhsPKey = lhs.getPKey();
                CFSecurityServicePKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo((Object)rhsPKey);
                return ret;
            }
        };
        int len = dict.size();
        ICFSecurityServiceObj[] arr = new ICFSecurityServiceObj[len];
        Iterator<Object> valIter = dict.values().iterator();
        int idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = (ICFSecurityServiceObj)valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readServiceByClusterIdx", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readServiceByClusterIdx", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFSecurityServiceObj> arrayList = new ArrayList<ICFSecurityServiceObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFSecurityServiceObj> sortedList = arrayList;
        return sortedList;
    }

    public List<ICFSecurityServiceObj> readServiceByHostIdx(long ClusterId, long HostNodeId) {
        return this.readServiceByHostIdx(ClusterId, HostNodeId, false);
    }

    public List<ICFSecurityServiceObj> readServiceByHostIdx(long ClusterId, long HostNodeId, boolean forceRead) {
        Map<Object, Object> dict;
        String S_ProcName = "readServiceByHostIdx";
        CFSecurityServiceByHostIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newHostIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        if (this.indexByHostIdx == null) {
            this.indexByHostIdx = new HashMap<CFSecurityServiceByHostIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>>();
        }
        if (!forceRead && this.indexByHostIdx.containsKey(key)) {
            dict = this.indexByHostIdx.get(key);
        } else {
            dict = new HashMap();
            this.indexByHostIdx.put(key, dict);
            CFSecurityServiceBuff[] buffList = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readDerivedByHostIdx(this.schema.getAuthorization(), ClusterId, HostNodeId);
            for (int idx = 0; idx < buffList.length; ++idx) {
                CFSecurityServiceBuff buff = buffList[idx];
                ICFSecurityServiceObj obj = this.schema.getServiceTableObj().newInstance();
                obj.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
                obj.setBuff(buff);
                ICFSecurityServiceObj iCFSecurityServiceObj = obj.realize();
            }
        }
        Comparator<ICFSecurityServiceObj> cmp = new Comparator<ICFSecurityServiceObj>(){

            @Override
            public int compare(ICFSecurityServiceObj lhs, ICFSecurityServiceObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFSecurityServicePKey lhsPKey = lhs.getPKey();
                CFSecurityServicePKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo((Object)rhsPKey);
                return ret;
            }
        };
        int len = dict.size();
        ICFSecurityServiceObj[] arr = new ICFSecurityServiceObj[len];
        Iterator<Object> valIter = dict.values().iterator();
        int idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = (ICFSecurityServiceObj)valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readServiceByHostIdx", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readServiceByHostIdx", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFSecurityServiceObj> arrayList = new ArrayList<ICFSecurityServiceObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFSecurityServiceObj> sortedList = arrayList;
        return sortedList;
    }

    public List<ICFSecurityServiceObj> readServiceByTypeIdx(int ServiceTypeId) {
        return this.readServiceByTypeIdx(ServiceTypeId, false);
    }

    public List<ICFSecurityServiceObj> readServiceByTypeIdx(int ServiceTypeId, boolean forceRead) {
        Map<Object, Object> dict;
        String S_ProcName = "readServiceByTypeIdx";
        CFSecurityServiceByTypeIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newTypeIdxKey();
        key.setRequiredServiceTypeId(ServiceTypeId);
        if (this.indexByTypeIdx == null) {
            this.indexByTypeIdx = new HashMap<CFSecurityServiceByTypeIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>>();
        }
        if (!forceRead && this.indexByTypeIdx.containsKey(key)) {
            dict = this.indexByTypeIdx.get(key);
        } else {
            dict = new HashMap();
            this.indexByTypeIdx.put(key, dict);
            CFSecurityServiceBuff[] buffList = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readDerivedByTypeIdx(this.schema.getAuthorization(), ServiceTypeId);
            for (int idx = 0; idx < buffList.length; ++idx) {
                CFSecurityServiceBuff buff = buffList[idx];
                ICFSecurityServiceObj obj = this.schema.getServiceTableObj().newInstance();
                obj.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
                obj.setBuff(buff);
                ICFSecurityServiceObj iCFSecurityServiceObj = obj.realize();
            }
        }
        Comparator<ICFSecurityServiceObj> cmp = new Comparator<ICFSecurityServiceObj>(){

            @Override
            public int compare(ICFSecurityServiceObj lhs, ICFSecurityServiceObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFSecurityServicePKey lhsPKey = lhs.getPKey();
                CFSecurityServicePKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo((Object)rhsPKey);
                return ret;
            }
        };
        int len = dict.size();
        ICFSecurityServiceObj[] arr = new ICFSecurityServiceObj[len];
        Iterator<Object> valIter = dict.values().iterator();
        int idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = (ICFSecurityServiceObj)valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readServiceByTypeIdx", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readServiceByTypeIdx", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFSecurityServiceObj> arrayList = new ArrayList<ICFSecurityServiceObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFSecurityServiceObj> sortedList = arrayList;
        return sortedList;
    }

    public ICFSecurityServiceObj readServiceByUTypeIdx(long ClusterId, long HostNodeId, int ServiceTypeId) {
        return this.readServiceByUTypeIdx(ClusterId, HostNodeId, ServiceTypeId, false);
    }

    public ICFSecurityServiceObj readServiceByUTypeIdx(long ClusterId, long HostNodeId, int ServiceTypeId, boolean forceRead) {
        if (this.indexByUTypeIdx == null) {
            this.indexByUTypeIdx = new HashMap<CFSecurityServiceByUTypeIdxKey, ICFSecurityServiceObj>();
        }
        CFSecurityServiceByUTypeIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUTypeIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        key.setRequiredServiceTypeId(ServiceTypeId);
        ICFSecurityServiceObj obj = null;
        if (!forceRead && this.indexByUTypeIdx.containsKey(key)) {
            obj = this.indexByUTypeIdx.get(key);
        } else {
            CFSecurityServiceBuff buff = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readDerivedByUTypeIdx(this.schema.getAuthorization(), ClusterId, HostNodeId, ServiceTypeId);
            if (buff != null) {
                obj = this.schema.getServiceTableObj().newInstance();
                obj.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
                obj.setBuff(buff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.indexByUTypeIdx.put(key, null);
            }
        }
        return obj;
    }

    public ICFSecurityServiceObj readServiceByUHostPortIdx(long ClusterId, long HostNodeId, short HostPort) {
        return this.readServiceByUHostPortIdx(ClusterId, HostNodeId, HostPort, false);
    }

    public ICFSecurityServiceObj readServiceByUHostPortIdx(long ClusterId, long HostNodeId, short HostPort, boolean forceRead) {
        if (this.indexByUHostPortIdx == null) {
            this.indexByUHostPortIdx = new HashMap<CFSecurityServiceByUHostPortIdxKey, ICFSecurityServiceObj>();
        }
        CFSecurityServiceByUHostPortIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUHostPortIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        key.setRequiredHostPort(HostPort);
        ICFSecurityServiceObj obj = null;
        if (!forceRead && this.indexByUHostPortIdx.containsKey(key)) {
            obj = this.indexByUHostPortIdx.get(key);
        } else {
            CFSecurityServiceBuff buff = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readDerivedByUHostPortIdx(this.schema.getAuthorization(), ClusterId, HostNodeId, HostPort);
            if (buff != null) {
                obj = this.schema.getServiceTableObj().newInstance();
                obj.setPKey(((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey());
                obj.setBuff(buff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.indexByUHostPortIdx.put(key, null);
            }
        }
        return obj;
    }

    public ICFSecurityServiceObj updateService(ICFSecurityServiceObj Obj) {
        ICFSecurityServiceObj obj = Obj;
        ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().updateService(this.schema.getAuthorization(), Obj.getServiceBuff());
        obj = Obj.realize();
        return obj;
    }

    public void deleteService(ICFSecurityServiceObj Obj) {
        ICFSecurityServiceObj obj = Obj;
        ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteService(this.schema.getAuthorization(), obj.getServiceBuff());
        obj.forget(true);
    }

    public void deleteServiceByIdIdx(long ClusterId, long ServiceId) {
        CFSecurityServicePKey pkey = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey();
        pkey.setRequiredClusterId(ClusterId);
        pkey.setRequiredServiceId(ServiceId);
        ICFSecurityServiceObj obj = this.readService(pkey);
        if (obj != null) {
            ICFSecurityServiceEditObj editObj = obj.getEdit();
            boolean editStarted = editObj == null ? (editObj = obj.beginEdit()) != null : false;
            if (editObj != null) {
                editObj.delete();
                if (editStarted) {
                    editObj.endEdit();
                }
            }
            obj.forget(true);
        }
    }

    public void deleteServiceByClusterIdx(long ClusterId) {
        CFSecurityServiceByClusterIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx == null) {
            this.indexByClusterIdx = new HashMap<CFSecurityServiceByClusterIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>>();
        }
        if (this.indexByClusterIdx.containsKey(key)) {
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> dict = this.indexByClusterIdx.get(key);
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByClusterIdx(this.schema.getAuthorization(), ClusterId);
            Iterator<Object> iter = dict.values().iterator();
            LinkedList<ICFSecurityServiceObj> toForget = new LinkedList<ICFSecurityServiceObj>();
            while (iter.hasNext()) {
                ICFSecurityServiceObj obj = iter.next();
                toForget.add(obj);
            }
            for (ICFSecurityServiceObj obj : toForget) {
                obj.forget(true);
            }
            this.indexByClusterIdx.remove(key);
        } else {
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByClusterIdx(this.schema.getAuthorization(), ClusterId);
        }
    }

    public void deleteServiceByHostIdx(long ClusterId, long HostNodeId) {
        CFSecurityServiceByHostIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newHostIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        if (this.indexByHostIdx == null) {
            this.indexByHostIdx = new HashMap<CFSecurityServiceByHostIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>>();
        }
        if (this.indexByHostIdx.containsKey(key)) {
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> dict = this.indexByHostIdx.get(key);
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByHostIdx(this.schema.getAuthorization(), ClusterId, HostNodeId);
            Iterator<Object> iter = dict.values().iterator();
            LinkedList<ICFSecurityServiceObj> toForget = new LinkedList<ICFSecurityServiceObj>();
            while (iter.hasNext()) {
                ICFSecurityServiceObj obj = iter.next();
                toForget.add(obj);
            }
            for (ICFSecurityServiceObj obj : toForget) {
                obj.forget(true);
            }
            this.indexByHostIdx.remove(key);
        } else {
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByHostIdx(this.schema.getAuthorization(), ClusterId, HostNodeId);
        }
    }

    public void deleteServiceByTypeIdx(int ServiceTypeId) {
        CFSecurityServiceByTypeIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newTypeIdxKey();
        key.setRequiredServiceTypeId(ServiceTypeId);
        if (this.indexByTypeIdx == null) {
            this.indexByTypeIdx = new HashMap<CFSecurityServiceByTypeIdxKey, Map<CFSecurityServicePKey, ICFSecurityServiceObj>>();
        }
        if (this.indexByTypeIdx.containsKey(key)) {
            Map<CFSecurityServicePKey, ICFSecurityServiceObj> dict = this.indexByTypeIdx.get(key);
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByTypeIdx(this.schema.getAuthorization(), ServiceTypeId);
            Iterator<Object> iter = dict.values().iterator();
            LinkedList<ICFSecurityServiceObj> toForget = new LinkedList<ICFSecurityServiceObj>();
            while (iter.hasNext()) {
                ICFSecurityServiceObj obj = iter.next();
                toForget.add(obj);
            }
            for (ICFSecurityServiceObj obj : toForget) {
                obj.forget(true);
            }
            this.indexByTypeIdx.remove(key);
        } else {
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByTypeIdx(this.schema.getAuthorization(), ServiceTypeId);
        }
    }

    public void deleteServiceByUTypeIdx(long ClusterId, long HostNodeId, int ServiceTypeId) {
        if (this.indexByUTypeIdx == null) {
            this.indexByUTypeIdx = new HashMap<CFSecurityServiceByUTypeIdxKey, ICFSecurityServiceObj>();
        }
        CFSecurityServiceByUTypeIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUTypeIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        key.setRequiredServiceTypeId(ServiceTypeId);
        ICFSecurityServiceObj obj = null;
        if (this.indexByUTypeIdx.containsKey(key)) {
            obj = this.indexByUTypeIdx.get(key);
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByUTypeIdx(this.schema.getAuthorization(), ClusterId, HostNodeId, ServiceTypeId);
            obj.forget(true);
        } else {
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByUTypeIdx(this.schema.getAuthorization(), ClusterId, HostNodeId, ServiceTypeId);
        }
    }

    public void deleteServiceByUHostPortIdx(long ClusterId, long HostNodeId, short HostPort) {
        if (this.indexByUHostPortIdx == null) {
            this.indexByUHostPortIdx = new HashMap<CFSecurityServiceByUHostPortIdxKey, ICFSecurityServiceObj>();
        }
        CFSecurityServiceByUHostPortIdxKey key = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newUHostPortIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        key.setRequiredHostPort(HostPort);
        ICFSecurityServiceObj obj = null;
        if (this.indexByUHostPortIdx.containsKey(key)) {
            obj = this.indexByUHostPortIdx.get(key);
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByUHostPortIdx(this.schema.getAuthorization(), ClusterId, HostNodeId, HostPort);
            obj.forget(true);
        } else {
            ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().deleteServiceByUHostPortIdx(this.schema.getAuthorization(), ClusterId, HostNodeId, HostPort);
        }
    }
}

