/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj;

import java.util.Calendar;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.ICFInternetSchema;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetClusterObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetSchemaObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetServiceObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetTenantObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServiceBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityServicePKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityHostNodeObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySchemaObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecUserObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityServiceEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityServiceObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityServiceTableObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityServiceTypeObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantObj;

public class CFInternetServiceObj
implements ICFInternetServiceObj {
    public static final String CLASS_CODE = "HSVC";
    protected ICFSecuritySecUserObj createdBy = null;
    protected ICFSecuritySecUserObj updatedBy = null;
    protected boolean isNew;
    protected ICFSecurityServiceEditObj edit;
    protected ICFSecuritySchemaObj schema;
    protected CFSecurityServicePKey pKey;
    protected CFSecurityServiceBuff buff;
    protected ICFSecurityClusterObj requiredOwnerCluster;
    protected ICFSecurityHostNodeObj optionalContainerHost;
    protected ICFSecurityServiceTypeObj optionalParentServiceType;

    public CFInternetServiceObj() {
        this.isNew = true;
        this.requiredOwnerCluster = null;
        this.optionalContainerHost = null;
        this.optionalParentServiceType = null;
    }

    public CFInternetServiceObj(ICFSecuritySchemaObj argSchema) {
        this.schema = argSchema;
        this.isNew = true;
        this.edit = null;
        this.requiredOwnerCluster = null;
        this.optionalContainerHost = null;
        this.optionalParentServiceType = null;
    }

    @Override
    public String getClassCode() {
        return CLASS_CODE;
    }

    public String getGenDefName() {
        return "Service";
    }

    public ICFLibAnyObj getScope() {
        ICFSecurityHostNodeObj scope = this.getOptionalContainerHost();
        return scope;
    }

    public ICFLibAnyObj getObjScope() {
        ICFSecurityHostNodeObj scope = this.getOptionalContainerHost();
        return scope;
    }

    public String getObjName() {
        long val = this.getRequiredServiceId();
        String objName = Long.toString(val);
        return objName;
    }

    public ICFLibAnyObj getObjQualifier(Class qualifyingClass) {
        CFInternetServiceObj container;
        if (qualifyingClass != null) {
            for (container = this; !(container == null || container instanceof ICFInternetClusterObj || container instanceof ICFInternetTenantObj || qualifyingClass.isInstance(container)); container = container.getObjScope()) {
            }
        } else {
            while (container != null && !(container instanceof ICFInternetClusterObj) && !(container instanceof ICFInternetTenantObj)) {
                container = container.getObjScope();
            }
        }
        return container;
    }

    public ICFLibAnyObj getNamedObject(Class qualifyingClass, String objName) {
        ICFLibAnyObj topContainer = this.getObjQualifier(qualifyingClass);
        if (topContainer == null) {
            return null;
        }
        ICFLibAnyObj namedObject = topContainer.getNamedObject(objName);
        return namedObject;
    }

    public ICFLibAnyObj getNamedObject(String objName) {
        String remainingName;
        ICFLibAnyObj subObj = null;
        int nextDot = objName.indexOf(46);
        if (nextDot >= 0) {
            String nextName = objName.substring(0, nextDot);
            remainingName = objName.substring(nextDot + 1);
        } else {
            String nextName = objName;
            remainingName = null;
        }
        ICFLibAnyObj retObj = remainingName == null ? subObj : (subObj == null ? null : subObj.getNamedObject(remainingName));
        return retObj;
    }

    public String getObjQualifiedName() {
        Object qualName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            qualName = containerName + "." + (String)qualName;
            container = container.getObjScope();
        }
        return qualName;
    }

    public String getObjFullName() {
        Object fullName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            fullName = containerName + "." + (String)fullName;
            container = container.getObjScope();
        }
        return fullName;
    }

    @Override
    public ICFSecurityServiceObj realize() {
        ICFSecurityServiceObj retobj = ((ICFInternetSchemaObj)this.schema).getServiceTableObj().realizeService((ICFSecurityServiceObj)this);
        return retobj;
    }

    @Override
    public void forget() {
        this.forget(false);
    }

    @Override
    public void forget(boolean forgetSubObjects) {
        ((ICFInternetSchemaObj)this.schema).getServiceTableObj().forgetService((ICFSecurityServiceObj)this, forgetSubObjects);
    }

    @Override
    public ICFSecurityServiceObj read() {
        ICFSecurityServiceObj retobj = ((ICFInternetSchemaObj)this.schema).getServiceTableObj().readServiceByIdIdx(this.getPKey().getRequiredClusterId(), this.getPKey().getRequiredServiceId(), false);
        return retobj;
    }

    @Override
    public ICFSecurityServiceObj read(boolean forceRead) {
        ICFSecurityServiceObj retobj = ((ICFInternetSchemaObj)this.schema).getServiceTableObj().readServiceByIdIdx(this.getPKey().getRequiredClusterId(), this.getPKey().getRequiredServiceId(), forceRead);
        return retobj;
    }

    @Override
    public ICFSecurityServiceTableObj getServiceTable() {
        return ((ICFInternetSchemaObj)this.schema).getServiceTableObj();
    }

    @Override
    public ICFSecuritySchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFSecuritySchemaObj value) {
        this.schema = value;
    }

    @Override
    public CFSecurityServiceBuff getBuff() {
        if (this.buff == null) {
            if (this.isNew) {
                this.buff = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newBuff();
            } else {
                this.buff = ((ICFInternetSchema)this.schema.getBackingStore()).getTableService().readDerivedByIdIdx(((ICFInternetSchemaObj)this.schema).getAuthorization(), this.getPKey().getRequiredClusterId(), this.getPKey().getRequiredServiceId());
                if (this.buff != null) {
                    this.copyBuffToPKey();
                }
            }
        }
        return this.buff;
    }

    @Override
    public void setBuff(CFSecurityServiceBuff value) {
        if (value != null && !(value instanceof CFSecurityServiceBuff)) {
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "setBuff", "value", (Object)value, "CFSecurityServiceBuff");
        }
        this.buff = value;
        this.copyBuffToPKey();
        this.requiredOwnerCluster = null;
        this.optionalContainerHost = null;
        this.optionalParentServiceType = null;
    }

    @Override
    public CFSecurityServiceBuff getServiceBuff() {
        return this.getBuff();
    }

    public CFSecurityServicePKey getPKey() {
        if (this.pKey == null) {
            this.pKey = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryService().newPKey();
        }
        return this.pKey;
    }

    public void setPKey(CFSecurityServicePKey value) {
        if (this.pKey != value) {
            this.pKey = value;
            this.copyPKeyToBuff();
        }
    }

    @Override
    public boolean getIsNew() {
        return this.isNew;
    }

    @Override
    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    @Override
    public ICFSecurityServiceEditObj beginEdit() {
        if (this.edit != null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "beginEdit", "An edit is already open");
        }
        CFInternetServiceObj lockobj = this.getIsNew() ? this : ((ICFInternetSchemaObj)this.schema).getServiceTableObj().lockService(this.getPKey());
        this.edit = ((ICFInternetSchemaObj)this.schema).getServiceTableObj().newEditInstance((ICFSecurityServiceObj)lockobj);
        return this.edit;
    }

    @Override
    public void endEdit() {
        this.edit = null;
    }

    @Override
    public ICFSecurityServiceEditObj getEdit() {
        return this.edit;
    }

    @Override
    public ICFSecurityServiceEditObj getEditAsService() {
        return this.edit;
    }

    @Override
    public ICFSecuritySecUserObj getCreatedBy() {
        if (this.createdBy == null) {
            CFSecurityServiceBuff buff = this.getBuff();
            this.createdBy = ((ICFInternetSchemaObj)this.getSchema()).getSecUserTableObj().readSecUserByIdIdx(buff.getCreatedByUserId());
        }
        return this.createdBy;
    }

    @Override
    public Calendar getCreatedAt() {
        return this.getBuff().getCreatedAt();
    }

    @Override
    public ICFSecuritySecUserObj getUpdatedBy() {
        if (this.updatedBy == null) {
            CFSecurityServiceBuff buff = this.getBuff();
            this.updatedBy = ((ICFInternetSchemaObj)this.getSchema()).getSecUserTableObj().readSecUserByIdIdx(buff.getUpdatedByUserId());
        }
        return this.updatedBy;
    }

    @Override
    public Calendar getUpdatedAt() {
        return this.getBuff().getUpdatedAt();
    }

    @Override
    public long getRequiredClusterId() {
        return this.getPKey().getRequiredClusterId();
    }

    @Override
    public long getRequiredServiceId() {
        return this.getPKey().getRequiredServiceId();
    }

    @Override
    public long getRequiredHostNodeId() {
        return this.getServiceBuff().getRequiredHostNodeId();
    }

    @Override
    public int getRequiredServiceTypeId() {
        return this.getServiceBuff().getRequiredServiceTypeId();
    }

    @Override
    public short getRequiredHostPort() {
        return this.getServiceBuff().getRequiredHostPort();
    }

    @Override
    public ICFSecurityClusterObj getRequiredOwnerCluster() {
        return this.getRequiredOwnerCluster(false);
    }

    @Override
    public ICFSecurityClusterObj getRequiredOwnerCluster(boolean forceRead) {
        boolean anyMissing;
        if ((this.requiredOwnerCluster == null || forceRead) && !(anyMissing = false)) {
            this.requiredOwnerCluster = ((ICFInternetSchemaObj)this.schema).getClusterTableObj().readClusterByIdIdx(this.getPKey().getRequiredClusterId(), forceRead);
        }
        return this.requiredOwnerCluster;
    }

    @Override
    public ICFSecurityHostNodeObj getOptionalContainerHost() {
        return this.getOptionalContainerHost(false);
    }

    @Override
    public ICFSecurityHostNodeObj getOptionalContainerHost(boolean forceRead) {
        boolean anyMissing;
        if ((this.optionalContainerHost == null || forceRead) && !(anyMissing = false)) {
            this.optionalContainerHost = ((ICFInternetSchemaObj)this.schema).getHostNodeTableObj().readHostNodeByIdIdx(this.getPKey().getRequiredClusterId(), this.getServiceBuff().getRequiredHostNodeId(), forceRead);
        }
        return this.optionalContainerHost;
    }

    @Override
    public ICFSecurityServiceTypeObj getOptionalParentServiceType() {
        return this.getOptionalParentServiceType(false);
    }

    @Override
    public ICFSecurityServiceTypeObj getOptionalParentServiceType(boolean forceRead) {
        boolean anyMissing;
        if ((this.optionalParentServiceType == null || forceRead) && !(anyMissing = false)) {
            this.optionalParentServiceType = ((ICFInternetSchemaObj)this.schema).getServiceTypeTableObj().readServiceTypeByIdIdx(this.getServiceBuff().getRequiredServiceTypeId(), forceRead);
        }
        return this.optionalParentServiceType;
    }

    @Override
    public void copyPKeyToBuff() {
        if (this.buff != null) {
            this.buff.setRequiredClusterId(this.getPKey().getRequiredClusterId());
            this.buff.setRequiredServiceId(this.getPKey().getRequiredServiceId());
        }
        if (this.edit != null) {
            this.edit.copyPKeyToBuff();
        }
    }

    @Override
    public void copyBuffToPKey() {
        this.getPKey().setRequiredClusterId(this.buff.getRequiredClusterId());
        this.getPKey().setRequiredServiceId(this.buff.getRequiredServiceId());
    }
}

