/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj;

import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetLicenseBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetLicensePKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.ICFInternetSchema;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetClusterObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetDomainObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetLicenseEditObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetLicenseObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetLicenseTableObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetSchemaObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetTenantObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantObj;

public class CFInternetLicenseObj
implements ICFInternetLicenseObj {
    public static final String CLASS_CODE = "LIC";
    protected boolean isNew;
    protected ICFInternetLicenseEditObj edit;
    protected ICFInternetSchemaObj schema;
    protected CFInternetLicensePKey pKey;
    protected CFInternetLicenseBuff buff;
    protected ICFSecurityTenantObj requiredOwnerTenant;
    protected ICFInternetDomainObj requiredContainerDomain;

    public CFInternetLicenseObj() {
        this.isNew = true;
        this.requiredOwnerTenant = null;
        this.requiredContainerDomain = null;
    }

    public CFInternetLicenseObj(ICFInternetSchemaObj argSchema) {
        this.schema = argSchema;
        this.isNew = true;
        this.edit = null;
        this.requiredOwnerTenant = null;
        this.requiredContainerDomain = null;
    }

    @Override
    public String getClassCode() {
        return CLASS_CODE;
    }

    public String getGenDefName() {
        return "License";
    }

    public ICFLibAnyObj getScope() {
        ICFInternetDomainObj scope = this.getRequiredContainerDomain();
        return scope;
    }

    public ICFLibAnyObj getObjScope() {
        ICFInternetDomainObj scope = this.getRequiredContainerDomain();
        return scope;
    }

    public String getObjName() {
        String objName = this.getRequiredName();
        return objName;
    }

    public ICFLibAnyObj getObjQualifier(Class qualifyingClass) {
        CFInternetLicenseObj container;
        if (qualifyingClass != null) {
            for (container = this; !(container == null || container instanceof ICFInternetClusterObj || container instanceof ICFInternetTenantObj || qualifyingClass.isInstance(container)); container = container.getObjScope()) {
            }
        } else {
            while (container != null && !(container instanceof ICFInternetClusterObj) && !(container instanceof ICFInternetTenantObj)) {
                container = container.getObjScope();
            }
        }
        return container;
    }

    public ICFLibAnyObj getNamedObject(Class qualifyingClass, String objName) {
        ICFLibAnyObj topContainer = this.getObjQualifier(qualifyingClass);
        if (topContainer == null) {
            return null;
        }
        ICFLibAnyObj namedObject = topContainer.getNamedObject(objName);
        return namedObject;
    }

    public ICFLibAnyObj getNamedObject(String objName) {
        String remainingName;
        ICFLibAnyObj subObj = null;
        int nextDot = objName.indexOf(46);
        if (nextDot >= 0) {
            String nextName = objName.substring(0, nextDot);
            remainingName = objName.substring(nextDot + 1);
        } else {
            String nextName = objName;
            remainingName = null;
        }
        ICFLibAnyObj retObj = remainingName == null ? subObj : (subObj == null ? null : subObj.getNamedObject(remainingName));
        return retObj;
    }

    public String getObjQualifiedName() {
        Object qualName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFInternetTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            qualName = containerName + "." + (String)qualName;
            container = container.getObjScope();
        }
        return qualName;
    }

    public String getObjFullName() {
        Object fullName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            fullName = containerName + "." + (String)fullName;
            container = container.getObjScope();
        }
        return fullName;
    }

    @Override
    public ICFInternetLicenseObj realize() {
        ICFInternetLicenseObj retobj = this.schema.getLicenseTableObj().realizeLicense(this);
        return retobj;
    }

    @Override
    public void forget() {
        this.forget(false);
    }

    @Override
    public void forget(boolean forgetSubObjects) {
        this.schema.getLicenseTableObj().forgetLicense(this, forgetSubObjects);
    }

    @Override
    public ICFInternetLicenseObj read() {
        ICFInternetLicenseObj retobj = this.schema.getLicenseTableObj().readLicenseByIdIdx(this.getPKey().getRequiredTenantId(), this.getPKey().getRequiredId(), false);
        return retobj;
    }

    @Override
    public ICFInternetLicenseObj read(boolean forceRead) {
        ICFInternetLicenseObj retobj = this.schema.getLicenseTableObj().readLicenseByIdIdx(this.getPKey().getRequiredTenantId(), this.getPKey().getRequiredId(), forceRead);
        return retobj;
    }

    @Override
    public ICFInternetLicenseTableObj getLicenseTable() {
        return this.schema.getLicenseTableObj();
    }

    @Override
    public ICFInternetSchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFInternetSchemaObj value) {
        this.schema = value;
    }

    @Override
    public CFInternetLicenseBuff getBuff() {
        if (this.buff == null) {
            if (this.isNew) {
                this.buff = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryLicense().newBuff();
            } else {
                this.buff = ((ICFInternetSchema)this.schema.getBackingStore()).getTableLicense().readDerivedByIdIdx(this.schema.getAuthorization(), this.getPKey().getRequiredTenantId(), this.getPKey().getRequiredId());
                if (this.buff != null) {
                    this.copyBuffToPKey();
                }
            }
        }
        return this.buff;
    }

    @Override
    public void setBuff(CFInternetLicenseBuff value) {
        if (value != null && !(value instanceof CFInternetLicenseBuff)) {
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "setBuff", "value", (Object)value, "CFInternetLicenseBuff");
        }
        this.buff = value;
        this.copyBuffToPKey();
        this.requiredOwnerTenant = null;
        this.requiredContainerDomain = null;
    }

    @Override
    public CFInternetLicenseBuff getLicenseBuff() {
        return this.getBuff();
    }

    @Override
    public CFInternetLicensePKey getPKey() {
        if (this.pKey == null) {
            this.pKey = ((ICFInternetSchema)this.schema.getBackingStore()).getFactoryLicense().newPKey();
        }
        return this.pKey;
    }

    @Override
    public void setPKey(CFInternetLicensePKey value) {
        if (this.pKey != value) {
            this.pKey = value;
            this.copyPKeyToBuff();
        }
    }

    @Override
    public boolean getIsNew() {
        return this.isNew;
    }

    @Override
    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    @Override
    public ICFInternetLicenseEditObj beginEdit() {
        if (this.edit != null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "beginEdit", "An edit is already open");
        }
        ICFInternetLicenseObj lockobj = this.getIsNew() ? this : this.schema.getLicenseTableObj().lockLicense(this.getPKey());
        this.edit = this.schema.getLicenseTableObj().newEditInstance(lockobj);
        return this.edit;
    }

    @Override
    public void endEdit() {
        this.edit = null;
    }

    @Override
    public ICFInternetLicenseEditObj getEdit() {
        return this.edit;
    }

    @Override
    public ICFInternetLicenseEditObj getEditAsLicense() {
        return this.edit;
    }

    @Override
    public long getRequiredTenantId() {
        return this.getPKey().getRequiredTenantId();
    }

    @Override
    public long getRequiredId() {
        return this.getPKey().getRequiredId();
    }

    @Override
    public long getRequiredDomainId() {
        return this.getLicenseBuff().getRequiredDomainId();
    }

    @Override
    public String getRequiredName() {
        return this.getLicenseBuff().getRequiredName();
    }

    @Override
    public String getOptionalDescription() {
        return this.getLicenseBuff().getOptionalDescription();
    }

    @Override
    public String getOptionalEmbeddedText() {
        return this.getLicenseBuff().getOptionalEmbeddedText();
    }

    @Override
    public String getOptionalFullText() {
        return this.getLicenseBuff().getOptionalFullText();
    }

    @Override
    public ICFSecurityTenantObj getRequiredOwnerTenant() {
        return this.getRequiredOwnerTenant(false);
    }

    @Override
    public ICFSecurityTenantObj getRequiredOwnerTenant(boolean forceRead) {
        boolean anyMissing;
        if ((this.requiredOwnerTenant == null || forceRead) && !(anyMissing = false)) {
            this.requiredOwnerTenant = this.schema.getTenantTableObj().readTenantByIdIdx(this.getPKey().getRequiredTenantId(), forceRead);
        }
        return this.requiredOwnerTenant;
    }

    @Override
    public ICFInternetDomainObj getRequiredContainerDomain() {
        return this.getRequiredContainerDomain(false);
    }

    @Override
    public ICFInternetDomainObj getRequiredContainerDomain(boolean forceRead) {
        boolean anyMissing;
        if ((this.requiredContainerDomain == null || forceRead) && !(anyMissing = false)) {
            this.requiredContainerDomain = this.schema.getDomainTableObj().readDomainByIdIdx(this.getPKey().getRequiredTenantId(), this.getLicenseBuff().getRequiredDomainId(), forceRead);
        }
        return this.requiredContainerDomain;
    }

    @Override
    public void copyPKeyToBuff() {
        if (this.buff != null) {
            this.buff.setRequiredTenantId(this.getPKey().getRequiredTenantId());
            this.buff.setRequiredId(this.getPKey().getRequiredId());
        }
        if (this.edit != null) {
            this.edit.copyPKeyToBuff();
        }
    }

    @Override
    public void copyBuffToPKey() {
        this.getPKey().setRequiredTenantId(this.buff.getRequiredTenantId());
        this.getPKey().setRequiredId(this.buff.getRequiredId());
    }
}

