/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.CFBamTenantEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.CFBamTenantObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamSchemaObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTenantTableObj;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternetObj.ICFInternetSchemaObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityTenantBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityTenantByClusterIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityTenantByUNameIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityTenantPKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySchemaObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantObj;

public class CFBamTenantTableObj
implements ICFBamTenantTableObj {
    protected ICFSecuritySchemaObj schema;
    private Map<CFSecurityTenantPKey, ICFSecurityTenantObj> members;
    private Map<CFSecurityTenantPKey, ICFSecurityTenantObj> allTenant;
    private Map<CFSecurityTenantByClusterIdxKey, Map<CFSecurityTenantPKey, ICFSecurityTenantObj>> indexByClusterIdx;
    private Map<CFSecurityTenantByUNameIdxKey, ICFSecurityTenantObj> indexByUNameIdx;
    public static String TABLE_NAME = "Tenant";
    public static String TABLE_DBNAME = "tenant";

    public CFBamTenantTableObj() {
        this.schema = null;
        this.members = new HashMap<CFSecurityTenantPKey, ICFSecurityTenantObj>();
        this.allTenant = null;
        this.indexByClusterIdx = null;
        this.indexByUNameIdx = null;
    }

    public CFBamTenantTableObj(ICFSecuritySchemaObj argSchema) {
        this.schema = argSchema;
        this.members = new HashMap<CFSecurityTenantPKey, ICFSecurityTenantObj>();
        this.allTenant = null;
        this.indexByClusterIdx = null;
        this.indexByUNameIdx = null;
    }

    public ICFSecuritySchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFSecuritySchemaObj value) {
        this.schema = value;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getTableDbName() {
        return TABLE_DBNAME;
    }

    public Class getObjQualifyingClass() {
        return null;
    }

    public void minimizeMemory() {
        this.allTenant = null;
        this.indexByClusterIdx = null;
        this.indexByUNameIdx = null;
        LinkedList<ICFSecurityTenantObj> toForget = new LinkedList<ICFSecurityTenantObj>();
        ICFSecurityTenantObj cur2 = null;
        for (ICFSecurityTenantObj cur2 : this.members.values()) {
            toForget.add(cur2);
        }
        for (ICFSecurityTenantObj cur2 : toForget) {
            cur2.forget();
        }
    }

    public ICFSecurityTenantObj newInstance() {
        CFBamTenantObj inst = new CFBamTenantObj(this.schema);
        return inst;
    }

    public ICFSecurityTenantEditObj newEditInstance(ICFSecurityTenantObj orig) {
        CFBamTenantEditObj edit = new CFBamTenantEditObj(orig);
        return edit;
    }

    public ICFSecurityTenantObj realizeTenant(ICFSecurityTenantObj Obj) {
        ICFSecurityTenantObj obj = Obj;
        CFSecurityTenantPKey pkey = obj.getPKey();
        ICFSecurityTenantObj keepObj = null;
        if (this.members.containsKey(pkey) && null != this.members.get(pkey)) {
            CFSecurityTenantByUNameIdxKey keyUNameIdx;
            Map<CFSecurityTenantPKey, ICFSecurityTenantObj> mapClusterIdx;
            CFSecurityTenantByClusterIdxKey keyClusterIdx;
            ICFSecurityTenantObj existingObj;
            keepObj = existingObj = this.members.get(pkey);
            if (this.indexByClusterIdx != null) {
                keyClusterIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByUNameIdx != null) {
                keyUNameIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.remove(keyUNameIdx);
            }
            keepObj.setBuff(Obj.getBuff());
            if (this.indexByClusterIdx != null) {
                keyClusterIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByUNameIdx != null) {
                keyUNameIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.put(keyUNameIdx, keepObj);
            }
            if (this.allTenant != null) {
                this.allTenant.put(keepObj.getPKey(), keepObj);
            }
        } else {
            keepObj = obj;
            keepObj.setIsNew(false);
            this.members.put(keepObj.getPKey(), keepObj);
            if (this.allTenant != null) {
                this.allTenant.put(keepObj.getPKey(), keepObj);
            }
            if (this.indexByClusterIdx != null) {
                CFSecurityTenantByClusterIdxKey keyClusterIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                Map<CFSecurityTenantPKey, ICFSecurityTenantObj> mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByUNameIdx != null) {
                CFSecurityTenantByUNameIdxKey keyUNameIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.put(keyUNameIdx, keepObj);
            }
        }
        return keepObj;
    }

    public void forgetTenant(ICFSecurityTenantObj Obj) {
        this.forgetTenant(Obj, false);
    }

    public void forgetTenant(ICFSecurityTenantObj Obj, boolean forgetSubObjects) {
        ICFSecurityTenantObj obj = Obj;
        CFSecurityTenantPKey pkey = obj.getPKey();
        if (this.members.containsKey(pkey)) {
            ICFSecurityTenantObj keepObj = this.members.get(pkey);
            if (this.indexByClusterIdx != null) {
                CFSecurityTenantByClusterIdxKey keyClusterIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                Map<CFSecurityTenantPKey, ICFSecurityTenantObj> mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByUNameIdx != null) {
                CFSecurityTenantByUNameIdxKey keyUNameIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.remove(keyUNameIdx);
            }
            if (this.allTenant != null) {
                this.allTenant.remove(keepObj.getPKey());
            }
            this.members.remove(pkey);
            if (forgetSubObjects) {
                this.schema.getTSecGroupTableObj().forgetTSecGroupByTenantIdx(keepObj.getRequiredId());
                ((ICFInternetSchemaObj)this.schema).getDomainTableObj().forgetDomainByTenantIdx(keepObj.getRequiredId());
                ((ICFInternetSchemaObj)this.schema).getTldTableObj().forgetTldByTldTenantIdx(keepObj.getRequiredId());
                ((ICFBamSchemaObj)this.schema).getSchemaDefTableObj().forgetSchemaDefByCTenantIdx(keepObj.getRequiredId());
            }
        }
    }

    public void forgetTenantByIdIdx(long Id) {
        ICFSecurityTenantObj probed;
        if (this.members == null) {
            return;
        }
        CFSecurityTenantPKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey();
        key.setRequiredId(Id);
        if (this.members.containsKey(key) && (probed = this.members.get(key)) != null) {
            probed.forget(true);
        }
    }

    public void forgetTenantByClusterIdx(long ClusterId) {
        if (this.indexByClusterIdx == null) {
            return;
        }
        CFSecurityTenantByClusterIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx.containsKey(key)) {
            Map<CFSecurityTenantPKey, ICFSecurityTenantObj> mapClusterIdx = this.indexByClusterIdx.get(key);
            if (mapClusterIdx != null) {
                LinkedList<ICFSecurityTenantObj> toForget = new LinkedList<ICFSecurityTenantObj>();
                ICFSecurityTenantObj cur2 = null;
                for (ICFSecurityTenantObj cur2 : mapClusterIdx.values()) {
                    toForget.add(cur2);
                }
                for (ICFSecurityTenantObj cur2 : toForget) {
                    cur2.forget(true);
                }
            }
            this.indexByClusterIdx.remove(key);
        }
    }

    public void forgetTenantByUNameIdx(long ClusterId, String TenantName) {
        if (this.indexByUNameIdx == null) {
            return;
        }
        CFSecurityTenantByUNameIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newUNameIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredTenantName(TenantName);
        if (this.indexByUNameIdx.containsKey(key)) {
            ICFSecurityTenantObj probed = this.indexByUNameIdx.get(key);
            if (probed != null) {
                probed.forget(true);
            }
            this.indexByUNameIdx.remove(key);
        }
    }

    public ICFSecurityTenantObj createTenant(ICFSecurityTenantObj Obj) {
        ICFSecurityTenantObj obj = Obj;
        CFSecurityTenantBuff buff = obj.getTenantBuff();
        ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().createTenant(this.schema.getAuthorization(), buff);
        obj.copyBuffToPKey();
        obj = obj.realize();
        return obj;
    }

    public ICFSecurityTenantObj readTenant(CFSecurityTenantPKey pkey) {
        return this.readTenant(pkey, false);
    }

    public ICFSecurityTenantObj readTenant(CFSecurityTenantPKey pkey, boolean forceRead) {
        ICFSecurityTenantObj obj = null;
        if (!forceRead && this.members.containsKey(pkey)) {
            obj = this.members.get(pkey);
        } else {
            CFSecurityTenantBuff readBuff = ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().readDerivedByIdIdx(this.schema.getAuthorization(), pkey.getRequiredId());
            if (readBuff != null) {
                obj = this.schema.getTenantTableObj().newInstance();
                obj.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey());
                obj.setBuff(readBuff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.members.put(pkey, null);
            }
        }
        return obj;
    }

    public ICFSecurityTenantObj lockTenant(CFSecurityTenantPKey pkey) {
        ICFSecurityTenantObj locked = null;
        CFSecurityTenantBuff lockBuff = ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().lockDerived(this.schema.getAuthorization(), pkey);
        if (lockBuff == null) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "lockTenant", (Object)pkey);
        }
        locked = this.schema.getTenantTableObj().newInstance();
        locked.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey());
        locked.setBuff(lockBuff);
        locked = locked.realize();
        return locked;
    }

    public List<ICFSecurityTenantObj> readAllTenant() {
        return this.readAllTenant(false);
    }

    public List<ICFSecurityTenantObj> readAllTenant(boolean forceRead) {
        int idx;
        String S_ProcName = "readAllTenant";
        if (this.allTenant == null || forceRead) {
            HashMap<CFSecurityTenantPKey, ICFSecurityTenantObj> map = new HashMap<CFSecurityTenantPKey, ICFSecurityTenantObj>();
            this.allTenant = map;
            CFSecurityTenantBuff[] buffList = ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().readAllDerived(this.schema.getAuthorization());
            for (idx = 0; idx < buffList.length; ++idx) {
                CFSecurityTenantBuff buff = buffList[idx];
                ICFSecurityTenantObj obj = this.newInstance();
                obj.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey());
                obj.setBuff(buff);
                ICFSecurityTenantObj iCFSecurityTenantObj = obj.realize();
            }
        }
        Comparator<ICFSecurityTenantObj> cmp = new Comparator<ICFSecurityTenantObj>(){

            @Override
            public int compare(ICFSecurityTenantObj lhs, ICFSecurityTenantObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFSecurityTenantPKey lhsPKey = lhs.getPKey();
                CFSecurityTenantPKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo((Object)rhsPKey);
                return ret;
            }
        };
        int len = this.allTenant.size();
        ICFSecurityTenantObj[] arr = new ICFSecurityTenantObj[len];
        Iterator<ICFSecurityTenantObj> valIter = this.allTenant.values().iterator();
        idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readAllTenant", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readAllTenant", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFSecurityTenantObj> arrayList = new ArrayList<ICFSecurityTenantObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFSecurityTenantObj> sortedList = arrayList;
        return sortedList;
    }

    public ICFSecurityTenantObj readTenantByIdIdx(long Id) {
        return this.readTenantByIdIdx(Id, false);
    }

    public ICFSecurityTenantObj readTenantByIdIdx(long Id, boolean forceRead) {
        CFSecurityTenantPKey pkey = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey();
        pkey.setRequiredId(Id);
        ICFSecurityTenantObj obj = this.readTenant(pkey, forceRead);
        return obj;
    }

    public List<ICFSecurityTenantObj> readTenantByClusterIdx(long ClusterId) {
        return this.readTenantByClusterIdx(ClusterId, false);
    }

    public List<ICFSecurityTenantObj> readTenantByClusterIdx(long ClusterId, boolean forceRead) {
        Map<Object, Object> dict;
        String S_ProcName = "readTenantByClusterIdx";
        CFSecurityTenantByClusterIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx == null) {
            this.indexByClusterIdx = new HashMap<CFSecurityTenantByClusterIdxKey, Map<CFSecurityTenantPKey, ICFSecurityTenantObj>>();
        }
        if (!forceRead && this.indexByClusterIdx.containsKey(key)) {
            dict = this.indexByClusterIdx.get(key);
        } else {
            dict = new HashMap();
            this.indexByClusterIdx.put(key, dict);
            CFSecurityTenantBuff[] buffList = ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().readDerivedByClusterIdx(this.schema.getAuthorization(), ClusterId);
            for (int idx = 0; idx < buffList.length; ++idx) {
                CFSecurityTenantBuff buff = buffList[idx];
                ICFSecurityTenantObj obj = this.schema.getTenantTableObj().newInstance();
                obj.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey());
                obj.setBuff(buff);
                ICFSecurityTenantObj iCFSecurityTenantObj = obj.realize();
            }
        }
        Comparator<ICFSecurityTenantObj> cmp = new Comparator<ICFSecurityTenantObj>(){

            @Override
            public int compare(ICFSecurityTenantObj lhs, ICFSecurityTenantObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFSecurityTenantPKey lhsPKey = lhs.getPKey();
                CFSecurityTenantPKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo((Object)rhsPKey);
                return ret;
            }
        };
        int len = dict.size();
        ICFSecurityTenantObj[] arr = new ICFSecurityTenantObj[len];
        Iterator<Object> valIter = dict.values().iterator();
        int idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = (ICFSecurityTenantObj)valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readTenantByClusterIdx", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readTenantByClusterIdx", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFSecurityTenantObj> arrayList = new ArrayList<ICFSecurityTenantObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFSecurityTenantObj> sortedList = arrayList;
        return sortedList;
    }

    public ICFSecurityTenantObj readTenantByUNameIdx(long ClusterId, String TenantName) {
        return this.readTenantByUNameIdx(ClusterId, TenantName, false);
    }

    public ICFSecurityTenantObj readTenantByUNameIdx(long ClusterId, String TenantName, boolean forceRead) {
        if (this.indexByUNameIdx == null) {
            this.indexByUNameIdx = new HashMap<CFSecurityTenantByUNameIdxKey, ICFSecurityTenantObj>();
        }
        CFSecurityTenantByUNameIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newUNameIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredTenantName(TenantName);
        ICFSecurityTenantObj obj = null;
        if (!forceRead && this.indexByUNameIdx.containsKey(key)) {
            obj = this.indexByUNameIdx.get(key);
        } else {
            CFSecurityTenantBuff buff = ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().readDerivedByUNameIdx(this.schema.getAuthorization(), ClusterId, TenantName);
            if (buff != null) {
                obj = this.schema.getTenantTableObj().newInstance();
                obj.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey());
                obj.setBuff(buff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.indexByUNameIdx.put(key, null);
            }
        }
        return obj;
    }

    public ICFSecurityTenantObj updateTenant(ICFSecurityTenantObj Obj) {
        ICFSecurityTenantObj obj = Obj;
        ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().updateTenant(this.schema.getAuthorization(), Obj.getTenantBuff());
        obj = Obj.realize();
        return obj;
    }

    public void deleteTenant(ICFSecurityTenantObj Obj) {
        ICFSecurityTenantObj obj = Obj;
        ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().deleteTenant(this.schema.getAuthorization(), obj.getTenantBuff());
        obj.forget(true);
    }

    public void deleteTenantByIdIdx(long Id) {
        CFSecurityTenantPKey pkey = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newPKey();
        pkey.setRequiredId(Id);
        ICFSecurityTenantObj obj = this.readTenant(pkey);
        if (obj != null) {
            ICFSecurityTenantEditObj editObj = obj.getEdit();
            boolean editStarted = editObj == null ? (editObj = obj.beginEdit()) != null : false;
            if (editObj != null) {
                editObj.delete();
                if (editStarted) {
                    editObj.endEdit();
                }
            }
            obj.forget(true);
        }
    }

    public void deleteTenantByClusterIdx(long ClusterId) {
        CFSecurityTenantByClusterIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx == null) {
            this.indexByClusterIdx = new HashMap<CFSecurityTenantByClusterIdxKey, Map<CFSecurityTenantPKey, ICFSecurityTenantObj>>();
        }
        if (this.indexByClusterIdx.containsKey(key)) {
            Map<CFSecurityTenantPKey, ICFSecurityTenantObj> dict = this.indexByClusterIdx.get(key);
            ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().deleteTenantByClusterIdx(this.schema.getAuthorization(), ClusterId);
            Iterator<Object> iter = dict.values().iterator();
            LinkedList<ICFSecurityTenantObj> toForget = new LinkedList<ICFSecurityTenantObj>();
            while (iter.hasNext()) {
                ICFSecurityTenantObj obj = iter.next();
                toForget.add(obj);
            }
            for (ICFSecurityTenantObj obj : toForget) {
                obj.forget(true);
            }
            this.indexByClusterIdx.remove(key);
        } else {
            ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().deleteTenantByClusterIdx(this.schema.getAuthorization(), ClusterId);
        }
    }

    public void deleteTenantByUNameIdx(long ClusterId, String TenantName) {
        if (this.indexByUNameIdx == null) {
            this.indexByUNameIdx = new HashMap<CFSecurityTenantByUNameIdxKey, ICFSecurityTenantObj>();
        }
        CFSecurityTenantByUNameIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryTenant().newUNameIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredTenantName(TenantName);
        ICFSecurityTenantObj obj = null;
        if (this.indexByUNameIdx.containsKey(key)) {
            obj = this.indexByUNameIdx.get(key);
            ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().deleteTenantByUNameIdx(this.schema.getAuthorization(), ClusterId, TenantName);
            obj.forget(true);
        } else {
            ((ICFBamSchema)this.schema.getBackingStore()).getTableTenant().deleteTenantByUNameIdx(this.schema.getAuthorization(), ClusterId, TenantName);
        }
    }

    public ICFSecurityTenantObj getSystemTenant() {
        ICFSecurityTenantObj tenantObj;
        boolean transactionStarted = this.schema.beginTransaction();
        try {
            ICFSecurityClusterObj clusterObj = this.schema.getClusterTableObj().getSystemCluster();
            tenantObj = this.readTenantByUNameIdx(clusterObj.getRequiredId(), "system");
            if (tenantObj == null) {
                tenantObj = this.newInstance();
                ICFSecurityTenantEditObj tenantEdit = tenantObj.beginEdit();
                tenantEdit.setRequiredContainerCluster(clusterObj);
                tenantEdit.setRequiredTenantName("system");
                tenantObj = tenantEdit.create();
                tenantEdit.endEdit();
            }
            if (transactionStarted) {
                this.schema.commit();
            }
        }
        catch (RuntimeException e) {
            if (transactionStarted) {
                try {
                    this.schema.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
        return tenantObj;
    }
}

