/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.CFBamScopeBuff;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.CFBamScopeByTenantIdxKey;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.CFBamScopePKey;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.CFBamScopeEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.CFBamScopeObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamSchemaObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamScopeEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamScopeObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamScopeTableObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFBamScopeTableObj
implements ICFBamScopeTableObj {
    protected ICFBamSchemaObj schema;
    private Map<CFBamScopePKey, ICFBamScopeObj> members;
    private Map<CFBamScopePKey, ICFBamScopeObj> allScope;
    private Map<CFBamScopeByTenantIdxKey, Map<CFBamScopePKey, ICFBamScopeObj>> indexByTenantIdx;
    public static String TABLE_NAME = "Scope";
    public static String TABLE_DBNAME = "scopedef";

    public CFBamScopeTableObj() {
        this.schema = null;
        this.members = new HashMap<CFBamScopePKey, ICFBamScopeObj>();
        this.allScope = null;
        this.indexByTenantIdx = null;
    }

    public CFBamScopeTableObj(ICFBamSchemaObj argSchema) {
        this.schema = argSchema;
        this.members = new HashMap<CFBamScopePKey, ICFBamScopeObj>();
        this.allScope = null;
        this.indexByTenantIdx = null;
    }

    @Override
    public ICFBamSchemaObj getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(ICFBamSchemaObj value) {
        this.schema = value;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getTableDbName() {
        return TABLE_DBNAME;
    }

    @Override
    public Class getObjQualifyingClass() {
        return null;
    }

    @Override
    public void minimizeMemory() {
        this.allScope = null;
        this.indexByTenantIdx = null;
        LinkedList<ICFBamScopeObj> toForget = new LinkedList<ICFBamScopeObj>();
        ICFBamScopeObj cur2 = null;
        for (ICFBamScopeObj cur2 : this.members.values()) {
            toForget.add(cur2);
        }
        for (ICFBamScopeObj cur2 : toForget) {
            cur2.forget();
        }
    }

    @Override
    public ICFBamScopeObj newInstance() {
        CFBamScopeObj inst = new CFBamScopeObj(this.schema);
        return inst;
    }

    @Override
    public ICFBamScopeEditObj newEditInstance(ICFBamScopeObj orig) {
        CFBamScopeEditObj edit = new CFBamScopeEditObj(orig);
        return edit;
    }

    @Override
    public ICFBamScopeObj constructByClassCode(String argClassCode) {
        ICFBamScopeObj obj = null;
        if (argClassCode.equals("SCOP")) {
            obj = this.schema.getScopeTableObj().newInstance();
        } else if (argClassCode.equals("SCHM")) {
            obj = this.schema.getSchemaDefTableObj().newInstance();
        } else if (argClassCode.equals("SCRF")) {
            obj = this.schema.getSchemaRefTableObj().newInstance();
        } else if (argClassCode.equals("SRVM")) {
            obj = this.schema.getServerMethodTableObj().newInstance();
        } else if (argClassCode.equals("SRVO")) {
            obj = this.schema.getServerObjFuncTableObj().newInstance();
        } else if (argClassCode.equals("SRVP")) {
            obj = this.schema.getServerProcTableObj().newInstance();
        } else if (argClassCode.equals("SRVL")) {
            obj = this.schema.getServerListFuncTableObj().newInstance();
        } else if (argClassCode.equals("TBLD")) {
            obj = this.schema.getTableTableObj().newInstance();
        } else if (argClassCode.equals("CLRD")) {
            obj = this.schema.getClearDepTableObj().newInstance();
        } else if (argClassCode.equals("CLR1")) {
            obj = this.schema.getClearSubDep1TableObj().newInstance();
        } else if (argClassCode.equals("CLR2")) {
            obj = this.schema.getClearSubDep2TableObj().newInstance();
        } else if (argClassCode.equals("CLR3")) {
            obj = this.schema.getClearSubDep3TableObj().newInstance();
        } else if (argClassCode.equals("CLRT")) {
            obj = this.schema.getClearTopDepTableObj().newInstance();
        } else if (argClassCode.equals("DELD")) {
            obj = this.schema.getDelDepTableObj().newInstance();
        } else if (argClassCode.equals("DEL1")) {
            obj = this.schema.getDelSubDep1TableObj().newInstance();
        } else if (argClassCode.equals("DEL2")) {
            obj = this.schema.getDelSubDep2TableObj().newInstance();
        } else if (argClassCode.equals("DEL3")) {
            obj = this.schema.getDelSubDep3TableObj().newInstance();
        } else if (argClassCode.equals("DELT")) {
            obj = this.schema.getDelTopDepTableObj().newInstance();
        } else if (argClassCode.equals("IDXD")) {
            obj = this.schema.getIndexTableObj().newInstance();
        } else if (argClassCode.equals("POPD")) {
            obj = this.schema.getPopDepTableObj().newInstance();
        } else if (argClassCode.equals("POP1")) {
            obj = this.schema.getPopSubDep1TableObj().newInstance();
        } else if (argClassCode.equals("POP2")) {
            obj = this.schema.getPopSubDep2TableObj().newInstance();
        } else if (argClassCode.equals("POP3")) {
            obj = this.schema.getPopSubDep3TableObj().newInstance();
        } else if (argClassCode.equals("POPT")) {
            obj = this.schema.getPopTopDepTableObj().newInstance();
        } else if (argClassCode.equals("RELD")) {
            obj = this.schema.getRelationTableObj().newInstance();
        }
        return obj;
    }

    @Override
    public ICFBamScopeObj realizeScope(ICFBamScopeObj Obj) {
        ICFBamScopeObj obj = Obj;
        CFBamScopePKey pkey = obj.getPKey();
        ICFBamScopeObj keepObj = null;
        if (this.members.containsKey(pkey) && null != this.members.get(pkey)) {
            Map<CFBamScopePKey, ICFBamScopeObj> mapTenantIdx;
            CFBamScopeByTenantIdxKey keyTenantIdx;
            ICFBamScopeObj existingObj;
            keepObj = existingObj = this.members.get(pkey);
            if (this.indexByTenantIdx != null) {
                keyTenantIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newTenantIdxKey();
                keyTenantIdx.setRequiredTenantId(keepObj.getRequiredTenantId());
                mapTenantIdx = this.indexByTenantIdx.get(keyTenantIdx);
                if (mapTenantIdx != null) {
                    mapTenantIdx.remove(keepObj.getPKey());
                }
            }
            keepObj.setBuff(Obj.getBuff());
            if (this.indexByTenantIdx != null) {
                keyTenantIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newTenantIdxKey();
                keyTenantIdx.setRequiredTenantId(keepObj.getRequiredTenantId());
                mapTenantIdx = this.indexByTenantIdx.get(keyTenantIdx);
                if (mapTenantIdx != null) {
                    mapTenantIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.allScope != null) {
                this.allScope.put(keepObj.getPKey(), keepObj);
            }
        } else {
            keepObj = obj;
            keepObj.setIsNew(false);
            this.members.put(keepObj.getPKey(), keepObj);
            if (this.allScope != null) {
                this.allScope.put(keepObj.getPKey(), keepObj);
            }
            if (this.indexByTenantIdx != null) {
                CFBamScopeByTenantIdxKey keyTenantIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newTenantIdxKey();
                keyTenantIdx.setRequiredTenantId(keepObj.getRequiredTenantId());
                Map<CFBamScopePKey, ICFBamScopeObj> mapTenantIdx = this.indexByTenantIdx.get(keyTenantIdx);
                if (mapTenantIdx != null) {
                    mapTenantIdx.put(keepObj.getPKey(), keepObj);
                }
            }
        }
        return keepObj;
    }

    @Override
    public void forgetScope(ICFBamScopeObj Obj) {
        this.forgetScope(Obj, false);
    }

    @Override
    public void forgetScope(ICFBamScopeObj Obj, boolean forgetSubObjects) {
        ICFBamScopeObj obj = Obj;
        CFBamScopePKey pkey = obj.getPKey();
        if (this.members.containsKey(pkey)) {
            ICFBamScopeObj keepObj = this.members.get(pkey);
            if (this.indexByTenantIdx != null) {
                CFBamScopeByTenantIdxKey keyTenantIdx = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newTenantIdxKey();
                keyTenantIdx.setRequiredTenantId(keepObj.getRequiredTenantId());
                Map<CFBamScopePKey, ICFBamScopeObj> mapTenantIdx = this.indexByTenantIdx.get(keyTenantIdx);
                if (mapTenantIdx != null) {
                    mapTenantIdx.remove(keepObj.getPKey());
                }
            }
            if (this.allScope != null) {
                this.allScope.remove(keepObj.getPKey());
            }
            this.members.remove(pkey);
            if (forgetSubObjects) {
                // empty if block
            }
        }
    }

    @Override
    public void forgetScopeByIdIdx(long TenantId, long Id) {
        ICFBamScopeObj probed;
        if (this.members == null) {
            return;
        }
        CFBamScopePKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey();
        key.setRequiredTenantId(TenantId);
        key.setRequiredId(Id);
        if (this.members.containsKey(key) && (probed = this.members.get(key)) != null) {
            probed.forget(true);
        }
    }

    @Override
    public void forgetScopeByTenantIdx(long TenantId) {
        if (this.indexByTenantIdx == null) {
            return;
        }
        CFBamScopeByTenantIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newTenantIdxKey();
        key.setRequiredTenantId(TenantId);
        if (this.indexByTenantIdx.containsKey(key)) {
            Map<CFBamScopePKey, ICFBamScopeObj> mapTenantIdx = this.indexByTenantIdx.get(key);
            if (mapTenantIdx != null) {
                LinkedList<ICFBamScopeObj> toForget = new LinkedList<ICFBamScopeObj>();
                ICFBamScopeObj cur2 = null;
                for (ICFBamScopeObj cur2 : mapTenantIdx.values()) {
                    toForget.add(cur2);
                }
                for (ICFBamScopeObj cur2 : toForget) {
                    cur2.forget(true);
                }
            }
            this.indexByTenantIdx.remove(key);
        }
    }

    @Override
    public ICFBamScopeObj createScope(ICFBamScopeObj Obj) {
        ICFBamScopeObj obj = Obj;
        CFBamScopeBuff buff = obj.getScopeBuff();
        ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().createScope(this.schema.getAuthorization(), buff);
        obj.copyBuffToPKey();
        if (obj.getPKey().getClassCode().equals("SCOP")) {
            obj = obj.realize();
        }
        return obj;
    }

    @Override
    public ICFBamScopeObj readScope(CFBamScopePKey pkey) {
        return this.readScope(pkey, false);
    }

    @Override
    public ICFBamScopeObj readScope(CFBamScopePKey pkey, boolean forceRead) {
        ICFBamScopeObj obj = null;
        if (!forceRead && this.members.containsKey(pkey)) {
            obj = this.members.get(pkey);
        } else {
            CFBamScopeBuff readBuff = ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().readDerivedByIdIdx(this.schema.getAuthorization(), pkey.getRequiredTenantId(), pkey.getRequiredId());
            if (readBuff != null) {
                obj = this.schema.getScopeTableObj().constructByClassCode(readBuff.getClassCode());
                obj.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey());
                obj.setBuff(readBuff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.members.put(pkey, null);
            }
        }
        return obj;
    }

    @Override
    public ICFBamScopeObj lockScope(CFBamScopePKey pkey) {
        ICFBamScopeObj locked = null;
        CFBamScopeBuff lockBuff = ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().lockDerived(this.schema.getAuthorization(), pkey);
        if (lockBuff == null) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "lockScope", (Object)pkey);
        }
        locked = this.schema.getScopeTableObj().constructByClassCode(lockBuff.getClassCode());
        locked.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey());
        locked.setBuff(lockBuff);
        locked = locked.realize();
        return locked;
    }

    @Override
    public List<ICFBamScopeObj> readAllScope() {
        return this.readAllScope(false);
    }

    @Override
    public List<ICFBamScopeObj> readAllScope(boolean forceRead) {
        int idx;
        String S_ProcName = "readAllScope";
        if (this.allScope == null || forceRead) {
            HashMap<CFBamScopePKey, ICFBamScopeObj> map = new HashMap<CFBamScopePKey, ICFBamScopeObj>();
            this.allScope = map;
            CFBamScopeBuff[] buffList = ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().readAllDerived(this.schema.getAuthorization());
            for (idx = 0; idx < buffList.length; ++idx) {
                CFBamScopeBuff buff = buffList[idx];
                ICFBamScopeObj obj = this.schema.getScopeTableObj().constructByClassCode(buff.getClassCode());
                obj.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey());
                obj.setBuff(buff);
                ICFBamScopeObj iCFBamScopeObj = obj.realize();
            }
        }
        Comparator<ICFBamScopeObj> cmp = new Comparator<ICFBamScopeObj>(){

            @Override
            public int compare(ICFBamScopeObj lhs, ICFBamScopeObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFBamScopePKey lhsPKey = lhs.getPKey();
                CFBamScopePKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo(rhsPKey);
                return ret;
            }
        };
        int len = this.allScope.size();
        ICFBamScopeObj[] arr = new ICFBamScopeObj[len];
        Iterator<ICFBamScopeObj> valIter = this.allScope.values().iterator();
        idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readAllScope", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readAllScope", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFBamScopeObj> arrayList = new ArrayList<ICFBamScopeObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFBamScopeObj> sortedList = arrayList;
        return sortedList;
    }

    @Override
    public ICFBamScopeObj readScopeByIdIdx(long TenantId, long Id) {
        return this.readScopeByIdIdx(TenantId, Id, false);
    }

    @Override
    public ICFBamScopeObj readScopeByIdIdx(long TenantId, long Id, boolean forceRead) {
        CFBamScopePKey pkey = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey();
        pkey.setRequiredTenantId(TenantId);
        pkey.setRequiredId(Id);
        ICFBamScopeObj obj = this.readScope(pkey, forceRead);
        return obj;
    }

    @Override
    public List<ICFBamScopeObj> readScopeByTenantIdx(long TenantId) {
        return this.readScopeByTenantIdx(TenantId, false);
    }

    @Override
    public List<ICFBamScopeObj> readScopeByTenantIdx(long TenantId, boolean forceRead) {
        Map<Object, Object> dict;
        String S_ProcName = "readScopeByTenantIdx";
        CFBamScopeByTenantIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newTenantIdxKey();
        key.setRequiredTenantId(TenantId);
        if (this.indexByTenantIdx == null) {
            this.indexByTenantIdx = new HashMap<CFBamScopeByTenantIdxKey, Map<CFBamScopePKey, ICFBamScopeObj>>();
        }
        if (!forceRead && this.indexByTenantIdx.containsKey(key)) {
            dict = this.indexByTenantIdx.get(key);
        } else {
            dict = new HashMap();
            this.indexByTenantIdx.put(key, dict);
            CFBamScopeBuff[] buffList = ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().readDerivedByTenantIdx(this.schema.getAuthorization(), TenantId);
            for (int idx = 0; idx < buffList.length; ++idx) {
                CFBamScopeBuff buff = buffList[idx];
                ICFBamScopeObj obj = this.schema.getScopeTableObj().constructByClassCode(buff.getClassCode());
                obj.setPKey(((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey());
                obj.setBuff(buff);
                ICFBamScopeObj iCFBamScopeObj = obj.realize();
            }
        }
        Comparator<ICFBamScopeObj> cmp = new Comparator<ICFBamScopeObj>(){

            @Override
            public int compare(ICFBamScopeObj lhs, ICFBamScopeObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFBamScopePKey lhsPKey = lhs.getPKey();
                CFBamScopePKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo(rhsPKey);
                return ret;
            }
        };
        int len = dict.size();
        ICFBamScopeObj[] arr = new ICFBamScopeObj[len];
        Iterator<Object> valIter = dict.values().iterator();
        int idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = (ICFBamScopeObj)valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readScopeByTenantIdx", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readScopeByTenantIdx", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFBamScopeObj> arrayList = new ArrayList<ICFBamScopeObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFBamScopeObj> sortedList = arrayList;
        return sortedList;
    }

    @Override
    public ICFBamScopeObj updateScope(ICFBamScopeObj Obj) {
        ICFBamScopeObj obj = Obj;
        ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().updateScope(this.schema.getAuthorization(), Obj.getScopeBuff());
        if (Obj.getClassCode().equals("SCOP")) {
            obj = Obj.realize();
        }
        return obj;
    }

    @Override
    public void deleteScope(ICFBamScopeObj Obj) {
        ICFBamScopeObj obj = Obj;
        ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().deleteScope(this.schema.getAuthorization(), obj.getScopeBuff());
        obj.forget(true);
    }

    @Override
    public void deleteScopeByIdIdx(long TenantId, long Id) {
        CFBamScopePKey pkey = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey();
        pkey.setRequiredTenantId(TenantId);
        pkey.setRequiredId(Id);
        ICFBamScopeObj obj = this.readScope(pkey);
        if (obj != null) {
            ICFBamScopeEditObj editObj = obj.getEdit();
            boolean editStarted = editObj == null ? (editObj = obj.beginEdit()) != null : false;
            if (editObj != null) {
                editObj.delete();
                if (editStarted) {
                    editObj.endEdit();
                }
            }
            obj.forget(true);
        }
    }

    @Override
    public void deleteScopeByTenantIdx(long TenantId) {
        CFBamScopeByTenantIdxKey key = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newTenantIdxKey();
        key.setRequiredTenantId(TenantId);
        if (this.indexByTenantIdx == null) {
            this.indexByTenantIdx = new HashMap<CFBamScopeByTenantIdxKey, Map<CFBamScopePKey, ICFBamScopeObj>>();
        }
        if (this.indexByTenantIdx.containsKey(key)) {
            Map<CFBamScopePKey, ICFBamScopeObj> dict = this.indexByTenantIdx.get(key);
            ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().deleteScopeByTenantIdx(this.schema.getAuthorization(), TenantId);
            Iterator<ICFBamScopeObj> iter = dict.values().iterator();
            LinkedList<ICFBamScopeObj> toForget = new LinkedList<ICFBamScopeObj>();
            while (iter.hasNext()) {
                ICFBamScopeObj obj = iter.next();
                toForget.add(obj);
            }
            for (ICFBamScopeObj obj : toForget) {
                obj.forget(true);
            }
            this.indexByTenantIdx.remove(key);
        } else {
            ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().deleteScopeByTenantIdx(this.schema.getAuthorization(), TenantId);
        }
    }
}

