/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj;

import java.util.Calendar;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.CFBamScopeBuff;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.CFBamScopePKey;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamClusterObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamSchemaObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamScopeEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamScopeObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamScopeTableObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTenantObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecUserObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantObj;

public class CFBamScopeObj
implements ICFBamScopeObj {
    public static final String CLASS_CODE = "SCOP";
    protected ICFSecuritySecUserObj createdBy = null;
    protected ICFSecuritySecUserObj updatedBy = null;
    protected boolean isNew;
    protected ICFBamScopeEditObj edit;
    protected ICFBamSchemaObj schema;
    protected CFBamScopePKey pKey;
    protected CFBamScopeBuff buff;
    protected ICFSecurityTenantObj requiredOwnerTenant;

    public CFBamScopeObj() {
        this.getPKey().setClassCode(this.getClassCode());
        this.isNew = true;
        this.requiredOwnerTenant = null;
    }

    public CFBamScopeObj(ICFBamSchemaObj argSchema) {
        this.schema = argSchema;
        this.isNew = true;
        this.edit = null;
        this.getPKey().setClassCode(this.getClassCode());
        this.requiredOwnerTenant = null;
    }

    @Override
    public String getClassCode() {
        return CLASS_CODE;
    }

    public String getGenDefName() {
        return "Scope";
    }

    public ICFLibAnyObj getScope() {
        return null;
    }

    public ICFLibAnyObj getObjScope() {
        return null;
    }

    public String getObjName() {
        long val = this.getRequiredId();
        String objName = Long.toString(val);
        return objName;
    }

    public ICFLibAnyObj getObjQualifier(Class qualifyingClass) {
        CFBamScopeObj container;
        if (qualifyingClass != null) {
            for (container = this; !(container == null || container instanceof ICFBamClusterObj || container instanceof ICFBamTenantObj || qualifyingClass.isInstance(container)); container = container.getObjScope()) {
            }
        } else {
            while (container != null && !(container instanceof ICFBamClusterObj) && !(container instanceof ICFBamTenantObj)) {
                container = container.getObjScope();
            }
        }
        return container;
    }

    public ICFLibAnyObj getNamedObject(Class qualifyingClass, String objName) {
        ICFLibAnyObj topContainer = this.getObjQualifier(qualifyingClass);
        if (topContainer == null) {
            return null;
        }
        ICFLibAnyObj namedObject = topContainer.getNamedObject(objName);
        return namedObject;
    }

    public ICFLibAnyObj getNamedObject(String objName) {
        String remainingName;
        ICFLibAnyObj subObj = null;
        int nextDot = objName.indexOf(46);
        if (nextDot >= 0) {
            String nextName = objName.substring(0, nextDot);
            remainingName = objName.substring(nextDot + 1);
        } else {
            String nextName = objName;
            remainingName = null;
        }
        ICFLibAnyObj retObj = remainingName == null ? subObj : (subObj == null ? null : subObj.getNamedObject(remainingName));
        return retObj;
    }

    public String getObjQualifiedName() {
        Object qualName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            qualName = containerName + "." + (String)qualName;
            container = container.getObjScope();
        }
        return qualName;
    }

    public String getObjFullName() {
        Object fullName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            fullName = containerName + "." + (String)fullName;
            container = container.getObjScope();
        }
        return fullName;
    }

    @Override
    public ICFBamScopeObj realize() {
        ICFBamScopeObj retobj = this.schema.getScopeTableObj().realizeScope(this);
        return retobj;
    }

    @Override
    public void forget() {
        this.forget(false);
    }

    @Override
    public void forget(boolean forgetSubObjects) {
        this.schema.getScopeTableObj().forgetScope(this, forgetSubObjects);
    }

    @Override
    public ICFBamScopeObj read() {
        ICFBamScopeObj retobj = this.schema.getScopeTableObj().readScopeByIdIdx(this.getPKey().getRequiredTenantId(), this.getPKey().getRequiredId(), false);
        return retobj;
    }

    @Override
    public ICFBamScopeObj read(boolean forceRead) {
        ICFBamScopeObj retobj = this.schema.getScopeTableObj().readScopeByIdIdx(this.getPKey().getRequiredTenantId(), this.getPKey().getRequiredId(), forceRead);
        return retobj;
    }

    @Override
    public ICFBamScopeTableObj getScopeTable() {
        return this.schema.getScopeTableObj();
    }

    @Override
    public ICFBamSchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFBamSchemaObj value) {
        this.schema = value;
    }

    @Override
    public CFBamScopeBuff getBuff() {
        if (this.buff == null) {
            if (this.isNew) {
                this.buff = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newBuff();
            } else {
                this.buff = ((ICFBamSchema)this.schema.getBackingStore()).getTableScope().readDerivedByIdIdx(this.schema.getAuthorization(), this.getPKey().getRequiredTenantId(), this.getPKey().getRequiredId());
                if (this.buff != null) {
                    this.copyBuffToPKey();
                }
            }
        }
        return this.buff;
    }

    @Override
    public void setBuff(CFBamScopeBuff value) {
        if (value != null && !(value instanceof CFBamScopeBuff)) {
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "setBuff", "value", (Object)value, "CFBamScopeBuff");
        }
        this.buff = value;
        this.copyBuffToPKey();
        this.requiredOwnerTenant = null;
    }

    @Override
    public CFBamScopeBuff getScopeBuff() {
        return this.getBuff();
    }

    @Override
    public CFBamScopePKey getPKey() {
        if (this.pKey == null) {
            this.pKey = ((ICFBamSchema)this.schema.getBackingStore()).getFactoryScope().newPKey();
        }
        return this.pKey;
    }

    @Override
    public void setPKey(CFBamScopePKey value) {
        if (this.pKey != value) {
            this.pKey = value;
            this.copyPKeyToBuff();
        }
    }

    @Override
    public boolean getIsNew() {
        return this.isNew;
    }

    @Override
    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    @Override
    public ICFBamScopeEditObj beginEdit() {
        if (this.edit != null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "beginEdit", "An edit is already open");
        }
        ICFBamScopeObj lockobj = this.getIsNew() ? this : this.schema.getScopeTableObj().lockScope(this.getPKey());
        this.edit = this.schema.getScopeTableObj().newEditInstance(lockobj);
        return this.edit;
    }

    @Override
    public void endEdit() {
        this.edit = null;
    }

    @Override
    public ICFBamScopeEditObj getEdit() {
        return this.edit;
    }

    @Override
    public ICFBamScopeEditObj getEditAsScope() {
        return this.edit;
    }

    @Override
    public ICFSecuritySecUserObj getCreatedBy() {
        if (this.createdBy == null) {
            CFBamScopeBuff buff = this.getBuff();
            this.createdBy = this.getSchema().getSecUserTableObj().readSecUserByIdIdx(buff.getCreatedByUserId());
        }
        return this.createdBy;
    }

    @Override
    public Calendar getCreatedAt() {
        return this.getBuff().getCreatedAt();
    }

    @Override
    public ICFSecuritySecUserObj getUpdatedBy() {
        if (this.updatedBy == null) {
            CFBamScopeBuff buff = this.getBuff();
            this.updatedBy = this.getSchema().getSecUserTableObj().readSecUserByIdIdx(buff.getUpdatedByUserId());
        }
        return this.updatedBy;
    }

    @Override
    public Calendar getUpdatedAt() {
        return this.getBuff().getUpdatedAt();
    }

    @Override
    public long getRequiredTenantId() {
        return this.getPKey().getRequiredTenantId();
    }

    @Override
    public long getRequiredId() {
        return this.getPKey().getRequiredId();
    }

    @Override
    public ICFSecurityTenantObj getRequiredOwnerTenant() {
        return this.getRequiredOwnerTenant(false);
    }

    @Override
    public ICFSecurityTenantObj getRequiredOwnerTenant(boolean forceRead) {
        boolean anyMissing;
        if ((this.requiredOwnerTenant == null || forceRead) && !(anyMissing = false)) {
            this.requiredOwnerTenant = this.schema.getTenantTableObj().readTenantByIdIdx(this.getPKey().getRequiredTenantId(), forceRead);
        }
        return this.requiredOwnerTenant;
    }

    @Override
    public void copyPKeyToBuff() {
        if (this.buff != null) {
            this.buff.setRequiredTenantId(this.getPKey().getRequiredTenantId());
            this.buff.setRequiredId(this.getPKey().getRequiredId());
        }
        if (this.edit != null) {
            this.edit.copyPKeyToBuff();
        }
    }

    @Override
    public void copyBuffToPKey() {
        this.getPKey().setClassCode(this.buff.getClassCode());
        this.getPKey().setRequiredTenantId(this.buff.getRequiredTenantId());
        this.getPKey().setRequiredId(this.buff.getRequiredId());
    }
}

