/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj;

import java.util.Calendar;
import java.util.UUID;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecuritySecSessionBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecuritySecSessionPKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySchemaObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecSessionEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecSessionObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecSessionTableObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecUserObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantObj;

public class CFSecuritySecSessionObj
implements ICFSecuritySecSessionObj {
    public static final String CLASS_CODE = "SESS";
    protected boolean isNew;
    protected ICFSecuritySecSessionEditObj edit;
    protected ICFSecuritySchemaObj schema;
    protected CFSecuritySecSessionPKey pKey;
    protected CFSecuritySecSessionBuff buff;
    protected ICFSecuritySecUserObj requiredContainerSecUser;
    protected ICFSecuritySecUserObj requiredParentSecProxy;

    public CFSecuritySecSessionObj() {
        this.isNew = true;
        this.requiredContainerSecUser = null;
        this.requiredParentSecProxy = null;
    }

    public CFSecuritySecSessionObj(ICFSecuritySchemaObj argSchema) {
        this.schema = argSchema;
        this.isNew = true;
        this.edit = null;
        this.requiredContainerSecUser = null;
        this.requiredParentSecProxy = null;
    }

    @Override
    public String getClassCode() {
        return CLASS_CODE;
    }

    public String getGenDefName() {
        return "SecSession";
    }

    public ICFLibAnyObj getScope() {
        ICFSecuritySecUserObj scope = this.getRequiredContainerSecUser();
        return scope;
    }

    public ICFLibAnyObj getObjScope() {
        ICFSecuritySecUserObj scope = this.getRequiredContainerSecUser();
        return scope;
    }

    public String getObjName() {
        UUID val = this.getRequiredSecSessionId();
        String objName = val.toString();
        return objName;
    }

    public ICFLibAnyObj getObjQualifier(Class qualifyingClass) {
        CFSecuritySecSessionObj container;
        if (qualifyingClass != null) {
            for (container = this; !(container == null || container instanceof ICFSecurityClusterObj || container instanceof ICFSecurityTenantObj || qualifyingClass.isInstance(container)); container = container.getObjScope()) {
            }
        } else {
            while (container != null && !(container instanceof ICFSecurityClusterObj) && !(container instanceof ICFSecurityTenantObj)) {
                container = container.getObjScope();
            }
        }
        return container;
    }

    public ICFLibAnyObj getNamedObject(Class qualifyingClass, String objName) {
        ICFLibAnyObj topContainer = this.getObjQualifier(qualifyingClass);
        if (topContainer == null) {
            return null;
        }
        ICFLibAnyObj namedObject = topContainer.getNamedObject(objName);
        return namedObject;
    }

    public ICFLibAnyObj getNamedObject(String objName) {
        String remainingName;
        ICFLibAnyObj subObj = null;
        int nextDot = objName.indexOf(46);
        if (nextDot >= 0) {
            String nextName = objName.substring(0, nextDot);
            remainingName = objName.substring(nextDot + 1);
        } else {
            String nextName = objName;
            remainingName = null;
        }
        ICFLibAnyObj retObj = remainingName == null ? subObj : (subObj == null ? null : subObj.getNamedObject(remainingName));
        return retObj;
    }

    public String getObjQualifiedName() {
        Object qualName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            qualName = containerName + "." + (String)qualName;
            container = container.getObjScope();
        }
        return qualName;
    }

    public String getObjFullName() {
        Object fullName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            fullName = containerName + "." + (String)fullName;
            container = container.getObjScope();
        }
        return fullName;
    }

    @Override
    public ICFSecuritySecSessionObj realize() {
        ICFSecuritySecSessionObj retobj = this.schema.getSecSessionTableObj().realizeSecSession(this);
        return retobj;
    }

    @Override
    public void forget() {
        this.forget(false);
    }

    @Override
    public void forget(boolean forgetSubObjects) {
        this.schema.getSecSessionTableObj().forgetSecSession(this, forgetSubObjects);
    }

    @Override
    public ICFSecuritySecSessionObj read() {
        ICFSecuritySecSessionObj retobj = this.schema.getSecSessionTableObj().readSecSessionByIdIdx(this.getPKey().getRequiredSecSessionId(), false);
        return retobj;
    }

    @Override
    public ICFSecuritySecSessionObj read(boolean forceRead) {
        ICFSecuritySecSessionObj retobj = this.schema.getSecSessionTableObj().readSecSessionByIdIdx(this.getPKey().getRequiredSecSessionId(), forceRead);
        return retobj;
    }

    @Override
    public ICFSecuritySecSessionTableObj getSecSessionTable() {
        return this.schema.getSecSessionTableObj();
    }

    @Override
    public ICFSecuritySchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFSecuritySchemaObj value) {
        this.schema = value;
    }

    @Override
    public CFSecuritySecSessionBuff getBuff() {
        if (this.buff == null) {
            if (this.isNew) {
                this.buff = this.schema.getBackingStore().getFactorySecSession().newBuff();
            } else {
                this.buff = this.schema.getBackingStore().getTableSecSession().readDerivedByIdIdx(this.schema.getAuthorization(), this.getPKey().getRequiredSecSessionId());
                if (this.buff != null) {
                    this.copyBuffToPKey();
                }
            }
        }
        return this.buff;
    }

    @Override
    public void setBuff(CFSecuritySecSessionBuff value) {
        if (value != null && !(value instanceof CFSecuritySecSessionBuff)) {
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "setBuff", "value", (Object)value, "CFSecuritySecSessionBuff");
        }
        this.buff = value;
        this.copyBuffToPKey();
        this.requiredContainerSecUser = null;
        this.requiredParentSecProxy = null;
    }

    @Override
    public CFSecuritySecSessionBuff getSecSessionBuff() {
        return this.getBuff();
    }

    @Override
    public CFSecuritySecSessionPKey getPKey() {
        if (this.pKey == null) {
            this.pKey = this.schema.getBackingStore().getFactorySecSession().newPKey();
        }
        return this.pKey;
    }

    @Override
    public void setPKey(CFSecuritySecSessionPKey value) {
        if (this.pKey != value) {
            this.pKey = value;
            this.copyPKeyToBuff();
        }
    }

    @Override
    public boolean getIsNew() {
        return this.isNew;
    }

    @Override
    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    @Override
    public ICFSecuritySecSessionEditObj beginEdit() {
        if (this.edit != null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "beginEdit", "An edit is already open");
        }
        ICFSecuritySecSessionObj lockobj = this.getIsNew() ? this : this.schema.getSecSessionTableObj().lockSecSession(this.getPKey());
        this.edit = this.schema.getSecSessionTableObj().newEditInstance(lockobj);
        return this.edit;
    }

    @Override
    public void endEdit() {
        this.edit = null;
    }

    @Override
    public ICFSecuritySecSessionEditObj getEdit() {
        return this.edit;
    }

    @Override
    public ICFSecuritySecSessionEditObj getEditAsSecSession() {
        return this.edit;
    }

    @Override
    public UUID getRequiredSecSessionId() {
        return this.getPKey().getRequiredSecSessionId();
    }

    @Override
    public UUID getRequiredSecUserId() {
        return this.getSecSessionBuff().getRequiredSecUserId();
    }

    @Override
    public String getOptionalSecDevName() {
        return this.getSecSessionBuff().getOptionalSecDevName();
    }

    @Override
    public Calendar getRequiredStart() {
        return this.getSecSessionBuff().getRequiredStart();
    }

    @Override
    public Calendar getOptionalFinish() {
        return this.getSecSessionBuff().getOptionalFinish();
    }

    @Override
    public UUID getOptionalSecProxyId() {
        return this.getSecSessionBuff().getOptionalSecProxyId();
    }

    @Override
    public ICFSecuritySecUserObj getRequiredContainerSecUser() {
        return this.getRequiredContainerSecUser(false);
    }

    @Override
    public ICFSecuritySecUserObj getRequiredContainerSecUser(boolean forceRead) {
        boolean anyMissing;
        if ((this.requiredContainerSecUser == null || forceRead) && !(anyMissing = false)) {
            this.requiredContainerSecUser = this.schema.getSecUserTableObj().readSecUserByIdIdx(this.getSecSessionBuff().getRequiredSecUserId(), forceRead);
        }
        return this.requiredContainerSecUser;
    }

    @Override
    public ICFSecuritySecUserObj getRequiredParentSecProxy() {
        return this.getRequiredParentSecProxy(false);
    }

    @Override
    public ICFSecuritySecUserObj getRequiredParentSecProxy(boolean forceRead) {
        if (this.requiredParentSecProxy == null || forceRead) {
            boolean anyMissing = false;
            if (this.getSecSessionBuff().getOptionalSecProxyId() == null) {
                anyMissing = true;
            }
            if (!anyMissing) {
                this.requiredParentSecProxy = this.schema.getSecUserTableObj().readSecUserByIdIdx(this.getSecSessionBuff().getOptionalSecProxyId(), forceRead);
            }
        }
        return this.requiredParentSecProxy;
    }

    @Override
    public void copyPKeyToBuff() {
        if (this.buff != null) {
            this.buff.setRequiredSecSessionId(this.getPKey().getRequiredSecSessionId());
        }
        if (this.edit != null) {
            this.edit.copyPKeyToBuff();
        }
    }

    @Override
    public void copyBuffToPKey() {
        this.getPKey().setRequiredSecSessionId(this.buff.getRequiredSecSessionId());
    }
}

