/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj;

import java.util.Calendar;
import java.util.List;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOLanguageBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOLanguagePKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryLanguageObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOLanguageEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOLanguageObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOLanguageTableObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySchemaObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecUserObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantObj;

public class CFSecurityISOLanguageObj
implements ICFSecurityISOLanguageObj {
    public static final String CLASS_CODE = "ISLN";
    protected ICFSecuritySecUserObj createdBy = null;
    protected ICFSecuritySecUserObj updatedBy = null;
    protected boolean isNew;
    protected ICFSecurityISOLanguageEditObj edit;
    protected ICFSecuritySchemaObj schema;
    protected CFSecurityISOLanguagePKey pKey;
    protected CFSecurityISOLanguageBuff buff;

    public CFSecurityISOLanguageObj() {
        this.isNew = true;
    }

    public CFSecurityISOLanguageObj(ICFSecuritySchemaObj argSchema) {
        this.schema = argSchema;
        this.isNew = true;
        this.edit = null;
    }

    @Override
    public String getClassCode() {
        return CLASS_CODE;
    }

    public String getGenDefName() {
        return "ISOLanguage";
    }

    public ICFLibAnyObj getScope() {
        return null;
    }

    public ICFLibAnyObj getObjScope() {
        return null;
    }

    public String getObjName() {
        String objName = this.getRequiredISO6392Code();
        return objName;
    }

    public ICFLibAnyObj getObjQualifier(Class qualifyingClass) {
        CFSecurityISOLanguageObj container;
        if (qualifyingClass != null) {
            for (container = this; !(container == null || container instanceof ICFSecurityClusterObj || container instanceof ICFSecurityTenantObj || qualifyingClass.isInstance(container)); container = container.getObjScope()) {
            }
        } else {
            while (container != null && !(container instanceof ICFSecurityClusterObj) && !(container instanceof ICFSecurityTenantObj)) {
                container = container.getObjScope();
            }
        }
        return container;
    }

    public ICFLibAnyObj getNamedObject(Class qualifyingClass, String objName) {
        ICFLibAnyObj topContainer = this.getObjQualifier(qualifyingClass);
        if (topContainer == null) {
            return null;
        }
        ICFLibAnyObj namedObject = topContainer.getNamedObject(objName);
        return namedObject;
    }

    public ICFLibAnyObj getNamedObject(String objName) {
        String remainingName;
        ICFLibAnyObj subObj = null;
        int nextDot = objName.indexOf(46);
        if (nextDot >= 0) {
            String nextName = objName.substring(0, nextDot);
            remainingName = objName.substring(nextDot + 1);
        } else {
            String nextName = objName;
            remainingName = null;
        }
        ICFLibAnyObj retObj = remainingName == null ? subObj : (subObj == null ? null : subObj.getNamedObject(remainingName));
        return retObj;
    }

    public String getObjQualifiedName() {
        Object qualName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            qualName = containerName + "." + (String)qualName;
            container = container.getObjScope();
        }
        return qualName;
    }

    public String getObjFullName() {
        Object fullName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            fullName = containerName + "." + (String)fullName;
            container = container.getObjScope();
        }
        return fullName;
    }

    @Override
    public ICFSecurityISOLanguageObj realize() {
        ICFSecurityISOLanguageObj retobj = this.schema.getISOLanguageTableObj().realizeISOLanguage(this);
        return retobj;
    }

    @Override
    public void forget() {
        this.forget(false);
    }

    @Override
    public void forget(boolean forgetSubObjects) {
        this.schema.getISOLanguageTableObj().forgetISOLanguage(this, forgetSubObjects);
    }

    @Override
    public ICFSecurityISOLanguageObj read() {
        ICFSecurityISOLanguageObj retobj = this.schema.getISOLanguageTableObj().readISOLanguageByIdIdx(this.getPKey().getRequiredISOLanguageId(), false);
        return retobj;
    }

    @Override
    public ICFSecurityISOLanguageObj read(boolean forceRead) {
        ICFSecurityISOLanguageObj retobj = this.schema.getISOLanguageTableObj().readISOLanguageByIdIdx(this.getPKey().getRequiredISOLanguageId(), forceRead);
        return retobj;
    }

    @Override
    public ICFSecurityISOLanguageTableObj getISOLanguageTable() {
        return this.schema.getISOLanguageTableObj();
    }

    @Override
    public ICFSecuritySchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFSecuritySchemaObj value) {
        this.schema = value;
    }

    @Override
    public CFSecurityISOLanguageBuff getBuff() {
        if (this.buff == null) {
            if (this.isNew) {
                this.buff = this.schema.getBackingStore().getFactoryISOLanguage().newBuff();
            } else {
                this.buff = this.schema.getBackingStore().getTableISOLanguage().readDerivedByIdIdx(this.schema.getAuthorization(), this.getPKey().getRequiredISOLanguageId());
                if (this.buff != null) {
                    this.copyBuffToPKey();
                }
            }
        }
        return this.buff;
    }

    @Override
    public void setBuff(CFSecurityISOLanguageBuff value) {
        if (value != null && !(value instanceof CFSecurityISOLanguageBuff)) {
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "setBuff", "value", (Object)value, "CFSecurityISOLanguageBuff");
        }
        this.buff = value;
        this.copyBuffToPKey();
    }

    @Override
    public CFSecurityISOLanguageBuff getISOLanguageBuff() {
        return this.getBuff();
    }

    @Override
    public CFSecurityISOLanguagePKey getPKey() {
        if (this.pKey == null) {
            this.pKey = this.schema.getBackingStore().getFactoryISOLanguage().newPKey();
        }
        return this.pKey;
    }

    @Override
    public void setPKey(CFSecurityISOLanguagePKey value) {
        if (this.pKey != value) {
            this.pKey = value;
            this.copyPKeyToBuff();
        }
    }

    @Override
    public boolean getIsNew() {
        return this.isNew;
    }

    @Override
    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    @Override
    public ICFSecurityISOLanguageEditObj beginEdit() {
        if (this.edit != null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "beginEdit", "An edit is already open");
        }
        ICFSecurityISOLanguageObj lockobj = this.getIsNew() ? this : this.schema.getISOLanguageTableObj().lockISOLanguage(this.getPKey());
        this.edit = this.schema.getISOLanguageTableObj().newEditInstance(lockobj);
        return this.edit;
    }

    @Override
    public void endEdit() {
        this.edit = null;
    }

    @Override
    public ICFSecurityISOLanguageEditObj getEdit() {
        return this.edit;
    }

    @Override
    public ICFSecurityISOLanguageEditObj getEditAsISOLanguage() {
        return this.edit;
    }

    @Override
    public ICFSecuritySecUserObj getCreatedBy() {
        if (this.createdBy == null) {
            CFSecurityISOLanguageBuff buff = this.getBuff();
            this.createdBy = this.getSchema().getSecUserTableObj().readSecUserByIdIdx(buff.getCreatedByUserId());
        }
        return this.createdBy;
    }

    @Override
    public Calendar getCreatedAt() {
        return this.getBuff().getCreatedAt();
    }

    @Override
    public ICFSecuritySecUserObj getUpdatedBy() {
        if (this.updatedBy == null) {
            CFSecurityISOLanguageBuff buff = this.getBuff();
            this.updatedBy = this.getSchema().getSecUserTableObj().readSecUserByIdIdx(buff.getUpdatedByUserId());
        }
        return this.updatedBy;
    }

    @Override
    public Calendar getUpdatedAt() {
        return this.getBuff().getUpdatedAt();
    }

    @Override
    public short getRequiredISOLanguageId() {
        return this.getPKey().getRequiredISOLanguageId();
    }

    @Override
    public String getRequiredISO6392Code() {
        return this.getISOLanguageBuff().getRequiredISO6392Code();
    }

    @Override
    public String getOptionalISO6391Code() {
        return this.getISOLanguageBuff().getOptionalISO6391Code();
    }

    @Override
    public String getRequiredEnglishName() {
        return this.getISOLanguageBuff().getRequiredEnglishName();
    }

    @Override
    public List<ICFSecurityISOCountryLanguageObj> getOptionalChildrenCountry() {
        List<ICFSecurityISOCountryLanguageObj> retval = this.schema.getISOCountryLanguageTableObj().readISOCountryLanguageByLanguageIdx(this.getPKey().getRequiredISOLanguageId(), false);
        return retval;
    }

    @Override
    public List<ICFSecurityISOCountryLanguageObj> getOptionalChildrenCountry(boolean forceRead) {
        List<ICFSecurityISOCountryLanguageObj> retval = this.schema.getISOCountryLanguageTableObj().readISOCountryLanguageByLanguageIdx(this.getPKey().getRequiredISOLanguageId(), forceRead);
        return retval;
    }

    @Override
    public void copyPKeyToBuff() {
        if (this.buff != null) {
            this.buff.setRequiredISOLanguageId(this.getPKey().getRequiredISOLanguageId());
        }
        if (this.edit != null) {
            this.edit.copyPKeyToBuff();
        }
    }

    @Override
    public void copyBuffToPKey() {
        this.getPKey().setRequiredISOLanguageId(this.buff.getRequiredISOLanguageId());
    }
}

