/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryByISOCodeIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryByNameIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryPKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.CFSecurityISOCountryEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.CFSecurityISOCountryObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryTableObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySchemaObj;

public class CFSecurityISOCountryTableObj
implements ICFSecurityISOCountryTableObj {
    protected ICFSecuritySchemaObj schema;
    private Map<CFSecurityISOCountryPKey, ICFSecurityISOCountryObj> members;
    private Map<CFSecurityISOCountryPKey, ICFSecurityISOCountryObj> allISOCountry;
    private Map<CFSecurityISOCountryByISOCodeIdxKey, ICFSecurityISOCountryObj> indexByISOCodeIdx;
    private Map<CFSecurityISOCountryByNameIdxKey, ICFSecurityISOCountryObj> indexByNameIdx;
    public static String TABLE_NAME = "ISOCountry";
    public static String TABLE_DBNAME = "iso_cntry";

    public CFSecurityISOCountryTableObj() {
        this.schema = null;
        this.members = new HashMap<CFSecurityISOCountryPKey, ICFSecurityISOCountryObj>();
        this.allISOCountry = null;
        this.indexByISOCodeIdx = null;
        this.indexByNameIdx = null;
    }

    public CFSecurityISOCountryTableObj(ICFSecuritySchemaObj argSchema) {
        this.schema = argSchema;
        this.members = new HashMap<CFSecurityISOCountryPKey, ICFSecurityISOCountryObj>();
        this.allISOCountry = null;
        this.indexByISOCodeIdx = null;
        this.indexByNameIdx = null;
    }

    @Override
    public ICFSecuritySchemaObj getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(ICFSecuritySchemaObj value) {
        this.schema = value;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getTableDbName() {
        return TABLE_DBNAME;
    }

    @Override
    public Class getObjQualifyingClass() {
        return null;
    }

    @Override
    public void minimizeMemory() {
        this.allISOCountry = null;
        this.indexByISOCodeIdx = null;
        this.indexByNameIdx = null;
        LinkedList<ICFSecurityISOCountryObj> toForget = new LinkedList<ICFSecurityISOCountryObj>();
        ICFSecurityISOCountryObj cur2 = null;
        for (ICFSecurityISOCountryObj cur2 : this.members.values()) {
            toForget.add(cur2);
        }
        for (ICFSecurityISOCountryObj cur2 : toForget) {
            cur2.forget();
        }
    }

    @Override
    public ICFSecurityISOCountryObj newInstance() {
        CFSecurityISOCountryObj inst = new CFSecurityISOCountryObj(this.schema);
        return inst;
    }

    @Override
    public ICFSecurityISOCountryEditObj newEditInstance(ICFSecurityISOCountryObj orig) {
        CFSecurityISOCountryEditObj edit = new CFSecurityISOCountryEditObj(orig);
        return edit;
    }

    @Override
    public ICFSecurityISOCountryObj realizeISOCountry(ICFSecurityISOCountryObj Obj) {
        ICFSecurityISOCountryObj obj = Obj;
        CFSecurityISOCountryPKey pkey = obj.getPKey();
        ICFSecurityISOCountryObj keepObj = null;
        if (this.members.containsKey(pkey) && null != this.members.get(pkey)) {
            CFSecurityISOCountryByNameIdxKey keyNameIdx;
            CFSecurityISOCountryByISOCodeIdxKey keyISOCodeIdx;
            ICFSecurityISOCountryObj existingObj;
            keepObj = existingObj = this.members.get(pkey);
            if (this.indexByISOCodeIdx != null) {
                keyISOCodeIdx = this.schema.getBackingStore().getFactoryISOCountry().newISOCodeIdxKey();
                keyISOCodeIdx.setRequiredISOCode(keepObj.getRequiredISOCode());
                this.indexByISOCodeIdx.remove(keyISOCodeIdx);
            }
            if (this.indexByNameIdx != null) {
                keyNameIdx = this.schema.getBackingStore().getFactoryISOCountry().newNameIdxKey();
                keyNameIdx.setRequiredName(keepObj.getRequiredName());
                this.indexByNameIdx.remove(keyNameIdx);
            }
            keepObj.setBuff(Obj.getBuff());
            if (this.indexByISOCodeIdx != null) {
                keyISOCodeIdx = this.schema.getBackingStore().getFactoryISOCountry().newISOCodeIdxKey();
                keyISOCodeIdx.setRequiredISOCode(keepObj.getRequiredISOCode());
                this.indexByISOCodeIdx.put(keyISOCodeIdx, keepObj);
            }
            if (this.indexByNameIdx != null) {
                keyNameIdx = this.schema.getBackingStore().getFactoryISOCountry().newNameIdxKey();
                keyNameIdx.setRequiredName(keepObj.getRequiredName());
                this.indexByNameIdx.put(keyNameIdx, keepObj);
            }
            if (this.allISOCountry != null) {
                this.allISOCountry.put(keepObj.getPKey(), keepObj);
            }
        } else {
            keepObj = obj;
            keepObj.setIsNew(false);
            this.members.put(keepObj.getPKey(), keepObj);
            if (this.allISOCountry != null) {
                this.allISOCountry.put(keepObj.getPKey(), keepObj);
            }
            if (this.indexByISOCodeIdx != null) {
                CFSecurityISOCountryByISOCodeIdxKey keyISOCodeIdx = this.schema.getBackingStore().getFactoryISOCountry().newISOCodeIdxKey();
                keyISOCodeIdx.setRequiredISOCode(keepObj.getRequiredISOCode());
                this.indexByISOCodeIdx.put(keyISOCodeIdx, keepObj);
            }
            if (this.indexByNameIdx != null) {
                CFSecurityISOCountryByNameIdxKey keyNameIdx = this.schema.getBackingStore().getFactoryISOCountry().newNameIdxKey();
                keyNameIdx.setRequiredName(keepObj.getRequiredName());
                this.indexByNameIdx.put(keyNameIdx, keepObj);
            }
        }
        return keepObj;
    }

    @Override
    public void forgetISOCountry(ICFSecurityISOCountryObj Obj) {
        this.forgetISOCountry(Obj, false);
    }

    @Override
    public void forgetISOCountry(ICFSecurityISOCountryObj Obj, boolean forgetSubObjects) {
        ICFSecurityISOCountryObj obj = Obj;
        CFSecurityISOCountryPKey pkey = obj.getPKey();
        if (this.members.containsKey(pkey)) {
            ICFSecurityISOCountryObj keepObj = this.members.get(pkey);
            if (this.indexByISOCodeIdx != null) {
                CFSecurityISOCountryByISOCodeIdxKey keyISOCodeIdx = this.schema.getBackingStore().getFactoryISOCountry().newISOCodeIdxKey();
                keyISOCodeIdx.setRequiredISOCode(keepObj.getRequiredISOCode());
                this.indexByISOCodeIdx.remove(keyISOCodeIdx);
            }
            if (this.indexByNameIdx != null) {
                CFSecurityISOCountryByNameIdxKey keyNameIdx = this.schema.getBackingStore().getFactoryISOCountry().newNameIdxKey();
                keyNameIdx.setRequiredName(keepObj.getRequiredName());
                this.indexByNameIdx.remove(keyNameIdx);
            }
            if (this.allISOCountry != null) {
                this.allISOCountry.remove(keepObj.getPKey());
            }
            this.members.remove(pkey);
            if (forgetSubObjects) {
                this.schema.getISOCountryCurrencyTableObj().forgetISOCountryCurrencyByCountryIdx(keepObj.getRequiredISOCountryId());
                this.schema.getISOCountryLanguageTableObj().forgetISOCountryLanguageByCountryIdx(keepObj.getRequiredISOCountryId());
            }
        }
    }

    @Override
    public void forgetISOCountryByIdIdx(short ISOCountryId) {
        ICFSecurityISOCountryObj probed;
        if (this.members == null) {
            return;
        }
        CFSecurityISOCountryPKey key = this.schema.getBackingStore().getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(ISOCountryId);
        if (this.members.containsKey(key) && (probed = this.members.get(key)) != null) {
            probed.forget(true);
        }
    }

    @Override
    public void forgetISOCountryByISOCodeIdx(String ISOCode) {
        if (this.indexByISOCodeIdx == null) {
            return;
        }
        CFSecurityISOCountryByISOCodeIdxKey key = this.schema.getBackingStore().getFactoryISOCountry().newISOCodeIdxKey();
        key.setRequiredISOCode(ISOCode);
        if (this.indexByISOCodeIdx.containsKey(key)) {
            ICFSecurityISOCountryObj probed = this.indexByISOCodeIdx.get(key);
            if (probed != null) {
                probed.forget(true);
            }
            this.indexByISOCodeIdx.remove(key);
        }
    }

    @Override
    public void forgetISOCountryByNameIdx(String Name) {
        if (this.indexByNameIdx == null) {
            return;
        }
        CFSecurityISOCountryByNameIdxKey key = this.schema.getBackingStore().getFactoryISOCountry().newNameIdxKey();
        key.setRequiredName(Name);
        if (this.indexByNameIdx.containsKey(key)) {
            ICFSecurityISOCountryObj probed = this.indexByNameIdx.get(key);
            if (probed != null) {
                probed.forget(true);
            }
            this.indexByNameIdx.remove(key);
        }
    }

    @Override
    public ICFSecurityISOCountryObj createISOCountry(ICFSecurityISOCountryObj Obj) {
        ICFSecurityISOCountryObj obj = Obj;
        CFSecurityISOCountryBuff buff = obj.getISOCountryBuff();
        this.schema.getBackingStore().getTableISOCountry().createISOCountry(this.schema.getAuthorization(), buff);
        obj.copyBuffToPKey();
        obj = obj.realize();
        return obj;
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountry(CFSecurityISOCountryPKey pkey) {
        return this.readISOCountry(pkey, false);
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountry(CFSecurityISOCountryPKey pkey, boolean forceRead) {
        ICFSecurityISOCountryObj obj = null;
        if (!forceRead && this.members.containsKey(pkey)) {
            obj = this.members.get(pkey);
        } else {
            CFSecurityISOCountryBuff readBuff = this.schema.getBackingStore().getTableISOCountry().readDerivedByIdIdx(this.schema.getAuthorization(), pkey.getRequiredISOCountryId());
            if (readBuff != null) {
                obj = this.schema.getISOCountryTableObj().newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryISOCountry().newPKey());
                obj.setBuff(readBuff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.members.put(pkey, null);
            }
        }
        return obj;
    }

    @Override
    public ICFSecurityISOCountryObj lockISOCountry(CFSecurityISOCountryPKey pkey) {
        ICFSecurityISOCountryObj locked = null;
        CFSecurityISOCountryBuff lockBuff = this.schema.getBackingStore().getTableISOCountry().lockDerived(this.schema.getAuthorization(), pkey);
        if (lockBuff == null) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "lockISOCountry", (Object)pkey);
        }
        locked = this.schema.getISOCountryTableObj().newInstance();
        locked.setPKey(this.schema.getBackingStore().getFactoryISOCountry().newPKey());
        locked.setBuff(lockBuff);
        locked = locked.realize();
        return locked;
    }

    @Override
    public List<ICFSecurityISOCountryObj> readAllISOCountry() {
        return this.readAllISOCountry(false);
    }

    @Override
    public List<ICFSecurityISOCountryObj> readAllISOCountry(boolean forceRead) {
        int idx;
        String S_ProcName = "readAllISOCountry";
        if (this.allISOCountry == null || forceRead) {
            HashMap<CFSecurityISOCountryPKey, ICFSecurityISOCountryObj> map = new HashMap<CFSecurityISOCountryPKey, ICFSecurityISOCountryObj>();
            this.allISOCountry = map;
            CFSecurityISOCountryBuff[] buffList = this.schema.getBackingStore().getTableISOCountry().readAllDerived(this.schema.getAuthorization());
            for (idx = 0; idx < buffList.length; ++idx) {
                CFSecurityISOCountryBuff buff = buffList[idx];
                ICFSecurityISOCountryObj obj = this.newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryISOCountry().newPKey());
                obj.setBuff(buff);
                ICFSecurityISOCountryObj iCFSecurityISOCountryObj = obj.realize();
            }
        }
        Comparator<ICFSecurityISOCountryObj> cmp = new Comparator<ICFSecurityISOCountryObj>(){

            @Override
            public int compare(ICFSecurityISOCountryObj lhs, ICFSecurityISOCountryObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFSecurityISOCountryPKey lhsPKey = lhs.getPKey();
                CFSecurityISOCountryPKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo(rhsPKey);
                return ret;
            }
        };
        int len = this.allISOCountry.size();
        ICFSecurityISOCountryObj[] arr = new ICFSecurityISOCountryObj[len];
        Iterator<ICFSecurityISOCountryObj> valIter = this.allISOCountry.values().iterator();
        idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readAllISOCountry", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readAllISOCountry", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFSecurityISOCountryObj> arrayList = new ArrayList<ICFSecurityISOCountryObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFSecurityISOCountryObj> sortedList = arrayList;
        return sortedList;
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountryByIdIdx(short ISOCountryId) {
        return this.readISOCountryByIdIdx(ISOCountryId, false);
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountryByIdIdx(short ISOCountryId, boolean forceRead) {
        CFSecurityISOCountryPKey pkey = this.schema.getBackingStore().getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(ISOCountryId);
        ICFSecurityISOCountryObj obj = this.readISOCountry(pkey, forceRead);
        return obj;
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountryByISOCodeIdx(String ISOCode) {
        return this.readISOCountryByISOCodeIdx(ISOCode, false);
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountryByISOCodeIdx(String ISOCode, boolean forceRead) {
        if (this.indexByISOCodeIdx == null) {
            this.indexByISOCodeIdx = new HashMap<CFSecurityISOCountryByISOCodeIdxKey, ICFSecurityISOCountryObj>();
        }
        CFSecurityISOCountryByISOCodeIdxKey key = this.schema.getBackingStore().getFactoryISOCountry().newISOCodeIdxKey();
        key.setRequiredISOCode(ISOCode);
        ICFSecurityISOCountryObj obj = null;
        if (!forceRead && this.indexByISOCodeIdx.containsKey(key)) {
            obj = this.indexByISOCodeIdx.get(key);
        } else {
            CFSecurityISOCountryBuff buff = this.schema.getBackingStore().getTableISOCountry().readDerivedByISOCodeIdx(this.schema.getAuthorization(), ISOCode);
            if (buff != null) {
                obj = this.schema.getISOCountryTableObj().newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryISOCountry().newPKey());
                obj.setBuff(buff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.indexByISOCodeIdx.put(key, null);
            }
        }
        return obj;
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountryByNameIdx(String Name) {
        return this.readISOCountryByNameIdx(Name, false);
    }

    @Override
    public ICFSecurityISOCountryObj readISOCountryByNameIdx(String Name, boolean forceRead) {
        if (this.indexByNameIdx == null) {
            this.indexByNameIdx = new HashMap<CFSecurityISOCountryByNameIdxKey, ICFSecurityISOCountryObj>();
        }
        CFSecurityISOCountryByNameIdxKey key = this.schema.getBackingStore().getFactoryISOCountry().newNameIdxKey();
        key.setRequiredName(Name);
        ICFSecurityISOCountryObj obj = null;
        if (!forceRead && this.indexByNameIdx.containsKey(key)) {
            obj = this.indexByNameIdx.get(key);
        } else {
            CFSecurityISOCountryBuff buff = this.schema.getBackingStore().getTableISOCountry().readDerivedByNameIdx(this.schema.getAuthorization(), Name);
            if (buff != null) {
                obj = this.schema.getISOCountryTableObj().newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryISOCountry().newPKey());
                obj.setBuff(buff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.indexByNameIdx.put(key, null);
            }
        }
        return obj;
    }

    @Override
    public ICFSecurityISOCountryObj updateISOCountry(ICFSecurityISOCountryObj Obj) {
        ICFSecurityISOCountryObj obj = Obj;
        this.schema.getBackingStore().getTableISOCountry().updateISOCountry(this.schema.getAuthorization(), Obj.getISOCountryBuff());
        obj = Obj.realize();
        return obj;
    }

    @Override
    public void deleteISOCountry(ICFSecurityISOCountryObj Obj) {
        ICFSecurityISOCountryObj obj = Obj;
        this.schema.getBackingStore().getTableISOCountry().deleteISOCountry(this.schema.getAuthorization(), obj.getISOCountryBuff());
        obj.forget(true);
    }

    @Override
    public void deleteISOCountryByIdIdx(short ISOCountryId) {
        CFSecurityISOCountryPKey pkey = this.schema.getBackingStore().getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(ISOCountryId);
        ICFSecurityISOCountryObj obj = this.readISOCountry(pkey);
        if (obj != null) {
            ICFSecurityISOCountryEditObj editObj = obj.getEdit();
            boolean editStarted = editObj == null ? (editObj = obj.beginEdit()) != null : false;
            if (editObj != null) {
                editObj.delete();
                if (editStarted) {
                    editObj.endEdit();
                }
            }
            obj.forget(true);
        }
    }

    @Override
    public void deleteISOCountryByISOCodeIdx(String ISOCode) {
        if (this.indexByISOCodeIdx == null) {
            this.indexByISOCodeIdx = new HashMap<CFSecurityISOCountryByISOCodeIdxKey, ICFSecurityISOCountryObj>();
        }
        CFSecurityISOCountryByISOCodeIdxKey key = this.schema.getBackingStore().getFactoryISOCountry().newISOCodeIdxKey();
        key.setRequiredISOCode(ISOCode);
        ICFSecurityISOCountryObj obj = null;
        if (this.indexByISOCodeIdx.containsKey(key)) {
            obj = this.indexByISOCodeIdx.get(key);
            this.schema.getBackingStore().getTableISOCountry().deleteISOCountryByISOCodeIdx(this.schema.getAuthorization(), ISOCode);
            obj.forget(true);
        } else {
            this.schema.getBackingStore().getTableISOCountry().deleteISOCountryByISOCodeIdx(this.schema.getAuthorization(), ISOCode);
        }
    }

    @Override
    public void deleteISOCountryByNameIdx(String Name) {
        if (this.indexByNameIdx == null) {
            this.indexByNameIdx = new HashMap<CFSecurityISOCountryByNameIdxKey, ICFSecurityISOCountryObj>();
        }
        CFSecurityISOCountryByNameIdxKey key = this.schema.getBackingStore().getFactoryISOCountry().newNameIdxKey();
        key.setRequiredName(Name);
        ICFSecurityISOCountryObj obj = null;
        if (this.indexByNameIdx.containsKey(key)) {
            obj = this.indexByNameIdx.get(key);
            this.schema.getBackingStore().getTableISOCountry().deleteISOCountryByNameIdx(this.schema.getAuthorization(), Name);
            obj.forget(true);
        } else {
            this.schema.getBackingStore().getTableISOCountry().deleteISOCountryByNameIdx(this.schema.getAuthorization(), Name);
        }
    }
}

