/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj;

import java.util.Calendar;
import java.util.List;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryPKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryCurrencyObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryEditObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryLanguageObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityISOCountryTableObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySchemaObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecuritySecUserObj;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityTenantObj;

public class CFSecurityISOCountryObj
implements ICFSecurityISOCountryObj {
    public static final String CLASS_CODE = "ISOC";
    protected ICFSecuritySecUserObj createdBy = null;
    protected ICFSecuritySecUserObj updatedBy = null;
    protected boolean isNew;
    protected ICFSecurityISOCountryEditObj edit;
    protected ICFSecuritySchemaObj schema;
    protected CFSecurityISOCountryPKey pKey;
    protected CFSecurityISOCountryBuff buff;

    public CFSecurityISOCountryObj() {
        this.isNew = true;
    }

    public CFSecurityISOCountryObj(ICFSecuritySchemaObj argSchema) {
        this.schema = argSchema;
        this.isNew = true;
        this.edit = null;
    }

    @Override
    public String getClassCode() {
        return CLASS_CODE;
    }

    public String getGenDefName() {
        return "ISOCountry";
    }

    public ICFLibAnyObj getScope() {
        return null;
    }

    public ICFLibAnyObj getObjScope() {
        return null;
    }

    public String getObjName() {
        String objName = this.getRequiredISOCode();
        return objName;
    }

    public ICFLibAnyObj getObjQualifier(Class qualifyingClass) {
        CFSecurityISOCountryObj container;
        if (qualifyingClass != null) {
            for (container = this; !(container == null || container instanceof ICFSecurityClusterObj || container instanceof ICFSecurityTenantObj || qualifyingClass.isInstance(container)); container = container.getObjScope()) {
            }
        } else {
            while (container != null && !(container instanceof ICFSecurityClusterObj) && !(container instanceof ICFSecurityTenantObj)) {
                container = container.getObjScope();
            }
        }
        return container;
    }

    public ICFLibAnyObj getNamedObject(Class qualifyingClass, String objName) {
        ICFLibAnyObj topContainer = this.getObjQualifier(qualifyingClass);
        if (topContainer == null) {
            return null;
        }
        ICFLibAnyObj namedObject = topContainer.getNamedObject(objName);
        return namedObject;
    }

    public ICFLibAnyObj getNamedObject(String objName) {
        String remainingName;
        ICFLibAnyObj subObj = null;
        int nextDot = objName.indexOf(46);
        if (nextDot >= 0) {
            String nextName = objName.substring(0, nextDot);
            remainingName = objName.substring(nextDot + 1);
        } else {
            String nextName = objName;
            remainingName = null;
        }
        ICFLibAnyObj retObj = remainingName == null ? subObj : (subObj == null ? null : subObj.getNamedObject(remainingName));
        return retObj;
    }

    public String getObjQualifiedName() {
        Object qualName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            qualName = containerName + "." + (String)qualName;
            container = container.getObjScope();
        }
        return qualName;
    }

    public String getObjFullName() {
        Object fullName = this.getObjName();
        ICFLibAnyObj container = this.getObjScope();
        while (container != null) {
            if (container instanceof ICFSecurityClusterObj) {
                container = null;
                continue;
            }
            if (container instanceof ICFSecurityTenantObj) {
                container = null;
                continue;
            }
            String containerName = container.getObjName();
            fullName = containerName + "." + (String)fullName;
            container = container.getObjScope();
        }
        return fullName;
    }

    @Override
    public ICFSecurityISOCountryObj realize() {
        ICFSecurityISOCountryObj retobj = this.schema.getISOCountryTableObj().realizeISOCountry(this);
        return retobj;
    }

    @Override
    public void forget() {
        this.forget(false);
    }

    @Override
    public void forget(boolean forgetSubObjects) {
        this.schema.getISOCountryTableObj().forgetISOCountry(this, forgetSubObjects);
    }

    @Override
    public ICFSecurityISOCountryObj read() {
        ICFSecurityISOCountryObj retobj = this.schema.getISOCountryTableObj().readISOCountryByIdIdx(this.getPKey().getRequiredISOCountryId(), false);
        return retobj;
    }

    @Override
    public ICFSecurityISOCountryObj read(boolean forceRead) {
        ICFSecurityISOCountryObj retobj = this.schema.getISOCountryTableObj().readISOCountryByIdIdx(this.getPKey().getRequiredISOCountryId(), forceRead);
        return retobj;
    }

    @Override
    public ICFSecurityISOCountryTableObj getISOCountryTable() {
        return this.schema.getISOCountryTableObj();
    }

    @Override
    public ICFSecuritySchemaObj getSchema() {
        return this.schema;
    }

    public void setSchema(ICFSecuritySchemaObj value) {
        this.schema = value;
    }

    @Override
    public CFSecurityISOCountryBuff getBuff() {
        if (this.buff == null) {
            if (this.isNew) {
                this.buff = this.schema.getBackingStore().getFactoryISOCountry().newBuff();
            } else {
                this.buff = this.schema.getBackingStore().getTableISOCountry().readDerivedByIdIdx(this.schema.getAuthorization(), this.getPKey().getRequiredISOCountryId());
                if (this.buff != null) {
                    this.copyBuffToPKey();
                }
            }
        }
        return this.buff;
    }

    @Override
    public void setBuff(CFSecurityISOCountryBuff value) {
        if (value != null && !(value instanceof CFSecurityISOCountryBuff)) {
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "setBuff", "value", (Object)value, "CFSecurityISOCountryBuff");
        }
        this.buff = value;
        this.copyBuffToPKey();
    }

    @Override
    public CFSecurityISOCountryBuff getISOCountryBuff() {
        return this.getBuff();
    }

    @Override
    public CFSecurityISOCountryPKey getPKey() {
        if (this.pKey == null) {
            this.pKey = this.schema.getBackingStore().getFactoryISOCountry().newPKey();
        }
        return this.pKey;
    }

    @Override
    public void setPKey(CFSecurityISOCountryPKey value) {
        if (this.pKey != value) {
            this.pKey = value;
            this.copyPKeyToBuff();
        }
    }

    @Override
    public boolean getIsNew() {
        return this.isNew;
    }

    @Override
    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    @Override
    public ICFSecurityISOCountryEditObj beginEdit() {
        if (this.edit != null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "beginEdit", "An edit is already open");
        }
        ICFSecurityISOCountryObj lockobj = this.getIsNew() ? this : this.schema.getISOCountryTableObj().lockISOCountry(this.getPKey());
        this.edit = this.schema.getISOCountryTableObj().newEditInstance(lockobj);
        return this.edit;
    }

    @Override
    public void endEdit() {
        this.edit = null;
    }

    @Override
    public ICFSecurityISOCountryEditObj getEdit() {
        return this.edit;
    }

    @Override
    public ICFSecurityISOCountryEditObj getEditAsISOCountry() {
        return this.edit;
    }

    @Override
    public ICFSecuritySecUserObj getCreatedBy() {
        if (this.createdBy == null) {
            CFSecurityISOCountryBuff buff = this.getBuff();
            this.createdBy = this.getSchema().getSecUserTableObj().readSecUserByIdIdx(buff.getCreatedByUserId());
        }
        return this.createdBy;
    }

    @Override
    public Calendar getCreatedAt() {
        return this.getBuff().getCreatedAt();
    }

    @Override
    public ICFSecuritySecUserObj getUpdatedBy() {
        if (this.updatedBy == null) {
            CFSecurityISOCountryBuff buff = this.getBuff();
            this.updatedBy = this.getSchema().getSecUserTableObj().readSecUserByIdIdx(buff.getUpdatedByUserId());
        }
        return this.updatedBy;
    }

    @Override
    public Calendar getUpdatedAt() {
        return this.getBuff().getUpdatedAt();
    }

    @Override
    public short getRequiredISOCountryId() {
        return this.getPKey().getRequiredISOCountryId();
    }

    @Override
    public String getRequiredISOCode() {
        return this.getISOCountryBuff().getRequiredISOCode();
    }

    @Override
    public String getRequiredName() {
        return this.getISOCountryBuff().getRequiredName();
    }

    @Override
    public List<ICFSecurityISOCountryCurrencyObj> getOptionalComponentsCurrency() {
        List<ICFSecurityISOCountryCurrencyObj> retval = this.schema.getISOCountryCurrencyTableObj().readISOCountryCurrencyByCountryIdx(this.getPKey().getRequiredISOCountryId(), false);
        return retval;
    }

    @Override
    public List<ICFSecurityISOCountryCurrencyObj> getOptionalComponentsCurrency(boolean forceRead) {
        List<ICFSecurityISOCountryCurrencyObj> retval = this.schema.getISOCountryCurrencyTableObj().readISOCountryCurrencyByCountryIdx(this.getPKey().getRequiredISOCountryId(), forceRead);
        return retval;
    }

    @Override
    public List<ICFSecurityISOCountryLanguageObj> getOptionalComponentsLanguage() {
        List<ICFSecurityISOCountryLanguageObj> retval = this.schema.getISOCountryLanguageTableObj().readISOCountryLanguageByCountryIdx(this.getPKey().getRequiredISOCountryId(), false);
        return retval;
    }

    @Override
    public List<ICFSecurityISOCountryLanguageObj> getOptionalComponentsLanguage(boolean forceRead) {
        List<ICFSecurityISOCountryLanguageObj> retval = this.schema.getISOCountryLanguageTableObj().readISOCountryLanguageByCountryIdx(this.getPKey().getRequiredISOCountryId(), forceRead);
        return retval;
    }

    @Override
    public void copyPKeyToBuff() {
        if (this.buff != null) {
            this.buff.setRequiredISOCountryId(this.getPKey().getRequiredISOCountryId());
        }
        if (this.edit != null) {
            this.edit.copyPKeyToBuff();
        }
    }

    @Override
    public void copyBuffToPKey() {
        this.getPKey().setRequiredISOCountryId(this.buff.getRequiredISOCountryId());
    }
}

