/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity;

import java.util.LinkedList;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityConfigurationFile;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecuritySchema;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.ICFSecuritySchema;

public class CFSecuritySchemaPool {
    protected static volatile CFSecuritySchemaPool schemaPool = null;
    protected String jndiName = null;
    protected CFSecurityConfigurationFile configFile = null;
    protected LinkedList<ICFSecuritySchema> instances = new LinkedList();

    public static CFSecuritySchemaPool getSchemaPool() {
        return schemaPool;
    }

    public static void setSchemaPool(CFSecuritySchemaPool pool) {
        if (schemaPool == null) {
            schemaPool = pool;
        }
    }

    public CFSecurityConfigurationFile getConfigurationFile() {
        return this.configFile;
    }

    public void setConfigurationFile(CFSecurityConfigurationFile value) {
        this.configFile = value;
    }

    public synchronized ICFSecuritySchema getInstance() {
        ICFSecuritySchema retInst = null;
        if (this.instances != null) {
            if (this.instances.isEmpty()) {
                retInst = this.newInstance();
                retInst.setConfigurationFile(this.getConfigurationFile());
                retInst.setJndiName(this.getJndiName());
                retInst.connect();
            } else {
                retInst = this.instances.removeFirst();
            }
        } else {
            retInst = null;
        }
        return retInst;
    }

    public synchronized void releaseInstance(ICFSecuritySchema inst) {
        if (inst == null) {
            return;
        }
        inst.rollback();
        if (this.instances != null && !this.instances.contains(inst)) {
            this.instances.addFirst(inst);
        }
    }

    public ICFSecuritySchema newInstance() {
        CFSecuritySchema retInst = new CFSecuritySchema();
        return retInst;
    }

    public void disposeInstance(ICFSecuritySchema inst) {
        try {
            inst.disconnect(false);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.instances != null && !this.instances.contains(inst)) {
            this.instances.addFirst(inst);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String value) {
        this.jndiName = value;
        if (this.jndiName != null && this.jndiName.length() > 0) {
            this.configFile = null;
        }
    }
}

