/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFSecurityConfigurationFile {
    protected String fileName = null;
    protected Properties props = new Properties();
    protected int netServerPort = -1;
    protected String dbServerClassName = null;
    protected String dbServer = null;
    protected int dbPort = -1;
    protected String dbDatabase = null;
    protected String dbUserName = null;
    protected String dbPassword = null;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String value) {
        this.fileName = value;
    }

    public String get(String theKey) {
        return this.props.getProperty(theKey);
    }

    public void set(String theKey, String theValue) {
        this.set(theKey, theValue, false);
    }

    public void set(String theKey, String theValue, boolean doSave) {
        this.props.put(theKey, theValue);
        if (doSave) {
            this.save();
        }
    }

    public void load() {
        this.load(this.fileName);
    }

    public void load(String configFileName) {
        boolean doSave = false;
        try {
            FileReader reader = new FileReader(configFileName);
            this.props.load(reader);
            reader.close();
        }
        catch (FileNotFoundException e) {
            doSave = true;
        }
        catch (IOException e) {
            throw CFLib.getDefaultExceptionFactory().newRuntimeException(this.getClass(), "load", "IOException " + e.getMessage(), (Throwable)e);
        }
        if (doSave) {
            this.save();
        }
    }

    public void save() {
        try {
            FileWriter writer = new FileWriter(this.fileName);
            this.props.store(writer, "CFSecurityConfigurationFile");
            writer.close();
        }
        catch (IOException e) {
            throw CFLib.getDefaultExceptionFactory().newRuntimeException(this.getClass(), "save", "IOException " + e.getMessage(), (Throwable)e);
        }
    }

    public int getNetServerPort() {
        if (this.netServerPort < 0) {
            String strValue = this.get("NetServerPort");
            this.netServerPort = Integer.parseInt(strValue);
        }
        return this.netServerPort;
    }

    public void setNetServerPort(int value) {
        this.netServerPort = value;
        String strValue = Integer.toString(this.netServerPort);
        this.set("NetServerPort", strValue);
    }

    public String getDbServerClassName() {
        if (this.dbServerClassName == null) {
            this.dbServerClassName = this.get("DbServerClassName");
        }
        return this.dbServerClassName;
    }

    public void setDbServerClassName(String value) {
        this.dbServerClassName = value;
        this.set("DbServerClassName", this.dbServerClassName);
    }

    public String getDbServer() {
        if (this.dbServer == null) {
            this.dbServer = this.get("DbServer");
        }
        return this.dbServer;
    }

    public void setDbServer(String value) {
        this.dbServer = value;
        this.set("DbServer", this.dbServer);
    }

    public int getDbPort() {
        if (this.dbPort < 0) {
            String strValue = this.get("DbPort");
            this.dbPort = Integer.parseInt(strValue);
        }
        return this.dbPort;
    }

    public void setDbPort(int value) {
        this.dbPort = value;
        String strValue = Integer.toString(this.dbPort);
        this.set("DbPort", strValue);
    }

    public String getDbDatabase() {
        if (this.dbDatabase == null) {
            this.dbDatabase = this.get("DbDatabase");
        }
        return this.dbDatabase;
    }

    public void setDbDatabase(String value) {
        this.dbDatabase = value;
        this.set("DbDatabase", this.dbDatabase);
    }

    public String getDbUserName() {
        if (this.dbUserName == null) {
            this.dbUserName = this.get("DbUserName");
        }
        return this.dbUserName;
    }

    public void setDbUserName(String value) {
        this.dbUserName = value;
        this.set("DbUserName", this.dbUserName);
    }

    public String getDbPassword() {
        if (this.dbPassword == null) {
            this.dbPassword = this.get("DbPassword");
        }
        return this.dbPassword;
    }

    public void setDbPassword(String value) {
        this.dbPassword = value;
        this.set("DbPassword", this.dbPassword);
    }
}

