/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFSecurityClientConfigurationFile {
    protected String fileName = null;
    protected Properties props = new Properties();
    protected String keyStore = null;
    protected String deviceName = null;
    public final int maxServerURL = 20;
    public final int maxServerURLIndex = 19;
    public final String attrNamePrefix = "ServerURL";
    protected String[] arrServerURL = new String[0];

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String value) {
        this.fileName = value;
    }

    public String get(String theKey) {
        return this.props.getProperty(theKey);
    }

    public void set(String theKey, String theValue) {
        this.set(theKey, theValue, false);
    }

    public void set(String theKey, String theValue, boolean doSave) {
        this.props.put(theKey, theValue);
        if (doSave) {
            this.save();
        }
    }

    public void load() {
        this.load(this.fileName);
    }

    public void load(String configFileName) {
        boolean doSave = false;
        try {
            FileReader reader = new FileReader(configFileName);
            this.props.load(reader);
            reader.close();
            this.keyStore = null;
            this.deviceName = null;
            this.loadServerURLProperties();
        }
        catch (FileNotFoundException e) {
            doSave = true;
        }
        catch (IOException e) {
            throw CFLib.getDefaultExceptionFactory().newRuntimeException(this.getClass(), "load", "IOException " + e.getMessage(), (Throwable)e);
        }
        if (doSave) {
            this.save();
        }
    }

    public void save() {
        try {
            FileWriter writer = new FileWriter(this.fileName);
            this.props.store(writer, "CFSecurityClientConfigurationFile");
            writer.close();
        }
        catch (IOException e) {
            throw CFLib.getDefaultExceptionFactory().newRuntimeException(this.getClass(), "save", "IOException " + e.getMessage(), (Throwable)e);
        }
    }

    public String getKeyStore() {
        if (this.keyStore == null) {
            this.keyStore = this.get("KeyStore");
        }
        return this.keyStore;
    }

    public void setKeyStore(String value) {
        this.keyStore = value;
        this.set("KeyStore", this.keyStore);
    }

    public String getDeviceName() {
        if (this.deviceName == null) {
            this.deviceName = this.get("DeviceName");
        }
        return this.deviceName;
    }

    public void setDeviceName(String value) {
        this.deviceName = value;
        this.set("DeviceName", this.deviceName);
    }

    public String[] getServerURLArray() {
        return this.arrServerURL;
    }

    public void loadServerURLProperties() {
        String curURL;
        String attrName;
        int curIdx;
        int maxURL = 0;
        for (curIdx = 0; curIdx < 20; ++curIdx) {
            attrName = "ServerURL" + Integer.toString(curIdx);
            curURL = this.get(attrName);
            if (curURL == null || curURL.length() <= 0) continue;
            maxURL = curIdx + 1;
        }
        if (maxURL > 0) {
            String[] newServerURL = new String[maxURL];
            for (curIdx = 0; curIdx < maxURL; ++curIdx) {
                attrName = "ServerURL" + Integer.toString(curIdx);
                newServerURL[curIdx] = curURL = this.get(attrName);
            }
            this.arrServerURL = newServerURL;
        }
    }

    public String getLatestServerURL() {
        String[] curServerURL = this.arrServerURL;
        String latest = curServerURL.length > 0 ? curServerURL[0] : null;
        return latest;
    }

    public void setLatestServerURL(String value) {
        String curValue;
        String attrName;
        String[] newServerURL;
        int curIdx;
        String S_ProcName = "setLatestServerURL";
        if (value == null || value.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setLatestServerURL", 1, "value");
        }
        int foundServerURLAtIndex = -1;
        String[] curServerURLArray = this.arrServerURL;
        int numIdx = curServerURLArray.length;
        for (curIdx = 0; curIdx < numIdx; ++curIdx) {
            String curServerURL = curServerURLArray[curIdx];
            if (!value.equals(curServerURL)) continue;
            foundServerURLAtIndex = curIdx;
            curIdx = numIdx;
        }
        if (foundServerURLAtIndex == 0) {
            return;
        }
        if (foundServerURLAtIndex == -1) {
            newServerURL = new String[numIdx + 1];
            newServerURL[0] = value;
            for (curIdx = 0; curIdx < numIdx; ++curIdx) {
                newServerURL[curIdx + 1] = this.arrServerURL[curIdx];
            }
            this.arrServerURL = newServerURL;
            numIdx = newServerURL.length;
            for (curIdx = numIdx - 1; curIdx >= 0; --curIdx) {
                attrName = "ServerURL" + Integer.toString(curIdx);
                curValue = newServerURL[curIdx];
                this.set(attrName, curValue);
            }
            this.save();
        } else if (foundServerURLAtIndex < 20) {
            newServerURL = new String[numIdx];
            newServerURL[0] = value;
            for (curIdx = 0; curIdx < foundServerURLAtIndex; ++curIdx) {
                newServerURL[curIdx + 1] = curServerURLArray[curIdx];
            }
            ++curIdx;
            while (curIdx < numIdx) {
                newServerURL[curIdx + 1] = curServerURLArray[curIdx];
                ++curIdx;
            }
        } else {
            newServerURL = new String[20];
            newServerURL[0] = value;
            for (curIdx = 0; curIdx < 20; ++curIdx) {
                newServerURL[curIdx + 1] = curServerURLArray[curIdx];
            }
        }
        this.arrServerURL = newServerURL;
        numIdx = newServerURL.length;
        for (curIdx = 0; curIdx < numIdx; ++curIdx) {
            attrName = "ServerURL" + Integer.toString(curIdx);
            curValue = newServerURL[curIdx];
            this.set(attrName, curValue);
        }
        this.save();
    }
}

