/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamAtomObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamChainObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamId16GenObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamId32GenObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamId64GenObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamIndexObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamRelationObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTableColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTableObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamValueObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;

public class MSSBamCFTableObj {
    public static List<ICFBamId16GenObj> getId16Generators(ICFBamTableObj tableDef) {
        LinkedList<ICFBamId16GenObj> list = new LinkedList<ICFBamId16GenObj>();
        Iterator childrenColumns = tableDef.getOptionalComponentsColumns().iterator();
        while (childrenColumns.hasNext()) {
            ICFBamAtomObj atomDef = null;
            ICFLibAnyObj colDef = (ICFLibAnyObj)childrenColumns.next();
            if (colDef instanceof ICFBamTableColObj) {
                atomDef = (ICFBamAtomObj)((ICFBamTableColObj)colDef).getRequiredParentDataType();
            } else if (colDef instanceof ICFBamAtomObj) {
                atomDef = (ICFBamAtomObj)colDef;
            }
            if (atomDef == null || !(atomDef instanceof ICFBamId16GenObj)) continue;
            list.add((ICFBamId16GenObj)atomDef);
        }
        return list;
    }

    public static List<ICFBamId32GenObj> getId32Generators(ICFBamTableObj tableDef) {
        LinkedList<ICFBamId32GenObj> list = new LinkedList<ICFBamId32GenObj>();
        Iterator childrenColumns = tableDef.getOptionalComponentsColumns().iterator();
        while (childrenColumns.hasNext()) {
            ICFBamAtomObj atomDef = null;
            ICFLibAnyObj colDef = (ICFLibAnyObj)childrenColumns.next();
            if (colDef instanceof ICFBamTableColObj) {
                atomDef = (ICFBamAtomObj)((ICFBamTableColObj)colDef).getRequiredParentDataType();
            } else if (colDef instanceof ICFBamAtomObj) {
                atomDef = (ICFBamAtomObj)colDef;
            }
            if (atomDef == null || !(atomDef instanceof ICFBamId32GenObj)) continue;
            list.add((ICFBamId32GenObj)atomDef);
        }
        return list;
    }

    public static List<ICFBamId64GenObj> getId64Generators(ICFBamTableObj tableDef) {
        LinkedList<ICFBamId64GenObj> list = new LinkedList<ICFBamId64GenObj>();
        Iterator childrenColumns = tableDef.getOptionalComponentsColumns().iterator();
        while (childrenColumns.hasNext()) {
            ICFBamAtomObj atomDef = null;
            ICFLibAnyObj colDef = (ICFLibAnyObj)childrenColumns.next();
            if (colDef instanceof ICFBamTableColObj) {
                atomDef = (ICFBamAtomObj)((ICFBamTableColObj)colDef).getRequiredParentDataType();
            } else if (colDef instanceof ICFBamAtomObj) {
                atomDef = (ICFBamAtomObj)colDef;
            }
            if (atomDef == null || !(atomDef instanceof ICFBamId64GenObj)) continue;
            list.add((ICFBamId64GenObj)atomDef);
        }
        return list;
    }

    public static List<ICFBamId16GenObj> getDispensedId16Generators(ICFBamTableObj tableDef) {
        LinkedList<ICFBamId16GenObj> list = new LinkedList<ICFBamId16GenObj>();
        Iterator dispensed = tableDef.getSchema().getId16GenTableObj().readId16GenByDispIdx(Long.valueOf(tableDef.getRequiredTenantId()), Long.valueOf(tableDef.getRequiredId())).iterator();
        while (dispensed.hasNext()) {
            list.add((ICFBamId16GenObj)dispensed.next());
        }
        return list;
    }

    public static List<ICFBamId32GenObj> getDispensedId32Generators(ICFBamTableObj tableDef) {
        LinkedList<ICFBamId32GenObj> list = new LinkedList<ICFBamId32GenObj>();
        Iterator dispensed = tableDef.getSchema().getId32GenTableObj().readId32GenByDispIdx(Long.valueOf(tableDef.getRequiredTenantId()), Long.valueOf(tableDef.getRequiredId())).iterator();
        while (dispensed.hasNext()) {
            list.add((ICFBamId32GenObj)dispensed.next());
        }
        return list;
    }

    public static List<ICFBamId64GenObj> getDispensedId64Generators(ICFBamTableObj tableDef) {
        LinkedList<ICFBamId64GenObj> list = new LinkedList<ICFBamId64GenObj>();
        Iterator dispensed = tableDef.getSchema().getId64GenTableObj().readId64GenByDispIdx(Long.valueOf(tableDef.getRequiredTenantId()), Long.valueOf(tableDef.getRequiredId())).iterator();
        while (dispensed.hasNext()) {
            list.add((ICFBamId64GenObj)dispensed.next());
        }
        return list;
    }

    public static List<ICFBamRelationObj> getOnlyOwnerRelations(ICFBamTableObj tableDef) {
        ICFBamRelationObj relationDef2 = null;
        LinkedList<ICFBamRelationObj> list = new LinkedList<ICFBamRelationObj>();
        for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
            if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Owner) continue;
            list.add(relationDef2);
        }
        ICFBamRelationObj superClass = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        while (superClass != null) {
            tableDef = superClass.getRequiredLookupToTable();
            for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
                if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Owner) continue;
                list.add(relationDef2);
            }
            superClass = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        }
        for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
            if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Container) continue;
            list.add(relationDef2);
        }
        superClass = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        while (superClass != null) {
            tableDef = superClass.getRequiredLookupToTable();
            for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
                if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Container) continue;
                list.add(relationDef2);
            }
            superClass = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        }
        return list;
    }

    public static List<ICFBamRelationObj> getContainerOwnerRelations(ICFBamTableObj tableDef) {
        ICFBamRelationObj relationDef2 = null;
        Object relationTag = null;
        LinkedList<ICFBamRelationObj> list = new LinkedList<ICFBamRelationObj>();
        for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
            if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Owner && relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Master && relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Parent && relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Container) continue;
            list.add(relationDef2);
        }
        ICFBamRelationObj superClass = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        while (superClass != null) {
            tableDef = superClass.getRequiredLookupToTable();
            for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
                if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Owner && relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Master && relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Parent && relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Container) continue;
                list.add(relationDef2);
            }
            superClass = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        }
        return list;
    }

    public static ICFBamRelationObj getContainerRelation(ICFBamTableObj tableDef) {
        for (ICFBamRelationObj relationDef : tableDef.getOptionalComponentsRelation()) {
            if (relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Container) continue;
            return relationDef;
        }
        return null;
    }

    public static ICFBamRelationObj getInheritedContainerRelation(ICFBamTableObj tableDef) {
        Object inheritedContainerRelation = null;
        while (inheritedContainerRelation == null && tableDef != null) {
            ICFBamRelationObj relationDef2;
            for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
                if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Container) continue;
                return relationDef2;
            }
            relationDef2 = MSSBamCFTableObj.getSuperClassRelation(tableDef);
            if (relationDef2 == null) {
                tableDef = null;
                continue;
            }
            tableDef = relationDef2.getRequiredLookupToTable();
        }
        return null;
    }

    public static ICFBamRelationObj getOwnerRelation(ICFBamTableObj tableDef) {
        for (ICFBamRelationObj relationDef : tableDef.getOptionalComponentsRelation()) {
            if (relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Owner) continue;
            return relationDef;
        }
        return null;
    }

    public static ICFBamRelationObj getInheritedOwnerRelation(ICFBamTableObj tableDef) {
        Object inheritedOwnerRelation = null;
        while (inheritedOwnerRelation == null && tableDef != null) {
            ICFBamRelationObj relationDef2;
            for (ICFBamRelationObj relationDef2 : tableDef.getOptionalComponentsRelation()) {
                if (relationDef2.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Owner) continue;
                return relationDef2;
            }
            relationDef2 = MSSBamCFTableObj.getSuperClassRelation(tableDef);
            if (relationDef2 == null) {
                tableDef = null;
                continue;
            }
            tableDef = relationDef2.getRequiredLookupToTable();
        }
        return null;
    }

    public static List<ICFBamRelationObj> getOwnerLookupRelations(ICFBamTableObj tableDef) {
        LinkedList<ICFBamRelationObj> list = new LinkedList<ICFBamRelationObj>();
        for (ICFBamRelationObj relationDef : tableDef.getOptionalComponentsRelation()) {
            if (relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Parent && relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Master && relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Container && relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Lookup && relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Owner) continue;
            list.add(relationDef);
        }
        return list;
    }

    public static List<ICFBamRelationObj> getOwnerContainerNamedLookupChainRelations(ICFBamTableObj tableDef) {
        LinkedList<ICFBamRelationObj> list = new LinkedList<ICFBamRelationObj>();
        List componentChains = tableDef.getOptionalComponentsChains();
        for (ICFBamRelationObj relationDef : tableDef.getOptionalComponentsRelation()) {
            ICFBamIndexObj toIndex;
            if (relationDef.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Superclass) continue;
            if (relationDef.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Container || relationDef.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Owner || relationDef.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Container || relationDef.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Parent || relationDef.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Lookup) {
                list.add(relationDef);
                continue;
            }
            if (relationDef.getRequiredIsXsdContainer() || !(toIndex = relationDef.getRequiredLookupToIndex()).getRequiredIsUnique()) continue;
            boolean referencedByChain = false;
            Iterator iterChain = componentChains.iterator();
            while (!referencedByChain && iterChain.hasNext()) {
                ICFBamChainObj chain = (ICFBamChainObj)iterChain.next();
                if (chain.getRequiredLookupPrevRel() == relationDef) {
                    referencedByChain = true;
                    continue;
                }
                if (chain.getRequiredLookupNextRel() != relationDef) continue;
                referencedByChain = true;
            }
            if (referencedByChain) {
                list.add(relationDef);
                continue;
            }
            ICFBamTableObj toTable = relationDef.getRequiredLookupToTable();
            ICFBamIndexObj lookupIndex = toTable.getOptionalLookupLookupIndex();
            while (lookupIndex == null && toTable != null) {
                ICFBamRelationObj superRelation = MSSBamCFTableObj.getSuperClassRelation(toTable);
                if (superRelation != null) {
                    toTable = superRelation.getRequiredLookupToTable();
                    if (toTable == null) continue;
                    lookupIndex = toTable.getOptionalLookupLookupIndex();
                    continue;
                }
                toTable = null;
            }
            if (lookupIndex == null) continue;
            list.add(relationDef);
        }
        return list;
    }

    public static List<ICFBamAtomObj> getChildrenAtoms(ICFBamTableObj tableDef) {
        LinkedList<ICFBamAtomObj> list = new LinkedList<ICFBamAtomObj>();
        for (ICFBamValueObj colDef : tableDef.getOptionalComponentsColumns()) {
            if (!(colDef instanceof ICFBamAtomObj)) continue;
            list.add((ICFBamAtomObj)colDef);
        }
        return list;
    }

    public static ICFBamRelationObj getSuperClassRelation(ICFBamTableObj tableDef) {
        for (ICFBamRelationObj relationDef : tableDef.getOptionalComponentsRelation()) {
            if (relationDef.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
            return relationDef;
        }
        return null;
    }

    public static List<ICFBamRelationObj> getSubClassRelations(ICFBamTableObj tableDef) {
        LinkedList<ICFBamRelationObj> list = new LinkedList<ICFBamRelationObj>();
        for (ICFBamRelationObj reverseRelation : tableDef.getOptionalChildrenReverseRelations()) {
            if (reverseRelation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
            list.add(reverseRelation);
        }
        return list;
    }

    public static ICFBamIndexObj getPrimaryKeyIndex(ICFBamTableObj tableDef) {
        ICFBamIndexObj primaryIndex = tableDef.getOptionalLookupPrimaryIndex();
        return primaryIndex;
    }

    public static List<ICFBamRelationObj> getFactoryOwnerRelations(ICFBamTableObj tableDef) {
        LinkedList<ICFBamRelationObj> list = new LinkedList<ICFBamRelationObj>();
        for (ICFBamRelationObj ownerRelation : MSSBamCFTableObj.getContainerOwnerRelations(tableDef)) {
            if (ownerRelation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
            list.add(ownerRelation);
        }
        return list;
    }

    public static List<ICFBamIndexObj> getInheritedIndexes(ICFBamTableObj tableDef) {
        LinkedList<ICFBamIndexObj> list = new LinkedList<ICFBamIndexObj>();
        ICFBamRelationObj superClassRelation = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        if (superClassRelation != null) {
            Iterator<ICFBamIndexObj> superClassInheritedIndexes = MSSBamCFTableObj.getInheritedIndexes(superClassRelation.getRequiredLookupToTable()).iterator();
            while (superClassInheritedIndexes.hasNext()) {
                list.add(superClassInheritedIndexes.next());
            }
            Iterator<ICFBamIndexObj> myIndexes = MSSBamCFTableObj.getChildrenIndexes(tableDef).iterator();
            while (myIndexes.hasNext()) {
                list.add(myIndexes.next());
            }
        }
        return list;
    }

    public static List<ICFBamIndexObj> getChildrenIndexes(ICFBamTableObj tableDef) {
        Iterator iter = tableDef.getOptionalComponentsIndex().iterator();
        LinkedList<ICFBamIndexObj> list = new LinkedList<ICFBamIndexObj>();
        while (iter.hasNext()) {
            list.add((ICFBamIndexObj)iter.next());
        }
        return list;
    }

    public static List<ICFBamRelationObj> getInheritedRelations(ICFBamTableObj tableDef) {
        LinkedList<ICFBamRelationObj> list = new LinkedList<ICFBamRelationObj>();
        ICFBamRelationObj superClassRelation = MSSBamCFTableObj.getSuperClassRelation(tableDef);
        if (superClassRelation != null) {
            Iterator<ICFBamRelationObj> superClassInheritedRelations = MSSBamCFTableObj.getInheritedRelations(superClassRelation.getRequiredLookupToTable()).iterator();
            while (superClassInheritedRelations.hasNext()) {
                list.add(superClassInheritedRelations.next());
            }
            Iterator<ICFBamRelationObj> myRelations = MSSBamCFTableObj.getChildrenRelations(tableDef).iterator();
            while (myRelations.hasNext()) {
                list.add(myRelations.next());
            }
        }
        return list;
    }

    public static List<ICFBamRelationObj> getChildrenRelations(ICFBamTableObj tableDef) {
        LinkedList<ICFBamRelationObj> childrenRelations = new LinkedList<ICFBamRelationObj>();
        List cltn = tableDef.getOptionalComponentsRelation();
        Iterator iter = cltn.iterator();
        while (iter.hasNext()) {
            childrenRelations.add((ICFBamRelationObj)iter.next());
        }
        return childrenRelations;
    }

    public static List<ICFBamValueObj> getTableIdGenerators(ICFBamTableObj tableDef) {
        LinkedList<ICFBamValueObj> list = new LinkedList<ICFBamValueObj>();
        Iterator<ICFBamId16GenObj> id16Generators = MSSBamCFTableObj.getId16Generators(tableDef).iterator();
        while (id16Generators.hasNext()) {
            list.add((ICFBamValueObj)id16Generators.next());
        }
        Iterator<ICFBamId32GenObj> id32Generators = MSSBamCFTableObj.getId32Generators(tableDef).iterator();
        while (id32Generators.hasNext()) {
            list.add((ICFBamValueObj)id32Generators.next());
        }
        Iterator<ICFBamId64GenObj> id64Generators = MSSBamCFTableObj.getId64Generators(tableDef).iterator();
        while (id64Generators.hasNext()) {
            list.add((ICFBamValueObj)id64Generators.next());
        }
        return list;
    }
}

