/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF.MSSBamCFPathDirInfo;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;

public class MSSBamCFPrefs {
    protected String UserName = null;
    protected String HomeDirName = null;
    protected File HomeDir = null;
    public static final String FILENAME_MSSCFRC = ".msscfrc";
    protected String UPrefFileName = null;
    protected Properties UPref = null;
    protected File UPrefFile = null;
    public static final String PROPNAME_ROOTGENDIR = "msscf.rootgendir";
    protected String RootGenDir = null;
    protected ArrayList<String> ModelPath = new ArrayList();
    public static final String PROPNAME_MODELDIR = "msscf.modeldir";
    protected ArrayList<String> CartridgePath = new ArrayList();
    public static final String PROPNAME_CARTRIDGEDIR = "msscf.cartridgedir";
    public static final String PACKAGE_JAR = "jar";

    protected Properties getProperties() {
        return this.UPref;
    }

    private synchronized void s_resolveUserName(ICFLibMessageLog log) {
        if (this.UserName != null) {
            return;
        }
        this.UserName = System.getProperty("user.name");
        if (this.UserName == null && log != null) {
            log.message("User name not set");
        }
    }

    public String getUserName(ICFLibMessageLog log) {
        if (this.UserName == null) {
            this.s_resolveUserName(log);
        }
        return this.UserName;
    }

    private synchronized void s_resolveHomeDirName(ICFLibMessageLog log) {
        if (this.HomeDirName != null) {
            return;
        }
        this.HomeDirName = System.getProperty("HOME");
        if (this.HomeDirName == null) {
            this.HomeDirName = System.getProperty("user.home");
            if (this.HomeDirName == null && log != null) {
                log.message("Home directory not set");
            }
        }
    }

    public String getHomeDirName(ICFLibMessageLog log) {
        if (this.HomeDirName == null) {
            this.s_resolveHomeDirName(log);
        }
        return this.HomeDirName;
    }

    private synchronized void s_resolveHomeDir(ICFLibMessageLog log) {
        if (this.HomeDir != null) {
            return;
        }
        this.getHomeDirName(log);
        if (this.HomeDirName == null) {
            return;
        }
        this.HomeDir = new File(this.HomeDirName);
        if (!this.HomeDir.exists()) {
            if (log != null) {
                log.message("Home directory " + this.HomeDir.getPath() + " does not exist");
            }
            return;
        }
        this.HomeDirName = new String(this.HomeDir.getPath());
        if (!this.HomeDir.isDirectory()) {
            if (log != null) {
                log.message("Home directory " + this.HomeDirName + " is not a directory");
            }
            return;
        }
    }

    public File getHomeDir(ICFLibMessageLog log) {
        if (this.HomeDir == null) {
            this.s_resolveHomeDir(log);
        }
        return this.HomeDir;
    }

    public String getRootGenDir() {
        if (this.RootGenDir == null) {
            this.RootGenDir = this.UPref.getProperty(PROPNAME_ROOTGENDIR);
        }
        return this.RootGenDir;
    }

    public void setRootGenDir(String value) {
        String S_ProcName = "MSSBamCFPrefs.setRootGenDir() ";
        if (value == null || value.length() == 0) {
            throw new RuntimeException("MSSBamCFPrefs.setRootGenDir() Argument 1 value is null or empty");
        }
        this.RootGenDir = new String(value);
        this.UPref.put(PROPNAME_ROOTGENDIR, this.RootGenDir);
    }

    public void addModelPath(String dirname) {
        String S_ProcName = "MSSBamCFPrefs.addModelPath() ";
        if (dirname == null || dirname.length() == 0) {
            throw new RuntimeException("MSSBamCFPrefs.addModelPath() dirname is null or empty");
        }
        MSSBamCFPathDirInfo pathdir = new MSSBamCFPathDirInfo(dirname, null);
        this.ModelPath.add(pathdir.getPathName());
        int seq = this.ModelPath.size() - 1;
        if (seq > 0) {
            String propName = new String(PROPNAME_MODELDIR + Integer.toString(seq));
            this.UPref.put(propName, pathdir.getPathName());
        } else {
            String propName = new String(PROPNAME_MODELDIR);
            this.UPref.put(propName, pathdir.getPathName());
        }
    }

    public Iterator<String> getModelPathIterator() {
        int len = this.ModelPath.size();
        ArrayList<String> list = len > 0 ? new ArrayList<String>(len) : new ArrayList();
        for (int idx = 0; idx < len; ++idx) {
            String pathdir = this.ModelPath.get(idx);
            list.add(pathdir);
        }
        return list.iterator();
    }

    public void addCartridgePath(String dirname) {
        String S_ProcName = "MSSBamCFPrefs.addCartridgePath() ";
        if (dirname == null || dirname.length() == 0) {
            throw new RuntimeException("MSSBamCFPrefs.addCartridgePath() Argument 1 dirname is null or empty");
        }
        String pathname = new String(dirname);
        this.CartridgePath.add(pathname);
        int seq = this.CartridgePath.size() - 1;
        if (seq > 0) {
            String propName = new String(PROPNAME_CARTRIDGEDIR + Integer.toString(seq));
            this.UPref.put(propName, pathname);
        } else {
            String propName = new String(PROPNAME_CARTRIDGEDIR);
            this.UPref.put(propName, pathname);
        }
    }

    public Iterator<String> getCartridgePathIterator() {
        Iterator<String> iter = this.CartridgePath.iterator();
        return iter;
    }

    public synchronized void reset(ICFLibMessageLog log) {
        String userName = this.getUserName(log);
        File homeDir = this.getHomeDir(log);
        if (homeDir == null || userName == null || userName.length() == 0) {
            this.RootGenDir = null;
            this.ModelPath.clear();
            this.CartridgePath.clear();
            return;
        }
        String msisaDir = new String(homeDir.getPath() + File.separator + "msscodefactory" + File.separator);
        this.setRootGenDir(msisaDir);
        this.addModelPath(msisaDir + "/net-sourceforge-MSSCodeFactory-2-9/java/model-2.9");
        this.addCartridgePath(msisaDir + "/net-sourceforge-MSSCodeFactory-Cartridge-2-9/anycartridge-2.9");
        this.addCartridgePath(msisaDir + "/net-sourceforge-MSSCodeFactory-Cartridge-2-9/dbcartridge-2.9");
        this.addCartridgePath(msisaDir + "/net-sourceforge-MSSCodeFactory-Cartridge-2-9/javacartridge-2.9");
        this.addCartridgePath(msisaDir + "/net-sourceforge-MSSCodeFactory-Cartridge-2-9/cpluscartridge-2.9");
    }

    protected void parseProperties(ICFLibMessageLog log, boolean reload) {
        String propName;
        String pathDir;
        int i;
        this.ModelPath.clear();
        this.CartridgePath.clear();
        String prop = this.UPref.getProperty(PROPNAME_ROOTGENDIR);
        if (prop != null) {
            this.RootGenDir = new String(prop);
        }
        for (i = 0; i >= 0 && (pathDir = this.UPref.getProperty(propName = i > 0 ? new String(PROPNAME_MODELDIR + Integer.toString(i)) : PROPNAME_MODELDIR)) != null && pathDir.length() > 0; ++i) {
            this.ModelPath.add(new String(pathDir));
        }
        for (i = 0; i >= 0 && (pathDir = this.UPref.getProperty(propName = i > 0 ? new String(PROPNAME_CARTRIDGEDIR + Integer.toString(i)) : PROPNAME_CARTRIDGEDIR)) != null && pathDir.length() > 0; ++i) {
            this.CartridgePath.add(new String(pathDir));
        }
    }

    public boolean savePreferences(ICFLibMessageLog log) {
        String S_ProcName = "MSSBamCFPrefs.savePreferences() ";
        boolean retStatus = false;
        if (this.UPrefFile == null) {
            this.UPrefFile = new File(this.UPrefFileName);
        }
        if (this.UPrefFile.exists()) {
            if (!this.UPrefFile.isFile()) {
                this.UPrefFile = null;
                log.message(this.UPrefFile.getPath() + "is not a file.");
                return false;
            }
            if (!this.UPrefFile.canRead()) {
                this.UPrefFile = null;
                log.message("User preferences file " + this.UPrefFileName + " is not readable");
                return false;
            }
            if (!this.UPrefFile.canWrite()) {
                this.UPrefFile = null;
                log.message("User preferences file " + this.UPrefFileName + " is not writable");
                return false;
            }
        }
        FileOutputStream fileWriter = null;
        try {
            fileWriter = new FileOutputStream(this.UPrefFileName);
            if (fileWriter == null) {
                this.UPrefFile = null;
                log.message("Could not write user preferences file " + this.UPrefFileName);
                return false;
            }
        }
        catch (IOException e) {
            this.UPrefFile = null;
            throw new RuntimeException("MSSBamCFPrefs.savePreferences() Could not write user preferences file " + this.UPrefFileName + ": " + e.getMessage());
        }
        try {
            this.UPref.store(fileWriter, "MSSBamCF Preferences for " + this.getUserName(null));
            fileWriter.flush();
            fileWriter.close();
            retStatus = true;
            log.message("Saved user preferences file " + this.UPrefFileName);
        }
        catch (IOException e) {
            this.UPrefFile = null;
            log.message("Error creating default user preferences file: " + e.getMessage());
        }
        return retStatus;
    }

    public boolean loadPreferences(ICFLibMessageLog log, boolean reload) {
        String S_ProcName = "MSSBamCFPrefs.loadPreferences() ";
        if (this.UPref != null && !reload) {
            return true;
        }
        this.ModelPath.clear();
        this.UPref = new Properties();
        log.message("Loading user preferences...");
        log.indent();
        File homeDir = this.getHomeDir(log);
        if (homeDir == null) {
            log.dedent();
            return false;
        }
        if (this.UPrefFileName == null || reload) {
            this.UPrefFileName = new String(homeDir.getPath() + File.separator + FILENAME_MSSCFRC);
            this.UPrefFile = new File(this.UPrefFileName);
            this.reset(log);
        }
        if (!this.UPrefFile.exists()) {
            return this.savePreferences(log);
        }
        if (!this.UPrefFile.isFile()) {
            this.UPrefFile = null;
            log.message(this.UPrefFile.getPath() + "is not a file.");
            log.dedent();
            return false;
        }
        if (!this.UPrefFile.canRead()) {
            this.UPrefFile = null;
            log.message("Permission denied attempting to read file " + this.UPrefFileName);
            log.dedent();
            return false;
        }
        FileInputStream fileReader = null;
        try {
            fileReader = new FileInputStream(this.UPrefFileName);
            if (fileReader == null) {
                this.UPrefFile = null;
                log.message("Could not load user preferences file " + this.UPrefFileName);
                log.dedent();
                return false;
            }
        }
        catch (IOException e) {
            this.UPrefFile = null;
            throw new RuntimeException("MSSBamCFPrefs.loadPreferences() Could not read user preferences file " + this.UPrefFileName + ": " + e.getMessage());
        }
        try {
            log.message("Loading user preferences from " + this.UPrefFileName);
            this.UPref.load(fileReader);
        }
        catch (IOException e) {
            this.UPrefFile = null;
            log.message("Error reading preferences file " + this.UPrefFileName + ": " + e.getMessage());
        }
        try {
            fileReader.close();
        }
        catch (IOException e) {
            this.UPrefFile = null;
        }
        this.parseProperties(log, reload);
        log.dedent();
        return true;
    }
}

