/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamBlobColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamBlobTypeObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamBoolColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamChainObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamDateColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamDoubleColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamFloatColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamId16GenObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamId32GenObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamId64GenObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamIndexColEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamIndexColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamIndexObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamInt16ColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamInt32ColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamInt64ColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamNmTokenColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamNmTokensColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamNumberColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamRelationColEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamRelationColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamRelationObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamSchemaDefObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamScopeObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamStringColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTZDateColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTZTimeColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTZTimestampColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTableColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTableObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTextColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTimeColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTimestampColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTokenColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamUInt16ColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamUInt32ColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamUInt64ColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamUuidColObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamUuidGenObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamValueEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamValueObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class MSSBamCFModelValidator {
    protected boolean modelIsValid = true;
    protected StringBuffer log = new StringBuffer();

    public String getValidationResults() {
        return this.log.toString();
    }

    public boolean validateSchemaDef(ICFBamSchemaDefObj schema) {
        this.modelIsValid = true;
        this.log = new StringBuffer();
        this.log.append("Validating SchemaDef \"" + schema.getObjFullName() + "\"...\n");
        this.propagateNameChanges(schema);
        this.validateSlices(schema);
        this.validateClassCodes(schema);
        this.validateDbNamesNotOverloaded(schema);
        this.validateColumnNamesNotOverloaded(schema);
        this.validateColumnShortNamesNotOverloaded(schema);
        this.validateColumnDbNamesNotOverloaded(schema);
        this.validateTablesHavePrimaryIndexes(schema);
        this.validateIndexesHaveColumns(schema);
        this.validatePrimaryIndexesAreUnique(schema);
        this.validatePrimaryIndexColumnsAreRequired(schema);
        this.validateIndexNamesNotOverloaded(schema);
        this.validateIndexSuffixesNotOverloaded(schema);
        this.validateIndexShortNamesNotOverloaded(schema);
        this.validateRelationsHaveLinkages(schema);
        this.validateRelationNamesNotOverloaded(schema);
        this.validateRelationSuffixesNotOverloaded(schema);
        this.validateOnlyOneSuperclassPerTable(schema);
        this.validateRelationsHaveColumns(schema);
        this.validateRelationColumnCountsMatchIndexes(schema);
        this.validateRelationsSpecifyAllFromColumns(schema);
        this.validateRelationsSpecifyAllToColumns(schema);
        this.validateChains(schema);
        if (this.modelIsValid) {
            this.log.append("SchemaDef \"" + schema.getObjFullName() + "\" is valid.\n");
        } else {
            this.log.append("SchemaDef \"" + schema.getObjFullName() + "\" is not valid.\n");
        }
        return this.modelIsValid;
    }

    public void propagateNameChanges(ICFBamSchemaDefObj schema) {
        this.propagateTypesAreNotNull(schema);
        this.propagateTableColumnNameChanges(schema);
        this.propagateIndexColumnNameChanges(schema);
    }

    protected void validateDbNamesNotOverloaded(ICFBamSchemaDefObj schema) {
        ICFBamScopeObj dup;
        String name;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            name = table.getOptionalDbName();
            if (name == null || name.length() <= 0) {
                name = table.getObjName();
            }
            if (map.containsKey(name)) {
                dup = (ICFBamScopeObj)map.get(name);
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" database name \"" + name + "\" collides with that of the " + dup.getGenDefName() + " \"" + dup.getObjQualifiedName() + "\"\n");
                valid = false;
                continue;
            }
            map.put(name, table);
        }
        for (ICFBamTableObj table : schema.getOptionalComponentsTables()) {
            for (ICFBamIndexObj index : table.getOptionalComponentsIndex()) {
                name = index.getOptionalDbName();
                if (name == null || name.length() <= 0) {
                    name = index.getObjName();
                }
                if (map.containsKey(name)) {
                    dup = (ICFBamScopeObj)map.get(name);
                    this.log.append("ERROR: Index \"" + index.getObjQualifiedName() + "\" database name \"" + name + "\" collides with that of the " + dup.getGenDefName() + " \"" + dup.getObjQualifiedName() + "\"\n");
                    valid = false;
                    continue;
                }
                map.put(name, index);
            }
        }
        for (ICFBamTableObj table : schema.getOptionalComponentsTables()) {
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                name = relation.getOptionalDbName();
                if (name == null || name.length() <= 0) {
                    name = relation.getObjName();
                }
                if (map.containsKey(name)) {
                    dup = (ICFBamScopeObj)map.get(name);
                    this.log.append("ERROR: Relation \"" + relation.getObjQualifiedName() + "\" database name \"" + name + "\" collides with that of the " + dup.getGenDefName() + " \"" + dup.getObjQualifiedName() + "\"\n");
                    valid = false;
                    continue;
                }
                map.put(name, relation);
            }
        }
        if (valid) {
            this.log.append("Schema database names are unique\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateSlices(ICFBamSchemaDefObj schema) {
        HashMap<Short, ICFBamValueObj> map = new HashMap<Short, ICFBamValueObj>();
        boolean valid = true;
        for (ICFBamValueObj type : schema.getOptionalComponentsTypes()) {
            Short slice;
            if (type instanceof ICFBamId16GenObj) {
                ICFBamId16GenObj id16gen = (ICFBamId16GenObj)type;
                slice = id16gen.getRequiredSlice();
            } else if (type instanceof ICFBamId32GenObj) {
                ICFBamId32GenObj id32gen = (ICFBamId32GenObj)type;
                slice = id32gen.getRequiredSlice();
            } else if (type instanceof ICFBamId64GenObj) {
                ICFBamId64GenObj id64gen = (ICFBamId64GenObj)type;
                slice = id64gen.getRequiredSlice();
            } else if (type instanceof ICFBamUuidGenObj) {
                ICFBamUuidGenObj uuidgen = (ICFBamUuidGenObj)type;
                slice = uuidgen.getRequiredSlice();
            } else {
                slice = null;
            }
            if (slice == null) continue;
            if (map.containsKey(slice)) {
                ICFBamValueObj dup = (ICFBamValueObj)map.get(slice);
                this.log.append("ERROR: " + type.getGenDefName() + " \"" + type.getObjName() + "\" slice " + slice + " is already in use by the " + dup.getGenDefName() + " \"" + dup.getObjName() + "\"\n");
                valid = false;
                continue;
            }
            map.put(slice, type);
        }
        if (valid) {
            this.log.append("Id generator slices are valid\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateClassCodes(ICFBamSchemaDefObj schema) {
        HashMap<String, ICFBamTableObj> map = new HashMap<String, ICFBamTableObj>();
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            if (map.containsKey(table.getRequiredTableClassCode())) {
                ICFBamTableObj dup = (ICFBamTableObj)map.get(table.getRequiredTableClassCode());
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" class code \"" + table.getRequiredTableClassCode() + "\" is already in use by the table \"" + dup.getObjName() + "\"\n");
                valid = false;
                continue;
            }
            map.put(table.getRequiredTableClassCode(), table);
        }
        if (valid) {
            this.log.append("Table class codes are valid\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateTablesHavePrimaryIndexes(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            if (table.getOptionalLookupPrimaryIndex() != null) continue;
            this.log.append("ERROR: Table \"" + table.getObjName() + "\" has no primary index\n");
            valid = false;
        }
        if (valid) {
            this.log.append("All tables have primary indexes\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validatePrimaryIndexesAreUnique(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            ICFBamIndexObj index = table.getOptionalLookupPrimaryIndex();
            if (index == null || index.getRequiredIsUnique()) continue;
            this.log.append("ERROR: Table \"" + table.getObjName() + "\" primary index \"" + index.getObjName() + "\" is not unique\n");
            valid = false;
        }
        if (valid) {
            this.log.append("Primary indexes are unique\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateIndexesHaveColumns(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            for (ICFBamIndexObj index : table.getOptionalComponentsIndex()) {
                Iterator colIter = index.getOptionalComponentsColumns().iterator();
                if (colIter.hasNext()) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" index \"" + index.getObjName() + "\" does not specify any columns\n");
                valid = false;
            }
        }
        if (valid) {
            this.log.append("Indexes all specify columns\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validatePrimaryIndexColumnsAreRequired(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            ICFBamIndexObj index = table.getOptionalLookupPrimaryIndex();
            if (index == null) continue;
            for (ICFBamIndexColObj col : index.getOptionalComponentsColumns()) {
                ICFBamValueObj tableCol = col.getRequiredLookupColumn();
                if (!tableCol.getRequiredIsNullable()) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" primary index \"" + index.getObjName() + "\" column \"" + tableCol.getObjName() + "\" is nullable\n");
                valid = false;
            }
        }
        if (valid) {
            this.log.append("Primary index columns are all required/not-null\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateIndexNamesNotOverloaded(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamIndexObj> map = new HashMap<String, ICFBamIndexObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamIndexObj index : worktable.getOptionalComponentsIndex()) {
                    if (map.containsKey(index.getObjName())) {
                        ICFBamIndexObj dup = (ICFBamIndexObj)map.get(index.getObjName());
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" index \"" + index.getObjName() + "\" overloads the name of the index \"" + dup.getRequiredContainerTable().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(index.getObjName(), index);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload index names\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateIndexShortNamesNotOverloaded(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamIndexObj> map = new HashMap<String, ICFBamIndexObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamIndexObj index : worktable.getOptionalComponentsIndex()) {
                    String shortName = index.getOptionalShortName();
                    if (shortName == null || shortName.length() <= 0) {
                        shortName = index.getObjName();
                    }
                    if (worktable.getOptionalLookupPrimaryIndex() == index) continue;
                    if (map.containsKey(shortName)) {
                        ICFBamIndexObj dup = (ICFBamIndexObj)map.get(shortName);
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" index \"" + index.getObjName() + "\" overloads the short name \"" + shortName + "\" of the index \"" + dup.getRequiredContainerTable().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(shortName, index);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload index short names\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateIndexSuffixesNotOverloaded(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamIndexObj> map = new HashMap<String, ICFBamIndexObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamIndexObj index : worktable.getOptionalComponentsIndex()) {
                    if (worktable.getOptionalLookupPrimaryIndex() == index) continue;
                    String suffix = index.getOptionalSuffix();
                    if (suffix == null || suffix.length() <= 0) {
                        suffix = index.getObjName();
                    }
                    if (map.containsKey(suffix)) {
                        ICFBamIndexObj dup = (ICFBamIndexObj)map.get(suffix);
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" index \"" + index.getObjName() + "\" overloads the suffix \"" + suffix + "\" of the index \"" + dup.getRequiredContainerTable().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(suffix, index);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload index short names\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateColumnNamesNotOverloaded(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamValueObj> map = new HashMap<String, ICFBamValueObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamValueObj col : worktable.getOptionalComponentsColumns()) {
                    Iterator indexColIter = worktable.getOptionalLookupPrimaryIndex().getOptionalComponentsColumns().iterator();
                    boolean notInPrimaryIndex = true;
                    while (notInPrimaryIndex && indexColIter.hasNext()) {
                        if (col != ((ICFBamIndexColObj)indexColIter.next()).getRequiredLookupColumn()) continue;
                        notInPrimaryIndex = false;
                    }
                    if (!notInPrimaryIndex) continue;
                    if (map.containsKey(col.getObjName())) {
                        ICFBamValueObj dup = (ICFBamValueObj)map.get(col.getObjName());
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" column \"" + col.getObjName() + "\" overloads the one defined by \"" + dup.getRequiredContainerScope().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(col.getObjName(), col);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload column names\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateColumnShortNamesNotOverloaded(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamValueObj> map = new HashMap<String, ICFBamValueObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamValueObj col : worktable.getOptionalComponentsColumns()) {
                    String colShortName = col.getOptionalShortName();
                    if (colShortName == null || colShortName.length() <= 0) {
                        colShortName = col.getObjName();
                    }
                    Iterator indexColIter = worktable.getOptionalLookupPrimaryIndex().getOptionalComponentsColumns().iterator();
                    boolean notInPrimaryIndex = true;
                    while (notInPrimaryIndex && indexColIter.hasNext()) {
                        if (col != ((ICFBamIndexColObj)indexColIter.next()).getRequiredLookupColumn()) continue;
                        notInPrimaryIndex = false;
                    }
                    if (!notInPrimaryIndex) continue;
                    if (map.containsKey(colShortName)) {
                        ICFBamValueObj dup = (ICFBamValueObj)map.get(colShortName);
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" column \"" + col.getObjName() + "\" overloads the short name \"" + colShortName + "\" defined by \"" + dup.getRequiredContainerScope().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(colShortName, col);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload column short names\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateColumnDbNamesNotOverloaded(ICFBamSchemaDefObj schema) {
        String S_ProcName = "validateColumnDbNamesNotOverloaded";
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamValueObj> map = new HashMap<String, ICFBamValueObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamValueObj col : worktable.getOptionalComponentsColumns()) {
                    String colDbName;
                    if (col instanceof ICFBamTableColObj) {
                        colDbName = ((ICFBamTableColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamBlobColObj) {
                        colDbName = ((ICFBamBlobColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamBoolColObj) {
                        colDbName = ((ICFBamBoolColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamInt16ColObj) {
                        colDbName = ((ICFBamInt16ColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamInt32ColObj) {
                        colDbName = ((ICFBamInt32ColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamInt64ColObj) {
                        colDbName = ((ICFBamInt64ColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamUInt16ColObj) {
                        colDbName = ((ICFBamUInt16ColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamUInt32ColObj) {
                        colDbName = ((ICFBamUInt32ColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamUInt64ColObj) {
                        colDbName = ((ICFBamUInt64ColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamFloatColObj) {
                        colDbName = ((ICFBamFloatColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamDoubleColObj) {
                        colDbName = ((ICFBamDoubleColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamNumberColObj) {
                        colDbName = ((ICFBamNumberColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamStringColObj) {
                        colDbName = ((ICFBamStringColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamTextColObj) {
                        colDbName = ((ICFBamTextColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamTokenColObj) {
                        colDbName = ((ICFBamTokenColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamNmTokenColObj) {
                        colDbName = ((ICFBamNmTokenColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamNmTokensColObj) {
                        colDbName = ((ICFBamNmTokensColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamDateColObj) {
                        colDbName = ((ICFBamDateColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamTimeColObj) {
                        colDbName = ((ICFBamTimeColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamTimestampColObj) {
                        colDbName = ((ICFBamTimestampColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamTZDateColObj) {
                        colDbName = ((ICFBamTZDateColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamTZTimeColObj) {
                        colDbName = ((ICFBamTZTimeColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamTZTimestampColObj) {
                        colDbName = ((ICFBamTZTimestampColObj)col).getOptionalDbName();
                    } else if (col instanceof ICFBamUuidColObj) {
                        colDbName = ((ICFBamUuidColObj)col).getOptionalDbName();
                    } else {
                        throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "validateColumnDbNamesNotOverloaded", "col", (Object)col, "definitely not " + col.getGenDefName());
                    }
                    if (colDbName == null || colDbName.length() <= 0) {
                        colDbName = col.getObjName();
                    }
                    Iterator indexColIter = worktable.getOptionalLookupPrimaryIndex().getOptionalComponentsColumns().iterator();
                    boolean notInPrimaryIndex = true;
                    while (notInPrimaryIndex && indexColIter.hasNext()) {
                        if (col != ((ICFBamIndexColObj)indexColIter.next()).getRequiredLookupColumn()) continue;
                        notInPrimaryIndex = false;
                    }
                    if (!notInPrimaryIndex) continue;
                    if (map.containsKey(colDbName)) {
                        ICFBamValueObj dup = (ICFBamValueObj)map.get(colDbName);
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" column \"" + col.getObjName() + "\" overloads the database name \"" + colDbName + "\" defined by \"" + dup.getRequiredContainerScope().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(colDbName, col);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload column database names\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateRelationsHaveLinkages(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                if (relation.getRelationTable() == null) {
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not specify its table\n");
                    valid = false;
                }
                if (relation.getRequiredLookupToTable() == null) {
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not specify a to table\n");
                    valid = false;
                }
                if (relation.getRequiredLookupFromIndex() == null) {
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not specify a from index\n");
                    valid = false;
                }
                if (relation.getRequiredLookupToIndex() != null) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not specify a to index\n");
                valid = false;
            }
        }
        if (valid) {
            this.log.append("Relations have proper linkages\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateRelationNamesNotOverloaded(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamRelationObj> map = new HashMap<String, ICFBamRelationObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamRelationObj relation : worktable.getOptionalComponentsRelation()) {
                    if (relation.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    if (map.containsKey(relation.getObjName())) {
                        ICFBamRelationObj dup = (ICFBamRelationObj)map.get(relation.getObjName());
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" relation \"" + relation.getObjName() + "\" overloads the name of the relationship \"" + dup.getRequiredContainerFromTable().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(relation.getObjName(), relation);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload relation names\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateRelationSuffixesNotOverloaded(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            LinkedList<ICFBamTableObj> tableStack = new LinkedList<ICFBamTableObj>();
            tableStack.add(table);
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    tableStack.add(worktable);
                    continue;
                }
                worktable = null;
            }
            HashMap<String, ICFBamRelationObj> map = new HashMap<String, ICFBamRelationObj>();
            while (tableStack.size() > 0) {
                worktable = (ICFBamTableObj)tableStack.getLast();
                tableStack.removeLast();
                for (ICFBamRelationObj relation : worktable.getOptionalComponentsRelation()) {
                    if (relation.getRequiredRelationType() == ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    String suffix = relation.getOptionalSuffix();
                    if (suffix == null || suffix.length() <= 0) {
                        suffix = relation.getObjName();
                    }
                    if (map.containsKey(suffix)) {
                        ICFBamRelationObj dup = (ICFBamRelationObj)map.get(suffix);
                        this.log.append("ERROR: Table \"" + worktable.getObjName() + "\" relation \"" + relation.getObjName() + "\" overloads the suffix \"" + suffix + "\" of the relationship \"" + dup.getRequiredContainerFromTable().getObjName() + "." + dup.getObjName() + "\"\n");
                        valid = false;
                        continue;
                    }
                    map.put(suffix, relation);
                }
            }
        }
        if (valid) {
            this.log.append("Tables do not overload relation suffixes\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateOnlyOneSuperclassPerTable(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        ICFBamRelationObj superclassRelation = null;
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            superclassRelation = null;
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                if (superclassRelation != null) {
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" is a Superclass relation, but \"" + superclassRelation.getObjName() + "\" has already been defined as the Superclass relation\n");
                    valid = false;
                    continue;
                }
                superclassRelation = relation;
            }
        }
        if (valid) {
            this.log.append("Tables have at most one Superclass relation\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateRelationsHaveColumns(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                Iterator colIter = relation.getOptionalComponentsColumns().iterator();
                if (colIter.hasNext()) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not specify any columns\n");
                valid = false;
            }
        }
        if (valid) {
            this.log.append("Relations all specify columns\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateRelationsSpecifyAllFromColumns(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                HashMap<String, ICFBamIndexColObj> map = new HashMap<String, ICFBamIndexColObj>();
                for (ICFBamRelationColObj relationCol : relation.getOptionalComponentsColumns()) {
                    ICFBamIndexColObj indexCol = relationCol.getRequiredLookupFromCol();
                    if (map.containsKey(indexCol.getObjName())) {
                        this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" specifies the from index column \"" + indexCol.getObjName() + "\" more than once\n");
                        valid = false;
                        continue;
                    }
                    map.put(indexCol.getObjName(), indexCol);
                }
                for (ICFBamIndexColObj indexCol : relation.getRequiredLookupFromIndex().getOptionalComponentsColumns()) {
                    if (indexCol == map.get(indexCol.getObjName())) continue;
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not reference the from index column \"" + indexCol.getObjName() + "\"\n");
                    valid = false;
                }
            }
        }
        if (valid) {
            this.log.append("Relations bind all from index columns exactly once\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateRelationsSpecifyAllToColumns(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                HashMap<String, ICFBamIndexColObj> map = new HashMap<String, ICFBamIndexColObj>();
                for (ICFBamRelationColObj relationCol : relation.getOptionalComponentsColumns()) {
                    ICFBamIndexColObj indexCol = relationCol.getRequiredLookupToCol();
                    if (map.containsKey(indexCol.getObjName())) {
                        this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" specifies the to index column \"" + indexCol.getObjName() + "\" more than once\n");
                        valid = false;
                        continue;
                    }
                    map.put(indexCol.getObjName(), indexCol);
                }
                for (ICFBamIndexColObj indexCol : relation.getRequiredLookupToIndex().getOptionalComponentsColumns()) {
                    if (indexCol == map.get(indexCol.getObjName())) continue;
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not reference the to index column \"" + indexCol.getObjName() + "\"\n");
                    valid = false;
                }
            }
        }
        if (valid) {
            this.log.append("Relations bind all to index columns exactly once\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateRelationColumnCountsMatchIndexes(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                if (relation.getRequiredLookupFromIndex().getOptionalComponentsColumns().size() != relation.getOptionalComponentsColumns().size()) {
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not specify the same number of columns as in the from index \"" + relation.getRequiredLookupFromIndex().getObjName() + "\"\n");
                    valid = false;
                }
                if (relation.getRequiredLookupToIndex().getOptionalComponentsColumns().size() == relation.getOptionalComponentsColumns().size()) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" relation \"" + relation.getObjName() + "\" does not specify the same number of columns as in the to index \"" + relation.getRequiredLookupToTable().getObjName() + "." + relation.getRequiredLookupToIndex().getObjName() + "\"\n");
                valid = false;
            }
        }
        if (valid) {
            this.log.append("Relations specify the same number of columns as their to/from indexes\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void validateChains(ICFBamSchemaDefObj schema) {
        Iterator tableIter = schema.getOptionalComponentsTables().iterator();
        boolean valid = true;
        while (tableIter.hasNext()) {
            String toColName;
            String fromColName;
            ICFBamTableObj table = (ICFBamTableObj)tableIter.next();
            Iterator chainIter = table.getOptionalComponentsChains().iterator();
            if (!chainIter.hasNext()) continue;
            ICFBamChainObj chain = (ICFBamChainObj)chainIter.next();
            if (chainIter.hasNext()) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" defines more than one chain\n");
                valid = false;
            }
            ICFBamTableObj worktable = table;
            while (worktable != null) {
                ICFBamRelationObj superRelation = null;
                Iterator relationIter = worktable.getOptionalComponentsRelation().iterator();
                while (superRelation == null && relationIter.hasNext()) {
                    ICFBamRelationObj relation = (ICFBamRelationObj)relationIter.next();
                    if (relation.getRequiredRelationType() != ICFBamSchema.RelationTypeEnum.Superclass) continue;
                    superRelation = relation;
                }
                if (superRelation != null) {
                    worktable = superRelation.getRequiredLookupToTable();
                    chainIter = worktable.getOptionalComponentsChains().iterator();
                    if (!chainIter.hasNext()) continue;
                    this.log.append("ERROR: Table \"" + table.getObjName() + "\" overloads the chain definition from the table \"" + worktable.getObjName() + "\" -- only one chain can be defined by an object hierarchy\n");
                    valid = false;
                    continue;
                }
                worktable = null;
            }
            ICFBamRelationObj prevRelation = chain.getRequiredLookupPrevRel();
            ICFBamRelationObj nextRelation = chain.getRequiredLookupNextRel();
            if (!prevRelation.getObjName().equals("Prev")) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" previous relation must be named \"Prev\"\n");
                valid = false;
            }
            if (!nextRelation.getObjName().equals("Next")) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" next relation must be named \"Next\"\n");
                valid = false;
            }
            if (prevRelation.getRequiredIsRequired()) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" previous relation must be optional\n");
                valid = false;
            }
            if (nextRelation.getRequiredIsRequired()) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" next relation must be optional\n");
                valid = false;
            }
            if (prevRelation.getRequiredContainerFromTable() != table) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a previous relation that is inherited by the table -- it must be defined by the table\n");
                valid = false;
            }
            if (nextRelation.getRequiredContainerFromTable() != table) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a next relation that is inherited by the table -- it must be defined by the table\n");
                valid = false;
            }
            if (prevRelation.getRequiredLookupFromIndex().getRequiredContainerTable() != table) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a previous relation whose from index is not defined by the table -- inherited indexes can not be referenced\n");
                valid = false;
            }
            if (prevRelation.getRequiredLookupToIndex().getRequiredContainerTable() != table) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a previous relation that does not target an index defined by the table -- inherited indexes can not be referenced\n");
                valid = false;
            }
            if (nextRelation.getRequiredLookupFromIndex().getRequiredContainerTable() != table) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a next relation whose from index is not defined by the table -- inherited indexes can not be referenced\n");
                valid = false;
            }
            if (nextRelation.getRequiredLookupToIndex().getRequiredContainerTable() != table) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a next relation that does not target an index defined by the table -- inherited indexes can not be referenced\n");
                valid = false;
            }
            if (prevRelation.getRequiredLookupToIndex() != table.getOptionalLookupPrimaryIndex()) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a previous relation that does not target the primary index of the table\n");
                valid = false;
            }
            if (nextRelation.getRequiredLookupToIndex() != table.getOptionalLookupPrimaryIndex()) {
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" references a next relation that does not target the primary index of the table\n");
                valid = false;
            }
            for (ICFBamRelationColObj relationCol : prevRelation.getOptionalComponentsColumns()) {
                if (relationCol.getRequiredLookupFromCol().getRequiredLookupColumn().getRequiredIsNullable()) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" previous relation column \"" + relationCol.getObjName() + " references a required from column -- all from columns of the referenced previous relationship must be nullable\n");
                valid = false;
            }
            for (ICFBamRelationColObj relationCol : nextRelation.getOptionalComponentsColumns()) {
                if (relationCol.getRequiredLookupFromCol().getRequiredLookupColumn().getRequiredIsNullable()) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" next relation column \"" + relationCol.getObjName() + " references a required from column -- all from columns of the referenced next relationship must be nullable\n");
                valid = false;
            }
            for (ICFBamRelationColObj relationCol : prevRelation.getOptionalComponentsColumns()) {
                fromColName = relationCol.getRequiredLookupFromCol().getObjName();
                if (fromColName.equals("Prev" + (toColName = relationCol.getRequiredLookupToCol().getObjName()))) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" prev relation column \"" + relationCol.getObjName() + " from column name must be the to column name prepended by \"Prev\"; the same restriction applies to the database names\n");
                valid = false;
            }
            for (ICFBamRelationColObj relationCol : nextRelation.getOptionalComponentsColumns()) {
                fromColName = relationCol.getRequiredLookupFromCol().getObjName();
                if (fromColName.equals("Next" + (toColName = relationCol.getRequiredLookupToCol().getObjName()))) continue;
                this.log.append("ERROR: Table \"" + table.getObjName() + "\" chain \"" + chain.getObjName() + "\" next relation column \"" + relationCol.getObjName() + " from column name must be the to column name prepended by \"Next\"; the same restriction applies to the database names\n");
                valid = false;
            }
        }
        if (valid) {
            this.log.append("Chains are valid\n");
        } else {
            this.modelIsValid = false;
        }
    }

    protected void propagateTypesAreNotNull(ICFBamSchemaDefObj schema) {
        for (ICFBamValueObj type : schema.getOptionalComponentsTypes()) {
            ICFBamValueEditObj editType;
            if (type instanceof ICFBamBlobTypeObj) {
                if (type.getRequiredIsNullable()) continue;
                editType = type.beginEdit();
                editType.setRequiredIsNullable(true);
                editType.update();
                editType.endEdit();
                continue;
            }
            if (!type.getRequiredIsNullable()) continue;
            editType = type.beginEdit();
            editType.setRequiredIsNullable(false);
            editType.update();
            editType.endEdit();
        }
    }

    protected void propagateTableColumnNameChanges(ICFBamSchemaDefObj schema) {
        for (ICFBamTableObj table : schema.getOptionalComponentsTables()) {
            for (ICFBamIndexObj index : table.getOptionalComponentsIndex()) {
                for (ICFBamIndexColObj indexCol : index.getOptionalComponentsColumns()) {
                    ICFBamValueObj column = indexCol.getRequiredLookupColumn();
                    if (!(!indexCol.getRequiredName().equals(column.getRequiredName()) || indexCol.getOptionalShortName() == null && column.getOptionalShortName() != null || indexCol.getOptionalShortName() != null && column.getOptionalShortName() == null || indexCol.getOptionalShortName() != null && column.getOptionalShortName() != null && !indexCol.getOptionalShortName().equals(column.getOptionalShortName()) || indexCol.getOptionalLabel() == null && column.getOptionalLabel() != null || indexCol.getOptionalLabel() != null && column.getOptionalLabel() == null || indexCol.getOptionalLabel() != null && column.getOptionalLabel() != null && !indexCol.getOptionalLabel().equals(column.getOptionalLabel()) || indexCol.getOptionalDescription() == null && column.getOptionalDescription() != null || indexCol.getOptionalDescription() != null && column.getOptionalDescription() == null || indexCol.getOptionalDescription() != null && column.getOptionalDescription() != null && !indexCol.getOptionalDescription().equals(column.getOptionalDescription()) || indexCol.getOptionalShortDescription() == null && column.getOptionalShortDescription() != null || indexCol.getOptionalShortDescription() != null && column.getOptionalShortDescription() == null) && (indexCol.getOptionalShortDescription() == null || column.getOptionalShortDescription() == null || indexCol.getOptionalShortDescription().equals(column.getOptionalShortDescription()))) continue;
                    ICFBamIndexColEditObj editIndexCol = indexCol.beginEdit();
                    editIndexCol.setRequiredName(column.getRequiredName());
                    editIndexCol.setOptionalShortName(column.getOptionalShortName());
                    editIndexCol.setOptionalDescription(column.getOptionalDescription());
                    editIndexCol.setOptionalLabel(column.getOptionalLabel());
                    editIndexCol.setOptionalShortDescription(column.getOptionalShortDescription());
                    editIndexCol.update();
                    editIndexCol.endEdit();
                }
            }
        }
    }

    protected void propagateIndexColumnNameChanges(ICFBamSchemaDefObj schema) {
        for (ICFBamTableObj table : schema.getOptionalComponentsTables()) {
            for (ICFBamRelationObj relation : table.getOptionalComponentsRelation()) {
                for (ICFBamRelationColObj relationCol : relation.getOptionalComponentsColumns()) {
                    ICFBamIndexColObj fromColumn = relationCol.getRequiredLookupFromCol();
                    if (!(!relationCol.getRequiredName().equals(fromColumn.getRequiredName()) || relationCol.getOptionalLabel() == null && fromColumn.getOptionalLabel() != null || relationCol.getOptionalLabel() != null && fromColumn.getOptionalLabel() == null || relationCol.getOptionalLabel() != null && fromColumn.getOptionalLabel() != null && !relationCol.getOptionalLabel().equals(fromColumn.getOptionalLabel()) || relationCol.getOptionalDescription() == null && fromColumn.getOptionalDescription() != null || relationCol.getOptionalDescription() != null && fromColumn.getOptionalDescription() == null || relationCol.getOptionalDescription() != null && fromColumn.getOptionalDescription() != null && !relationCol.getOptionalDescription().equals(fromColumn.getOptionalDescription()) || relationCol.getOptionalShortName() == null && fromColumn.getOptionalShortName() != null || relationCol.getOptionalShortName() != null && fromColumn.getOptionalShortName() == null || relationCol.getOptionalShortName() != null && fromColumn.getOptionalShortName() != null && !relationCol.getOptionalShortName().equals(fromColumn.getOptionalShortName()) || relationCol.getOptionalShortDescription() == null && fromColumn.getOptionalShortDescription() != null || relationCol.getOptionalShortDescription() != null && fromColumn.getOptionalShortDescription() == null) && (relationCol.getOptionalShortDescription() == null || fromColumn.getOptionalShortDescription() == null || relationCol.getOptionalShortDescription().equals(fromColumn.getOptionalShortDescription()))) continue;
                    ICFBamRelationColEditObj editRelationCol = relationCol.beginEdit();
                    editRelationCol.setRequiredName(fromColumn.getRequiredName());
                    editRelationCol.setOptionalShortName(fromColumn.getOptionalShortName());
                    editRelationCol.setOptionalDescription(fromColumn.getOptionalDescription());
                    editRelationCol.setOptionalLabel(fromColumn.getOptionalLabel());
                    editRelationCol.setOptionalShortDescription(fromColumn.getOptionalShortDescription());
                    editRelationCol.update();
                    editRelationCol.endEdit();
                }
            }
        }
    }
}

