/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.MssCF;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbToolSetObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFEngine;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFRuleSetParser;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFSaxParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreElementHandler;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import org.apache.log4j.Level;
import org.apache.xerces.xni.grammars.Grammar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MssCFToolSetParser
extends MssCFSaxParser
implements ContentHandler {
    public static final String SCHEMA_XMLNS = "uri://net.sourceforge.msscodefactory/cfgenkb-2.9-toolset";
    public static final String SCHEMA_URI = "../bin/xsd/cfgenkb-2.9-toolset.xsd";
    public static final String SCHEMA_ROOT_URI = "/xsd/cfgenkb-2.9-toolset.xsd";
    private MssCFRuleSetParser ruleSetParser = null;
    private String curToolSet = null;
    protected static Grammar myGrammar = null;

    public MssCFToolSetParser(MssCFEngine engine, ICFLibMessageLog jLogger) {
        super(engine, jLogger);
        this.setRootElementHandler(new RootHandler(this));
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = MssCFToolSetParser.addToGrammarPool((String)SCHEMA_URI, (InputStream)input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = MssCFToolSetParser.addToGrammarPool((String)SCHEMA_ROOT_URI, (InputStream)input);
                }
            }
        }
        this.initParser();
        this.ruleSetParser = new MssCFRuleSetParser(engine, jLogger);
    }

    public String getCurToolSet() {
        return this.curToolSet;
    }

    protected void setCurToolSet(String toolSet) {
        this.curToolSet = MssCFToolSetParser.getInternalToolSetName(toolSet);
    }

    protected void parse(String uri) {
        assert (uri != null && uri.length() > 0) : "uri (parm 1) is null or empty";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(uri, (DefaultHandler)((Object)this));
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (FileNotFoundException e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            }
            CFLib.beep();
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            CFLib.beep();
        }
    }

    protected void parse(InputStream inputStream) {
        assert (inputStream != null) : "inputStream (arg 1) is null";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(inputStream, (DefaultHandler)((Object)this));
        }
        catch (SAXParseException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            CFLib.beep();
        }
    }

    class RuleSetHandler
    extends CFLibXmlCoreElementHandler {
        public RuleSetHandler(MssCFToolSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("START ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\"");
                } else {
                    buff.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff.append("\n\tAttribute[" + idxAttr + "] localName=");
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff.append("\"" + attrQName + "\", type=");
                    } else {
                        buff.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff.append("\"" + attrType + "\", value=");
                    } else {
                        buff.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff.append("null");
                }
                buff.append('\n');
                debugLogger.debug((Object)buff.toString());
            }
            String attrName = null;
            assert (qName.equals("RuleSet"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            String ruleSetDocRoot = MssCFToolSetParser.this.getDocumentRootDir();
            String ruleSetName = ruleSetDocRoot + attrName + ".xml";
            InputStream ruleSetManifestXml = null;
            if (ruleSetDocRoot.startsWith("jar:")) {
                try {
                    URL url = new URL(ruleSetName);
                    if (url != null && (ruleSetManifestXml = url.openStream()) == null) {
                        ruleSetName = null;
                        ruleSetDocRoot = null;
                    }
                }
                catch (MalformedURLException e) {
                    ruleSetManifestXml = null;
                    ruleSetName = null;
                    ruleSetDocRoot = null;
                }
                catch (IOException e) {
                    ruleSetManifestXml = null;
                    ruleSetName = null;
                    ruleSetDocRoot = null;
                }
            } else {
                try {
                    ruleSetManifestXml = new FileInputStream(ruleSetName);
                }
                catch (FileNotFoundException e) {
                    ruleSetManifestXml = null;
                    this.getLog().message("ERROR: \tCould not find RuleSet \"" + ruleSetName + "\"\n");
                    CFLib.beep();
                    return;
                }
            }
            try {
                MssCFToolSetParser.this.ruleSetParser.setLog(this.getLog());
                MssCFToolSetParser.this.ruleSetParser.setDefaultToolSet(((MssCFToolSetParser)this.getParser()).getCurToolSet());
                MssCFToolSetParser.this.ruleSetParser.parse(ruleSetManifestXml, ruleSetDocRoot);
            }
            catch (Exception e) {
                this.getLog().message("ERROR: " + MssCFToolSetParser.this.getLocationInfo() + "\tCould not load ToolSet \"" + attrName + "\"\n");
                CFLib.beep();
            }
            finally {
                if (ruleSetManifestXml != null) {
                    try {
                        ruleSetManifestXml.close();
                    }
                    catch (Exception exception) {}
                    ruleSetManifestXml = null;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
        }
    }

    class ToolSetHandler
    extends CFLibXmlCoreElementHandler {
        public ToolSetHandler(MssCFToolSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
            this.addElementHandler("RuleSet", new RuleSetHandler(coreParser));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            StringBuffer buff;
            String attrLocalName;
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff2 = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff2.length() > 0) {
                    buff2.append(": ");
                }
                buff2.append("START ELEMENT localName=");
                if (localName != null) {
                    buff2.append("\"" + localName + "\", qName=");
                } else {
                    buff2.append("null, qName=");
                }
                if (qName != null) {
                    buff2.append("\"" + qName + "\"");
                } else {
                    buff2.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff2.append("\n\tAttribute[" + idxAttr + "] localName=");
                    attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff2.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff2.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff2.append("\"" + attrQName + "\", type=");
                    } else {
                        buff2.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff2.append("\"" + attrType + "\", value=");
                    } else {
                        buff2.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff2.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff2.append("null");
                }
                buff2.append('\n');
                debugLogger.debug((Object)buff2.toString());
            }
            String attrName = null;
            String attrRevision = null;
            String attrDescr = null;
            assert (qName.equals("ToolSet"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Revision")) {
                    assert (attrRevision == null) : "Duplicate attribute \"Revision\" detected";
                    attrRevision = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Descr")) {
                    assert (attrDescr == null) : "Duplicate attribute \"Descr\" detected";
                    attrDescr = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            assert (attrRevision != null && attrRevision.length() > 0) : "Missing attribute \"Revision\"";
            assert (attrDescr != null && attrDescr.length() > 0) : "Missing attribute \"Descr\"";
            this.getLog().message("\tLoading ToolSet \"" + attrName + "\", Revision = \"" + attrRevision + "\", Descr=\"" + attrDescr + "\"\n");
            String useToolSet = MssCFSaxParser.getInternalToolSetName(attrName);
            ((MssCFToolSetParser)this.getParser()).setCurToolSet(useToolSet);
            ICFGenKbToolSetObj toolset = MssCFToolSetParser.this.getEngine().getToolSetTableObj().readToolSetByNameIdx(useToolSet);
            if (toolset != null) {
                buff = new StringBuffer("\tEnabled ToolSet \"");
            } else {
                toolset = MssCFToolSetParser.this.getEngine().defineToolSet(useToolSet);
                buff = new StringBuffer("\tDefined ToolSet \"");
            }
            buff.append(useToolSet);
            buff.append("\"\n");
            this.getLog().message(buff.toString());
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
        }
    }

    class RootHandler
    extends CFLibXmlCoreElementHandler {
        public RootHandler(MssCFToolSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
            this.addElementHandler("ToolSet", new ToolSetHandler(coreParser));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

