/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.MssCF;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFEngine;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFSaxParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreContext;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreElementHandler;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import org.apache.log4j.Level;
import org.apache.xerces.xni.grammars.Grammar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MssCFRuleSetParser
extends MssCFSaxParser
implements ContentHandler {
    public static final String SCHEMA_XMLNS = "uri://net.sourceforge.msscodefactory/cfgenkb-2.9-ruleset";
    public static final String SCHEMA_URI = "../bin/xsd/cfgenkb-2.9-ruleset.xsd";
    public static final String SCHEMA_ROOT_URI = "/xsd/cfgenkb-2.9-ruleset.xsd";
    private String defaultToolSet = null;
    protected static Grammar myGrammar = null;

    public MssCFRuleSetParser(MssCFEngine engine, ICFLibMessageLog jLogger) {
        super(engine, jLogger);
        this.setRootElementHandler(new RootHandler(this));
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = MssCFRuleSetParser.addToGrammarPool((String)SCHEMA_URI, (InputStream)input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = MssCFRuleSetParser.addToGrammarPool((String)SCHEMA_ROOT_URI, (InputStream)input);
                }
            }
        }
        this.initParser();
    }

    public String getDefaultToolSet() {
        return this.defaultToolSet;
    }

    public void setDefaultToolSet(String toolSet) {
        this.defaultToolSet = MssCFRuleSetParser.getInternalToolSetName(toolSet);
    }

    protected void parse(String uri) {
        assert (uri != null && uri.length() > 0) : "uri (parm 1) is null or empty";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(uri, (DefaultHandler)((Object)this));
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (FileNotFoundException e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            }
            CFLib.beep();
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            CFLib.beep();
        }
    }

    protected void parse(InputStream inputStream) {
        assert (inputStream != null) : "inputStream (arg 1) is null";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(inputStream, (DefaultHandler)((Object)this));
        }
        catch (SAXParseException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            CFLib.beep();
        }
    }

    class GenFileHandler
    extends CFLibXmlCoreElementHandler {
        public GenFileHandler(MssCFRuleSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            StringBuffer buff;
            String defaultToolSet;
            StringBuffer buff2 = this.getParser().appendLocatorInformation(new StringBuffer());
            if (buff2.length() > 0) {
                buff2.append(": ");
            }
            buff2.append("START ELEMENT localName=");
            if (localName != null) {
                buff2.append("\"" + localName + "\", qName=");
            } else {
                buff2.append("null, qName=");
            }
            if (qName != null) {
                buff2.append("\"" + qName + "\"");
            } else {
                buff2.append("null");
            }
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                buff2.append("\n\tAttribute[" + idxAttr + "] localName=");
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName != null) {
                    buff2.append("\"" + attrLocalName + "\", qName=");
                } else {
                    buff2.append("null, qName=");
                }
                String attrQName = attrs.getQName(idxAttr);
                if (attrQName != null) {
                    buff2.append("\"" + attrQName + "\", type=");
                } else {
                    buff2.append("null, type=");
                }
                String attrType = attrs.getType(idxAttr);
                if (attrType != null) {
                    buff2.append("\"" + attrType + "\", value=");
                } else {
                    buff2.append("null, value=");
                }
                String attrValue = attrs.getValue(idxAttr);
                if (attrValue != null) {
                    buff2.append("\"" + attrValue + "\"");
                    continue;
                }
                buff2.append("null");
            }
            buff2.append('\n');
            debugLogger.debug((Object)buff2.toString());
            String attrId = null;
            String attrName = null;
            String attrToolSet = null;
            String attrScopeDef = null;
            String attrGenDef = null;
            String attrSourceBundle = null;
            String attrBasePackageName = null;
            String attrSubPackageName = null;
            String attrExpansionClassName = null;
            String attrExpansionKeyName = null;
            String attrExpansionFileName = null;
            assert (qName.equals("GenFile"));
            int numAttrs2 = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs2; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ScopeDef")) {
                    assert (attrScopeDef == null) : "Duplicate attribute \"ScopeDef\" detected";
                    attrScopeDef = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("GenDef")) {
                    assert (attrGenDef == null) : "Duplicate attribute \"GenDef\" detected";
                    attrGenDef = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("SourceBundle")) {
                    assert (attrSourceBundle == null) : "Duplicate attribute \"SourceBundle\" detected";
                    attrSourceBundle = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("BasePackageName")) {
                    assert (attrBasePackageName == null) : "Duplicate attribute \"BasePackageName\" detected";
                    attrBasePackageName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("SubPackageName")) {
                    assert (attrSubPackageName == null) : "Duplicate attribute \"SubPackageName\" detected";
                    attrSubPackageName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ExpansionClassName")) {
                    assert (attrExpansionClassName == null) : "Duplicate attribute \"ExpansionClassName\" detected";
                    attrExpansionClassName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ExpansionKeyName")) {
                    assert (attrExpansionKeyName == null) : "Duplicate attribute \"ExpansionKeyName\" detected";
                    attrExpansionKeyName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ExpansionFileName")) {
                    assert (attrExpansionFileName == null) : "Duplicate attribute \"ExpansionFileName\" detected";
                    attrExpansionFileName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ToolSet")) {
                    assert (attrToolSet == null) : "Duplicate attribute \"ToolSet\" detected";
                    attrToolSet = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Id")) {
                    assert (attrId == null) : "Duplicate attribute \"Id\" detected";
                    attrId = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            assert (attrGenDef != null && attrGenDef.length() > 0) : "Missing attribute \"GenDef\"";
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buff3 = new StringBuffer("\t\t\tGenFile");
                if (attrId != null && attrId.length() > 0) {
                    buff3.append(" Id=\"" + attrId + "\"");
                }
                if (attrToolSet != null && attrToolSet.length() > 0) {
                    buff3.append(" ToolSet=\"" + attrToolSet + "\"");
                }
                buff3.append(" Name=\"" + attrName + "\"");
                buff3.append(" ScopeDef=\"" + (attrScopeDef != null ? attrScopeDef : "") + "\"");
                buff3.append(" GenDef=\"" + attrGenDef + "\"");
                if (attrSourceBundle != null && attrSourceBundle.length() > 0) {
                    buff3.append(" SourceBundle=\"" + attrSourceBundle + "\"");
                }
                if (attrBasePackageName != null && attrBasePackageName.length() > 0) {
                    buff3.append(" BasePackageName=\"" + attrBasePackageName + "\"");
                }
                if (attrSubPackageName != null && attrSubPackageName.length() > 0) {
                    buff3.append(" SubPackageName=\"" + attrSubPackageName + "\"");
                }
                if (attrExpansionClassName != null && attrExpansionClassName.length() > 0) {
                    buff3.append(" ExpansionClassName=\"" + attrExpansionClassName + "\"");
                }
                if (attrExpansionKeyName != null && attrExpansionKeyName.length() > 0) {
                    buff3.append(" ExpansionKeyName=\"" + attrExpansionKeyName + "\"");
                }
                if (attrExpansionFileName != null && attrExpansionFileName.length() > 0) {
                    buff3.append(" ExpansionFileName=\"" + attrExpansionFileName + "\"");
                }
                buff3.append('\n');
                debugLogger.debug((Object)buff3.toString());
            }
            String useToolSet = attrToolSet != null ? (attrToolSet.equals("*") || attrToolSet.equals("object") ? "Object" : attrToolSet) : MssCFRuleSetParser.this.getDefaultToolSet();
            if (useToolSet != null && !useToolSet.equals(defaultToolSet = MssCFRuleSetParser.this.getDefaultToolSet())) {
                buff = new StringBuffer("\t\t\t\tExpected ToolSet \"");
                buff.append(defaultToolSet);
                buff.append("\", not \"");
                buff.append(useToolSet);
                buff.append("\", encountered near ");
                this.getParser().appendLocatorInformation(buff);
                buff.append('\n');
                this.getLog().message("ERROR: " + buff.toString());
            }
            defaultToolSet = MssCFRuleSetParser.this.getDefaultToolSet();
            if (useToolSet != null) {
                if (!useToolSet.equals(defaultToolSet)) {
                    buff = new StringBuffer("\t\t\t\tExpected ToolSet \"");
                    buff.append(defaultToolSet);
                    buff.append("\", not \"");
                    buff.append(useToolSet);
                    buff.append("\", encountered near ");
                    this.getParser().appendLocatorInformation(buff);
                    buff.append('\n');
                    this.getLog().message("ERROR: " + buff.toString());
                }
            } else if (defaultToolSet != null) {
                buff = new StringBuffer("\t\t\t\tExpected ToolSet \"");
                buff.append(defaultToolSet);
                buff.append("\", not null, encountered near ");
                this.getParser().appendLocatorInformation(buff);
                buff.append('\n');
                this.getLog().message("ERROR: " + buff.toString());
            }
            CFLibXmlCoreContext curContext = this.getParser().getCurContext();
            curContext.putNamedValue("Id", (Object)attrId);
            curContext.putNamedValue("Name", (Object)attrName);
            curContext.putNamedValue("ToolSet", (Object)attrToolSet);
            curContext.putNamedValue("ScopeDef", (Object)attrScopeDef);
            curContext.putNamedValue("GenDef", (Object)attrGenDef);
            curContext.putNamedValue("SourceBundle", (Object)attrSourceBundle);
            curContext.putNamedValue("BasePackageName", (Object)attrBasePackageName);
            curContext.putNamedValue("SubPackageName", (Object)attrSubPackageName);
            curContext.putNamedValue("ExpansionClassName", (Object)attrExpansionClassName);
            curContext.putNamedValue("ExpansionKeyName", (Object)attrExpansionKeyName);
            curContext.putNamedValue("ExpansionFileName", (Object)attrExpansionFileName);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
            CFLibXmlCoreContext curContext = this.getParser().getCurContext();
            String attrName = (String)curContext.getNamedValue("Name");
            String attrToolSet = (String)curContext.getNamedValue("ToolSet");
            String attrScopeDef = (String)curContext.getNamedValue("ScopeDef");
            String attrGenDef = (String)curContext.getNamedValue("GenDef");
            String attrSourceBundle = (String)curContext.getNamedValue("SourceBundle");
            String attrBasePackageName = (String)curContext.getNamedValue("BasePackageName");
            String attrSubPackageName = (String)curContext.getNamedValue("SubPackageName");
            String attrExpansionClassName = (String)curContext.getNamedValue("ExpansionClassName");
            String attrExpansionKeyName = (String)curContext.getNamedValue("ExpansionKeyName");
            String attrExpansionFileName = (String)curContext.getNamedValue("ExpansionFileName");
            String attrText = curContext.getElementText();
            String useToolSet = attrToolSet != null ? (attrToolSet.equals("*") || attrToolSet.equals("object") ? "Object" : attrToolSet) : MssCFRuleSetParser.this.getDefaultToolSet();
            String useScopeDef = attrScopeDef == null || attrScopeDef.length() <= 0 ? null : (attrScopeDef.equals("*") || attrScopeDef.equals("Object") || attrScopeDef.equals("object") ? attrScopeDef : attrScopeDef);
            String useGenDef = attrGenDef == null || attrGenDef.length() <= 0 ? null : (attrGenDef.equals("*") ? attrGenDef : attrGenDef);
            MssCFRuleSetParser.this.getEngine().defineFile(useToolSet, useScopeDef, useGenDef, attrName, attrText, attrSourceBundle, attrBasePackageName, attrSubPackageName, attrExpansionClassName, attrExpansionKeyName, attrExpansionFileName);
        }
    }

    class GenTruncHandler
    extends CFLibXmlCoreElementHandler {
        public GenTruncHandler(MssCFRuleSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            StringBuffer buff;
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff2 = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff2.length() > 0) {
                    buff2.append(": ");
                }
                buff2.append("START ELEMENT localName=");
                if (localName != null) {
                    buff2.append("\"" + localName + "\", qName=");
                } else {
                    buff2.append("null, qName=");
                }
                if (qName != null) {
                    buff2.append("\"" + qName + "\"");
                } else {
                    buff2.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff2.append("\n\tAttribute[" + idxAttr + "] localName=");
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff2.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff2.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff2.append("\"" + attrQName + "\", type=");
                    } else {
                        buff2.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff2.append("\"" + attrType + "\", value=");
                    } else {
                        buff2.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff2.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff2.append("null");
                }
                buff2.append('\n');
                debugLogger.debug((Object)buff2.toString());
            }
            String attrId = null;
            String attrName = null;
            String attrToolSet = null;
            String attrScopeDef = null;
            String attrGenDef = null;
            String attrTruncateAt = null;
            assert (qName.equals("GenTrunc"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ScopeDef")) {
                    assert (attrScopeDef == null) : "Duplicate attribute \"ScopeDef\" detected";
                    attrScopeDef = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("GenDef")) {
                    assert (attrGenDef == null) : "Duplicate attribute \"GenDef\" detected";
                    attrGenDef = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("TruncateAt")) {
                    assert (attrTruncateAt == null) : "Duplicate attribute \"TruncateAt\" detected";
                    attrTruncateAt = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ToolSet")) {
                    assert (attrToolSet == null) : "Duplicate attribute \"ToolSet\" detected";
                    attrToolSet = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Id")) {
                    assert (attrId == null) : "Duplicate attribute \"Id\" detected";
                    attrId = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            assert (attrGenDef != null && attrGenDef.length() > 0) : "Missing attribute \"GenDef\"";
            assert (attrTruncateAt != null && attrTruncateAt.length() > 0) : "Missing attribute \"TruncateAt\"";
            String defaultToolSet = MssCFRuleSetParser.this.getDefaultToolSet();
            String useToolSet = attrToolSet == null ? defaultToolSet : MssCFSaxParser.getInternalToolSetName(attrToolSet);
            int intTruncateAt = Integer.parseInt(attrTruncateAt);
            if (useToolSet != null) {
                if (!useToolSet.equals(defaultToolSet)) {
                    buff = new StringBuffer("\t\t\t\tExpected ToolSet \"");
                    buff.append(defaultToolSet);
                    buff.append("\", not \"");
                    buff.append(useToolSet);
                    buff.append("\", encountered near ");
                    this.getParser().appendLocatorInformation(buff);
                    buff.append('\n');
                    this.getLog().message("ERROR: " + buff.toString());
                }
            } else if (defaultToolSet != null) {
                buff = new StringBuffer("\t\t\t\tExpected ToolSet \"");
                buff.append(defaultToolSet);
                buff.append("\", not null, encountered near ");
                this.getParser().appendLocatorInformation(buff);
                buff.append('\n');
                this.getLog().message("ERROR: " + buff.toString());
            }
            CFLibXmlCoreContext curContext = this.getParser().getCurContext();
            curContext.putNamedValue("Id", attrId);
            curContext.putNamedValue("Name", (Object)attrName);
            curContext.putNamedValue("ToolSet", (Object)useToolSet);
            curContext.putNamedValue("ScopeDef", (Object)attrScopeDef);
            curContext.putNamedValue("GenDef", (Object)attrGenDef);
            curContext.putNamedValue("TruncateAt", (Object)attrTruncateAt);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
            CFLibXmlCoreContext curContext = this.getParser().getCurContext();
            String attrName = (String)curContext.getNamedValue("Name");
            String useToolSet = (String)curContext.getNamedValue("ToolSet");
            String attrScopeDef = (String)curContext.getNamedValue("ScopeDef");
            String attrGenDef = (String)curContext.getNamedValue("GenDef");
            String attrTruncateAt = (String)curContext.getNamedValue("TruncateAt");
            String attrText = curContext.getElementText();
            String useScopeDef = attrScopeDef == null || attrScopeDef.length() <= 0 ? null : (attrScopeDef.equals("*") ? attrScopeDef : attrScopeDef);
            String useGenDef = attrGenDef == null || attrGenDef.length() <= 0 ? null : (attrGenDef.equals("*") ? attrGenDef : attrGenDef);
            int truncateAt = Integer.parseInt(attrTruncateAt);
            MssCFRuleSetParser.this.getEngine().defineTrunc(useToolSet, useScopeDef, useGenDef, attrName, attrText, truncateAt);
        }
    }

    class GenRuleHandler
    extends CFLibXmlCoreElementHandler {
        public GenRuleHandler(MssCFRuleSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            StringBuffer buff;
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff2 = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff2.length() > 0) {
                    buff2.append(": ");
                }
                buff2.append("START ELEMENT localName=");
                if (localName != null) {
                    buff2.append("\"" + localName + "\", qName=");
                } else {
                    buff2.append("null, qName=");
                }
                if (qName != null) {
                    buff2.append("\"" + qName + "\"");
                } else {
                    buff2.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff2.append("\n\tAttribute[" + idxAttr + "] localName=");
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff2.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff2.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff2.append("\"" + attrQName + "\", type=");
                    } else {
                        buff2.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff2.append("\"" + attrType + "\", value=");
                    } else {
                        buff2.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff2.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff2.append("null");
                }
                buff2.append('\n');
                debugLogger.debug((Object)buff2.toString());
            }
            String attrId = null;
            String attrName = null;
            String attrToolSet = null;
            String attrScopeDef = null;
            String attrGenDef = null;
            assert (qName.equals("GenRule"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ScopeDef")) {
                    assert (attrScopeDef == null) : "Duplicate attribute \"ScopeDef\" detected";
                    attrScopeDef = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("GenDef")) {
                    assert (attrGenDef == null) : "Duplicate attribute \"GenDef\" detected";
                    attrGenDef = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ToolSet")) {
                    assert (attrToolSet == null) : "Duplicate attribute \"ToolSet\" detected";
                    attrToolSet = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Id")) {
                    assert (attrId == null) : "Duplicate attribute \"Id\" detected";
                    attrId = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            assert (attrGenDef != null && attrGenDef.length() > 0) : "Missing attribute \"GenDef\"";
            String defaultToolSet = MssCFRuleSetParser.this.getDefaultToolSet();
            String useToolSet = attrToolSet == null ? defaultToolSet : MssCFSaxParser.getInternalToolSetName(attrToolSet);
            if (useToolSet != null) {
                if (useToolSet != defaultToolSet && !useToolSet.equals(defaultToolSet)) {
                    buff = new StringBuffer("\t\t\t\tExpected ToolSet \"");
                    buff.append(defaultToolSet);
                    buff.append("\", not \"");
                    buff.append(useToolSet);
                    buff.append("\", encountered near ");
                    this.getParser().appendLocatorInformation(buff);
                    buff.append('\n');
                    this.getLog().message("ERROR: " + buff.toString());
                }
            } else if (defaultToolSet != null) {
                buff = new StringBuffer("\t\t\t\tExpected ToolSet \"");
                buff.append(defaultToolSet);
                buff.append("\", not null, encountered near ");
                this.getParser().appendLocatorInformation(buff);
                buff.append('\n');
                this.getLog().message("ERROR: " + buff.toString());
            }
            CFLibXmlCoreContext curContext = this.getParser().getCurContext();
            curContext.putNamedValue("Id", attrId);
            curContext.putNamedValue("Name", (Object)attrName);
            curContext.putNamedValue("ToolSet", (Object)useToolSet);
            curContext.putNamedValue("ScopeDef", (Object)attrScopeDef);
            curContext.putNamedValue("GenDef", (Object)attrGenDef);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
            CFLibXmlCoreContext curContext = this.getParser().getCurContext();
            String attrName = (String)curContext.getNamedValue("Name");
            String useToolSet = (String)curContext.getNamedValue("ToolSet");
            String attrScopeDef = (String)curContext.getNamedValue("ScopeDef");
            String attrGenDef = (String)curContext.getNamedValue("GenDef");
            String attrText = curContext.getElementText();
            String useScopeDef = attrScopeDef == null || attrScopeDef.length() <= 0 ? null : (attrScopeDef.equals("*") ? attrScopeDef : new String(attrScopeDef));
            String useGenDef = attrGenDef == null || attrGenDef.length() <= 0 ? null : (attrGenDef.equals("*") ? attrGenDef : new String(attrGenDef));
            MssCFRuleSetParser.this.getEngine().defineRule(useToolSet, useScopeDef, useGenDef, attrName, attrText);
        }
    }

    class RuleSetHandler
    extends CFLibXmlCoreElementHandler {
        public RuleSetHandler(MssCFRuleSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
            this.addElementHandler("GenRule", new GenRuleHandler(coreParser));
            this.addElementHandler("GenTrunc", new GenTruncHandler(coreParser));
            this.addElementHandler("GenFile", new GenFileHandler(coreParser));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("START ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\"");
                } else {
                    buff.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff.append("\n\tAttribute[" + idxAttr + "] localName=");
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff.append("\"" + attrQName + "\", type=");
                    } else {
                        buff.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff.append("\"" + attrType + "\", value=");
                    } else {
                        buff.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff.append("null");
                }
                buff.append('\n');
                debugLogger.debug((Object)buff.toString());
            }
            String attrToolSet = null;
            String attrName = null;
            String attrRevision = null;
            String attrDescr = null;
            assert (qName.equals("RuleSet"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Descr")) {
                    assert (attrDescr == null) : "Duplicate attribute \"Descr\" detected";
                    attrDescr = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Revision")) {
                    assert (attrRevision == null) : "Duplicate attribute \"Revision\" detected";
                    attrRevision = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("ToolSet")) {
                    assert (attrToolSet == null) : "Duplicate attribute \"ToolSet\" detected";
                    attrToolSet = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrToolSet != null && attrToolSet.length() > 0) : "Missing attribute \"ToolSet\"";
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            assert (attrDescr != null && attrDescr.length() > 0) : "Missing attribute \"Descr\"";
            if (attrRevision != null && attrRevision.length() > 0) {
                this.getLog().message("\t\tLoading " + attrToolSet + " RuleSet \"" + attrName + "\", Revision = \"" + attrRevision + "\", Descr=\"" + attrDescr + "\"\n");
            } else {
                this.getLog().message("\t\tLoading " + attrToolSet + " RuleSet \"" + attrName + "\", Descr=\"" + attrDescr + "\"\n");
            }
            String defaultToolSet = ((MssCFRuleSetParser)this.getParser()).getDefaultToolSet();
            String useToolSet = attrToolSet == null ? defaultToolSet : MssCFSaxParser.getInternalToolSetName(attrToolSet);
            if (useToolSet != defaultToolSet && !useToolSet.equals(defaultToolSet)) {
                StringBuffer buff = new StringBuffer("\t\t\tExpected ToolSet ");
                if (defaultToolSet != null) {
                    buff.append('\"');
                    buff.append(defaultToolSet);
                    buff.append("\", not ");
                } else {
                    buff.append("null, not ");
                }
                if (useToolSet != null) {
                    buff.append('\"');
                    buff.append(useToolSet);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                this.getLog().message("ERROR: " + buff.toString());
                MssCFRuleSetParser.this.setDefaultToolSet(useToolSet);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
        }
    }

    class RootHandler
    extends CFLibXmlCoreElementHandler {
        public RootHandler(MssCFRuleSetParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
            this.addElementHandler("RuleSet", new RuleSetHandler(coreParser));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

