/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.MssCF;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbToolObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFEngine;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFSaxParser;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFToolSetParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreElementHandler;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xerces.xni.grammars.Grammar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MssCFRuleCartridgeParser
extends MssCFSaxParser
implements ContentHandler {
    public static final String SCHEMA_XMLNS = "uri://net.sourceforge.msscodefactory/cfgenkb-2.9-cartridge";
    public static final String SCHEMA_URI = "../bin/xsd/cfgenkb-2.9-cartridge.xsd";
    public static final String SCHEMA_ROOT_URI = "/xsd/cfgenkb-2.9-cartridge.xsd";
    protected static Logger debugLogger = Logger.getLogger(MssCFRuleCartridgeParser.class);
    protected static ArrayList cartridgePath = new ArrayList();
    private static Map ruleCartridgeNames = new HashMap();
    private static Vector toolSetNames = new Vector();
    private MssCFToolSetParser toolSetParser = null;
    private MssCFRuleCartridgeParser parentParser = null;
    protected static Grammar myGrammar = null;

    public MssCFRuleCartridgeParser(MssCFEngine engine, ICFLibMessageLog log) {
        super(engine, log);
        this.setRootElementHandler(new RootHandler(this));
        this.parentParser = null;
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = MssCFRuleCartridgeParser.addToGrammarPool((String)SCHEMA_URI, (InputStream)input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = MssCFRuleCartridgeParser.addToGrammarPool((String)SCHEMA_ROOT_URI, (InputStream)input);
                }
            }
        }
        this.initParser();
        this.parentParser = null;
        this.toolSetParser = new MssCFToolSetParser(this.getEngine(), this.getLog());
    }

    public MssCFRuleCartridgeParser(MssCFRuleCartridgeParser parser) {
        super(parser.getEngine(), parser.getLog());
        this.setRootElementHandler(new RootHandler(this));
        this.parentParser = parser;
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = MssCFRuleCartridgeParser.addToGrammarPool((String)SCHEMA_URI, (InputStream)input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = MssCFRuleCartridgeParser.addToGrammarPool((String)SCHEMA_ROOT_URI, (InputStream)input);
                }
            }
        }
        this.initParser();
        this.toolSetParser = new MssCFToolSetParser(this.getEngine(), this.getLog());
    }

    public static void addCartridgePath(String dirname) {
        assert (dirname != null && dirname.length() == 0) : "dirname (arg 1) is null or empty";
        for (String match : cartridgePath) {
            if (!dirname.equals(match)) continue;
            return;
        }
        cartridgePath.add(new String(dirname));
    }

    public static Iterator getCartridgePathIterator() {
        Iterator iter = cartridgePath.iterator();
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRuleCartridge(String cartridgeName) {
        String ruleCartridgeFileName = null;
        String ruleCartridgeRootDir = null;
        InputStream ruleCartridgeManifestXml = null;
        Iterator iterPath = MssCFRuleCartridgeParser.getCartridgePathIterator();
        while (ruleCartridgeManifestXml == null && iterPath.hasNext()) {
            String cartridgeDir = (String)iterPath.next();
            int cartridgeDirLen = cartridgeDir.length();
            assert (cartridgeDirLen > 0) : "CartridgeDir entry is empty";
            char cartridgeDirTail = cartridgeDir.charAt(cartridgeDirLen - 1);
            ruleCartridgeRootDir = cartridgeDirTail == '/' || cartridgeDirTail == '\\' ? new String(cartridgeDir + cartridgeName + File.separator) : new String(cartridgeDir + File.separator + cartridgeName + File.separator);
            ruleCartridgeFileName = ruleCartridgeRootDir + "rulecartridge.xml";
            if (ruleCartridgeRootDir.startsWith("jar:")) {
                try {
                    URL url = new URL(ruleCartridgeFileName);
                    if (url == null || (ruleCartridgeManifestXml = url.openStream()) != null) continue;
                    ruleCartridgeFileName = null;
                    ruleCartridgeRootDir = null;
                }
                catch (MalformedURLException e) {
                    ruleCartridgeManifestXml = null;
                    ruleCartridgeFileName = null;
                    ruleCartridgeRootDir = null;
                }
                catch (IOException e) {
                    ruleCartridgeManifestXml = null;
                    ruleCartridgeFileName = null;
                    ruleCartridgeRootDir = null;
                }
                continue;
            }
            try {
                ruleCartridgeManifestXml = new FileInputStream(ruleCartridgeFileName);
            }
            catch (FileNotFoundException e) {
                ruleCartridgeManifestXml = null;
                ruleCartridgeFileName = null;
                ruleCartridgeRootDir = null;
            }
        }
        if (ruleCartridgeManifestXml == null) {
            String resName = "/cartridge-1.11/" + cartridgeName + "/rulecartridge.xml";
            URL url = this.cfEngine.getClass().getResource(resName);
            if (url != null) {
                String urlString = url.toString();
                int lastSlash = urlString.lastIndexOf(47);
                ruleCartridgeRootDir = urlString.substring(0, lastSlash);
                ruleCartridgeManifestXml = this.cfEngine.getClass().getResourceAsStream(urlString);
            } else {
                resName = "cartridge-1.11/" + cartridgeName + "/rulecartridge.xml";
                url = this.cfEngine.getClass().getResource(resName);
                if (url != null) {
                    String urlString = url.toString();
                    int lastSlash = urlString.lastIndexOf(47);
                    ruleCartridgeRootDir = urlString.substring(0, lastSlash);
                    ruleCartridgeManifestXml = this.cfEngine.getClass().getResourceAsStream(urlString);
                }
            }
        }
        if (ruleCartridgeManifestXml == null) {
            throw new RuntimeException(new FileNotFoundException("Could not locate Rule Cartridge \"" + cartridgeName + "\""));
        }
        try {
            this.parse(ruleCartridgeManifestXml, ruleCartridgeRootDir);
        }
        finally {
            try {
                ruleCartridgeManifestXml.close();
            }
            catch (Exception e) {
                throw new RuntimeException(this.getLocationInfo() + "Could not close Rule Cartridge \"" + cartridgeName + "\"", e);
            }
        }
    }

    public static String[] getToolSetNames() {
        int numElts = toolSetNames.size();
        if (numElts <= 0) {
            return null;
        }
        String[] retval = new String[numElts];
        for (int idx = 0; idx < numElts; ++idx) {
            retval[idx] = new String((String)toolSetNames.get(idx));
        }
        return retval;
    }

    public static void resetToolSetNames() {
        toolSetNames.clear();
    }

    public static String addToolSetName(String name) {
        String ret2;
        assert (name != null);
        for (String ret2 : toolSetNames) {
            if (!name.equals(ret2)) continue;
            return ret2;
        }
        ret2 = new String(name);
        toolSetNames.add(ret2);
        return ret2;
    }

    public static String[] getRuleCartridgeNames() {
        int numElts = ruleCartridgeNames.size();
        if (numElts <= 0) {
            return null;
        }
        String[] retval = new String[numElts];
        for (int idx = 0; idx < numElts; ++idx) {
            retval[idx] = new String((String)ruleCartridgeNames.get(idx));
        }
        return retval;
    }

    public static void resetRuleCartridgeNames() {
        ruleCartridgeNames.clear();
    }

    public static String addRuleCartridgeName(String name) {
        String ret2;
        assert (name != null);
        for (String ret2 : ruleCartridgeNames.keySet()) {
            if (!name.equals(ret2)) continue;
            return ret2;
        }
        ret2 = new String(name);
        ruleCartridgeNames.put(ret2, ret2);
        return ret2;
    }

    public static boolean isRuleCartridgeNameLoaded(String name) {
        return ruleCartridgeNames.containsKey(name);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        String documentRootDir = this.getDocumentRootDir();
        if (documentRootDir != null) {
            this.getLog().message("Loading Rule Cartridge from document directory \"" + documentRootDir + "\"\n");
        } else {
            this.getLog().message("ERROR: Rule Cartridge document directory could not be determined\n");
        }
    }

    protected void parse(String uri) {
        assert (uri != null && uri.length() > 0) : "uri (parm 1) is null or empty";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(uri, (DefaultHandler)((Object)this));
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (FileNotFoundException e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Could not find file \"" + uri + "\"\n");
            }
            CFLib.beep();
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            CFLib.beep();
        }
    }

    protected void parse(InputStream inputStream) {
        assert (inputStream != null) : "inputStream (arg 1) is null";
        assert (this.saxParser != null) : "Parser must be initialized first";
        try {
            this.saxParser.reset();
            this.saxParser.parse(inputStream, (DefaultHandler)((Object)this));
        }
        catch (SAXParseException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored SAXParseException exception " + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested == null) {
                nested = e;
            }
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parse() Ignored exception " + this.getFormattedNearLocation() + nested.getClass().getName() + " " + nested.getMessage() + "\n");
            }
            CFLib.beep();
        }
        catch (Exception e) {
            if (this.getLog() != null) {
                this.getLog().message("CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            } else {
                System.err.append("ERROR: CFLibXmlCoreSaxParser.parser() Ignored exception " + this.getFormattedNearLocation() + e.getClass().getName() + " " + e.getMessage() + "\n");
            }
            CFLib.beep();
        }
    }

    class ToolSetHandler
    extends CFLibXmlCoreElementHandler {
        public ToolSetHandler(MssCFRuleCartridgeParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("START ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\"");
                } else {
                    buff.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff.append("\n\tAttribute[" + idxAttr + "] localName=");
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff.append("\"" + attrQName + "\", type=");
                    } else {
                        buff.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff.append("\"" + attrType + "\", value=");
                    } else {
                        buff.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff.append("null");
                }
                buff.append('\n');
                debugLogger.debug((Object)buff.toString());
            }
            String attrName = null;
            assert (qName.equals("ToolSet"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            String toolSetDocRoot = new String(MssCFRuleCartridgeParser.this.getDocumentRootDir() + attrName + "/");
            String toolSetManifestName = new String(toolSetDocRoot + "toolset.xml");
            InputStream toolSetManifestXml = null;
            if (toolSetDocRoot.startsWith("jar:")) {
                try {
                    URL url = new URL(toolSetManifestName);
                    if (url != null && (toolSetManifestXml = url.openStream()) == null) {
                        toolSetManifestName = null;
                        toolSetDocRoot = null;
                    }
                }
                catch (MalformedURLException e) {
                    toolSetManifestXml = null;
                    toolSetManifestName = null;
                    toolSetDocRoot = null;
                }
                catch (IOException e) {
                    toolSetManifestXml = null;
                    toolSetManifestName = null;
                    toolSetDocRoot = null;
                }
            } else {
                try {
                    toolSetManifestXml = new FileInputStream(toolSetManifestName);
                }
                catch (FileNotFoundException e) {
                    toolSetManifestXml = null;
                    this.getLog().message("ERROR: \tCould not find ToolSet manifest \"" + toolSetManifestName + "\"\n");
                    CFLib.beep();
                    return;
                }
            }
            try {
                MssCFRuleCartridgeParser.addToolSetName(MssCFSaxParser.getInternalToolSetName(attrName));
                MssCFRuleCartridgeParser.this.toolSetParser.setLog(this.getLog());
                MssCFRuleCartridgeParser.this.toolSetParser.parse(toolSetManifestXml, toolSetDocRoot);
            }
            catch (Exception e) {
                this.getLog().message("ERROR: " + MssCFRuleCartridgeParser.this.getLocationInfo() + "\tCould not load ToolSet \"" + attrName + "\"\n");
                CFLib.beep();
            }
            finally {
                if (toolSetManifestXml != null) {
                    try {
                        toolSetManifestXml.close();
                    }
                    catch (Exception exception) {}
                    toolSetManifestXml = null;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
        }
    }

    class ToolHandler
    extends CFLibXmlCoreElementHandler {
        public ToolHandler(MssCFRuleCartridgeParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            StringBuffer buff;
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff2 = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff2.length() > 0) {
                    buff2.append(": ");
                }
                buff2.append("START ELEMENT localName=");
                if (localName != null) {
                    buff2.append("\"" + localName + "\", qName=");
                } else {
                    buff2.append("null, qName=");
                }
                if (qName != null) {
                    buff2.append("\"" + qName + "\"");
                } else {
                    buff2.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff2.append("\n\tAttribute[" + idxAttr + "] localName=");
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff2.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff2.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff2.append("\"" + attrQName + "\", type=");
                    } else {
                        buff2.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff2.append("\"" + attrType + "\", value=");
                    } else {
                        buff2.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff2.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff2.append("null");
                }
                buff2.append('\n');
                debugLogger.debug((Object)buff2.toString());
            }
            String attrName = null;
            String attrReplaces = null;
            assert (qName.equals("Tool"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Replaces")) {
                    assert (attrReplaces == null) : "Duplicate attribute \"Replaces\" detected";
                    attrReplaces = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            ICFGenKbToolObj tool = MssCFRuleCartridgeParser.this.getEngine().getToolTableObj().readToolByNameIdx(attrName);
            if (tool != null) {
                buff = new StringBuffer("\tEnabled Tool \"");
            } else {
                tool = MssCFRuleCartridgeParser.this.getEngine().defineTool(attrName);
                buff = new StringBuffer("\tDefined Tool \"");
            }
            buff.append(attrName);
            buff.append('\"');
            if (attrReplaces != null && attrReplaces.length() > 0) {
                buff.append(" replaces \"");
                buff.append(attrReplaces);
                buff.append("\"\n");
            } else {
                buff.append('\n');
            }
            this.getLog().message(buff.toString());
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
        }
    }

    class UseCartridgeHandler
    extends CFLibXmlCoreElementHandler {
        public UseCartridgeHandler(MssCFRuleCartridgeParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("START ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\"");
                } else {
                    buff.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff.append("\n\tAttribute[" + idxAttr + "] localName=");
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff.append("\"" + attrQName + "\", type=");
                    } else {
                        buff.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff.append("\"" + attrType + "\", value=");
                    } else {
                        buff.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff.append("null");
                }
                buff.append('\n');
                debugLogger.debug((Object)buff.toString());
            }
            String attrName = null;
            assert (qName.equals("UseCartridge"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            if (!MssCFRuleCartridgeParser.isRuleCartridgeNameLoaded(attrName)) {
                MssCFRuleCartridgeParser subParser = new MssCFRuleCartridgeParser(MssCFRuleCartridgeParser.this.getEngine(), this.getLog());
                subParser.loadRuleCartridge(attrName);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
        }
    }

    class RuleCartridgeHandler
    extends CFLibXmlCoreElementHandler {
        public RuleCartridgeHandler(MssCFRuleCartridgeParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
            this.addElementHandler("UseCartridge", new UseCartridgeHandler(coreParser));
            this.addElementHandler("Tool", new ToolHandler(coreParser));
            this.addElementHandler("ToolSet", new ToolSetHandler(coreParser));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String attrLocalName;
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("START ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\"");
                } else {
                    buff.append("null");
                }
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    buff.append("\n\tAttribute[" + idxAttr + "] localName=");
                    attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName != null) {
                        buff.append("\"" + attrLocalName + "\", qName=");
                    } else {
                        buff.append("null, qName=");
                    }
                    String attrQName = attrs.getQName(idxAttr);
                    if (attrQName != null) {
                        buff.append("\"" + attrQName + "\", type=");
                    } else {
                        buff.append("null, type=");
                    }
                    String attrType = attrs.getType(idxAttr);
                    if (attrType != null) {
                        buff.append("\"" + attrType + "\", value=");
                    } else {
                        buff.append("null, value=");
                    }
                    String attrValue = attrs.getValue(idxAttr);
                    if (attrValue != null) {
                        buff.append("\"" + attrValue + "\"");
                        continue;
                    }
                    buff.append("null");
                }
                buff.append('\n');
                debugLogger.debug((Object)buff.toString());
            }
            String attrName = null;
            String attrRevision = null;
            String attrDescr = null;
            assert (qName.equals("RuleCartridge"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Name")) {
                    assert (attrName == null) : "Duplicate attribute \"Name\" detected";
                    attrName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Revision")) {
                    assert (attrRevision == null) : "Duplicate attribute \"Revision\" detected";
                    attrRevision = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("Descr")) {
                    assert (attrDescr == null) : "Duplicate attribute \"Descr\" detected";
                    attrDescr = attrs.getValue(idxAttr);
                    continue;
                }
                if (!attrLocalName.equals("schemaLocation")) assert (false) : "Unrecognized attribute \"" + attrLocalName + "\"";
            }
            assert (attrName != null && attrName.length() > 0) : "Missing attribute \"Name\"";
            assert (attrRevision != null && attrRevision.length() > 0) : "Missing attribute \"Revision\"";
            assert (attrDescr != null && attrDescr.length() > 0) : "Missing attribute \"Descr\"";
            this.getLog().message("Loading RuleCartridge Name=\"" + attrName + "\", Revision = \"" + attrRevision + "\", Descr=\"" + attrDescr + "\"\n");
            MssCFRuleCartridgeParser.addRuleCartridgeName(attrName);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (debugLogger.getLevel() != null && debugLogger.getLevel().toInt() >= Level.DEBUG.toInt() && debugLogger.isDebugEnabled()) {
                StringBuffer buff = this.getParser().appendLocatorInformation(new StringBuffer());
                if (buff.length() > 0) {
                    buff.append(": ");
                }
                buff.append("END ELEMENT localName=");
                if (localName != null) {
                    buff.append("\"" + localName + "\", qName=");
                } else {
                    buff.append("null, qName=");
                }
                if (qName != null) {
                    buff.append("\"" + qName + "\", text=");
                } else {
                    buff.append("null, text=");
                }
                String text = this.getParser().getCurContext().getElementText();
                if (text != null) {
                    buff.append('\"');
                    buff.append(text);
                    buff.append("\"\n");
                } else {
                    buff.append("null\n");
                }
                debugLogger.debug((Object)buff.toString());
            }
        }
    }

    class RootHandler
    extends CFLibXmlCoreElementHandler {
        public RootHandler(MssCFRuleCartridgeParser coreParser) {
            super((CFLibXmlCoreParser)coreParser);
            this.addElementHandler("RuleCartridge", new RuleCartridgeHandler(coreParser));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

