/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.MssCF;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Calendar;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;

public class MssCFMessageLogWrapper
implements ICFLibMessageLog {
    private StringBuffer backlog = new StringBuffer();
    private PrintStream logFile = null;
    private int indent = 0;

    public int getMessageLogIndent() {
        return this.indent;
    }

    public synchronized void dedent() {
        this.indent = this.indent > 0 ? --this.indent : 0;
    }

    public synchronized void indent() {
        ++this.indent;
    }

    public PrintStream getPrintStream() {
        return this.logFile;
    }

    public synchronized void message(String msg) {
        if (msg == null) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        String stamp = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL ", cal);
        buff.append(stamp);
        for (int i = 0; i < this.indent; ++i) {
            buff.append("\t");
        }
        buff.append(msg);
        if (!msg.endsWith("\n")) {
            buff.append("\n");
        }
        boolean wroteSomewhere = false;
        if (this.backlog != null) {
            this.backlog.append(buff.toString());
        }
        if (this.logFile != null) {
            if (this.backlog != null) {
                if (this.backlog.length() > 0) {
                    this.logFile.append(this.backlog.toString());
                }
                this.backlog = null;
            }
            this.logFile.append(buff.toString());
            this.logFile.flush();
        }
        if (!wroteSomewhere) {
            System.out.append(buff.toString());
            System.out.flush();
        }
    }

    public String getBacklog() {
        String retval = this.backlog != null ? this.backlog.toString() : null;
        return retval;
    }

    public void openLogFile(String fileName) throws FileNotFoundException {
        assert (fileName != null && fileName.length() > 0) : "File name must be specified";
        assert (this.logFile == null) : "Log file is already open";
        this.logFile = new PrintStream(fileName);
    }

    public void closeLogFile() {
        if (this.logFile != null) {
            PrintStream old = this.logFile;
            this.logFile = null;
            old.flush();
            old.close();
        }
    }
}

