/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbAuthorization;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbCursor;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCountryLanguageBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOLanguageBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOLanguageByCode2IdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOLanguageByCode3IdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOLanguagePKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbISOLanguageTable;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbSchema;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam.CFGenKbRamISOLanguageCursor;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFGenKbRamISOLanguageTable
implements ICFGenKbISOLanguageTable {
    private ICFGenKbSchema schema;
    private Map<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff> dictByPKey = new HashMap<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff>();
    private Map<CFGenKbISOLanguageByCode3IdxKey, CFGenKbISOLanguageBuff> dictByCode3Idx = new HashMap<CFGenKbISOLanguageByCode3IdxKey, CFGenKbISOLanguageBuff>();
    private Map<CFGenKbISOLanguageByCode2IdxKey, Map<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff>> dictByCode2Idx = new HashMap<CFGenKbISOLanguageByCode2IdxKey, Map<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff>>();

    public CFGenKbRamISOLanguageTable(ICFGenKbSchema argSchema) {
        this.schema = argSchema;
    }

    @Override
    public void createISOLanguage(CFGenKbAuthorization Authorization, CFGenKbISOLanguageBuff Buff) {
        Map<Object, Object> subdictCode2Idx;
        String S_ProcName = "createISOLanguage";
        CFGenKbISOLanguagePKey pkey = this.schema.getFactoryISOLanguage().newPKey();
        pkey.setRequiredISOLanguageId(this.schema.nextISOLanguageIdGen());
        Buff.setRequiredISOLanguageId(pkey.getRequiredISOLanguageId());
        CFGenKbISOLanguageByCode3IdxKey keyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        keyCode3Idx.setRequiredISO6392Code(Buff.getRequiredISO6392Code());
        CFGenKbISOLanguageByCode2IdxKey keyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        keyCode2Idx.setOptionalISO6391Code(Buff.getOptionalISO6391Code());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createISOLanguage", (Object)pkey);
        }
        if (this.dictByCode3Idx.containsKey(keyCode3Idx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOLanguage", "ISOLanguage6392Idx", (Object)keyCode3Idx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByCode3Idx.put(keyCode3Idx, Buff);
        if (this.dictByCode2Idx.containsKey(keyCode2Idx)) {
            subdictCode2Idx = this.dictByCode2Idx.get(keyCode2Idx);
        } else {
            subdictCode2Idx = new HashMap();
            this.dictByCode2Idx.put(keyCode2Idx, subdictCode2Idx);
        }
        subdictCode2Idx.put(pkey, Buff);
    }

    @Override
    public CFGenKbISOLanguageBuff readDerived(CFGenKbAuthorization Authorization, CFGenKbISOLanguagePKey PKey) {
        String S_ProcName = "CFGenKbRamISOLanguage.readDerived";
        CFGenKbISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(PKey.getRequiredISOLanguageId());
        CFGenKbISOLanguageBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOLanguageBuff lockDerived(CFGenKbAuthorization Authorization, CFGenKbISOLanguagePKey PKey) {
        String S_ProcName = "CFGenKbRamISOLanguage.readDerived";
        CFGenKbISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(PKey.getRequiredISOLanguageId());
        CFGenKbISOLanguageBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOLanguageBuff[] readAllDerived(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamISOLanguage.readAllDerived";
        CFGenKbISOLanguageBuff[] retList = new CFGenKbISOLanguageBuff[this.dictByPKey.values().size()];
        Iterator<CFGenKbISOLanguageBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    @Override
    public CFGenKbISOLanguageBuff readDerivedByCode3Idx(CFGenKbAuthorization Authorization, String ISO6392Code) {
        String S_ProcName = "CFGenKbRamISOLanguage.readDerivedByCode3Idx";
        CFGenKbISOLanguageByCode3IdxKey key = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        key.setRequiredISO6392Code(ISO6392Code);
        CFGenKbISOLanguageBuff buff = this.dictByCode3Idx.containsKey(key) ? this.dictByCode3Idx.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOLanguageBuff[] readDerivedByCode2Idx(CFGenKbAuthorization Authorization, String ISO6391Code) {
        CFGenKbISOLanguageBuff[] recArray;
        String S_ProcName = "CFGenKbRamISOLanguage.readDerivedByCode2Idx";
        CFGenKbISOLanguageByCode2IdxKey key = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        key.setOptionalISO6391Code(ISO6391Code);
        if (this.dictByCode2Idx.containsKey(key)) {
            Map<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff> subdictCode2Idx = this.dictByCode2Idx.get(key);
            recArray = new CFGenKbISOLanguageBuff[subdictCode2Idx.size()];
            Iterator<CFGenKbISOLanguageBuff> iter = subdictCode2Idx.values().iterator();
            int idx = 0;
            while (iter.hasNext()) {
                recArray[idx++] = iter.next();
            }
        } else {
            HashMap subdictCode2Idx = new HashMap();
            this.dictByCode2Idx.put(key, subdictCode2Idx);
            recArray = new CFGenKbISOLanguageBuff[]{};
        }
        return recArray;
    }

    @Override
    public CFGenKbISOLanguageBuff readDerivedByIdIdx(CFGenKbAuthorization Authorization, short ISOLanguageId) {
        String S_ProcName = "CFGenKbRamISOLanguage.readDerivedByIdIdx() ";
        CFGenKbISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(ISOLanguageId);
        CFGenKbISOLanguageBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOLanguageBuff readBuff(CFGenKbAuthorization Authorization, CFGenKbISOLanguagePKey PKey) {
        String S_ProcName = "CFGenKbRamISOLanguage.readBuff";
        CFGenKbISOLanguageBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISLN")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbISOLanguageBuff lockBuff(CFGenKbAuthorization Authorization, CFGenKbISOLanguagePKey PKey) {
        String S_ProcName = "lockBuff";
        CFGenKbISOLanguageBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISLN")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbISOLanguageBuff[] readAllBuff(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamISOLanguage.readAllBuff";
        ArrayList<CFGenKbISOLanguageBuff> filteredList = new ArrayList<CFGenKbISOLanguageBuff>();
        CFGenKbISOLanguageBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFGenKbISOLanguageBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISLN")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFGenKbISOLanguageBuff[0]);
    }

    @Override
    public CFGenKbISOLanguageBuff readBuffByIdIdx(CFGenKbAuthorization Authorization, short ISOLanguageId) {
        String S_ProcName = "CFGenKbRamISOLanguage.readBuffByIdIdx() ";
        CFGenKbISOLanguageBuff buff = this.readDerivedByIdIdx(Authorization, ISOLanguageId);
        if (buff != null && buff.getClassCode().equals("ISLN")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbISOLanguageBuff readBuffByCode3Idx(CFGenKbAuthorization Authorization, String ISO6392Code) {
        String S_ProcName = "CFGenKbRamISOLanguage.readBuffByCode3Idx() ";
        CFGenKbISOLanguageBuff buff = this.readDerivedByCode3Idx(Authorization, ISO6392Code);
        if (buff != null && buff.getClassCode().equals("ISLN")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbISOLanguageBuff[] readBuffByCode2Idx(CFGenKbAuthorization Authorization, String ISO6391Code) {
        String S_ProcName = "CFGenKbRamISOLanguage.readBuffByCode2Idx() ";
        ArrayList<CFGenKbISOLanguageBuff> filteredList = new ArrayList<CFGenKbISOLanguageBuff>();
        CFGenKbISOLanguageBuff[] buffList = this.readDerivedByCode2Idx(Authorization, ISO6391Code);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFGenKbISOLanguageBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISLN")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFGenKbISOLanguageBuff[0]);
    }

    @Override
    public void updateISOLanguage(CFGenKbAuthorization Authorization, CFGenKbISOLanguageBuff Buff) {
        CFGenKbISOLanguagePKey pkey = this.schema.getFactoryISOLanguage().newPKey();
        pkey.setRequiredISOLanguageId(Buff.getRequiredISOLanguageId());
        CFGenKbISOLanguageBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateISOLanguage", "Existing record not found", "ISOLanguage", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateISOLanguage", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFGenKbISOLanguageByCode3IdxKey existingKeyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        existingKeyCode3Idx.setRequiredISO6392Code(existing.getRequiredISO6392Code());
        CFGenKbISOLanguageByCode3IdxKey newKeyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        newKeyCode3Idx.setRequiredISO6392Code(Buff.getRequiredISO6392Code());
        CFGenKbISOLanguageByCode2IdxKey existingKeyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        existingKeyCode2Idx.setOptionalISO6391Code(existing.getOptionalISO6391Code());
        CFGenKbISOLanguageByCode2IdxKey newKeyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        newKeyCode2Idx.setOptionalISO6391Code(Buff.getOptionalISO6391Code());
        if (!existingKeyCode3Idx.equals(newKeyCode3Idx) && this.dictByCode3Idx.containsKey(newKeyCode3Idx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOLanguage", "ISOLanguage6392Idx", (Object)newKeyCode3Idx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByCode3Idx.remove(existingKeyCode3Idx);
        this.dictByCode3Idx.put(newKeyCode3Idx, Buff);
        Map<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff> subdict = this.dictByCode2Idx.get(existingKeyCode2Idx);
        if (subdict != null) {
            subdict.remove(pkey);
        }
        if (this.dictByCode2Idx.containsKey(newKeyCode2Idx)) {
            subdict = this.dictByCode2Idx.get(newKeyCode2Idx);
        } else {
            subdict = new HashMap<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff>();
            this.dictByCode2Idx.put(newKeyCode2Idx, subdict);
        }
        subdict.put(pkey, Buff);
    }

    @Override
    public void deleteISOLanguage(CFGenKbAuthorization Authorization, CFGenKbISOLanguageBuff Buff) {
        String S_ProcName = "CFGenKbRamISOLanguageTable.deleteISOLanguage() ";
        CFGenKbISOLanguagePKey pkey = this.schema.getFactoryISOLanguage().newPKey();
        pkey.setRequiredISOLanguageId(Buff.getRequiredISOLanguageId());
        CFGenKbISOLanguageBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteISOLanguage", (Object)pkey);
        }
        CFGenKbISOCountryLanguageBuff[] arrCheckISOLanguageCountries = this.schema.getTableISOCountryLanguage().readDerivedByLanguageIdx(Authorization, existing.getRequiredISOLanguageId());
        if (arrCheckISOLanguageCountries.length > 0) {
            this.schema.getTableISOCountryLanguage().deleteISOCountryLanguageByLanguageIdx(Authorization, existing.getRequiredISOLanguageId());
        }
        CFGenKbISOLanguageByCode3IdxKey keyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        keyCode3Idx.setRequiredISO6392Code(existing.getRequiredISO6392Code());
        CFGenKbISOLanguageByCode2IdxKey keyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        keyCode2Idx.setOptionalISO6391Code(existing.getOptionalISO6391Code());
        this.dictByPKey.remove(pkey);
        this.dictByCode3Idx.remove(keyCode3Idx);
        Map<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff> subdict = this.dictByCode2Idx.get(keyCode2Idx);
        subdict.remove(pkey);
    }

    @Override
    public void deleteISOLanguageByIdIdx(CFGenKbAuthorization Authorization, short argISOLanguageId) {
        CFGenKbISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(argISOLanguageId);
        this.deleteISOLanguageByIdIdx(Authorization, key);
    }

    @Override
    public void deleteISOLanguageByIdIdx(CFGenKbAuthorization Authorization, CFGenKbISOLanguagePKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOLanguageBuff> matchSet = new LinkedList<CFGenKbISOLanguageBuff>();
        for (CFGenKbISOLanguageBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOLanguageBuff cur : matchSet) {
            cur = this.schema.getTableISOLanguage().readDerivedByIdIdx(Authorization, cur.getRequiredISOLanguageId());
            this.deleteISOLanguage(Authorization, cur);
        }
    }

    @Override
    public void deleteISOLanguageByCode3Idx(CFGenKbAuthorization Authorization, String argISO6392Code) {
        CFGenKbISOLanguageByCode3IdxKey key = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        key.setRequiredISO6392Code(argISO6392Code);
        this.deleteISOLanguageByCode3Idx(Authorization, key);
    }

    @Override
    public void deleteISOLanguageByCode3Idx(CFGenKbAuthorization Authorization, CFGenKbISOLanguageByCode3IdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOLanguageBuff> matchSet = new LinkedList<CFGenKbISOLanguageBuff>();
        for (CFGenKbISOLanguageBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOLanguageBuff cur : matchSet) {
            cur = this.schema.getTableISOLanguage().readDerivedByIdIdx(Authorization, cur.getRequiredISOLanguageId());
            this.deleteISOLanguage(Authorization, cur);
        }
    }

    @Override
    public void deleteISOLanguageByCode2Idx(CFGenKbAuthorization Authorization, String argISO6391Code) {
        CFGenKbISOLanguageByCode2IdxKey key = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        key.setOptionalISO6391Code(argISO6391Code);
        this.deleteISOLanguageByCode2Idx(Authorization, key);
    }

    @Override
    public void deleteISOLanguageByCode2Idx(CFGenKbAuthorization Authorization, CFGenKbISOLanguageByCode2IdxKey argKey) {
        boolean anyNotNull = false;
        if (argKey.getOptionalISO6391Code() != null) {
            anyNotNull = true;
        }
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOLanguageBuff> matchSet = new LinkedList<CFGenKbISOLanguageBuff>();
        for (CFGenKbISOLanguageBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOLanguageBuff cur : matchSet) {
            cur = this.schema.getTableISOLanguage().readDerivedByIdIdx(Authorization, cur.getRequiredISOLanguageId());
            this.deleteISOLanguage(Authorization, cur);
        }
    }

    @Override
    public CFGenKbCursor openISOLanguageCursorAll(CFGenKbAuthorization Authorization) {
        CFGenKbRamISOLanguageCursor cursor = new CFGenKbRamISOLanguageCursor(Authorization, this.schema, this.dictByPKey.values());
        return cursor;
    }

    @Override
    public CFGenKbCursor openISOLanguageCursorByCode2Idx(CFGenKbAuthorization Authorization, String ISO6391Code) {
        CFGenKbRamISOLanguageCursor cursor;
        CFGenKbISOLanguageByCode2IdxKey key = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        key.setOptionalISO6391Code(ISO6391Code);
        if (this.dictByCode2Idx.containsKey(key)) {
            Map<CFGenKbISOLanguagePKey, CFGenKbISOLanguageBuff> subdictCode2Idx = this.dictByCode2Idx.get(key);
            cursor = new CFGenKbRamISOLanguageCursor(Authorization, this.schema, subdictCode2Idx.values());
        } else {
            cursor = new CFGenKbRamISOLanguageCursor(Authorization, this.schema, new ArrayList<CFGenKbISOLanguageBuff>());
        }
        return cursor;
    }

    @Override
    public void closeISOLanguageCursor(CFGenKbCursor Cursor) {
    }

    @Override
    public CFGenKbISOLanguageBuff nextISOLanguageCursor(CFGenKbCursor Cursor) {
        CFGenKbRamISOLanguageCursor cursor = (CFGenKbRamISOLanguageCursor)Cursor;
        CFGenKbISOLanguageBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    @Override
    public CFGenKbISOLanguageBuff prevISOLanguageCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFGenKbISOLanguageBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOLanguageCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbISOLanguageBuff firstISOLanguageCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = 1;
        CFGenKbISOLanguageBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOLanguageCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbISOLanguageBuff lastISOLanguageCursor(CFGenKbCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastISOLanguageCursor");
    }

    @Override
    public CFGenKbISOLanguageBuff nthISOLanguageCursor(CFGenKbCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFGenKbISOLanguageBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOLanguageCursor(Cursor);
        }
        return rec;
    }

    @Override
    public void releasePreparedStatements() {
    }
}

