/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbAuthorization;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbCursor;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCountryCurrencyBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCurrencyBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCurrencyByCcyCdIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCurrencyByCcyNmIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCurrencyPKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbISOCurrencyTable;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbSchema;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam.CFGenKbRamISOCurrencyCursor;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFGenKbRamISOCurrencyTable
implements ICFGenKbISOCurrencyTable {
    private ICFGenKbSchema schema;
    private Map<CFGenKbISOCurrencyPKey, CFGenKbISOCurrencyBuff> dictByPKey = new HashMap<CFGenKbISOCurrencyPKey, CFGenKbISOCurrencyBuff>();
    private Map<CFGenKbISOCurrencyByCcyCdIdxKey, CFGenKbISOCurrencyBuff> dictByCcyCdIdx = new HashMap<CFGenKbISOCurrencyByCcyCdIdxKey, CFGenKbISOCurrencyBuff>();
    private Map<CFGenKbISOCurrencyByCcyNmIdxKey, CFGenKbISOCurrencyBuff> dictByCcyNmIdx = new HashMap<CFGenKbISOCurrencyByCcyNmIdxKey, CFGenKbISOCurrencyBuff>();

    public CFGenKbRamISOCurrencyTable(ICFGenKbSchema argSchema) {
        this.schema = argSchema;
    }

    @Override
    public void createISOCurrency(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyBuff Buff) {
        String S_ProcName = "createISOCurrency";
        CFGenKbISOCurrencyPKey pkey = this.schema.getFactoryISOCurrency().newPKey();
        pkey.setRequiredISOCurrencyId(this.schema.nextISOCurrencyIdGen());
        Buff.setRequiredISOCurrencyId(pkey.getRequiredISOCurrencyId());
        CFGenKbISOCurrencyByCcyCdIdxKey keyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        keyCcyCdIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFGenKbISOCurrencyByCcyNmIdxKey keyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        keyCcyNmIdx.setRequiredName(Buff.getRequiredName());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createISOCurrency", (Object)pkey);
        }
        if (this.dictByCcyCdIdx.containsKey(keyCcyCdIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCurrency", "ISOCurrencyCodeIdx", (Object)keyCcyCdIdx);
        }
        if (this.dictByCcyNmIdx.containsKey(keyCcyNmIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCurrency", "ISOCurrencyNameIdx", (Object)keyCcyNmIdx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByCcyCdIdx.put(keyCcyCdIdx, Buff);
        this.dictByCcyNmIdx.put(keyCcyNmIdx, Buff);
    }

    @Override
    public CFGenKbISOCurrencyBuff readDerived(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyPKey PKey) {
        String S_ProcName = "CFGenKbRamISOCurrency.readDerived";
        CFGenKbISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(PKey.getRequiredISOCurrencyId());
        CFGenKbISOCurrencyBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCurrencyBuff lockDerived(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyPKey PKey) {
        String S_ProcName = "CFGenKbRamISOCurrency.readDerived";
        CFGenKbISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(PKey.getRequiredISOCurrencyId());
        CFGenKbISOCurrencyBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCurrencyBuff[] readAllDerived(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamISOCurrency.readAllDerived";
        CFGenKbISOCurrencyBuff[] retList = new CFGenKbISOCurrencyBuff[this.dictByPKey.values().size()];
        Iterator<CFGenKbISOCurrencyBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    @Override
    public CFGenKbISOCurrencyBuff readDerivedByCcyCdIdx(CFGenKbAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFGenKbRamISOCurrency.readDerivedByCcyCdIdx";
        CFGenKbISOCurrencyByCcyCdIdxKey key = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        key.setRequiredISOCode(ISOCode);
        CFGenKbISOCurrencyBuff buff = this.dictByCcyCdIdx.containsKey(key) ? this.dictByCcyCdIdx.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCurrencyBuff readDerivedByCcyNmIdx(CFGenKbAuthorization Authorization, String Name) {
        String S_ProcName = "CFGenKbRamISOCurrency.readDerivedByCcyNmIdx";
        CFGenKbISOCurrencyByCcyNmIdxKey key = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        key.setRequiredName(Name);
        CFGenKbISOCurrencyBuff buff = this.dictByCcyNmIdx.containsKey(key) ? this.dictByCcyNmIdx.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCurrencyBuff readDerivedByIdIdx(CFGenKbAuthorization Authorization, short ISOCurrencyId) {
        String S_ProcName = "CFGenKbRamISOCurrency.readDerivedByIdIdx() ";
        CFGenKbISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(ISOCurrencyId);
        CFGenKbISOCurrencyBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCurrencyBuff readBuff(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyPKey PKey) {
        String S_ProcName = "CFGenKbRamISOCurrency.readBuff";
        CFGenKbISOCurrencyBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISCY")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbISOCurrencyBuff lockBuff(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyPKey PKey) {
        String S_ProcName = "lockBuff";
        CFGenKbISOCurrencyBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISCY")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbISOCurrencyBuff[] readAllBuff(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamISOCurrency.readAllBuff";
        ArrayList<CFGenKbISOCurrencyBuff> filteredList = new ArrayList<CFGenKbISOCurrencyBuff>();
        CFGenKbISOCurrencyBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFGenKbISOCurrencyBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISCY")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFGenKbISOCurrencyBuff[0]);
    }

    @Override
    public CFGenKbISOCurrencyBuff readBuffByIdIdx(CFGenKbAuthorization Authorization, short ISOCurrencyId) {
        String S_ProcName = "CFGenKbRamISOCurrency.readBuffByIdIdx() ";
        CFGenKbISOCurrencyBuff buff = this.readDerivedByIdIdx(Authorization, ISOCurrencyId);
        if (buff != null && buff.getClassCode().equals("ISCY")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbISOCurrencyBuff readBuffByCcyCdIdx(CFGenKbAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFGenKbRamISOCurrency.readBuffByCcyCdIdx() ";
        CFGenKbISOCurrencyBuff buff = this.readDerivedByCcyCdIdx(Authorization, ISOCode);
        if (buff != null && buff.getClassCode().equals("ISCY")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbISOCurrencyBuff readBuffByCcyNmIdx(CFGenKbAuthorization Authorization, String Name) {
        String S_ProcName = "CFGenKbRamISOCurrency.readBuffByCcyNmIdx() ";
        CFGenKbISOCurrencyBuff buff = this.readDerivedByCcyNmIdx(Authorization, Name);
        if (buff != null && buff.getClassCode().equals("ISCY")) {
            return buff;
        }
        return null;
    }

    @Override
    public void updateISOCurrency(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyBuff Buff) {
        CFGenKbISOCurrencyPKey pkey = this.schema.getFactoryISOCurrency().newPKey();
        pkey.setRequiredISOCurrencyId(Buff.getRequiredISOCurrencyId());
        CFGenKbISOCurrencyBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateISOCurrency", "Existing record not found", "ISOCurrency", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateISOCurrency", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFGenKbISOCurrencyByCcyCdIdxKey existingKeyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        existingKeyCcyCdIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFGenKbISOCurrencyByCcyCdIdxKey newKeyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        newKeyCcyCdIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFGenKbISOCurrencyByCcyNmIdxKey existingKeyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        existingKeyCcyNmIdx.setRequiredName(existing.getRequiredName());
        CFGenKbISOCurrencyByCcyNmIdxKey newKeyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        newKeyCcyNmIdx.setRequiredName(Buff.getRequiredName());
        if (!existingKeyCcyCdIdx.equals(newKeyCcyCdIdx) && this.dictByCcyCdIdx.containsKey(newKeyCcyCdIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCurrency", "ISOCurrencyCodeIdx", (Object)newKeyCcyCdIdx);
        }
        if (!existingKeyCcyNmIdx.equals(newKeyCcyNmIdx) && this.dictByCcyNmIdx.containsKey(newKeyCcyNmIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCurrency", "ISOCurrencyNameIdx", (Object)newKeyCcyNmIdx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByCcyCdIdx.remove(existingKeyCcyCdIdx);
        this.dictByCcyCdIdx.put(newKeyCcyCdIdx, Buff);
        this.dictByCcyNmIdx.remove(existingKeyCcyNmIdx);
        this.dictByCcyNmIdx.put(newKeyCcyNmIdx, Buff);
    }

    @Override
    public void deleteISOCurrency(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyBuff Buff) {
        String S_ProcName = "CFGenKbRamISOCurrencyTable.deleteISOCurrency() ";
        CFGenKbISOCurrencyPKey pkey = this.schema.getFactoryISOCurrency().newPKey();
        pkey.setRequiredISOCurrencyId(Buff.getRequiredISOCurrencyId());
        CFGenKbISOCurrencyBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteISOCurrency", (Object)pkey);
        }
        CFGenKbISOCountryCurrencyBuff[] arrCheckISOCurrencyCountries = this.schema.getTableISOCountryCurrency().readDerivedByCurrencyIdx(Authorization, existing.getRequiredISOCurrencyId());
        if (arrCheckISOCurrencyCountries.length > 0) {
            this.schema.getTableISOCountryCurrency().deleteISOCountryCurrencyByCurrencyIdx(Authorization, existing.getRequiredISOCurrencyId());
        }
        CFGenKbISOCurrencyByCcyCdIdxKey keyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        keyCcyCdIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFGenKbISOCurrencyByCcyNmIdxKey keyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        keyCcyNmIdx.setRequiredName(existing.getRequiredName());
        this.dictByPKey.remove(pkey);
        this.dictByCcyCdIdx.remove(keyCcyCdIdx);
        this.dictByCcyNmIdx.remove(keyCcyNmIdx);
    }

    @Override
    public void deleteISOCurrencyByIdIdx(CFGenKbAuthorization Authorization, short argISOCurrencyId) {
        CFGenKbISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(argISOCurrencyId);
        this.deleteISOCurrencyByIdIdx(Authorization, key);
    }

    @Override
    public void deleteISOCurrencyByIdIdx(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyPKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOCurrencyBuff> matchSet = new LinkedList<CFGenKbISOCurrencyBuff>();
        for (CFGenKbISOCurrencyBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOCurrencyBuff cur : matchSet) {
            cur = this.schema.getTableISOCurrency().readDerivedByIdIdx(Authorization, cur.getRequiredISOCurrencyId());
            this.deleteISOCurrency(Authorization, cur);
        }
    }

    @Override
    public void deleteISOCurrencyByCcyCdIdx(CFGenKbAuthorization Authorization, String argISOCode) {
        CFGenKbISOCurrencyByCcyCdIdxKey key = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        key.setRequiredISOCode(argISOCode);
        this.deleteISOCurrencyByCcyCdIdx(Authorization, key);
    }

    @Override
    public void deleteISOCurrencyByCcyCdIdx(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyByCcyCdIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOCurrencyBuff> matchSet = new LinkedList<CFGenKbISOCurrencyBuff>();
        for (CFGenKbISOCurrencyBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOCurrencyBuff cur : matchSet) {
            cur = this.schema.getTableISOCurrency().readDerivedByIdIdx(Authorization, cur.getRequiredISOCurrencyId());
            this.deleteISOCurrency(Authorization, cur);
        }
    }

    @Override
    public void deleteISOCurrencyByCcyNmIdx(CFGenKbAuthorization Authorization, String argName) {
        CFGenKbISOCurrencyByCcyNmIdxKey key = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        key.setRequiredName(argName);
        this.deleteISOCurrencyByCcyNmIdx(Authorization, key);
    }

    @Override
    public void deleteISOCurrencyByCcyNmIdx(CFGenKbAuthorization Authorization, CFGenKbISOCurrencyByCcyNmIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOCurrencyBuff> matchSet = new LinkedList<CFGenKbISOCurrencyBuff>();
        for (CFGenKbISOCurrencyBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOCurrencyBuff cur : matchSet) {
            cur = this.schema.getTableISOCurrency().readDerivedByIdIdx(Authorization, cur.getRequiredISOCurrencyId());
            this.deleteISOCurrency(Authorization, cur);
        }
    }

    @Override
    public CFGenKbCursor openISOCurrencyCursorAll(CFGenKbAuthorization Authorization) {
        CFGenKbRamISOCurrencyCursor cursor = new CFGenKbRamISOCurrencyCursor(Authorization, this.schema, this.dictByPKey.values());
        return cursor;
    }

    @Override
    public void closeISOCurrencyCursor(CFGenKbCursor Cursor) {
    }

    @Override
    public CFGenKbISOCurrencyBuff nextISOCurrencyCursor(CFGenKbCursor Cursor) {
        CFGenKbRamISOCurrencyCursor cursor = (CFGenKbRamISOCurrencyCursor)Cursor;
        CFGenKbISOCurrencyBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    @Override
    public CFGenKbISOCurrencyBuff prevISOCurrencyCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFGenKbISOCurrencyBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCurrencyCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbISOCurrencyBuff firstISOCurrencyCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = 1;
        CFGenKbISOCurrencyBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCurrencyCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbISOCurrencyBuff lastISOCurrencyCursor(CFGenKbCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastISOCurrencyCursor");
    }

    @Override
    public CFGenKbISOCurrencyBuff nthISOCurrencyCursor(CFGenKbCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFGenKbISOCurrencyBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCurrencyCursor(Cursor);
        }
        return rec;
    }

    @Override
    public void releasePreparedStatements() {
    }
}

