/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbAuthorization;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbCursor;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCountryBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCountryByISOCodeIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCountryByNameIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbISOCountryPKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbISOCountryTable;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbSchema;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam.CFGenKbRamISOCountryCursor;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFGenKbRamISOCountryTable
implements ICFGenKbISOCountryTable {
    private ICFGenKbSchema schema;
    private Map<CFGenKbISOCountryPKey, CFGenKbISOCountryBuff> dictByPKey = new HashMap<CFGenKbISOCountryPKey, CFGenKbISOCountryBuff>();
    private Map<CFGenKbISOCountryByISOCodeIdxKey, CFGenKbISOCountryBuff> dictByISOCodeIdx = new HashMap<CFGenKbISOCountryByISOCodeIdxKey, CFGenKbISOCountryBuff>();
    private Map<CFGenKbISOCountryByNameIdxKey, CFGenKbISOCountryBuff> dictByNameIdx = new HashMap<CFGenKbISOCountryByNameIdxKey, CFGenKbISOCountryBuff>();

    public CFGenKbRamISOCountryTable(ICFGenKbSchema argSchema) {
        this.schema = argSchema;
    }

    @Override
    public void createISOCountry(CFGenKbAuthorization Authorization, CFGenKbISOCountryBuff Buff) {
        String S_ProcName = "createISOCountry";
        CFGenKbISOCountryPKey pkey = this.schema.getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(this.schema.nextISOCountryIdGen());
        Buff.setRequiredISOCountryId(pkey.getRequiredISOCountryId());
        CFGenKbISOCountryByISOCodeIdxKey keyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        keyISOCodeIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFGenKbISOCountryByNameIdxKey keyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        keyNameIdx.setRequiredName(Buff.getRequiredName());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createISOCountry", (Object)pkey);
        }
        if (this.dictByISOCodeIdx.containsKey(keyISOCodeIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCountry", "ISOCountryCodeIdx", (Object)keyISOCodeIdx);
        }
        if (this.dictByNameIdx.containsKey(keyNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCountry", "ISOCountryNameIdx", (Object)keyNameIdx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByISOCodeIdx.put(keyISOCodeIdx, Buff);
        this.dictByNameIdx.put(keyNameIdx, Buff);
    }

    @Override
    public CFGenKbISOCountryBuff readDerived(CFGenKbAuthorization Authorization, CFGenKbISOCountryPKey PKey) {
        String S_ProcName = "CFGenKbRamISOCountry.readDerived";
        CFGenKbISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(PKey.getRequiredISOCountryId());
        CFGenKbISOCountryBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCountryBuff lockDerived(CFGenKbAuthorization Authorization, CFGenKbISOCountryPKey PKey) {
        String S_ProcName = "CFGenKbRamISOCountry.readDerived";
        CFGenKbISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(PKey.getRequiredISOCountryId());
        CFGenKbISOCountryBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCountryBuff[] readAllDerived(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamISOCountry.readAllDerived";
        CFGenKbISOCountryBuff[] retList = new CFGenKbISOCountryBuff[this.dictByPKey.values().size()];
        Iterator<CFGenKbISOCountryBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    @Override
    public CFGenKbISOCountryBuff readDerivedByISOCodeIdx(CFGenKbAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFGenKbRamISOCountry.readDerivedByISOCodeIdx";
        CFGenKbISOCountryByISOCodeIdxKey key = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        key.setRequiredISOCode(ISOCode);
        CFGenKbISOCountryBuff buff = this.dictByISOCodeIdx.containsKey(key) ? this.dictByISOCodeIdx.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCountryBuff readDerivedByNameIdx(CFGenKbAuthorization Authorization, String Name) {
        String S_ProcName = "CFGenKbRamISOCountry.readDerivedByNameIdx";
        CFGenKbISOCountryByNameIdxKey key = this.schema.getFactoryISOCountry().newNameIdxKey();
        key.setRequiredName(Name);
        CFGenKbISOCountryBuff buff = this.dictByNameIdx.containsKey(key) ? this.dictByNameIdx.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCountryBuff readDerivedByIdIdx(CFGenKbAuthorization Authorization, short ISOCountryId) {
        String S_ProcName = "CFGenKbRamISOCountry.readDerivedByIdIdx() ";
        CFGenKbISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(ISOCountryId);
        CFGenKbISOCountryBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbISOCountryBuff readBuff(CFGenKbAuthorization Authorization, CFGenKbISOCountryPKey PKey) {
        String S_ProcName = "CFGenKbRamISOCountry.readBuff";
        CFGenKbISOCountryBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISOC")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbISOCountryBuff lockBuff(CFGenKbAuthorization Authorization, CFGenKbISOCountryPKey PKey) {
        String S_ProcName = "lockBuff";
        CFGenKbISOCountryBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISOC")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbISOCountryBuff[] readAllBuff(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamISOCountry.readAllBuff";
        ArrayList<CFGenKbISOCountryBuff> filteredList = new ArrayList<CFGenKbISOCountryBuff>();
        CFGenKbISOCountryBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFGenKbISOCountryBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISOC")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFGenKbISOCountryBuff[0]);
    }

    @Override
    public CFGenKbISOCountryBuff readBuffByIdIdx(CFGenKbAuthorization Authorization, short ISOCountryId) {
        String S_ProcName = "CFGenKbRamISOCountry.readBuffByIdIdx() ";
        CFGenKbISOCountryBuff buff = this.readDerivedByIdIdx(Authorization, ISOCountryId);
        if (buff != null && buff.getClassCode().equals("ISOC")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbISOCountryBuff readBuffByISOCodeIdx(CFGenKbAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFGenKbRamISOCountry.readBuffByISOCodeIdx() ";
        CFGenKbISOCountryBuff buff = this.readDerivedByISOCodeIdx(Authorization, ISOCode);
        if (buff != null && buff.getClassCode().equals("ISOC")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbISOCountryBuff readBuffByNameIdx(CFGenKbAuthorization Authorization, String Name) {
        String S_ProcName = "CFGenKbRamISOCountry.readBuffByNameIdx() ";
        CFGenKbISOCountryBuff buff = this.readDerivedByNameIdx(Authorization, Name);
        if (buff != null && buff.getClassCode().equals("ISOC")) {
            return buff;
        }
        return null;
    }

    @Override
    public void updateISOCountry(CFGenKbAuthorization Authorization, CFGenKbISOCountryBuff Buff) {
        CFGenKbISOCountryPKey pkey = this.schema.getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(Buff.getRequiredISOCountryId());
        CFGenKbISOCountryBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateISOCountry", "Existing record not found", "ISOCountry", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateISOCountry", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFGenKbISOCountryByISOCodeIdxKey existingKeyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        existingKeyISOCodeIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFGenKbISOCountryByISOCodeIdxKey newKeyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        newKeyISOCodeIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFGenKbISOCountryByNameIdxKey existingKeyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        existingKeyNameIdx.setRequiredName(existing.getRequiredName());
        CFGenKbISOCountryByNameIdxKey newKeyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        newKeyNameIdx.setRequiredName(Buff.getRequiredName());
        if (!existingKeyISOCodeIdx.equals(newKeyISOCodeIdx) && this.dictByISOCodeIdx.containsKey(newKeyISOCodeIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCountry", "ISOCountryCodeIdx", (Object)newKeyISOCodeIdx);
        }
        if (!existingKeyNameIdx.equals(newKeyNameIdx) && this.dictByNameIdx.containsKey(newKeyNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCountry", "ISOCountryNameIdx", (Object)newKeyNameIdx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByISOCodeIdx.remove(existingKeyISOCodeIdx);
        this.dictByISOCodeIdx.put(newKeyISOCodeIdx, Buff);
        this.dictByNameIdx.remove(existingKeyNameIdx);
        this.dictByNameIdx.put(newKeyNameIdx, Buff);
    }

    @Override
    public void deleteISOCountry(CFGenKbAuthorization Authorization, CFGenKbISOCountryBuff Buff) {
        String S_ProcName = "CFGenKbRamISOCountryTable.deleteISOCountry() ";
        CFGenKbISOCountryPKey pkey = this.schema.getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(Buff.getRequiredISOCountryId());
        CFGenKbISOCountryBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteISOCountry", (Object)pkey);
        }
        this.schema.getTableISOCountryLanguage().deleteISOCountryLanguageByCountryIdx(Authorization, existing.getRequiredISOCountryId());
        this.schema.getTableISOCountryCurrency().deleteISOCountryCurrencyByCountryIdx(Authorization, existing.getRequiredISOCountryId());
        CFGenKbISOCountryByISOCodeIdxKey keyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        keyISOCodeIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFGenKbISOCountryByNameIdxKey keyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        keyNameIdx.setRequiredName(existing.getRequiredName());
        this.dictByPKey.remove(pkey);
        this.dictByISOCodeIdx.remove(keyISOCodeIdx);
        this.dictByNameIdx.remove(keyNameIdx);
    }

    @Override
    public void deleteISOCountryByIdIdx(CFGenKbAuthorization Authorization, short argISOCountryId) {
        CFGenKbISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(argISOCountryId);
        this.deleteISOCountryByIdIdx(Authorization, key);
    }

    @Override
    public void deleteISOCountryByIdIdx(CFGenKbAuthorization Authorization, CFGenKbISOCountryPKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOCountryBuff> matchSet = new LinkedList<CFGenKbISOCountryBuff>();
        for (CFGenKbISOCountryBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOCountryBuff cur : matchSet) {
            cur = this.schema.getTableISOCountry().readDerivedByIdIdx(Authorization, cur.getRequiredISOCountryId());
            this.deleteISOCountry(Authorization, cur);
        }
    }

    @Override
    public void deleteISOCountryByISOCodeIdx(CFGenKbAuthorization Authorization, String argISOCode) {
        CFGenKbISOCountryByISOCodeIdxKey key = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        key.setRequiredISOCode(argISOCode);
        this.deleteISOCountryByISOCodeIdx(Authorization, key);
    }

    @Override
    public void deleteISOCountryByISOCodeIdx(CFGenKbAuthorization Authorization, CFGenKbISOCountryByISOCodeIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOCountryBuff> matchSet = new LinkedList<CFGenKbISOCountryBuff>();
        for (CFGenKbISOCountryBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOCountryBuff cur : matchSet) {
            cur = this.schema.getTableISOCountry().readDerivedByIdIdx(Authorization, cur.getRequiredISOCountryId());
            this.deleteISOCountry(Authorization, cur);
        }
    }

    @Override
    public void deleteISOCountryByNameIdx(CFGenKbAuthorization Authorization, String argName) {
        CFGenKbISOCountryByNameIdxKey key = this.schema.getFactoryISOCountry().newNameIdxKey();
        key.setRequiredName(argName);
        this.deleteISOCountryByNameIdx(Authorization, key);
    }

    @Override
    public void deleteISOCountryByNameIdx(CFGenKbAuthorization Authorization, CFGenKbISOCountryByNameIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbISOCountryBuff> matchSet = new LinkedList<CFGenKbISOCountryBuff>();
        for (CFGenKbISOCountryBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbISOCountryBuff cur : matchSet) {
            cur = this.schema.getTableISOCountry().readDerivedByIdIdx(Authorization, cur.getRequiredISOCountryId());
            this.deleteISOCountry(Authorization, cur);
        }
    }

    @Override
    public CFGenKbCursor openISOCountryCursorAll(CFGenKbAuthorization Authorization) {
        CFGenKbRamISOCountryCursor cursor = new CFGenKbRamISOCountryCursor(Authorization, this.schema, this.dictByPKey.values());
        return cursor;
    }

    @Override
    public void closeISOCountryCursor(CFGenKbCursor Cursor) {
    }

    @Override
    public CFGenKbISOCountryBuff nextISOCountryCursor(CFGenKbCursor Cursor) {
        CFGenKbRamISOCountryCursor cursor = (CFGenKbRamISOCountryCursor)Cursor;
        CFGenKbISOCountryBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    @Override
    public CFGenKbISOCountryBuff prevISOCountryCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFGenKbISOCountryBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCountryCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbISOCountryBuff firstISOCountryCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = 1;
        CFGenKbISOCountryBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCountryCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbISOCountryBuff lastISOCountryCursor(CFGenKbCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastISOCountryCursor");
    }

    @Override
    public CFGenKbISOCountryBuff nthISOCountryCursor(CFGenKbCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFGenKbISOCountryBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCountryCursor(Cursor);
        }
        return rec;
    }

    @Override
    public void releasePreparedStatements() {
    }
}

