/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbAuthorization;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbClusterBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbClusterByUDescrIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbClusterByUDomainNameIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbClusterPKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbCursor;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbSecAppBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbSecGroupBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbClusterTable;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbSchema;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam.CFGenKbRamClusterCursor;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam.CFGenKbRamClusterId32Gen;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam.CFGenKbRamClusterId64Gen;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFGenKbRamClusterTable
implements ICFGenKbClusterTable {
    private ICFGenKbSchema schema;
    private Map<CFGenKbClusterPKey, CFGenKbClusterBuff> dictByPKey = new HashMap<CFGenKbClusterPKey, CFGenKbClusterBuff>();
    private Map<CFGenKbClusterByUDomainNameIdxKey, CFGenKbClusterBuff> dictByUDomainNameIdx = new HashMap<CFGenKbClusterByUDomainNameIdxKey, CFGenKbClusterBuff>();
    private Map<CFGenKbClusterByUDescrIdxKey, CFGenKbClusterBuff> dictByUDescrIdx = new HashMap<CFGenKbClusterByUDescrIdxKey, CFGenKbClusterBuff>();
    private Map<CFGenKbRamClusterId32Gen, CFGenKbRamClusterId32Gen> id32Generator = new HashMap<CFGenKbRamClusterId32Gen, CFGenKbRamClusterId32Gen>();
    private Map<CFGenKbRamClusterId64Gen, CFGenKbRamClusterId64Gen> id64Generator = new HashMap<CFGenKbRamClusterId64Gen, CFGenKbRamClusterId64Gen>();

    public CFGenKbRamClusterTable(ICFGenKbSchema argSchema) {
        this.schema = argSchema;
    }

    protected int generateNextId32(long argId, short argSliceId) {
        CFGenKbRamClusterId32Gen key = new CFGenKbRamClusterId32Gen();
        key.setRequiredId(argId);
        key.setRequiredSliceId(argSliceId);
        CFGenKbRamClusterId32Gen useGen = this.id32Generator.get(key);
        if (useGen == null) {
            this.id32Generator.put(key, key);
            useGen = key;
        }
        int retNext = useGen.getNextId();
        return retNext;
    }

    protected long generateNextId64(long argId, short argSliceId) {
        CFGenKbRamClusterId64Gen key = new CFGenKbRamClusterId64Gen();
        key.setRequiredId(argId);
        key.setRequiredSliceId(argSliceId);
        CFGenKbRamClusterId64Gen useGen = this.id64Generator.get(key);
        if (useGen == null) {
            this.id64Generator.put(key, key);
            useGen = key;
        }
        long retNext = useGen.getNextId();
        return retNext;
    }

    @Override
    public int nextSecAppIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        int retval = this.nextSecAppIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public int nextSecAppIdGen(CFGenKbAuthorization Authorization, long argId) {
        int retNext = this.generateNextId32(argId, (short)107);
        return retNext;
    }

    @Override
    public int nextSecFormIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        int retval = this.nextSecFormIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public int nextSecFormIdGen(CFGenKbAuthorization Authorization, long argId) {
        int retNext = this.generateNextId32(argId, (short)108);
        return retNext;
    }

    @Override
    public int nextSecGroupIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        int retval = this.nextSecGroupIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public int nextSecGroupIdGen(CFGenKbAuthorization Authorization, long argId) {
        int retNext = this.generateNextId32(argId, (short)109);
        return retNext;
    }

    @Override
    public long nextHostNodeIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        long retval = this.nextHostNodeIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public long nextHostNodeIdGen(CFGenKbAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)116);
        return retNext;
    }

    @Override
    public long nextSecGroupFormIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        long retval = this.nextSecGroupFormIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public long nextSecGroupFormIdGen(CFGenKbAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)112);
        return retNext;
    }

    @Override
    public long nextSecGroupIncludeIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        long retval = this.nextSecGroupIncludeIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public long nextSecGroupIncludeIdGen(CFGenKbAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)111);
        return retNext;
    }

    @Override
    public long nextSecGroupMemberIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        long retval = this.nextSecGroupMemberIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public long nextSecGroupMemberIdGen(CFGenKbAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)110);
        return retNext;
    }

    @Override
    public long nextServiceIdGen(CFGenKbAuthorization Authorization, CFGenKbClusterPKey pkey) {
        long retval = this.nextServiceIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    @Override
    public long nextServiceIdGen(CFGenKbAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)115);
        return retNext;
    }

    @Override
    public void createCluster(CFGenKbAuthorization Authorization, CFGenKbClusterBuff Buff) {
        String S_ProcName = "createCluster";
        CFGenKbClusterPKey pkey = this.schema.getFactoryCluster().newPKey();
        pkey.setRequiredId(this.schema.nextClusterIdGen());
        Buff.setRequiredId(pkey.getRequiredId());
        CFGenKbClusterByUDomainNameIdxKey keyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        keyUDomainNameIdx.setRequiredFullDomainName(Buff.getRequiredFullDomainName());
        CFGenKbClusterByUDescrIdxKey keyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        keyUDescrIdx.setRequiredDescription(Buff.getRequiredDescription());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createCluster", (Object)pkey);
        }
        if (this.dictByUDomainNameIdx.containsKey(keyUDomainNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createCluster", "ClusterUDomainNameIdx", (Object)keyUDomainNameIdx);
        }
        if (this.dictByUDescrIdx.containsKey(keyUDescrIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createCluster", "ClusterUDescrNameIdx", (Object)keyUDescrIdx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByUDomainNameIdx.put(keyUDomainNameIdx, Buff);
        this.dictByUDescrIdx.put(keyUDescrIdx, Buff);
    }

    @Override
    public CFGenKbClusterBuff readDerived(CFGenKbAuthorization Authorization, CFGenKbClusterPKey PKey) {
        String S_ProcName = "CFGenKbRamCluster.readDerived";
        CFGenKbClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(PKey.getRequiredId());
        CFGenKbClusterBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbClusterBuff lockDerived(CFGenKbAuthorization Authorization, CFGenKbClusterPKey PKey) {
        String S_ProcName = "CFGenKbRamCluster.readDerived";
        CFGenKbClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(PKey.getRequiredId());
        CFGenKbClusterBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbClusterBuff[] readAllDerived(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamCluster.readAllDerived";
        CFGenKbClusterBuff[] retList = new CFGenKbClusterBuff[this.dictByPKey.values().size()];
        Iterator<CFGenKbClusterBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    @Override
    public CFGenKbClusterBuff readDerivedByUDomainNameIdx(CFGenKbAuthorization Authorization, String FullDomainName) {
        String S_ProcName = "CFGenKbRamCluster.readDerivedByUDomainNameIdx";
        CFGenKbClusterByUDomainNameIdxKey key = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        key.setRequiredFullDomainName(FullDomainName);
        CFGenKbClusterBuff buff = this.dictByUDomainNameIdx.containsKey(key) ? this.dictByUDomainNameIdx.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbClusterBuff readDerivedByUDescrIdx(CFGenKbAuthorization Authorization, String Description) {
        String S_ProcName = "CFGenKbRamCluster.readDerivedByUDescrIdx";
        CFGenKbClusterByUDescrIdxKey key = this.schema.getFactoryCluster().newUDescrIdxKey();
        key.setRequiredDescription(Description);
        CFGenKbClusterBuff buff = this.dictByUDescrIdx.containsKey(key) ? this.dictByUDescrIdx.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbClusterBuff readDerivedByIdIdx(CFGenKbAuthorization Authorization, long Id) {
        String S_ProcName = "CFGenKbRamCluster.readDerivedByIdIdx() ";
        CFGenKbClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(Id);
        CFGenKbClusterBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    @Override
    public CFGenKbClusterBuff readBuff(CFGenKbAuthorization Authorization, CFGenKbClusterPKey PKey) {
        String S_ProcName = "CFGenKbRamCluster.readBuff";
        CFGenKbClusterBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("CLUS")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbClusterBuff lockBuff(CFGenKbAuthorization Authorization, CFGenKbClusterPKey PKey) {
        String S_ProcName = "lockBuff";
        CFGenKbClusterBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("CLUS")) {
            buff = null;
        }
        return buff;
    }

    @Override
    public CFGenKbClusterBuff[] readAllBuff(CFGenKbAuthorization Authorization) {
        String S_ProcName = "CFGenKbRamCluster.readAllBuff";
        ArrayList<CFGenKbClusterBuff> filteredList = new ArrayList<CFGenKbClusterBuff>();
        CFGenKbClusterBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFGenKbClusterBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("CLUS")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFGenKbClusterBuff[0]);
    }

    @Override
    public CFGenKbClusterBuff readBuffByIdIdx(CFGenKbAuthorization Authorization, long Id) {
        String S_ProcName = "CFGenKbRamCluster.readBuffByIdIdx() ";
        CFGenKbClusterBuff buff = this.readDerivedByIdIdx(Authorization, Id);
        if (buff != null && buff.getClassCode().equals("CLUS")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbClusterBuff readBuffByUDomainNameIdx(CFGenKbAuthorization Authorization, String FullDomainName) {
        String S_ProcName = "CFGenKbRamCluster.readBuffByUDomainNameIdx() ";
        CFGenKbClusterBuff buff = this.readDerivedByUDomainNameIdx(Authorization, FullDomainName);
        if (buff != null && buff.getClassCode().equals("CLUS")) {
            return buff;
        }
        return null;
    }

    @Override
    public CFGenKbClusterBuff readBuffByUDescrIdx(CFGenKbAuthorization Authorization, String Description) {
        String S_ProcName = "CFGenKbRamCluster.readBuffByUDescrIdx() ";
        CFGenKbClusterBuff buff = this.readDerivedByUDescrIdx(Authorization, Description);
        if (buff != null && buff.getClassCode().equals("CLUS")) {
            return buff;
        }
        return null;
    }

    @Override
    public void updateCluster(CFGenKbAuthorization Authorization, CFGenKbClusterBuff Buff) {
        CFGenKbClusterPKey pkey = this.schema.getFactoryCluster().newPKey();
        pkey.setRequiredId(Buff.getRequiredId());
        CFGenKbClusterBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateCluster", "Existing record not found", "Cluster", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateCluster", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFGenKbClusterByUDomainNameIdxKey existingKeyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        existingKeyUDomainNameIdx.setRequiredFullDomainName(existing.getRequiredFullDomainName());
        CFGenKbClusterByUDomainNameIdxKey newKeyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        newKeyUDomainNameIdx.setRequiredFullDomainName(Buff.getRequiredFullDomainName());
        CFGenKbClusterByUDescrIdxKey existingKeyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        existingKeyUDescrIdx.setRequiredDescription(existing.getRequiredDescription());
        CFGenKbClusterByUDescrIdxKey newKeyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        newKeyUDescrIdx.setRequiredDescription(Buff.getRequiredDescription());
        if (!existingKeyUDomainNameIdx.equals(newKeyUDomainNameIdx) && this.dictByUDomainNameIdx.containsKey(newKeyUDomainNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateCluster", "ClusterUDomainNameIdx", (Object)newKeyUDomainNameIdx);
        }
        if (!existingKeyUDescrIdx.equals(newKeyUDescrIdx) && this.dictByUDescrIdx.containsKey(newKeyUDescrIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateCluster", "ClusterUDescrNameIdx", (Object)newKeyUDescrIdx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByUDomainNameIdx.remove(existingKeyUDomainNameIdx);
        this.dictByUDomainNameIdx.put(newKeyUDomainNameIdx, Buff);
        this.dictByUDescrIdx.remove(existingKeyUDescrIdx);
        this.dictByUDescrIdx.put(newKeyUDescrIdx, Buff);
    }

    @Override
    public void deleteCluster(CFGenKbAuthorization Authorization, CFGenKbClusterBuff Buff) {
        String S_ProcName = "CFGenKbRamClusterTable.deleteCluster() ";
        CFGenKbClusterPKey pkey = this.schema.getFactoryCluster().newPKey();
        pkey.setRequiredId(Buff.getRequiredId());
        CFGenKbClusterBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteCluster", (Object)pkey);
        }
        CFGenKbSecGroupBuff[] arrDelSecGroupForms = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupForms = 0; idxDelSecGroupForms < arrDelSecGroupForms.length; ++idxDelSecGroupForms) {
            CFGenKbSecGroupBuff buffDelSecGroupForms = arrDelSecGroupForms[idxDelSecGroupForms];
            this.schema.getTableSecGroupForm().deleteSecGroupFormByGroupIdx(Authorization, buffDelSecGroupForms.getRequiredClusterId(), buffDelSecGroupForms.getRequiredSecGroupId());
        }
        CFGenKbSecGroupBuff[] arrDelSecGroupIncludedByGroup = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupIncludedByGroup = 0; idxDelSecGroupIncludedByGroup < arrDelSecGroupIncludedByGroup.length; ++idxDelSecGroupIncludedByGroup) {
            CFGenKbSecGroupBuff buffDelSecGroupIncludedByGroup = arrDelSecGroupIncludedByGroup[idxDelSecGroupIncludedByGroup];
            this.schema.getTableSecGroupInclude().deleteSecGroupIncludeByIncludeIdx(Authorization, buffDelSecGroupIncludedByGroup.getRequiredClusterId(), buffDelSecGroupIncludedByGroup.getRequiredSecGroupId());
        }
        CFGenKbSecGroupBuff[] arrDelSecGroupMembers = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupMembers = 0; idxDelSecGroupMembers < arrDelSecGroupMembers.length; ++idxDelSecGroupMembers) {
            CFGenKbSecGroupBuff buffDelSecGroupMembers = arrDelSecGroupMembers[idxDelSecGroupMembers];
            this.schema.getTableSecGroupMember().deleteSecGroupMemberByGroupIdx(Authorization, buffDelSecGroupMembers.getRequiredClusterId(), buffDelSecGroupMembers.getRequiredSecGroupId());
        }
        CFGenKbSecGroupBuff[] arrDelSecGroupIncludes = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupIncludes = 0; idxDelSecGroupIncludes < arrDelSecGroupIncludes.length; ++idxDelSecGroupIncludes) {
            CFGenKbSecGroupBuff buffDelSecGroupIncludes = arrDelSecGroupIncludes[idxDelSecGroupIncludes];
            this.schema.getTableSecGroupInclude().deleteSecGroupIncludeByGroupIdx(Authorization, buffDelSecGroupIncludes.getRequiredClusterId(), buffDelSecGroupIncludes.getRequiredSecGroupId());
        }
        this.schema.getTableSecGroup().deleteSecGroupByClusterIdx(Authorization, existing.getRequiredId());
        CFGenKbSecAppBuff[] arrDelSecAppForms = this.schema.getTableSecApp().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecAppForms = 0; idxDelSecAppForms < arrDelSecAppForms.length; ++idxDelSecAppForms) {
            CFGenKbSecAppBuff buffDelSecAppForms = arrDelSecAppForms[idxDelSecAppForms];
            this.schema.getTableSecForm().deleteSecFormBySecAppIdx(Authorization, buffDelSecAppForms.getRequiredClusterId(), buffDelSecAppForms.getRequiredSecAppId());
        }
        this.schema.getTableSecApp().deleteSecAppByClusterIdx(Authorization, existing.getRequiredId());
        this.schema.getTableTenant().deleteTenantByClusterIdx(Authorization, existing.getRequiredId());
        this.schema.getTableHostNode().deleteHostNodeByClusterIdx(Authorization, existing.getRequiredId());
        CFGenKbClusterByUDomainNameIdxKey keyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        keyUDomainNameIdx.setRequiredFullDomainName(existing.getRequiredFullDomainName());
        CFGenKbClusterByUDescrIdxKey keyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        keyUDescrIdx.setRequiredDescription(existing.getRequiredDescription());
        this.dictByPKey.remove(pkey);
        this.dictByUDomainNameIdx.remove(keyUDomainNameIdx);
        this.dictByUDescrIdx.remove(keyUDescrIdx);
    }

    @Override
    public void deleteClusterByIdIdx(CFGenKbAuthorization Authorization, long argId) {
        CFGenKbClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(argId);
        this.deleteClusterByIdIdx(Authorization, key);
    }

    @Override
    public void deleteClusterByIdIdx(CFGenKbAuthorization Authorization, CFGenKbClusterPKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbClusterBuff> matchSet = new LinkedList<CFGenKbClusterBuff>();
        for (CFGenKbClusterBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbClusterBuff cur : matchSet) {
            cur = this.schema.getTableCluster().readDerivedByIdIdx(Authorization, cur.getRequiredId());
            this.deleteCluster(Authorization, cur);
        }
    }

    @Override
    public void deleteClusterByUDomainNameIdx(CFGenKbAuthorization Authorization, String argFullDomainName) {
        CFGenKbClusterByUDomainNameIdxKey key = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        key.setRequiredFullDomainName(argFullDomainName);
        this.deleteClusterByUDomainNameIdx(Authorization, key);
    }

    @Override
    public void deleteClusterByUDomainNameIdx(CFGenKbAuthorization Authorization, CFGenKbClusterByUDomainNameIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbClusterBuff> matchSet = new LinkedList<CFGenKbClusterBuff>();
        for (CFGenKbClusterBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbClusterBuff cur : matchSet) {
            cur = this.schema.getTableCluster().readDerivedByIdIdx(Authorization, cur.getRequiredId());
            this.deleteCluster(Authorization, cur);
        }
    }

    @Override
    public void deleteClusterByUDescrIdx(CFGenKbAuthorization Authorization, String argDescription) {
        CFGenKbClusterByUDescrIdxKey key = this.schema.getFactoryCluster().newUDescrIdxKey();
        key.setRequiredDescription(argDescription);
        this.deleteClusterByUDescrIdx(Authorization, key);
    }

    @Override
    public void deleteClusterByUDescrIdx(CFGenKbAuthorization Authorization, CFGenKbClusterByUDescrIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFGenKbClusterBuff> matchSet = new LinkedList<CFGenKbClusterBuff>();
        for (CFGenKbClusterBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals(cur)) continue;
            matchSet.add(cur);
        }
        for (CFGenKbClusterBuff cur : matchSet) {
            cur = this.schema.getTableCluster().readDerivedByIdIdx(Authorization, cur.getRequiredId());
            this.deleteCluster(Authorization, cur);
        }
    }

    @Override
    public CFGenKbCursor openClusterCursorAll(CFGenKbAuthorization Authorization) {
        CFGenKbRamClusterCursor cursor = new CFGenKbRamClusterCursor(Authorization, this.schema, this.dictByPKey.values());
        return cursor;
    }

    @Override
    public void closeClusterCursor(CFGenKbCursor Cursor) {
    }

    @Override
    public CFGenKbClusterBuff nextClusterCursor(CFGenKbCursor Cursor) {
        CFGenKbRamClusterCursor cursor = (CFGenKbRamClusterCursor)Cursor;
        CFGenKbClusterBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    @Override
    public CFGenKbClusterBuff prevClusterCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFGenKbClusterBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextClusterCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbClusterBuff firstClusterCursor(CFGenKbCursor Cursor) {
        int targetRowIdx = 1;
        CFGenKbClusterBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextClusterCursor(Cursor);
        }
        return rec;
    }

    @Override
    public CFGenKbClusterBuff lastClusterCursor(CFGenKbCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastClusterCursor");
    }

    @Override
    public CFGenKbClusterBuff nthClusterCursor(CFGenKbCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFGenKbClusterBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextClusterCursor(Cursor);
        }
        return rec;
    }

    @Override
    public void releasePreparedStatements() {
    }
}

