/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbTenantBuff;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbTenantByClusterIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbTenantByUNameIdxKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.CFGenKbTenantPKey;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.CFGenKbTenantEditObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.CFGenKbTenantObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbClusterObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbSchemaObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbTenantEditObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbTenantObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbTenantTableObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;

public class CFGenKbTenantTableObj
implements ICFGenKbTenantTableObj {
    protected ICFGenKbSchemaObj schema;
    private Map<CFGenKbTenantPKey, ICFGenKbTenantObj> members;
    private Map<CFGenKbTenantPKey, ICFGenKbTenantObj> allTenant;
    private Map<CFGenKbTenantByClusterIdxKey, Map<CFGenKbTenantPKey, ICFGenKbTenantObj>> indexByClusterIdx;
    private Map<CFGenKbTenantByUNameIdxKey, ICFGenKbTenantObj> indexByUNameIdx;
    public static String TABLE_NAME = "Tenant";
    public static String TABLE_DBNAME = "tenant";

    public CFGenKbTenantTableObj() {
        this.schema = null;
        this.members = new HashMap<CFGenKbTenantPKey, ICFGenKbTenantObj>();
        this.allTenant = null;
        this.indexByClusterIdx = null;
        this.indexByUNameIdx = null;
    }

    public CFGenKbTenantTableObj(ICFGenKbSchemaObj argSchema) {
        this.schema = argSchema;
        this.members = new HashMap<CFGenKbTenantPKey, ICFGenKbTenantObj>();
        this.allTenant = null;
        this.indexByClusterIdx = null;
        this.indexByUNameIdx = null;
    }

    @Override
    public ICFGenKbSchemaObj getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(ICFGenKbSchemaObj value) {
        this.schema = value;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getTableDbName() {
        return TABLE_DBNAME;
    }

    @Override
    public void minimizeMemory() {
        this.allTenant = null;
        this.indexByClusterIdx = null;
        this.indexByUNameIdx = null;
        LinkedList<ICFGenKbTenantObj> toForget = new LinkedList<ICFGenKbTenantObj>();
        ICFGenKbTenantObj cur2 = null;
        for (ICFGenKbTenantObj cur2 : this.members.values()) {
            toForget.add(cur2);
        }
        for (ICFGenKbTenantObj cur2 : toForget) {
            cur2.forget();
        }
    }

    @Override
    public ICFGenKbTenantObj newInstance() {
        CFGenKbTenantObj inst = new CFGenKbTenantObj(this.schema);
        return inst;
    }

    @Override
    public ICFGenKbTenantEditObj newEditInstance(ICFGenKbTenantObj orig) {
        CFGenKbTenantEditObj edit = new CFGenKbTenantEditObj(orig);
        return edit;
    }

    @Override
    public ICFGenKbTenantObj realizeTenant(ICFGenKbTenantObj Obj) {
        ICFGenKbTenantObj obj = Obj;
        CFGenKbTenantPKey pkey = obj.getPKey();
        ICFGenKbTenantObj keepObj = null;
        if (this.members.containsKey(pkey) && null != this.members.get(pkey)) {
            CFGenKbTenantByUNameIdxKey keyUNameIdx;
            Map<CFGenKbTenantPKey, ICFGenKbTenantObj> mapClusterIdx;
            CFGenKbTenantByClusterIdxKey keyClusterIdx;
            ICFGenKbTenantObj existingObj;
            keepObj = existingObj = this.members.get(pkey);
            if (this.indexByClusterIdx != null) {
                keyClusterIdx = this.schema.getBackingStore().getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByUNameIdx != null) {
                keyUNameIdx = this.schema.getBackingStore().getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.remove(keyUNameIdx);
            }
            keepObj.setBuff(Obj.getBuff());
            if (this.indexByClusterIdx != null) {
                keyClusterIdx = this.schema.getBackingStore().getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByUNameIdx != null) {
                keyUNameIdx = this.schema.getBackingStore().getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.put(keyUNameIdx, keepObj);
            }
            if (this.allTenant != null) {
                this.allTenant.put(keepObj.getPKey(), keepObj);
            }
        } else {
            keepObj = obj;
            keepObj.setIsNew(false);
            this.members.put(keepObj.getPKey(), keepObj);
            if (this.allTenant != null) {
                this.allTenant.put(keepObj.getPKey(), keepObj);
            }
            if (this.indexByClusterIdx != null) {
                CFGenKbTenantByClusterIdxKey keyClusterIdx = this.schema.getBackingStore().getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                Map<CFGenKbTenantPKey, ICFGenKbTenantObj> mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.put(keepObj.getPKey(), keepObj);
                }
            }
            if (this.indexByUNameIdx != null) {
                CFGenKbTenantByUNameIdxKey keyUNameIdx = this.schema.getBackingStore().getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.put(keyUNameIdx, keepObj);
            }
        }
        return keepObj;
    }

    @Override
    public void forgetTenant(ICFGenKbTenantObj Obj) {
        this.forgetTenant(Obj, false);
    }

    @Override
    public void forgetTenant(ICFGenKbTenantObj Obj, boolean forgetSubObjects) {
        ICFGenKbTenantObj obj = Obj;
        CFGenKbTenantPKey pkey = obj.getPKey();
        if (this.members.containsKey(pkey)) {
            ICFGenKbTenantObj keepObj = this.members.get(pkey);
            if (this.indexByClusterIdx != null) {
                CFGenKbTenantByClusterIdxKey keyClusterIdx = this.schema.getBackingStore().getFactoryTenant().newClusterIdxKey();
                keyClusterIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                Map<CFGenKbTenantPKey, ICFGenKbTenantObj> mapClusterIdx = this.indexByClusterIdx.get(keyClusterIdx);
                if (mapClusterIdx != null) {
                    mapClusterIdx.remove(keepObj.getPKey());
                }
            }
            if (this.indexByUNameIdx != null) {
                CFGenKbTenantByUNameIdxKey keyUNameIdx = this.schema.getBackingStore().getFactoryTenant().newUNameIdxKey();
                keyUNameIdx.setRequiredClusterId(keepObj.getRequiredClusterId());
                keyUNameIdx.setRequiredTenantName(keepObj.getRequiredTenantName());
                this.indexByUNameIdx.remove(keyUNameIdx);
            }
            if (this.allTenant != null) {
                this.allTenant.remove(keepObj.getPKey());
            }
            this.members.remove(pkey);
            if (forgetSubObjects) {
                this.schema.getTSecGroupTableObj().forgetTSecGroupByTenantIdx(keepObj.getRequiredId());
                this.schema.getRuleCartTableObj().forgetRuleCartByTenantIdx(keepObj.getRequiredId());
            }
        }
    }

    @Override
    public void forgetTenantByIdIdx(long Id) {
        ICFGenKbTenantObj probed;
        if (this.members == null) {
            return;
        }
        CFGenKbTenantPKey key = this.schema.getBackingStore().getFactoryTenant().newPKey();
        key.setRequiredId(Id);
        if (this.members.containsKey(key) && (probed = this.members.get(key)) != null) {
            probed.forget(true);
        }
    }

    @Override
    public void forgetTenantByClusterIdx(long ClusterId) {
        if (this.indexByClusterIdx == null) {
            return;
        }
        CFGenKbTenantByClusterIdxKey key = this.schema.getBackingStore().getFactoryTenant().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx.containsKey(key)) {
            Map<CFGenKbTenantPKey, ICFGenKbTenantObj> mapClusterIdx = this.indexByClusterIdx.get(key);
            if (mapClusterIdx != null) {
                LinkedList<ICFGenKbTenantObj> toForget = new LinkedList<ICFGenKbTenantObj>();
                ICFGenKbTenantObj cur2 = null;
                for (ICFGenKbTenantObj cur2 : mapClusterIdx.values()) {
                    toForget.add(cur2);
                }
                for (ICFGenKbTenantObj cur2 : toForget) {
                    cur2.forget(true);
                }
            }
            this.indexByClusterIdx.remove(key);
        }
    }

    @Override
    public void forgetTenantByUNameIdx(long ClusterId, String TenantName) {
        if (this.indexByUNameIdx == null) {
            return;
        }
        CFGenKbTenantByUNameIdxKey key = this.schema.getBackingStore().getFactoryTenant().newUNameIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredTenantName(TenantName);
        if (this.indexByUNameIdx.containsKey(key)) {
            ICFGenKbTenantObj probed = this.indexByUNameIdx.get(key);
            if (probed != null) {
                probed.forget(true);
            }
            this.indexByUNameIdx.remove(key);
        }
    }

    @Override
    public ICFGenKbTenantObj createTenant(ICFGenKbTenantObj Obj) {
        ICFGenKbTenantObj obj = Obj;
        CFGenKbTenantBuff buff = obj.getTenantBuff();
        this.schema.getBackingStore().getTableTenant().createTenant(this.schema.getAuthorization(), buff);
        obj.copyBuffToPKey();
        obj = obj.realize();
        return obj;
    }

    @Override
    public ICFGenKbTenantObj readTenant(CFGenKbTenantPKey pkey) {
        return this.readTenant(pkey, false);
    }

    @Override
    public ICFGenKbTenantObj readTenant(CFGenKbTenantPKey pkey, boolean forceRead) {
        ICFGenKbTenantObj obj = null;
        if (!forceRead && this.members.containsKey(pkey)) {
            obj = this.members.get(pkey);
        } else {
            CFGenKbTenantBuff readBuff = this.schema.getBackingStore().getTableTenant().readDerivedByIdIdx(this.schema.getAuthorization(), pkey.getRequiredId());
            if (readBuff != null) {
                obj = this.schema.getTenantTableObj().newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryTenant().newPKey());
                obj.setBuff(readBuff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.members.put(pkey, null);
            }
        }
        return obj;
    }

    @Override
    public ICFGenKbTenantObj lockTenant(CFGenKbTenantPKey pkey) {
        ICFGenKbTenantObj locked = null;
        CFGenKbTenantBuff lockBuff = this.schema.getBackingStore().getTableTenant().lockDerived(this.schema.getAuthorization(), pkey);
        if (lockBuff == null) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "lockTenant", (Object)pkey);
        }
        locked = this.schema.getTenantTableObj().newInstance();
        locked.setPKey(this.schema.getBackingStore().getFactoryTenant().newPKey());
        locked.setBuff(lockBuff);
        locked = locked.realize();
        return locked;
    }

    @Override
    public List<ICFGenKbTenantObj> readAllTenant() {
        return this.readAllTenant(false);
    }

    @Override
    public List<ICFGenKbTenantObj> readAllTenant(boolean forceRead) {
        int idx;
        String S_ProcName = "readAllTenant";
        if (this.allTenant == null || forceRead) {
            HashMap<CFGenKbTenantPKey, ICFGenKbTenantObj> map = new HashMap<CFGenKbTenantPKey, ICFGenKbTenantObj>();
            this.allTenant = map;
            CFGenKbTenantBuff[] buffList = this.schema.getBackingStore().getTableTenant().readAllDerived(this.schema.getAuthorization());
            for (idx = 0; idx < buffList.length; ++idx) {
                CFGenKbTenantBuff buff = buffList[idx];
                ICFGenKbTenantObj obj = this.newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryTenant().newPKey());
                obj.setBuff(buff);
                ICFGenKbTenantObj iCFGenKbTenantObj = obj.realize();
            }
        }
        Comparator<ICFGenKbTenantObj> cmp = new Comparator<ICFGenKbTenantObj>(){

            @Override
            public int compare(ICFGenKbTenantObj lhs, ICFGenKbTenantObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFGenKbTenantPKey lhsPKey = lhs.getPKey();
                CFGenKbTenantPKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo(rhsPKey);
                return ret;
            }
        };
        int len = this.allTenant.size();
        ICFGenKbTenantObj[] arr = new ICFGenKbTenantObj[len];
        Iterator<ICFGenKbTenantObj> valIter = this.allTenant.values().iterator();
        idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readAllTenant", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readAllTenant", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFGenKbTenantObj> arrayList = new ArrayList<ICFGenKbTenantObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFGenKbTenantObj> sortedList = arrayList;
        return sortedList;
    }

    @Override
    public ICFGenKbTenantObj readTenantByIdIdx(long Id) {
        return this.readTenantByIdIdx(Id, false);
    }

    @Override
    public ICFGenKbTenantObj readTenantByIdIdx(long Id, boolean forceRead) {
        CFGenKbTenantPKey pkey = this.schema.getBackingStore().getFactoryTenant().newPKey();
        pkey.setRequiredId(Id);
        ICFGenKbTenantObj obj = this.readTenant(pkey, forceRead);
        return obj;
    }

    @Override
    public List<ICFGenKbTenantObj> readTenantByClusterIdx(long ClusterId) {
        return this.readTenantByClusterIdx(ClusterId, false);
    }

    @Override
    public List<ICFGenKbTenantObj> readTenantByClusterIdx(long ClusterId, boolean forceRead) {
        Map<Object, Object> dict;
        String S_ProcName = "readTenantByClusterIdx";
        CFGenKbTenantByClusterIdxKey key = this.schema.getBackingStore().getFactoryTenant().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx == null) {
            this.indexByClusterIdx = new HashMap<CFGenKbTenantByClusterIdxKey, Map<CFGenKbTenantPKey, ICFGenKbTenantObj>>();
        }
        if (!forceRead && this.indexByClusterIdx.containsKey(key)) {
            dict = this.indexByClusterIdx.get(key);
        } else {
            dict = new HashMap();
            this.indexByClusterIdx.put(key, dict);
            CFGenKbTenantBuff[] buffList = this.schema.getBackingStore().getTableTenant().readDerivedByClusterIdx(this.schema.getAuthorization(), ClusterId);
            for (int idx = 0; idx < buffList.length; ++idx) {
                CFGenKbTenantBuff buff = buffList[idx];
                ICFGenKbTenantObj obj = this.schema.getTenantTableObj().newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryTenant().newPKey());
                obj.setBuff(buff);
                ICFGenKbTenantObj iCFGenKbTenantObj = obj.realize();
            }
        }
        Comparator<ICFGenKbTenantObj> cmp = new Comparator<ICFGenKbTenantObj>(){

            @Override
            public int compare(ICFGenKbTenantObj lhs, ICFGenKbTenantObj rhs) {
                if (lhs == null) {
                    if (rhs == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                CFGenKbTenantPKey lhsPKey = lhs.getPKey();
                CFGenKbTenantPKey rhsPKey = rhs.getPKey();
                int ret = lhsPKey.compareTo(rhsPKey);
                return ret;
            }
        };
        int len = dict.size();
        ICFGenKbTenantObj[] arr = new ICFGenKbTenantObj[len];
        Iterator<Object> valIter = dict.values().iterator();
        int idx = 0;
        while (idx < len && valIter.hasNext()) {
            arr[idx++] = (ICFGenKbTenantObj)valIter.next();
        }
        if (idx < len) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.getClass(), "readTenantByClusterIdx", 0, "idx", idx, len);
        }
        if (valIter.hasNext()) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "readTenantByClusterIdx", 0, "idx", idx, len);
        }
        Arrays.sort(arr, cmp);
        ArrayList<ICFGenKbTenantObj> arrayList = new ArrayList<ICFGenKbTenantObj>(len);
        for (idx = 0; idx < len; ++idx) {
            arrayList.add(arr[idx]);
        }
        ArrayList<ICFGenKbTenantObj> sortedList = arrayList;
        return sortedList;
    }

    @Override
    public ICFGenKbTenantObj readTenantByUNameIdx(long ClusterId, String TenantName) {
        return this.readTenantByUNameIdx(ClusterId, TenantName, false);
    }

    @Override
    public ICFGenKbTenantObj readTenantByUNameIdx(long ClusterId, String TenantName, boolean forceRead) {
        if (this.indexByUNameIdx == null) {
            this.indexByUNameIdx = new HashMap<CFGenKbTenantByUNameIdxKey, ICFGenKbTenantObj>();
        }
        CFGenKbTenantByUNameIdxKey key = this.schema.getBackingStore().getFactoryTenant().newUNameIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredTenantName(TenantName);
        ICFGenKbTenantObj obj = null;
        if (!forceRead && this.indexByUNameIdx.containsKey(key)) {
            obj = this.indexByUNameIdx.get(key);
        } else {
            CFGenKbTenantBuff buff = this.schema.getBackingStore().getTableTenant().readDerivedByUNameIdx(this.schema.getAuthorization(), ClusterId, TenantName);
            if (buff != null) {
                obj = this.schema.getTenantTableObj().newInstance();
                obj.setPKey(this.schema.getBackingStore().getFactoryTenant().newPKey());
                obj.setBuff(buff);
                obj = obj.realize();
            } else if (this.schema.getCacheMisses()) {
                this.indexByUNameIdx.put(key, null);
            }
        }
        return obj;
    }

    @Override
    public ICFGenKbTenantObj updateTenant(ICFGenKbTenantObj Obj) {
        ICFGenKbTenantObj obj = Obj;
        this.schema.getBackingStore().getTableTenant().updateTenant(this.schema.getAuthorization(), Obj.getTenantBuff());
        obj = Obj.realize();
        return obj;
    }

    @Override
    public void deleteTenant(ICFGenKbTenantObj Obj) {
        ICFGenKbTenantObj obj = Obj;
        this.schema.getBackingStore().getTableTenant().deleteTenant(this.schema.getAuthorization(), obj.getTenantBuff());
        obj.forget(true);
    }

    @Override
    public void deleteTenantByIdIdx(long Id) {
        CFGenKbTenantPKey pkey = this.schema.getBackingStore().getFactoryTenant().newPKey();
        pkey.setRequiredId(Id);
        ICFGenKbTenantObj obj = this.readTenant(pkey);
        if (obj != null) {
            ICFGenKbTenantEditObj editObj = obj.getEdit();
            boolean editStarted = editObj == null ? (editObj = obj.beginEdit()) != null : false;
            if (editObj != null) {
                editObj.delete();
                if (editStarted) {
                    editObj.endEdit();
                }
            }
            obj.forget(true);
        }
    }

    @Override
    public void deleteTenantByClusterIdx(long ClusterId) {
        CFGenKbTenantByClusterIdxKey key = this.schema.getBackingStore().getFactoryTenant().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.indexByClusterIdx == null) {
            this.indexByClusterIdx = new HashMap<CFGenKbTenantByClusterIdxKey, Map<CFGenKbTenantPKey, ICFGenKbTenantObj>>();
        }
        if (this.indexByClusterIdx.containsKey(key)) {
            Map<CFGenKbTenantPKey, ICFGenKbTenantObj> dict = this.indexByClusterIdx.get(key);
            this.schema.getBackingStore().getTableTenant().deleteTenantByClusterIdx(this.schema.getAuthorization(), ClusterId);
            Iterator<ICFGenKbTenantObj> iter = dict.values().iterator();
            LinkedList<ICFGenKbTenantObj> toForget = new LinkedList<ICFGenKbTenantObj>();
            while (iter.hasNext()) {
                ICFGenKbTenantObj obj = iter.next();
                toForget.add(obj);
            }
            for (ICFGenKbTenantObj obj : toForget) {
                obj.forget(true);
            }
            this.indexByClusterIdx.remove(key);
        } else {
            this.schema.getBackingStore().getTableTenant().deleteTenantByClusterIdx(this.schema.getAuthorization(), ClusterId);
        }
    }

    @Override
    public void deleteTenantByUNameIdx(long ClusterId, String TenantName) {
        if (this.indexByUNameIdx == null) {
            this.indexByUNameIdx = new HashMap<CFGenKbTenantByUNameIdxKey, ICFGenKbTenantObj>();
        }
        CFGenKbTenantByUNameIdxKey key = this.schema.getBackingStore().getFactoryTenant().newUNameIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredTenantName(TenantName);
        ICFGenKbTenantObj obj = null;
        if (this.indexByUNameIdx.containsKey(key)) {
            obj = this.indexByUNameIdx.get(key);
            this.schema.getBackingStore().getTableTenant().deleteTenantByUNameIdx(this.schema.getAuthorization(), ClusterId, TenantName);
            obj.forget(true);
        } else {
            this.schema.getBackingStore().getTableTenant().deleteTenantByUNameIdx(this.schema.getAuthorization(), ClusterId, TenantName);
        }
    }

    @Override
    public ICFGenKbTenantObj getSystemTenant() {
        ICFGenKbTenantObj tenantObj;
        boolean transactionStarted = this.schema.beginTransaction();
        try {
            ICFGenKbClusterObj clusterObj = this.schema.getClusterTableObj().getSystemCluster();
            tenantObj = this.readTenantByUNameIdx(clusterObj.getRequiredId(), "system");
            if (tenantObj == null) {
                tenantObj = this.newInstance();
                ICFGenKbTenantEditObj tenantEdit = tenantObj.beginEdit();
                tenantEdit.setRequiredContainerCluster(clusterObj);
                tenantEdit.setRequiredTenantName("system");
                tenantObj = tenantEdit.create();
                tenantEdit.endEdit();
            }
            if (transactionStarted) {
                this.schema.commit();
            }
        }
        catch (RuntimeException e) {
            if (transactionStarted) {
                try {
                    this.schema.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
        return tenantObj;
    }
}

