/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.v2_9.CFCli;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Iterator;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.CFBamSchemaObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamClusterEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamClusterObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamSchemaObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTenantEditObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamTenantObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamObj.ICFBamVersionObj;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamSchema;
import net.sourceforge.msscodefactory.cfbamcustom.v2_9.CFBamXmlLoader.CFBamXmlLoader;
import net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF.MSSBamCFAnyObj;
import net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF.MSSBamCFEngine;
import net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF.MSSBamCFGelCompiler;
import net.sourceforge.msscodefactory.cfbamcustom.v2_9.MSSBamCF.MSSBamCFPrefs;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKb.ICFGenKbSchema;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.CFGenKbSchemaObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbClusterEditObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbClusterObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbSchemaObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbTenantEditObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbObj.ICFGenKbTenantObj;
import net.sourceforge.msscodefactory.cfcore.v2_9.CFGenKbRam.CFGenKbRamSchema;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFEngine;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFMessageLogWrapper;
import net.sourceforge.msscodefactory.cfcore.v2_9.MssCF.MssCFRuleCartridgeParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibAnyObj;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.ICFSecuritySchema;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurityObj.ICFSecurityClusterObj;

public class CFCli {
    public static final String LogFileName = "ManufactureProject.log";
    public static final String ProductName = "MSS Code Factory 2.9.14150";
    private static MSSBamCFPrefs _UserPrefs = null;
    private static String[] parsedToolSetNames = null;
    private static ICFLibMessageLog log = new MssCFMessageLogWrapper();
    private static MSSBamCFEngine cfEngine = null;

    public static MSSBamCFEngine getEngine() {
        return cfEngine;
    }

    public static void setEngine(MSSBamCFEngine engine) {
        cfEngine = engine;
    }

    public static void saveUserPreferences() {
        if (_UserPrefs != null && !_UserPrefs.savePreferences(log)) {
            return;
        }
    }

    protected static void initConsoleLog() {
    }

    public static void main(String[] args) {
        String S_ProcName = "MSSBamCFCli.main() ";
        CFCli.initConsoleLog();
        MSSBamCFGelCompiler.setCodeFactoryVersion((String)ProductName);
        String cartridgeName = "";
        Timestamp genstarttime = null;
        Timestamp genendtime = null;
        ICFBamVersionObj version = null;
        String toolsetName = null;
        String dashD = null;
        genstarttime = new Timestamp(System.currentTimeMillis());
        try {
            String str;
            int lastSlash;
            String modelName;
            log.message("Starting MSS Code Factory 2.9.14150...");
            boolean testOnly = false;
            switch (args.length) {
                case 2: {
                    modelName = args[0];
                    cartridgeName = args[1];
                    toolsetName = null;
                    break;
                }
                case 3: {
                    modelName = args[0];
                    cartridgeName = args[1];
                    dashD = args[2];
                    toolsetName = null;
                    break;
                }
                case 4: {
                    modelName = args[0];
                    cartridgeName = args[1];
                    dashD = args[2];
                    toolsetName = args[3];
                    break;
                }
                default: {
                    testOnly = true;
                    dashD = null;
                    toolsetName = null;
                    String msg = "net.sourceforge.msscodefactory.v2_9.CFCli.CFCli model_name_or_uri cartridge_name [-d|-n] [toolsetName]]\n\tWHERE\n\t\tmodel_name_or_uri is the name of the application model to generate,\n\t\t\tor the URI of a model definition file to load.\n\t\tcartridge_name is the name of the rule cartridge to use\n\t\t\tfor generating code.\n\t\t-d turns on debug tracing\n\t\t-n disables debug tracing (the default)\n\t\ttoolsetName is the name of the toolset to produce code for";
                    log.message(msg);
                    throw new IllegalArgumentException(msg);
                }
            }
            _UserPrefs = new MSSBamCFPrefs();
            if (!_UserPrefs.loadPreferences(log, false)) {
                log.message("Cannot continue.");
                return;
            }
            String prefsGenDir = _UserPrefs.getRootGenDir();
            if (prefsGenDir == null || prefsGenDir.length() <= 0) {
                throw new RuntimeException("MSSBamCFCli.main() Preferences RootGenDir is null or empty");
            }
            int idxLast = prefsGenDir.length() - 1;
            String rootGenDir = prefsGenDir.lastIndexOf(47) == idxLast || prefsGenDir.lastIndexOf(92) == idxLast || prefsGenDir.lastIndexOf(File.separatorChar) == idxLast ? prefsGenDir : prefsGenDir + File.separator;
            String logFileName = rootGenDir + LogFileName;
            try {
                log.openLogFile(logFileName);
                log.closeLogFile();
                File f = new File(logFileName);
                if (f.exists()) {
                    f.delete();
                }
            }
            catch (FileNotFoundException f) {
                // empty catch block
            }
            log.message("MSS Code Factory 2.9.14150 started");
            CFGenKbRamSchema genKbSchema = new CFGenKbRamSchema();
            CFGenKbSchemaObj genKbBLSchema = new CFGenKbSchemaObj();
            genKbBLSchema.setBackingStore((ICFGenKbSchema)genKbSchema);
            CFBamRamSchema bamSchema = new CFBamRamSchema();
            CFBamSchemaObj bamBLSchema = new CFBamSchemaObj();
            bamBLSchema.setBackingStore((ICFSecuritySchema)bamSchema);
            ICFGenKbClusterObj origCluster = genKbBLSchema.getClusterTableObj().newInstance();
            ICFGenKbClusterEditObj editCluster = origCluster.beginEdit();
            editCluster.setRequiredFullDomainName("msscodefactory.sourceforge.net");
            origCluster = editCluster.create();
            editCluster.endEdit();
            ICFGenKbTenantObj origTenant = genKbBLSchema.getTenantTableObj().newInstance();
            ICFGenKbTenantEditObj editTenant = origTenant.beginEdit();
            editTenant.setRequiredContainerCluster(origCluster);
            editTenant.setRequiredTenantName("internal");
            origTenant = editTenant.create();
            editTenant.endEdit();
            if (dashD != null) {
                if (dashD.equals("-d") || dashD.equals("-D")) {
                    MSSBamCFEngine.enableDebugMode();
                } else if (dashD.equals("-n") || dashD.equals("-N")) {
                    MSSBamCFEngine.disableDebugMode();
                } else if (toolsetName == null) {
                    toolsetName = dashD;
                    dashD = null;
                } else {
                    log.message("WARNING: Ignoring unrecognized third parameter \"" + dashD + "\"");
                    dashD = null;
                }
            }
            cfEngine = new MSSBamCFEngine();
            cfEngine.setLog(log);
            cfEngine.init((ICFGenKbSchemaObj)genKbBLSchema, origTenant, (ICFBamSchemaObj)bamBLSchema, rootGenDir);
            log.message("Linked with CFLib version 2.9.14143");
            log.message("Linked with MssCFEngine version 2.9.14144");
            log.message("Linked with MSS Code Factory version 2.9.14150");
            log.message("Initializing rule cartridge parser...");
            Iterator cartridgePath = _UserPrefs.getCartridgePathIterator();
            while (cartridgePath.hasNext()) {
                String cartridgeDir = (String)cartridgePath.next();
                MssCFRuleCartridgeParser.addCartridgePath((String)cartridgeDir);
            }
            URL url = cfEngine.getClass().getResource("/cartridge-1.11/net-sourceforge-msscodefactory-111-toolset-java/rulecartridge.xml");
            if (url == null) {
                url = cfEngine.getClass().getResource("cartridge-1.11/net-sourceforge-msscodefactory-111-toolset-java/rulecartridge.xml");
            }
            if (url != null && (lastSlash = (str = url.toString()).lastIndexOf(47)) > 0 && (lastSlash = (str = str.substring(0, lastSlash)).lastIndexOf(47)) > 0) {
                str = str.substring(0, lastSlash + 1);
                MssCFRuleCartridgeParser.addCartridgePath((String)str);
            }
            Iterator modelPath = _UserPrefs.getModelPathIterator();
            while (modelPath.hasNext()) {
                String modelDir = (String)modelPath.next();
                CFBamXmlLoader.addModelPath((String)modelDir);
            }
            MssCFRuleCartridgeParser cartridgeParser = new MssCFRuleCartridgeParser((MssCFEngine)cfEngine, log);
            parsedToolSetNames = null;
            try {
                cartridgeParser.loadRuleCartridge(cartridgeName);
            }
            catch (Exception e) {
                log.message("Could not load rule cartridge: " + e.getMessage());
                throw e;
            }
            catch (Error e) {
                log.message("Could not load rule cartridge: " + e.getMessage());
                throw e;
            }
            parsedToolSetNames = MssCFRuleCartridgeParser.getToolSetNames();
            if (parsedToolSetNames != null && parsedToolSetNames.length > 0) {
                StringBuffer msg = new StringBuffer();
                msg.append("Rule cartridge specified tool set names ");
                for (int idxName = 0; idxName < parsedToolSetNames.length; ++idxName) {
                    if (idxName > 0) {
                        msg.append(", ");
                    }
                    msg.append(parsedToolSetNames[idxName]);
                }
                log.message(msg.toString());
            } else {
                log.message("Rule cartridge did not define tool set names to process.");
            }
            ICFBamClusterObj origBamCluster = (ICFBamClusterObj)bamBLSchema.getClusterTableObj().newInstance();
            ICFBamClusterEditObj editBamCluster = (ICFBamClusterEditObj)origBamCluster.beginEdit();
            editBamCluster.setRequiredFullDomainName("system");
            origBamCluster = (ICFBamClusterObj)editBamCluster.create();
            editBamCluster.endEdit();
            ICFBamTenantObj origBamTenant = (ICFBamTenantObj)bamBLSchema.getTenantTableObj().newInstance();
            ICFBamTenantEditObj editBamTenant = (ICFBamTenantEditObj)origBamTenant.beginEdit();
            editBamTenant.setRequiredContainerCluster((ICFSecurityClusterObj)origBamCluster);
            editBamTenant.setRequiredTenantName("system");
            origBamTenant = (ICFBamTenantObj)editBamTenant.create();
            editBamTenant.endEdit();
            CFBamXmlLoader bamParser = new CFBamXmlLoader(cfEngine, log);
            bamParser.setSchemaObj((ICFBamSchemaObj)bamBLSchema);
            bamParser.setTenant(origBamTenant);
            try {
                bamParser.loadTenant(modelName);
            }
            catch (Exception e) {
                log.message("Could not load Tenant: " + e.getMessage());
                throw e;
            }
            catch (Error e) {
                log.message("Could not load Tenant: " + e.getMessage());
                throw e;
            }
            ICFBamTenantObj Tenant = bamParser.getTenant();
            version = bamParser.getDefinedProjectVersion();
            try {
                if (toolsetName != null && toolsetName.length() > 0) {
                    String[] evalToolSetName = new String[]{toolsetName};
                    if (version != null) {
                        cfEngine.generate(rootGenDir, (ICFLibAnyObj)version, evalToolSetName, "top");
                    }
                } else if (version != null) {
                    cfEngine.generate(rootGenDir, (ICFLibAnyObj)version, parsedToolSetNames, "top");
                }
            }
            catch (Exception e) {
                log.message("MSSBamCFCli.main() Manufacturing code threw " + e.getClass().getName() + " " + e.getMessage() + ", stack trace follows:");
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            log.message("MSSBamCFCli.main() Caught " + e.getClass().getName() + " " + e.getMessage() + ", stack trace follows:");
            e.printStackTrace();
        }
        genendtime = new Timestamp(System.currentTimeMillis());
        long msec = genendtime.getTime() - genstarttime.getTime();
        String elapsed = String.format("%1$d:%2$02d:%3$02d.%4$03d", msec / 3600000L, msec / 60000L % 60L, msec / 1000L % 60L, msec % 1000L);
        log.message((version != null ? MSSBamCFAnyObj.getFullName(version) : "Code") + " manufacturing took " + elapsed);
        log.message("Releasing MSS Code Factory 2.9.14150 engine...");
        cfEngine = null;
        log.message("MSS Code Factory 2.9.14150 finished.");
        log.closeLogFile();
    }
}

