"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var MapGenerator = require("./map-generator");

// Object with processed CSS
var Result = (function () {
  var Result = function Result(root, opts) {
    if (opts === undefined) opts = {};
    this.root = root;
    this.opts = opts;
  };

  _classProps(Result, null, {
    map: {
      // Lazy method to return source map
      get: function () {
        if (!this.cssCached) this.stringify();
        return this.mapCached;
      }
    },
    css: {
      // Lazy method to return CSS string
      get: function () {
        if (!this.cssCached) this.stringify();
        return this.cssCached;
      }
    },
    toString: {
      writable: true,


      // Return CSS string on any try to print
      value: function () {
        return this.css;
      }
    },
    stringify: {
      writable: true,


      // Generate CSS and map
      value: function () {
        var map = new MapGenerator(this.root, this.opts);
        var generated = map.generate();
        this.cssCached = generated[0];
        this.mapCached = generated[1];
      }
    }
  });

  return Result;
})();

module.exports = Result;