"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var _extends = function (child, parent) {
  child.prototype = Object.create(parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  child.__proto__ = parent;
};

var Node = require("./node");

// CSS comment between declarations or rules
var Comment = (function (Node) {
  var Comment = function Comment(defaults) {
    this.type = "comment";
    Node.call(this, defaults);
  };

  _extends(Comment, Node);

  _classProps(Comment, null, {
    styleMap: {
      writable: true,
      value: function () {
        return {
          commentLeft: this.left,
          commentRight: this.right
        };
      }
    },
    stringify: {
      writable: true,


      // Stringify declaration
      value: function (builder) {
        if (this.before) builder(this.before);
        var left = this.style("commentLeft");
        var right = this.style("commentRight");
        builder("/*" + left + this.text + right + "*/", this);
      }
    }
  });

  return Comment;
})(Node);

module.exports = Comment;