/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

public class StringUtils {
    private StringUtils() {
    }

    public static String unescapeString(String str) {
        int len = str.length();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int c = str.charAt(i) & 0xFFFF;
            StringUtils.processChar(c, res);
        }
        return '\"' + res.toString() + '\"';
    }

    public static String unescapeChar(char ch) {
        if (ch == '\'') {
            return "'\\''";
        }
        StringBuilder res = new StringBuilder();
        StringUtils.processChar(ch, res);
        return '\'' + res.toString() + '\'';
    }

    private static void processChar(int c, StringBuilder res) {
        switch (c) {
            case 10: {
                res.append("\\n");
                break;
            }
            case 13: {
                res.append("\\r");
                break;
            }
            case 9: {
                res.append("\\t");
                break;
            }
            case 8: {
                res.append("\\b");
                break;
            }
            case 12: {
                res.append("\\f");
                break;
            }
            case 39: {
                res.append('\'');
                break;
            }
            case 34: {
                res.append("\\\"");
                break;
            }
            case 92: {
                res.append("\\\\");
                break;
            }
            default: {
                if (32 <= c && c <= 126) {
                    res.append((char)c);
                    break;
                }
                res.append("\\u").append(String.format("%04x", c));
            }
        }
    }

    public static String escape(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': 
                case '$': 
                case ',': 
                case '.': 
                case '/': 
                case ';': 
                case '<': {
                    sb.append('_');
                    continue block5;
                }
                case '[': {
                    sb.append('A');
                    continue block5;
                }
                case '*': 
                case '>': 
                case '?': 
                case ']': {
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeXML(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeResValue(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block12: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block12;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block12;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block12;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block12;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block12;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block12;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

