/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.TypeClass;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.BinopExpr;
import com.googlecode.dex2jar.ir.expr.CastExpr;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.NewMutiArrayExpr;
import com.googlecode.dex2jar.ir.expr.RefExpr;
import com.googlecode.dex2jar.ir.expr.StaticFieldExpr;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.expr.UnopExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TypeTransformer
implements Transformer {
    private static final String[] possibleIntTypes = new String[]{"B", "S", "C", "I"};

    @Override
    public void transform(IrMethod irMethod) {
        TypeAnalyze ta = new TypeAnalyze(irMethod);
        List<TypeRef> refs = ta.analyze();
        for (TypeRef ref : refs) {
            String type = ref.getType();
            if (type == null) {
                System.err.println(ref);
                continue;
            }
            if (ref.value.vt == Value.VT.CONSTANT) {
                Constant cst = (Constant)ref.value;
                switch (type.charAt(0)) {
                    case 'L': 
                    case '[': {
                        int i;
                        Object[] f;
                        Object[] x;
                        if (Integer.valueOf(0).equals(cst.value)) {
                            cst.value = Constant.Null;
                        }
                        if (type.equals("[F") && cst.value instanceof int[]) {
                            x = (int[])cst.value;
                            f = new float[x.length];
                            for (i = 0; i < x.length; ++i) {
                                f[i] = Float.intBitsToFloat(x[i]);
                            }
                            cst.value = f;
                        }
                        if (!type.equals("[D") || !(cst.value instanceof long[])) break;
                        x = (long[])cst.value;
                        f = new double[x.length];
                        for (i = 0; i < x.length; ++i) {
                            f[i] = (float)Double.longBitsToDouble(x[i]);
                        }
                        cst.value = f;
                        break;
                    }
                    case 'F': {
                        if (cst.value instanceof Float) break;
                        cst.value = Float.valueOf(Float.intBitsToFloat(((Number)cst.value).intValue()));
                        break;
                    }
                    case 'D': {
                        if (cst.value instanceof Double) break;
                        cst.value = Double.longBitsToDouble(((Number)cst.value).longValue());
                        break;
                    }
                }
            }
            Value value = ref.value;
            value.valueType = type;
            value.tag = null;
            ref.clear();
        }
    }

    private static class TypeAnalyze {
        protected IrMethod method;
        private List<TypeRef> refs = new ArrayList<TypeRef>();

        public TypeAnalyze(IrMethod method) {
            this.method = method;
        }

        public List<TypeRef> analyze() {
            this.sxStmt();
            this.fixTypes();
            return this.refs;
        }

        private void fixTypes() {
            TypeRef ref;
            UniqueQueue<TypeRef> q = new UniqueQueue<TypeRef>();
            HashSet<TypeRef> arrayRoots = new HashSet<TypeRef>();
            for (TypeRef t : this.refs) {
                if (t.gArrayValues == null && t.sArrayValues == null) continue;
                arrayRoots.add(t);
                q.add(t);
            }
            while (!q.isEmpty()) {
                ref = (TypeRef)q.poll();
                TypeRef.SharedT arrayValue = ref.getArrayValueShareT();
                if (ref.gArrayValues == null) continue;
                for (TypeRef typeRef : ref.gArrayValues) {
                }
            }
            q.addAll((Collection<TypeRef>)this.refs);
            while (!q.isEmpty()) {
                while (!q.isEmpty()) {
                    ref = (TypeRef)q.poll();
                    this.copyTypes(q, ref);
                }
                for (TypeRef ref2 : arrayRoots) {
                    String provideDesc = ref2.getProvideDesc();
                    if (provideDesc == null || provideDesc.charAt(0) != '[') continue;
                    String ele = provideDesc.substring(1);
                    if (ref2.gArrayValues != null) {
                        for (TypeRef p : ref2.gArrayValues) {
                            if (p.updateTypeClass(TypeClass.clzOf(ele))) {
                                q.add(p);
                            }
                            TypeAnalyze.mergeTypeToArrayGetValue(ele, p, q);
                        }
                    }
                    if (ref2.sArrayValues == null) continue;
                    for (TypeRef p : ref2.sArrayValues) {
                        if (p.updateTypeClass(TypeClass.clzOf(ele))) {
                            q.add(p);
                        }
                        if (!p.addUses(ele)) continue;
                        q.add(p);
                    }
                }
            }
        }

        private static void mergeTypeToArrayGetValue(String type, TypeRef target, UniqueQueue<TypeRef> q) {
            if (target.getProvideDesc() == null) {
                target.setProvideDesc(type);
                q.add(target);
            } else {
                String mergedType = TypeAnalyze.mergeTypeEx(type, target.getProvideDesc());
                if (!mergedType.equals(target.getProvideDesc())) {
                    target.setProvideDesc(mergedType);
                    q.add(target);
                }
            }
        }

        private static void mergeTypeToSubRef(String type, TypeRef target, UniqueQueue<TypeRef> q) {
            if (target.getProvideDesc() == null) {
                target.setProvideDesc(type);
                q.add(target);
            } else {
                String mergedType = TypeAnalyze.mergeProviderType(type, target.getProvideDesc());
                if (!mergedType.equals(target.getProvideDesc())) {
                    target.setProvideDesc(mergedType);
                    q.add(target);
                }
            }
        }

        private static String mergeTypeEx(String a, String b) {
            int bs;
            if (a.equals(b)) {
                return a;
            }
            int as = TypeAnalyze.countArrayDim(a);
            if (as > (bs = TypeAnalyze.countArrayDim(b))) {
                return a;
            }
            if (bs > as) {
                return b;
            }
            String elementTypeA = a.substring(as);
            String elementTypeB = a.substring(bs);
            TypeClass ta = TypeClass.clzOf(elementTypeA);
            TypeClass tb = TypeClass.clzOf(elementTypeB);
            if (ta.fixed && !tb.fixed) {
                return a;
            }
            if (!ta.fixed && tb.fixed) {
                return b;
            }
            if (ta.fixed && tb.fixed) {
                if (ta != tb) {
                    if (as == 0) {
                        throw new RuntimeException();
                    }
                    return TypeAnalyze.buildArray(as - 1, "L");
                }
                if (ta == TypeClass.INT) {
                    String chooseType = "I";
                    for (int i = possibleIntTypes.length - 1; i >= 0; --i) {
                        String t = possibleIntTypes[i];
                        if (!a.equals(t) && !b.equals(t)) continue;
                        chooseType = t;
                        break;
                    }
                    return TypeAnalyze.buildArray(as, chooseType);
                }
                return TypeAnalyze.buildArray(as, "L");
            }
            return TypeAnalyze.buildArray(as, TypeClass.merge((TypeClass)ta, (TypeClass)tb).name);
        }

        private void copyTypes(UniqueQueue<TypeRef> q, TypeRef ref) {
            TypeClass clz = ref.getClz();
            switch (clz) {
                case BOOLEAN: 
                case FLOAT: 
                case LONG: 
                case DOUBLE: 
                case VOID: {
                    ref.setProvideDesc(clz.name);
                    break;
                }
            }
            String provideDesc = ref.getProvideDesc();
            if (provideDesc == null && ref.parents != null && ref.parents.size() > 1 && this.isAllParentSetted(ref)) {
                provideDesc = this.mergeParentType(ref.parents);
                ref.setProvideDesc(provideDesc);
            }
            if (ref.parents != null) {
                for (TypeRef p : ref.parents) {
                    if (p.updateTypeClass(clz)) {
                        q.add(p);
                    }
                    if (ref.getUses() == null || !p.addAllUses(ref.getUses())) continue;
                    q.add(p);
                }
            }
            if (ref.children != null) {
                for (TypeRef p : ref.children) {
                    if (p.updateTypeClass(clz)) {
                        q.add(p);
                    }
                    if (provideDesc == null) continue;
                    TypeAnalyze.mergeTypeToSubRef(provideDesc, p, q);
                }
            }
            if (ref.sameValues != null) {
                for (TypeRef p : ref.sameValues) {
                    if (!p.updateTypeClass(clz)) continue;
                    q.add(p);
                }
            }
        }

        private boolean isAllParentSetted(TypeRef ref) {
            boolean allAreSet = true;
            for (TypeRef p : ref.parents) {
                if (p.getProvideDesc() != null) continue;
                allAreSet = false;
                break;
            }
            return allAreSet;
        }

        private static String mergeObjectType(String a, String b) {
            if (a.equals(b)) {
                return a;
            }
            if ("L".endsWith(a)) {
                return b;
            }
            if ("L".equals(b)) {
                return a;
            }
            if (a.compareTo(b) > 0) {
                return a;
            }
            return b;
        }

        private static String mergeProviderType(String a, String b) {
            if (a.equals(b)) {
                return a;
            }
            TypeClass ta = TypeClass.clzOf(a);
            TypeClass tb = TypeClass.clzOf(b);
            if (ta.fixed && !tb.fixed) {
                return a;
            }
            if (!ta.fixed && tb.fixed) {
                return b;
            }
            if (ta.fixed && tb.fixed) {
                if (ta != tb) {
                    throw new RuntimeException();
                }
                if (ta == TypeClass.INT) {
                    for (int i = possibleIntTypes.length - 1; i >= 0; --i) {
                        String t = possibleIntTypes[i];
                        if (!a.equals(t) && !b.equals(t)) continue;
                        return t;
                    }
                    return "I";
                }
                if (ta == TypeClass.OBJECT) {
                    int as = TypeAnalyze.countArrayDim(a);
                    int bs = TypeAnalyze.countArrayDim(b);
                    if (as == 0 || bs == 0) {
                        return TypeAnalyze.mergeObjectType(a, b);
                    }
                    String elementTypeA = a.substring(as);
                    String elementTypeB = a.substring(bs);
                    if (as < bs) {
                        return TypeAnalyze.buildArray(elementTypeB.charAt(0) == 'L' ? bs : bs - 1, "L");
                    }
                    if (bs > as) {
                        return TypeAnalyze.buildArray(elementTypeA.charAt(0) == 'L' ? as : as - 1, "L");
                    }
                    if (elementTypeA.charAt(0) != 'L' || elementTypeB.charAt(0) != 'L') {
                        return TypeAnalyze.buildArray(as - 1, "L");
                    }
                    return TypeAnalyze.buildArray(as, "L");
                }
                throw new RuntimeException();
            }
            return TypeClass.merge((TypeClass)ta, (TypeClass)tb).name;
        }

        private static String buildArray(int dim, String s) {
            if (dim == 0) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dim; ++i) {
                sb.append('[');
            }
            sb.append(s);
            return sb.toString();
        }

        private static int countArrayDim(String a) {
            int i = 0;
            while (a.charAt(i) == '[') {
                ++i;
            }
            return i;
        }

        private String mergeParentType(Set<TypeRef> parents) {
            Iterator<TypeRef> it = parents.iterator();
            String a = it.next().getProvideDesc();
            while (it.hasNext()) {
                a = TypeAnalyze.mergeProviderType(a, it.next().getProvideDesc());
            }
            return a;
        }

        private void e0expr(Value.E0Expr op, boolean getValue) {
            switch (op.vt) {
                case LOCAL: {
                    break;
                }
                case NEW: {
                    NewExpr newExpr = (NewExpr)op;
                    this.provideAs(newExpr, newExpr.type);
                    break;
                }
                case THIS_REF: 
                case PARAMETER_REF: 
                case EXCEPTION_REF: {
                    RefExpr refExpr = (RefExpr)op;
                    String refType = refExpr.type;
                    if (refType == null && op.vt == Value.VT.EXCEPTION_REF) {
                        refType = "Ljava/lang/Throwable;";
                    }
                    this.provideAs(refExpr, refType);
                    break;
                }
                case STATIC_FIELD: {
                    StaticFieldExpr fe = (StaticFieldExpr)op;
                    if (getValue) {
                        this.provideAs(fe, fe.type);
                        break;
                    }
                    this.useAs(fe, fe.type);
                    break;
                }
                case CONSTANT: {
                    Constant cst = (Constant)op;
                    Object value = cst.value;
                    if (value instanceof String) {
                        this.provideAs(cst, "Ljava/lang/String;");
                        break;
                    }
                    if (value instanceof Constant.Type) {
                        this.provideAs(cst, "Ljava/lang/Class;");
                        break;
                    }
                    if (value instanceof Number) {
                        if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
                            int a = ((Number)value).intValue();
                            if (a == 0) {
                                this.provideAs(cst, TypeClass.ZIFL.name);
                                break;
                            }
                            if (a == 1) {
                                this.provideAs(cst, TypeClass.ZIF.name);
                                break;
                            }
                            this.provideAs(cst, TypeClass.IF.name);
                            break;
                        }
                        if (value instanceof Long) {
                            this.provideAs(cst, "w");
                            break;
                        }
                        if (value instanceof Float) {
                            this.provideAs(cst, "F");
                            break;
                        }
                        if (!(value instanceof Double)) break;
                        this.provideAs(cst, "D");
                        break;
                    }
                    if (value instanceof Character) {
                        this.provideAs(cst, "C");
                        break;
                    }
                    this.provideAs(cst, "L");
                    break;
                }
            }
        }

        private void e1expr(Value.E1Expr e1, boolean getValue) {
            Value v = e1.op;
            switch (e1.vt) {
                case CAST: {
                    CastExpr ce = (CastExpr)e1;
                    if (ce.to.equals("B")) {
                        this.useAs(v, TypeClass.ZI.name);
                        this.provideAs(e1, TypeClass.ZI.name);
                        break;
                    }
                    this.useAs(v, ce.from);
                    this.provideAs(e1, ce.to);
                    break;
                }
                case FIELD: {
                    FieldExpr fe = (FieldExpr)e1;
                    if (getValue) {
                        this.provideAs(fe, fe.type);
                    } else {
                        this.useAs(fe, fe.type);
                    }
                    if (v == null) break;
                    this.useAs(v, fe.owner);
                    break;
                }
                case CHECK_CAST: {
                    TypeExpr te = (TypeExpr)e1;
                    this.provideAs(te, te.type);
                    this.useAs(v, "L");
                    break;
                }
                case INSTANCE_OF: {
                    TypeExpr te = (TypeExpr)e1;
                    this.provideAs(te, "Z");
                    this.useAs(v, "L");
                    break;
                }
                case NEW_ARRAY: {
                    TypeExpr te = (TypeExpr)e1;
                    this.provideAs(te, "[" + te.type);
                    this.useAs(v, "I");
                    break;
                }
                case LENGTH: {
                    UnopExpr ue = (UnopExpr)e1;
                    this.provideAs(ue, "I");
                    this.useAs(v, "[?");
                    break;
                }
                case NEG: 
                case NOT: {
                    UnopExpr ue = (UnopExpr)e1;
                    this.provideAs(ue, ue.type);
                    this.useAs(v, ue.type);
                    break;
                }
            }
            if (v != null) {
                this.exExpr(v);
            }
        }

        private void e2expr(Value.E2Expr e2, boolean getValue) {
            Value a = e2.op1.trim();
            Value b = e2.op2.trim();
            switch (e2.vt) {
                case ARRAY: {
                    this.useAs(b, "I");
                    String elementType = ((ArrayExpr)e2).elementType;
                    this.useAs(a, "[" + elementType);
                    if (getValue) {
                        this.provideAs(e2, elementType);
                        this.linkGetArray(a, e2);
                        break;
                    }
                    this.useAs(e2, elementType);
                    this.linkSetArray(a, e2);
                    break;
                }
                case LCMP: 
                case FCMPG: 
                case FCMPL: 
                case DCMPG: 
                case DCMPL: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    this.provideAs(e2, "I");
                    break;
                }
                case EQ: 
                case NE: {
                    this.useAs(e2.getOp2(), TypeClass.ZIL.name);
                    this.useAs(e2.getOp1(), TypeClass.ZIL.name);
                    this.linkSameAs(e2.getOp1(), e2.getOp2());
                    this.provideAs(e2, "Z");
                    break;
                }
                case GE: 
                case GT: 
                case LE: 
                case LT: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    this.provideAs(e2, "Z");
                    break;
                }
                case ADD: 
                case SUB: 
                case IDIV: 
                case LDIV: 
                case FDIV: 
                case DDIV: 
                case MUL: 
                case REM: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    this.provideAs(e2, be.type);
                    break;
                }
                case OR: 
                case AND: 
                case XOR: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    if ("J".equals(be.type) || "w".equals(be.type)) {
                        this.provideAs(e2, be.type);
                        break;
                    }
                    this.provideAs(e2, TypeClass.ZI.name);
                    break;
                }
                case SHL: 
                case SHR: 
                case USHR: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, "I");
                    this.provideAs(e2, be.type);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (a != null) {
                this.exExpr(a);
            }
            if (b != null) {
                this.exExpr(b);
            }
        }

        private void linkSameAs(Value a, Value b) {
            TypeRef aa = this.getDefTypeRef(a);
            TypeRef bb = this.getDefTypeRef(b);
            if (aa.sameValues == null) {
                aa.sameValues = new HashSet<TypeRef>(3);
            }
            if (bb.sameValues == null) {
                bb.sameValues = new HashSet<TypeRef>(3);
            }
            aa.sameValues.add(bb);
            bb.sameValues.add(aa);
        }

        private void enexpr(Value.EnExpr enExpr) {
            Value[] vbs = enExpr.ops;
            switch (enExpr.vt) {
                case INVOKE_NEW: 
                case INVOKE_INTERFACE: 
                case INVOKE_SPECIAL: 
                case INVOKE_STATIC: 
                case INVOKE_VIRTUAL: {
                    InvokeExpr ie = (InvokeExpr)enExpr;
                    String type = ie.vt == Value.VT.INVOKE_NEW ? ie.owner : ie.ret;
                    this.provideAs(enExpr, type);
                    this.useAs(enExpr, type);
                    int start = 0;
                    if (ie.vt != Value.VT.INVOKE_STATIC && ie.vt != Value.VT.INVOKE_NEW) {
                        start = 1;
                        this.useAs(vbs[0], ie.owner);
                    }
                    int i = 0;
                    while (start < vbs.length) {
                        this.useAs(vbs[start], ie.args[i]);
                        ++start;
                        ++i;
                    }
                    break;
                }
                case FILLED_ARRAY: {
                    FilledArrayExpr fae = (FilledArrayExpr)enExpr;
                    for (Value vb : vbs) {
                        this.useAs(vb, fae.type);
                    }
                    this.provideAs(fae, "[" + fae.type);
                    break;
                }
                case NEW_MUTI_ARRAY: {
                    NewMutiArrayExpr nmae = (NewMutiArrayExpr)enExpr;
                    for (Value vb : vbs) {
                        this.useAs(vb, "I");
                    }
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < nmae.dimension; ++i) {
                        sb.append('[');
                    }
                    sb.append(nmae.baseType);
                    this.provideAs(nmae, sb.toString());
                    break;
                }
                case PHI: {
                    for (Value vb : vbs) {
                        this.linkFromTo(vb, enExpr);
                    }
                    break;
                }
            }
            for (Value vb : enExpr.ops) {
                this.exExpr(vb);
            }
        }

        private void exExpr(Value op) {
            this.exExpr(op, true);
        }

        private void exExpr(Value op, boolean getValue) {
            switch (op.et) {
                case E0: {
                    this.e0expr((Value.E0Expr)op, getValue);
                    break;
                }
                case E1: {
                    this.e1expr((Value.E1Expr)op, getValue);
                    break;
                }
                case E2: {
                    this.e2expr((Value.E2Expr)op, getValue);
                    break;
                }
                case En: {
                    this.enexpr((Value.EnExpr)op);
                }
            }
        }

        private TypeRef getDefTypeRef(Value v) {
            TypeRef typeRef;
            Object object = v.tag;
            if (object == null || !(object instanceof TypeRef)) {
                typeRef = new TypeRef(v);
                this.refs.add(typeRef);
                v.tag = typeRef;
            } else {
                typeRef = (TypeRef)object;
            }
            return typeRef;
        }

        private void linkGetArray(Value array, Value v) {
            TypeRef root = this.getDefTypeRef(array);
            TypeRef value = this.getDefTypeRef(v);
            if (root.gArrayValues == null) {
                root.gArrayValues = new HashSet<TypeRef>(3);
            }
            root.gArrayValues.add(value);
            value.arrayRoot = root;
        }

        private void linkSetArray(Value array, Value v) {
            TypeRef root = this.getDefTypeRef(array);
            TypeRef value = this.getDefTypeRef(v);
            if (root.sArrayValues == null) {
                root.sArrayValues = new HashSet<TypeRef>(3);
            }
            root.sArrayValues.add(value);
            value.arrayRoot = root;
        }

        private void linkFromTo(Value from, Value to) {
            TypeRef tFrom = this.getDefTypeRef(from);
            TypeRef tTo = this.getDefTypeRef(to);
            if (tFrom.children == null) {
                tFrom.children = new HashSet<TypeRef>();
            }
            tFrom.children.add(tTo);
            if (tTo.parents == null) {
                tTo.parents = new HashSet<TypeRef>();
            }
            tTo.parents.add(tFrom);
        }

        private void provideAs(Value op, String type) {
            TypeRef typeRef = this.getDefTypeRef(op);
            typeRef.setProvideDesc(type);
            typeRef.updateTypeClass(TypeClass.clzOf(type));
        }

        private void s1stmt(Stmt.E1Stmt s) {
            if (s.st == Stmt.ST.GOTO) {
                return;
            }
            Value op = s.op;
            switch (s.st) {
                case LOOKUP_SWITCH: 
                case TABLE_SWITCH: {
                    this.useAs(op, "I");
                    break;
                }
                case GOTO: {
                    break;
                }
                case IF: {
                    this.useAs(op, "Z");
                    break;
                }
                case LOCK: 
                case UNLOCK: {
                    this.useAs(op, "L");
                    break;
                }
                case THROW: {
                    this.useAs(op, "Ljava/lang/Throwable;");
                    break;
                }
                case RETURN: {
                    this.useAs(op, this.method.ret);
                    break;
                }
            }
            this.exExpr(op);
        }

        private void s2stmt(Stmt.E2Stmt s) {
            if (s.st == Stmt.ST.FILL_ARRAY_DATA) {
                this.linkFromTo(s.op1, s.op2);
            } else {
                Value from = s.op2;
                Value to = s.op1;
                this.linkFromTo(from, to);
                this.exExpr(from);
                this.exExpr(to, false);
            }
        }

        private void sxStmt() {
            block5: for (Stmt p = this.method.stmts.getFirst(); p != null; p = p.getNext()) {
                switch (p.et) {
                    case E0: {
                        if (p.st != Stmt.ST.LABEL) continue block5;
                        LabelStmt labelStmt = (LabelStmt)p;
                        if (labelStmt.phis == null) continue block5;
                        for (AssignStmt phi : labelStmt.phis) {
                            this.s2stmt(phi);
                        }
                        continue block5;
                    }
                    case E1: {
                        this.s1stmt((Stmt.E1Stmt)p);
                        continue block5;
                    }
                    case E2: {
                        this.s2stmt((Stmt.E2Stmt)p);
                        continue block5;
                    }
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (TypeRef ref : this.refs) {
                sb.append(ref).append("\n");
            }
            return sb.toString();
        }

        private void useAs(Value op, String type) {
            TypeRef typeRef = this.getDefTypeRef(op);
            typeRef.addUses(type);
            typeRef.updateTypeClass(TypeClass.clzOf(type));
        }
    }

    public static class TypeRef {
        public final Value value;
        public Set<TypeRef> sameValues = null;
        public Set<TypeRef> gArrayValues = null;
        public Set<TypeRef> sArrayValues = null;
        public TypeRef arrayRoot = null;
        public Set<TypeRef> parents = null;
        public Set<TypeRef> children = null;
        private SharedT arrayValueShareT;
        SharedT t = new SharedT();

        public void setArrayValueShareT(SharedT arrayValueShareT) {
            this.arrayValueShareT = arrayValueShareT;
        }

        public TypeClass getClz() {
            return this.t.getReal().clz;
        }

        public void setClz(TypeClass clz) {
            this.t.getReal().clz = clz;
        }

        SharedT getArrayValueShareT() {
            if (this.arrayValueShareT == null) {
                this.arrayValueShareT = new SharedT();
                return this.arrayValueShareT;
            }
            return this.arrayValueShareT.getReal();
        }

        boolean mergeT(TypeRef other) {
            SharedT a = this.t.getReal();
            SharedT b = other.t.getReal();
            this.t = a;
            other.t = a;
            if (a != b) {
                this.updateTypeClass(other.getClz());
                return a.merge(b);
            }
            return false;
        }

        public TypeRef(Value value) {
            this.value = value;
        }

        public String toString() {
            String p = this.getUses() == null ? "[]" : this.getUses().toString();
            return (Object)((Object)this.getClz()) + "::" + this.value + ": " + this.getProvideDesc() + " > {" + p.substring(1, p.length() - 1) + "}";
        }

        public String getType() {
            if (this.getClz() == TypeClass.OBJECT) {
                if (this.getProvideDesc().length() == 1) {
                    return "Ljava/lang/Object;";
                }
                return this.getProvideDesc();
            }
            if (this.getClz().fixed && this.getClz() != TypeClass.INT) {
                if (this.getProvideDesc() == null) {
                    throw new RuntimeException();
                }
                return this.getProvideDesc();
            }
            if (this.getClz() == TypeClass.JD) {
                return "J";
            }
            if (this.getUses() != null) {
                for (String t : possibleIntTypes) {
                    if (!this.getUses().contains(t)) continue;
                    return t;
                }
            }
            switch (this.getClz()) {
                case ZI: {
                    return "I";
                }
                case ZIFL: 
                case ZIF: 
                case ZIL: {
                    return "Z";
                }
                case INT: 
                case IF: {
                    return "I";
                }
            }
            throw new RuntimeException();
        }

        public boolean updateTypeClass(TypeClass clz) {
            TypeClass merged = TypeClass.merge(this.getClz(), clz);
            if (merged == this.getClz()) {
                return false;
            }
            this.setClz(merged);
            return true;
        }

        public void clear() {
            this.sArrayValues = null;
            this.gArrayValues = null;
            this.parents = null;
            this.children = null;
            this.children = null;
            this.sameValues = null;
        }

        public Set<String> getUses() {
            return this.t.getReal().uses;
        }

        public String getProvideDesc() {
            return this.t.getReal().provideDesc;
        }

        public void setProvideDesc(String provideDesc) {
            this.t.getReal().provideDesc = provideDesc;
        }

        public boolean addUses(String ele) {
            SharedT t = this.t.getReal();
            if (t.uses != null) {
                return t.uses.add(ele);
            }
            t.uses = new HashSet();
            return t.uses.add(ele);
        }

        public boolean addAllUses(Set<String> uses) {
            if (uses != null) {
                return uses.addAll(uses);
            }
            uses = new HashSet<String>();
            return uses.addAll(uses);
        }

        static class SharedT {
            private TypeClass clz = TypeClass.UNKNOWN;
            private String provideDesc = null;
            private Set<String> uses;
            SharedT next;

            SharedT() {
            }

            SharedT getReal() {
                SharedT _this = this;
                SharedT _next = this.next;
                while (_next != null) {
                    _this = _next;
                    _next = _next.next;
                }
                return _this;
            }

            boolean merge(SharedT b) {
                SharedT a = this;
                if (a == b) {
                    return false;
                }
                b.next = a;
                if (a.provideDesc == null) {
                    a.provideDesc = b.provideDesc;
                } else if (b.provideDesc != null) {
                    a.provideDesc = TypeAnalyze.mergeProviderType(a.provideDesc, b.provideDesc);
                }
                if (b.uses != null) {
                    if (a.uses == null) {
                        a.uses = new HashSet<String>();
                    }
                    a.uses.addAll(b.uses);
                }
                return true;
            }
        }
    }
}

