#ifndef YDWEReplayHelperIncluded
#define YDWEReplayHelperIncluded

library YDWEReplayWriter initializer Init
	globals
		private player curplayer = null
		private gamecache gc
	endglobals
	private function IsLivingPlayer takes player p returns boolean
		return (GetPlayerSlotState(p) == PLAYER_SLOT_STATE_PLAYING) /*
		*/ and (GetPlayerController(p) == MAP_CONTROL_USER)
	endfunction
	private function GetLivingfPlayer takes nothing returns player
		local integer i = 0
		loop
			exitwhen IsLivingPlayer(Player(i)) or i >= 11
			set i = i + 1
		endloop
		return Player(i)
	endfunction
	function YDWEWriteToReplay takes string table, string key, integer data returns nothing
		if not IsLivingPlayer(curplayer) then
			set curplayer = GetLivingfPlayer()
		endif
		call StoreInteger(gc, table, key, data)
		if GetLocalPlayer() == curplayer then
			call SyncStoredInteger(gc, table, key)
		endif
	endfunction
	function YDWEReadFromReplay takes string table, string key returns integer
		return GetStoredInteger(gc, table, key)
	endfunction
	private function Init takes nothing returns nothing
		call FlushGameCache(InitGameCache("11.x"))
		set gc = InitGameCache("11.x")
	endfunction
endlibrary

library YDWEReplayHelper requires YDWEReplayWriter
	// ---------------------------------------------------
	// ϷʱûʤһĶID
	// 1IDΪ02IDΪ1
	// ---------------------------------------------------
	function YDWERHSetGameWinner takes integer WinnerId returns nothing
        call YDWEWriteToReplay("Global", "Winner", WinnerId+1)
	endfunction
	// ---------------------------------------------------
	// ϷʼʱϷʼ㡣
	// ʱһΡ
	// ---------------------------------------------------
	function YDWERHSetGameStart takes nothing returns nothing
        call YDWEWriteToReplay("Data", "GameStart", 1)
	endfunction
	// ---------------------------------------------------
	// ϷʱϷʱ
	// ---------------------------------------------------
	function YDWERHSetGameTime takes integer m, integer s returns nothing
        call YDWEWriteToReplay("Global", "m", m)
        call YDWEWriteToReplay("Global", "s", s)
	endfunction
//------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------
	// ʱûصǰѪİٷֱȡ
	// 75%50%25%10%ʱֱһΡ
	// ---------------------------------------------------
	function YDWERHSetBaseTowerLift takes integer TeamId, integer value returns nothing
		if TeamId == 0 then
			call YDWEWriteToReplay("Data", "Tree", value)
		elseif TeamId == 1 then
			call YDWEWriteToReplay("Data", "Throne", value)
		else
			call YDWEWriteToReplay("Data", "Fort"+I2S(TeamId), value)
		endif
	endfunction
//------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------
	// ƵʱƵҵIDƵϢ
	//   TowerTeam  ĶID1IDΪ02IDΪ1
	//   TowerLevel ĵȼΪ1Ϊ2ߵΪ3ұϵΪ4
	//   TowerSide  λã·Ϊ0·Ϊ1·Ϊ2ұϵΪ1(·)
	// ---------------------------------------------------
	function YDWERHSetTowerDeathEvent takes integer PlayerId, integer TowerTeam, integer TowerLevel, integer TowerSide returns nothing
        call YDWEWriteToReplay("Data", "Tower"+I2S(TowerTeam)+I2S(TowerLevel)+I2S(TowerSide), PlayerId)
	endfunction
	// ---------------------------------------------------
	// ӢʱҵID
	// ---------------------------------------------------
	function YDWERHSetLevel takes integer PlayerId, integer level returns nothing
        call YDWEWriteToReplay("Data", "Level"+I2S(level), PlayerId)
	endfunction
	// ---------------------------------------------------
	// ӢʱҵIDɱ˵ҵID
	// ---------------------------------------------------
	function YDWERHSetKillEvent takes integer DeaderId, integer KillerId returns nothing
        call YDWEWriteToReplay("Data", "Hero"+I2S(DeaderId), KillerId)
	endfunction
	// ---------------------------------------------------
	// ӢʱҵIDҵID
	// ---------------------------------------------------
	function YDWERHSetAssistEvent takes integer DeaderId, integer AssisterId returns nothing
        call YDWEWriteToReplay("Data", "Assist"+I2S(AssisterId), DeaderId)
	endfunction
//------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------
	// ӢۻƷʱûõƷ
	// ---------------------------------------------------
	function YDWERHAddItem takes integer PlayerId, integer ItemId returns nothing
        call YDWEWriteToReplay("Data", "PUI_"+I2S(PlayerId), ItemId)
	endfunction
	// ---------------------------------------------------
	// ӢʧȥƷʱʧȥƷ
	// ---------------------------------------------------
	function YDWERHSubItem takes integer PlayerId, integer ItemId returns nothing
        call YDWEWriteToReplay("Data", "DRI_"+I2S(PlayerId), ItemId)
	endfunction
	// ---------------------------------------------------
	// ϷʱӢϵƷ
	// indexΪ0~5
	// ---------------------------------------------------
	function YDWERHSetHeroItem takes integer PlayerId, integer index, integer ItemId returns nothing
		call YDWEWriteToReplay(I2S(PlayerId), "8_"+I2S(index), ItemId)
	endfunction
//------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------
	// ϷʱҵǰǮ
	// ---------------------------------------------------
	function YDWERHSetGold takes integer PlayerId, integer value returns nothing
		call YDWEWriteToReplay(I2S(PlayerId), "6", value)
	endfunction
//------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------
	// Ϸʱҵɱ
	// ---------------------------------------------------
	function YDWERHSetKill takes integer PlayerId, integer value returns nothing
        call YDWEWriteToReplay(I2S(PlayerId), "1", value)
	endfunction
	// ---------------------------------------------------
	// Ϸʱҵ
	// ---------------------------------------------------
	function YDWERHSetDead takes integer PlayerId, integer value returns nothing
        call YDWEWriteToReplay(I2S(PlayerId), "2", value)
	endfunction
	// ---------------------------------------------------
	// Ϸʱҵ
	// ---------------------------------------------------
	function YDWERHSetAssist takes integer PlayerId, integer value returns nothing
        call YDWEWriteToReplay(I2S(PlayerId), "5", value)
	endfunction
//------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------
	// (κʱ)ҵ
	// ÿ210һΡ
	// ---------------------------------------------------
	function YDWERHSetCreepKills takes integer PlayerId, integer value returns nothing
        call YDWEWriteToReplay("Data", "CSK"+I2S(PlayerId), value)
	endfunction
	// ---------------------------------------------------
	// (κʱ)ҵķ
	// ÿ210һΡ
	// ---------------------------------------------------
	function YDWERHSetCreepDenies takes integer PlayerId, integer value returns nothing
        call YDWEWriteToReplay("Data", "CSD"+I2S(PlayerId), value)
	endfunction
	// ---------------------------------------------------
	// (κʱ)ҵĴҰ
	// ÿ210һΡ
	// ---------------------------------------------------
	function YDWERHSetNeutralKills takes integer PlayerId, integer value returns nothing
        call YDWEWriteToReplay("Data", "NK"+I2S(PlayerId), value)
	endfunction

	// ---------------------------------------------------
	// 뿪ʱҵҰ
	// ---------------------------------------------------
	function YDWERHSetKillUnitInPlayerLeave takes integer PlayerId, integer k, integer d, integer n returns nothing
        call YDWEWriteToReplay("Data", "CK"+I2S(k)+"D"+I2S(d)+"N"+I2S(n), PlayerId)
	endfunction
	// ---------------------------------------------------
	// ϷʱҵҰ
	// ---------------------------------------------------
	function YDWERHSetKillUnitInGameEnd takes integer PlayerId, integer k, integer d, integer n returns nothing
        call YDWEWriteToReplay(I2S(PlayerId), "3", k)
        call YDWEWriteToReplay(I2S(PlayerId), "4", d)
        call YDWEWriteToReplay(I2S(PlayerId), "7", n)
	endfunction
//------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------
	//  ϷѡӢ(ѡ)ʱҵѡӢۡ
	// ---------------------------------------------------
	function YDWERHSetHeroId takes integer PlayerId, integer HeroId returns nothing
        call YDWEWriteToReplay(I2S(PlayerId), "9", HeroId)
	endfunction
	// ---------------------------------------------------
	// ϷҸĶʱҵڵλ(spģʽ)
	// 1Ϊ1~52Ϊ6~10
	// ---------------------------------------------------
	function YDWERHSetColorId takes integer PlayerId, integer ColorId returns nothing
        call YDWEWriteToReplay(I2S(PlayerId), "id", ColorId)
	endfunction
endlibrary

#endif
