////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2011 Waves Audio Ltd. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////

// Waves Audio 
(function($)
{
	$.fn.maxx = function(options)
	{

		var jhndl = this;
		var options = $.extend(
		{
			li_width: 60,
			speed: 350
		},options);

		return this.each(function()
		{
			var hndl = this;

			this.MaxxAudio = new ActiveXObject("MaxxGadget.GadgetObject");
			this.BypassAllStatus = "";
			this.BYPASS_ALL = 1; // 1 is Off, 0 is On
			this.BYPASS_BTN_ON = 0;
			this.BYPASS_BTN_OFF = 1;
			this.ul = "";
			this.CurrentSlide = 0;
			this.SlidesNumber = 0;
			this.NextSlide = 0;
			this.NextPos;
			this.nSoundMode = "";
			this.CurrentHTML = "";

			hndl.jump = function(slide)
			{
				if(hndl.SlidesNumber == 1)
				{
					//one slide only...
				}
				else
				{
					if (slide >= 0 && slide <= hndl.SlidesNumber)
					{
						hndl.NextSlide = slide;
						hndl.NextPos = -1 * options.li_width * hndl.NextSlide;
						hndl.ul.css("left", hndl.NextPos);
						hndl.CurrentSlide = hndl.NextSlide;

					}
				}
			};

			hndl.jump_animate = function(slide)
			{
				if (slide >= 0 && slide <= hndl.SlidesNumber)
				{
					hndl.NextSlide = slide;
					hndl.NextPos = -1 * options.li_width * hndl.NextSlide;
					hndl.ul.animate( {left:hndl.NextPos}, options.speed);
					hndl.CurrentSlide = hndl.NextSlide;

				}
			};

			hndl.SetPreset = function(nIndex)
			{
				// Set preset
				hndl.MaxxAudio.SetSoundMode(nIndex);
				hndl.MaxxAudio.SetParameter(hndl.BYPASS_ALL, hndl.BypassAllStatus);
			};

			this.SelectBoxInit = function()
			{
				var presets_num = hndl.MaxxAudio.GetSoundModeCount();
				hndl.SlidesNumber = presets_num;
				var html = "";

				if(presets_num == 1)
				{
					$("#left_arrow").hide();
					$("#right_arrow").hide();
					$("div#SelectBoxContent").addClass("one");
				}
				else
				{
					$("#left_arrow").show();
					$("#right_arrow").show();
					$("div#SelectBoxContent").removeClass("one");
				}

				html += "<ul class=\"SelectBoxUl\" style=\"width: " + (eval(presets_num) + 2)*options.li_width + "px;\">";

				// Add last item at the start
				if(presets_num > 1)
				{
					html += "<li class=\"Slide" + (presets_num-1) + "\">";
					html += hndl.MaxxAudio.GetSoundModeName(presets_num-1);
					html += "</li>";
				}

				for(var i=0; i<presets_num; i++)
				{

					if($.trim(hndl.MaxxAudio.GetSoundModeName(i)) != "")
					{						
						html += "<li class=\"Slide" + i + "\">";
						html += hndl.MaxxAudio.GetSoundModeName(i);
						html += "</li>";
					}
				}

				if(presets_num > 1)
				{
					html += "<li class=\"Slide0" + "\">";
					html += hndl.MaxxAudio.GetSoundModeName(0);
					html += "</li>";
				}

				html += "</ul>";
				
				
				
				// If new html has been changed then update
				if (hndl.CurrentHTML != html)
				{
					hndl.CurrentHTML = html;
					$("div#SelectBoxContent").html(html);
					hndl.ul = $(".SelectBoxUl");
				}
			};

			// Handle the Settings dialog show event.
			this.OnParameterChanged = function(aaa, bbb)
			{
				hndl.OnOffInit();
				hndl.SelectBoxInit();

				nSoundMode = hndl.MaxxAudio.GetSoundMode();
				hndl.jump(nSoundMode + 1)
			};

			this.OnOffInit = function()
			{

				// Get byppas state
				hndl.BypassAllStatus = hndl.MaxxAudio.GetParameter(hndl.BYPASS_ALL);

				if (hndl.BypassAllStatus == hndl.BYPASS_BTN_ON)
				{

					$("#on_btn").show();
					$("#off_btn").hide();
				}
				else // BYPASS_BTN_OFF
				{
					$("#on_btn").hide();
					$("#off_btn").show();
				}
			};


			this.OnOffClickInit = function()
			{

				$(".on_off_div").get(0).onclick = function()
				{
					if(hndl.BypassAllStatus == hndl.BYPASS_BTN_ON)
					{

						// Close it
						$("#on_btn").hide();
						$("#off_btn").show();

						hndl.BypassAllStatus = hndl.BYPASS_BTN_OFF;
					}
					else // BYPASS_BTN_OFF
					{
						// Open it
						$("#on_btn").show();
						$("#off_btn").hide();

						hndl.BypassAllStatus = hndl.BYPASS_BTN_ON;
					}

					hndl.MaxxAudio.SetParameter(hndl.BYPASS_ALL, hndl.BypassAllStatus);

					// Restore select box display position
					hndl.jump(hndl.CurrentSlide);
				}
			};

			this.go = function(direction)
			{
				switch(direction)
				{
				case "prev":
					{
						if (eval(hndl.CurrentSlide) >= 2)
						{
							hndl.CurrentSlide = hndl.CurrentSlide - 1;
							hndl.SetPreset(hndl.CurrentSlide - 1);
							hndl.NextSlide = eval(hndl.CurrentSlide);
							hndl.NextPos = -1 * options.li_width * hndl.NextSlide;
							hndl.ul.animate( {left:hndl.NextPos}, options.speed);
						}
						else
						{
							hndl.SetPreset(hndl.SlidesNumber - 1);
							hndl.ul.animate( {left:"0"}, options.speed, function()
							{
								hndl.jump(hndl.SlidesNumber);
							});
						}

						break;
					}
				case "next":
					{
						if (eval(hndl.CurrentSlide) < hndl.SlidesNumber)
						{
							hndl.CurrentSlide = eval(hndl.CurrentSlide) + 1;
							hndl.SetPreset(hndl.CurrentSlide - 1);
							hndl.NextSlide = eval(hndl.CurrentSlide);
							hndl.NextPos = -1*options.li_width*hndl.NextSlide;
							hndl.ul.animate( {left:hndl.NextPos}, options.speed);
						}
						else
						{
							hndl.SetPreset(0);
							hndl.NextSlide = eval(hndl.SlidesNumber) + 1;
							hndl.NextPos = -1*options.li_width*hndl.NextSlide;
							hndl.ul.animate( {left:hndl.NextPos}, options.speed, function()
							{
								hndl.jump(1);
							});
						}
						
						break;
					}
				}
			};

			this.SelectBoxClickInit = function()
			{
				$("#left_arrow").unbind().click(function()
				{
					hndl.go("prev");
				});

				$("#right_arrow").unbind().click(function()
				{
					hndl.go("next");
				});
			};

			this.SettingsInit = function()
			{
				$("#options-btn").get(0).onclick = function()
				{
					hndl.MaxxAudio.OpenSettings(0, 0);
				}
			};

			this.init = function()
			{
				hndl.MaxxAudio.Initialize("APORenderGFX", 0, "");
				hndl.MaxxAudio.RegisterParameterChangeNotification(hndl.OnParameterChanged);

				hndl.OnOffInit();
				hndl.OnOffClickInit();
				hndl.SettingsInit();
				hndl.SelectBoxInit();
				hndl.SelectBoxClickInit();

				// Set position to 1 as default, will be changed when calling to OnParameterChanged()
				hndl.jump(1);
				hndl.OnParameterChanged(0, 0);
			};

			this.init();

		});
	};
})(jQuery);


$("document").ready(function()
{
	$("#wrapper").maxx( {li_width:60});
});