<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:export="export">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<export:data>
		<uiConfig>
			<applicationInfo name="CorelDRAW" framework="CorelDRAW" version="15" userConfiguration="true" localizedLang="CS"></applicationInfo>
			<items>
				<itemData guid="21996b4e-627a-43fe-b948-9fa46ca5b432" dynamicCommand="ColorReplacer.MainModule.替换颜色" dynamicCategory="2cc24a3e-fe24-4708-9a74-9c75406eebcd" userCaption="替换颜色">
					<userSmallBitmap xmlns:dt="urn:schemas-microsoft-com:datatypes" dt:dt="bin.base64">
						//8BABAAV0NtblVJX1VJSXRlbUJtcAAAAAAAAAAAKAAAAAAEAAAAAQAAKAAAABAAAAAQAAAA
						AQAIAAAAAAAAAQAAAAAAAAAAAAAAAQAAAAEAAAAAAAD///8AyNDUAP//AADFlpgAOTAyAF9c
						6wAXEuIAPjnnAHsBfwD/mf8A//3/AOoCyQD++/0ACggJAOjm5wDCS3YAEg8QACUfIQB5c3UA
						LSYoADQsLgA5MTMAOzM1AD83OQCKhocA8+/wADgvMQA+NTcAW1JUAHhvcQA7MTMAPTM1AEI4
						OgBOREYAlZCRAMjDxABFOjwAQjU3AEQ3OQBGOTsASTw+AP33+AAhGhsAVkdJAHVnaQDb1NUA
						U0FDAFxKTABtW10AZlZYAFZNTgDElZkAinN1AExAQQBGPD0AWk9QAOXMzgD54+UAgGBiAIxq
						bAB3WlwAwJWYAINmaADBl5oAwJaZAMGYmwDDnJ8Ap4aIAMmnqQDHpqgAzKutANu7vQDbvb8A
						4cPFAMa2twDdzM0A38/QAPvr7ADj1tcAx5eZAMKUlgDFl5kAq4OFAMaZmwDJnJ4AupCSAGJM
						TQDEmpwAzaKkAMObnQDGn6EA3LO1AM2nqQDWr7EA88nLAIRtbgDNsLEA0bS1ANW4uQCrlJUA
						5MfIAOzP0ADRt7gA7tPUAPPY2QDWvr8A9tzdANjBwgDaxcYA2MPEAPjh4gDbx8gA2cXGAPji
						4wD03+AA/OfoAOrX2ACGTk8AkmtsAIplZgCLZ2gAsoqLAJ99fgCWdncAz6eoANOrrADmvL0A
						88jJAN+4uQDFo6QA68PEAPHJygDzzM0A9M7PANy7vADsycoA3r6/APzZ2gB5AQEAjmZmAI1l
						ZQCNZ2cAtZmZADwzMwD109MAuKOjAMGtrQDbxcUA2cTEANrHxwD55uYA49PTANDBwQDz5OQA
						/PDwAOne3gDk2dkA49jYAObc3AD99PQA7OPjAOri4gCZlJQA7ufnAMbAwADy7OwA7ujoAPXw
						8ADl4OAA7+vrALi1tQD++/sA9vPzAPPw8ADDwMAAqKamAP/9/QD59/cA9vT0AL27uwD//v4A
						5+bmAP8QCgDz8O8AtJKCAKhrSgD/YAEAZzMBAP38+wD5+PcA/5kBAEU9LwD/wzMAiHQfAFhR
						KgBjXCgAaWImAHJsJAB7dSIAop0YAI+KHAD9+wEA7+4FAOvoBQDc2wkAf30FAM3KDAC7uBEA
						/f0BAPr6AQD19QMAZ2czAMPDwQCUnjMAssGbAMbRtQDg5tYAoLOFANffzACMqG8AfP8JAAzj
						FwA/TU0A6/39AMHHxwD6//8A/f//AG/i7gDF9PkACtXwALHCxQCtt7kAXWJlACRmkgC0uLwA
						OzxHAAEBgQABATMAFRjsAJma7gD9/f0A+vr6AOXl5QDNzc0Aw8PDAMjQ1ACzs7MAmZmZAH9/
						fwBnZ2cATU1NADs7OwAzMzMAGRkZAAEBAQD29vb29vb29vYhLS0tHiH29vb29vb29vb2HQEB
						AUsp9vb29vY19vb29jgBAQGrHfb29vb2LTX29vYdAbSvAbR89vb29jVTRPb2M7AfE66pMfb2
						PGD2j3v29iwsNzguqR32d0v29mR6Nfb29vYdq09gO5n3Fvb2S2aPMfb2F/SSO3ym9i329vZj
						ZjL2LfaTefYx8vczHTIt9hMcLTM4Mfb2MQEuHRL2NvYYMD0oKDP29jWqrvb2vjP2KY58Pzsx
						Mvb29rK+vQEi9i1TfzlCMCH29if3AQEBLPb2RDmmSFfp9vYy9PSl9Db29vZkRIL29vb2JSI2
						NjYl9vb29vb29vb21NDIAICAgADU0MgAAAAAAA==
					</userSmallBitmap>
				</itemData>
			</items>
			<commandBars>
				<commandBarData guid="bd6ea995-8296-4d80-8aaa-c8ca9705c602" type="toolbar" nonLocalizableName="颜色替换" userCaption="颜色替换" userCreated="true">
					<container floatWidth="32767">
						<item guidRef="21996b4e-627a-43fe-b948-9fa46ca5b432"/>
					</container>
				</commandBarData>
			</commandBars>
		</uiConfig>
	</export:data>
	<xsl:template match="node()[count(*)='0']|@*">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="node()">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="uiConfig">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*"/>
			<xsl:if test="not(./items)">
				<xsl:copy-of select="document('')/*/export:data/uiConfig/items"/>
			</xsl:if>
			<xsl:if test="not(./commandBars)">
				<xsl:copy-of select="document('')/*/export:data/uiConfig/commandBars"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="uiConfig/items">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*"/>
			<xsl:if test="not(./itemData[@guid='21996b4e-627a-43fe-b948-9fa46ca5b432'])">
				<xsl:copy-of select="document('')/*/export:data/uiConfig/items/itemData[@guid='21996b4e-627a-43fe-b948-9fa46ca5b432']"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="uiConfig/items/itemData[@guid='21996b4e-627a-43fe-b948-9fa46ca5b432']">
		<xsl:copy-of select="document('')/*/export:data/uiConfig/items/itemData[@guid='21996b4e-627a-43fe-b948-9fa46ca5b432']"/>
	</xsl:template>
	<xsl:template match="uiConfig/commandBars">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*"/>
			<xsl:if test="not(./commandBarData[@guid='bd6ea995-8296-4d80-8aaa-c8ca9705c602'])">
				<xsl:copy-of select="document('')/*/export:data/uiConfig/commandBars/commandBarData[@guid='bd6ea995-8296-4d80-8aaa-c8ca9705c602']"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="uiConfig/commandBars/commandBarData[@guid='bd6ea995-8296-4d80-8aaa-c8ca9705c602']">
		<xsl:copy-of select="document('')/*/export:data/uiConfig/commandBars/commandBarData[@guid='bd6ea995-8296-4d80-8aaa-c8ca9705c602']"/>
	</xsl:template>
</xsl:stylesheet>
