/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.mos6526;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IComponent;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.SIDEndian;

public class SID6526
implements IComponent {
    private static final String credit = "*SID6526 (SIDPlay1 Fake CIA) Emulation:\tCopyright (C) 2001 Simon White <sidplay2@yahoo.com>";
    private C64Env m_env;
    private IEventContext m_eventContext;
    private long m_accessClk;
    private Event.event_phase_t m_phase;
    private short[] regs = new short[16];
    private short cra;
    private int ta_latch;
    private int ta;
    private long rnd;
    private int m_count;
    private boolean locked;
    private TaEvent m_taEvent;

    public SID6526(C64Env c64Env) {
        this.m_env = c64Env;
        this.m_eventContext = this.m_env.context();
        this.m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
        this.rnd = 0L;
        this.m_taEvent = new TaEvent(this);
        this.clock(65535);
        this.reset(false);
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    public void reset(boolean bl) {
        this.locked = false;
        this.ta = this.ta_latch = this.m_count;
        this.cra = 0;
        this.rnd = bl ? 0L : (this.rnd += System.nanoTime() & 0xFFL);
        this.m_accessClk = 0L;
        this.m_eventContext.cancel(this.m_taEvent);
    }

    @Override
    public short read(short s) {
        if (s > 15) {
            return 0;
        }
        switch (s) {
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                this.rnd = this.rnd * 13L + 1L;
                return (short)(this.rnd >> 3);
            }
        }
        return this.regs[s];
    }

    @Override
    public void write(short s, short s2) {
        if (s > 15) {
            return;
        }
        this.regs[s] = s2;
        if (this.locked) {
            return;
        }
        long l = this.m_eventContext.getTime(this.m_accessClk, this.m_phase);
        this.m_accessClk += l;
        this.ta = (int)((long)this.ta - l);
        if (this.ta == 0) {
            this.event();
        }
        switch (s) {
            case 4: {
                this.ta_latch = SIDEndian.endian_16lo8(this.ta_latch, s2);
                break;
            }
            case 5: {
                this.ta_latch = SIDEndian.endian_16hi8(this.ta_latch, s2);
                if ((this.cra & 1) != 0) break;
                this.ta = this.ta_latch;
                break;
            }
            case 14: {
                this.cra = (short)(s2 | 1);
                if ((s2 & 0x10) != 0) {
                    this.cra = (short)(this.cra & 0xEF);
                    this.ta = this.ta_latch;
                }
                this.m_eventContext.schedule(this.m_taEvent, (long)this.ta + 1L, this.m_phase);
                break;
            }
        }
    }

    @Override
    public final String credits() {
        return credit;
    }

    @Override
    public final String error() {
        return "";
    }

    public void event() {
        this.m_accessClk = this.m_eventContext.getTime(this.m_phase);
        this.ta = this.ta_latch;
        this.m_eventContext.schedule(this.m_taEvent, (long)this.ta + 1L, this.m_phase);
        this.m_env.interruptIRQ(true);
    }

    public void clock(int n) {
        this.m_count = n;
    }

    public void lock() {
        this.locked = true;
    }

    private static class TaEvent
    extends Event {
        private SID6526 m_cia;

        @Override
        public void event() {
            this.m_cia.event();
        }

        public TaEvent(SID6526 sID6526) {
            super("CIA Timer A");
            this.m_cia = sID6526;
        }
    }
}

