/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.common;

import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IEventContext;

public class EventScheduler
extends Event
implements IEventContext {
    public static final int EVENT_TIMEWARP_COUNT = 1048575;
    private long m_absClk;
    private long m_events = 0L;
    private EventTimeWarp m_timeWarp = new EventTimeWarp(this);

    @Override
    public void event() {
        Event event = this.m_next;
        this.m_absClk += this.m_clk;
        while (event.m_pending) {
            event.m_clk -= this.m_clk;
            event = event.m_next;
        }
        this.m_clk = 0L;
        this.schedule(this.m_timeWarp, 1048575L, Event.event_phase_t.EVENT_CLOCK_PHI1);
    }

    private void dispatch(Event event) {
        this.cancelPending(event);
        event.event();
    }

    private void cancelPending(Event event) {
        event.m_pending = false;
        event.m_prev.m_next = event.m_next;
        event.m_next.m_prev = event.m_prev;
        --this.m_events;
    }

    public EventScheduler(String string) {
        super(string);
        this.m_next = this;
        this.m_prev = this;
        this.reset();
    }

    @Override
    public void cancel(Event event) {
        if (event.m_pending) {
            this.cancelPending(event);
        }
    }

    public void reset() {
        Event event = this.m_next;
        this.m_pending = false;
        while (event.m_pending) {
            event.m_pending = false;
            event = event.m_next;
        }
        this.m_next = this;
        this.m_prev = this;
        this.m_absClk = 0L;
        this.m_clk = 0L;
        this.m_events = 0L;
        this.event();
    }

    @Override
    public void schedule(Event event, long l, Event.event_phase_t event_phase_t2) {
        if (!event.m_pending) {
            long l2 = this.m_clk + (l << 1);
            l2 += this.m_absClk + l2 & 1L ^ (long)(event_phase_t2 == Event.event_phase_t.EVENT_CLOCK_PHI1 ? 0 : 1);
            Event event2 = this.m_next;
            long l3 = this.m_events;
            while (l3-- != 0L && event2.m_clk <= l2) {
                event2 = event2.m_next;
            }
            event.m_next = event2;
            event.m_prev = event2.m_prev;
            event2.m_prev.m_next = event;
            event2.m_prev = event;
            event.m_pending = true;
            event.m_clk = l2;
            ++this.m_events;
        } else {
            this.cancelPending(event);
            this.schedule(event, l, event_phase_t2);
        }
    }

    public void clock() {
        this.m_clk = this.m_next.m_clk;
        this.dispatch(this.m_next);
    }

    @Override
    public final long getTime(Event.event_phase_t event_phase_t2) {
        return this.m_absClk + this.m_clk + (long)((event_phase_t2 == Event.event_phase_t.EVENT_CLOCK_PHI1 ? 0 : 1) ^ 1) >> 1;
    }

    @Override
    public final long getTime(long l, Event.event_phase_t event_phase_t2) {
        return this.getTime(event_phase_t2) - l << 1 >> 1;
    }

    @Override
    public final Event.event_phase_t phase() {
        return (this.m_absClk + this.m_clk & 1L) == 0L ? Event.event_phase_t.EVENT_CLOCK_PHI1 : Event.event_phase_t.EVENT_CLOCK_PHI2;
    }

    public static class EventTimeWarp
    extends Event {
        private EventScheduler m_scheduler;

        @Override
        public void event() {
            this.m_scheduler.event();
        }

        public EventTimeWarp(EventScheduler eventScheduler) {
            super("Time Warp");
            this.m_scheduler = eventScheduler;
        }
    }
}

