/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APEDescriptor {
    public String cID;
    public int nVersion;
    public long nDescriptorBytes;
    public long nHeaderBytes;
    public long nSeekTableBytes;
    public long nHeaderDataBytes;
    public long nAPEFrameDataBytes;
    public long nAPEFrameDataBytesHigh;
    public long nTerminatingDataBytes;
    public byte[] cFileMD5 = new byte[16];
    public static final int APE_DESCRIPTOR_BYTES = 52;

    public static APEDescriptor read(File file) throws IOException {
        try {
            APEDescriptor aPEDescriptor = new APEDescriptor();
            ByteArrayReader byteArrayReader = new ByteArrayReader(file, 36);
            aPEDescriptor.cID = byteArrayReader.readString(4, "US-ASCII");
            aPEDescriptor.nVersion = byteArrayReader.readUnsignedShort();
            byteArrayReader.skipBytes(2L);
            aPEDescriptor.nDescriptorBytes = byteArrayReader.readUnsignedInt();
            aPEDescriptor.nHeaderBytes = byteArrayReader.readUnsignedInt();
            aPEDescriptor.nSeekTableBytes = byteArrayReader.readUnsignedInt();
            aPEDescriptor.nHeaderDataBytes = byteArrayReader.readUnsignedInt();
            aPEDescriptor.nAPEFrameDataBytes = byteArrayReader.readUnsignedInt();
            aPEDescriptor.nAPEFrameDataBytesHigh = byteArrayReader.readUnsignedInt();
            aPEDescriptor.nTerminatingDataBytes = byteArrayReader.readUnsignedInt();
            file.readFully(aPEDescriptor.cFileMD5);
            return aPEDescriptor;
        }
        catch (EOFException eOFException) {
            throw new JMACException("Unsupported Format");
        }
    }

    public void write(ByteArrayWriter byteArrayWriter) {
        byteArrayWriter.writeString(this.cID, 4, "US-ASCII");
        byteArrayWriter.writeUnsignedShort(this.nVersion);
        byteArrayWriter.writeUnsignedShort(0);
        byteArrayWriter.writeUnsignedInt(this.nDescriptorBytes);
        byteArrayWriter.writeUnsignedInt(this.nHeaderBytes);
        byteArrayWriter.writeUnsignedInt(this.nSeekTableBytes);
        byteArrayWriter.writeUnsignedInt(this.nHeaderDataBytes);
        byteArrayWriter.writeUnsignedInt(this.nAPEFrameDataBytes);
        byteArrayWriter.writeUnsignedInt(this.nAPEFrameDataBytesHigh);
        byteArrayWriter.writeUnsignedInt(this.nTerminatingDataBytes);
        byteArrayWriter.writeBytes(this.cFileMD5);
    }
}

